/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.util;

import com.atlassian.bamboo.build.ViewBuildResults;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.runtime.RuntimeTaskDefinition;
import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.log4j.Logger;
import org.apache.tools.ant.types.Commandline;
import org.jetbrains.annotations.NotNull;
import org.jfrog.bamboo.admin.BintrayConfig;
import org.jfrog.bamboo.admin.ServerConfig;
import org.jfrog.bamboo.admin.ServerConfigManager;
import org.jfrog.bamboo.context.AbstractBuildContext;
import org.jfrog.bamboo.security.EncryptionHelper;
import org.jfrog.bamboo.util.BuildInfoLog;
import org.jfrog.bamboo.util.HttpUtils;
import org.jfrog.bamboo.util.TaskDefinitionHelper;
import org.jfrog.build.extractor.clientConfiguration.client.ArtifactoryBuildInfoClient;

public class TaskUtils {
    private static final char PROPERTIES_DELIMITER = ';';
    private static final char KEY_VALUE_SEPARATOR = '=';
    private static final String DOWNLOAD_ARTIFACTS_TASK_KEY = "com.atlassian.bamboo.plugins.bamboo-artifact-downloader-plugin:artifactdownloadertask";

    public static Map<String, String> getEscapedEnvMap(Map<String, String> env) {
        HashMap<String, String> result = Maps.newHashMap();
        if (env != null) {
            for (Map.Entry<String, String> entry : env.entrySet()) {
                String escaped = entry.getKey().replace('_', '.');
                escaped = StringUtils.removeStart(escaped, "bamboo.");
                result.put(escaped, entry.getValue());
            }
        }
        return result;
    }

    public static void appendBuildInfoPropertiesArgument(List<String> arguments, String buildInfoPropertiesFile) {
        if (arguments != null && StringUtils.isNotBlank(buildInfoPropertiesFile)) {
            arguments.add(Commandline.quoteArgument((String)("-DbuildInfoConfig.propertiesFile=" + buildInfoPropertiesFile)));
        }
    }

    public static Multimap<String, String> extractMatrixParamFromString(String propertiesInput) {
        String[] matrixParamString;
        ArrayListMultimap<String, String> matrixParams = ArrayListMultimap.create();
        for (String s : matrixParamString = StringUtils.split(propertiesInput, ';')) {
            boolean validProperty;
            String[] keyValueArr = StringUtils.split(s, '=');
            boolean bl = validProperty = keyValueArr.length == 2;
            if (!validProperty) continue;
            String formatKey = keyValueArr[0].replace(" ", "");
            matrixParams.put(formatKey, keyValueArr[1].trim());
        }
        return matrixParams;
    }

    public static String getSelectedServerId(TaskDefinition definition) {
        if (definition == null) {
            return "";
        }
        Map configuration = definition.getConfiguration();
        Map filtered = Maps.filterKeys(configuration, new Predicate<String>(){

            @Override
            public boolean apply(String input) {
                return StringUtils.endsWith(input, "artifactoryServerId");
            }
        });
        return (String)filtered.values().iterator().next();
    }

    public static RuntimeTaskDefinition findDownloadArtifactsTask(@NotNull List<RuntimeTaskDefinition> runtimeTaskDefinitionList) {
        for (RuntimeTaskDefinition rtd : runtimeTaskDefinitionList) {
            if (!rtd.getPluginKey().equals(DOWNLOAD_ARTIFACTS_TASK_KEY)) continue;
            return rtd;
        }
        throw new IllegalStateException("\"Artifacts Download\" task must run before the \"Artifactory Deployment\" task.");
    }

    public static Map<String, String> findConfigurationForBuildTask(ViewBuildResults viewBuildResults) {
        List taskDefinitions = viewBuildResults.getImmutableBuild().getBuildDefinition().getTaskDefinitions();
        for (TaskDefinition taskDefinition : taskDefinitions) {
            if (!StringUtils.startsWith(taskDefinition.getPluginKey(), "org.jfrog.bamboo.bamboo-artifactory-plugin")) continue;
            return taskDefinition.getConfiguration();
        }
        throw new IllegalStateException("This job has no Artifactory task.");
    }

    public static TaskDefinition getMavenOrGradleTaskDefinition(ImmutablePlan plan) {
        if (plan == null) {
            return null;
        }
        List definitions = plan.getBuildDefinition().getTaskDefinitions();
        if (definitions.isEmpty()) {
            return null;
        }
        return TaskDefinitionHelper.findMavenOrGradleDefinition(definitions);
    }

    public static ServerConfig getArtifactoryServerConfig(ImmutablePlan plan) {
        TaskDefinition mavenOrGradleTaskDefinition = TaskDefinitionHelper.getPushToBintrayEnabledTaskDefinition(plan);
        String serverIdStr = TaskUtils.getSelectedServerId(mavenOrGradleTaskDefinition);
        if (StringUtils.isNotEmpty(serverIdStr)) {
            long serverId = Long.parseLong(serverIdStr);
            return ServerConfigManager.getInstance().getServerConfigById(serverId);
        }
        throw new IllegalStateException("Error while trying to create ArtifactoryBuildInfoClient");
    }

    public static ArtifactoryBuildInfoClient createClient(ServerConfigManager serverConfigManager, ServerConfig serverConfig, AbstractBuildContext context, Logger log) {
        ArtifactoryBuildInfoClient client;
        String serverUrl = TaskUtils.substituteVariables(serverConfigManager, serverConfig.getUrl());
        String username = TaskUtils.substituteVariables(serverConfigManager, context.getDeployerUsername());
        if (StringUtils.isBlank(username)) {
            username = TaskUtils.substituteVariables(serverConfigManager, serverConfig.getUsername());
        }
        BuildInfoLog bambooLog = new BuildInfoLog(log);
        if (StringUtils.isBlank(username)) {
            client = new ArtifactoryBuildInfoClient(serverUrl, bambooLog);
        } else {
            String password = TaskUtils.substituteVariables(serverConfigManager, context.getDeployerPassword());
            if (StringUtils.isBlank(password)) {
                password = TaskUtils.substituteVariables(serverConfigManager, serverConfig.getPassword());
            }
            client = new ArtifactoryBuildInfoClient(serverUrl, username, password, bambooLog);
        }
        client.setConnectionTimeout(serverConfig.getTimeout());
        return client;
    }

    public static int testBintrayConnection(String bintrayUrl, String bintrayUser, String bintrayApiKey) throws IOException {
        DefaultHttpClient client = new DefaultHttpClient();
        String testUrl = bintrayUrl + "users/" + bintrayUser;
        HttpGet testConnectionRequest = new HttpGet(testUrl);
        testConnectionRequest.setHeader(HttpUtils.createAuthorizationHeader(bintrayUser, bintrayApiKey));
        HttpResponse response = client.execute(testConnectionRequest);
        return response.getStatusLine().getStatusCode();
    }

    private static String substituteVariables(ServerConfigManager serverConfigManager, String s) {
        return s != null ? serverConfigManager.substituteVariables(s) : null;
    }

    public static String decryptIfNeeded(String s) {
        try {
            s = EncryptionHelper.decrypt(s);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return s;
    }

    public static BintrayConfig getBintrayConfig() {
        ServerConfigManager serverConfigManager = ServerConfigManager.getInstance();
        return serverConfigManager.getBintrayConfig();
    }

    public static String getBintrayUrl() {
        String bintrayUrl = System.getenv("BAMBOO_BINTRAY_URL");
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)bintrayUrl)) {
            bintrayUrl = "https://api.bintray.com/";
        }
        return bintrayUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSpecFromFile(File sourceCodeDirectory, String specFilePath) throws IOException {
        String string;
        FileInputStream fis = null;
        try {
            Path path = Paths.get(specFilePath, new String[0]);
            File specFile = path.isAbsolute() ? path.toFile() : Paths.get(sourceCodeDirectory.getAbsolutePath(), specFilePath).toFile();
            fis = new FileInputStream(specFile);
            byte[] data = new byte[(int)specFile.length()];
            fis.read(data);
            string = new String(data, "UTF-8");
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fis);
            throw throwable;
        }
        IOUtils.closeQuietly(fis);
        return string;
    }
}

