/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.util.deployment;

import com.atlassian.bamboo.task.TaskDefinition;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileFilter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class FilesCollector {
    private static final String PATH_KEY = "localPath";
    private String projectRoot;
    private List<String> subDirectories;
    private Map<String, Set<File>> collectedFiles;

    public FilesCollector(String projectRoot, TaskDefinition taskDefinition) {
        this.projectRoot = projectRoot;
        this.subDirectories = Lists.newArrayList();
        this.collectSubDirectories(taskDefinition);
    }

    public Map<String, Set<File>> getCollectedFiles() {
        if (this.collectedFiles == null) {
            this.collectFiles();
        }
        return this.collectedFiles;
    }

    private void collectFiles() {
        File[] preConfiguredDirectories;
        this.collectedFiles = Maps.newHashMap();
        File dir = new File(this.projectRoot);
        for (File subDir : preConfiguredDirectories = dir.listFiles(new PreConfiguredDirectoriesFilter(this.subDirectories))) {
            Iterator<File> files = FileUtils.iterateFiles(subDir, null, true);
            HashSet<File> currentPathFiles = Sets.newHashSet();
            this.collectedFiles.put(subDir.getAbsolutePath().substring(this.projectRoot.length() + 1), currentPathFiles);
            while (files.hasNext()) {
                File current = files.next();
                if (!current.isFile()) continue;
                currentPathFiles.add(current);
            }
        }
        File[] otherFiles = dir.listFiles(new RootDirFilesFilter(this.projectRoot, this.subDirectories));
        HashSet<File> rootDirFiles = Sets.newHashSet();
        this.collectedFiles.put("", rootDirFiles);
        for (File otherFile : otherFiles) {
            if (!otherFile.isFile()) continue;
            rootDirFiles.add(otherFile);
        }
    }

    private void collectSubDirectories(TaskDefinition artifactsDownloadRtd) {
        if (artifactsDownloadRtd != null) {
            Map downloadTaskConfiguration = artifactsDownloadRtd.getConfiguration();
            for (String s : downloadTaskConfiguration.keySet()) {
                if (!s.startsWith(PATH_KEY)) continue;
                this.subDirectories.add((String)downloadTaskConfiguration.get(s));
            }
        }
    }

    private class PreConfiguredDirectoriesFilter
    implements FileFilter {
        private List<String> subDirs;

        public PreConfiguredDirectoriesFilter(List<String> subDirs) {
            this.subDirs = subDirs;
        }

        @Override
        public boolean accept(File pathname) {
            if (pathname.isDirectory()) {
                for (String subDir : this.subDirs) {
                    if (!StringUtils.endsWith((CharSequence)pathname.getAbsolutePath(), (CharSequence)subDir)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private class RootDirFilesFilter
    implements FileFilter {
        private String rootDirectory;
        private List<String> subDirs;

        public RootDirFilesFilter(String rootDirectory, List<String> subDirs) {
            this.rootDirectory = rootDirectory;
            this.subDirs = subDirs;
        }

        @Override
        public boolean accept(File pathname) {
            String substring = pathname.getAbsolutePath().substring(this.rootDirectory.length() + 1);
            return !this.subDirs.contains(substring);
        }
    }
}

