/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.util.generic;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jfrog.build.api.Dependency;
import org.jfrog.build.api.dependency.DownloadableArtifact;
import org.jfrog.build.api.util.FileChecksumCalculator;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.clientConfiguration.client.ArtifactoryDependenciesClient;
import org.jfrog.build.extractor.clientConfiguration.util.DependenciesDownloader;
import org.jfrog.build.extractor.clientConfiguration.util.DependenciesDownloaderHelper;

public class DependenciesDownloaderImpl
implements DependenciesDownloader {
    private ArtifactoryDependenciesClient client;
    private Log log;
    private File workingDirectory;
    private boolean flatDownload = false;

    public DependenciesDownloaderImpl(ArtifactoryDependenciesClient client, File workingDirectory, Log log) {
        this.client = client;
        this.workingDirectory = workingDirectory;
        this.log = log;
    }

    @Override
    public ArtifactoryDependenciesClient getClient() {
        return this.client;
    }

    @Override
    public List<Dependency> download(Set<DownloadableArtifact> downloadableArtifacts) throws IOException {
        DependenciesDownloaderHelper helper = new DependenciesDownloaderHelper(this, this.log);
        return helper.downloadDependencies(downloadableArtifacts);
    }

    @Override
    public String getTargetDir(String targetDir, String relativeDir) throws IOException {
        return FilenameUtils.concat(this.workingDirectory.getPath(), FilenameUtils.concat(targetDir, relativeDir));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> saveDownloadedFile(InputStream is, String filePath) throws IOException {
        try {
            File newFile = new File(filePath);
            com.atlassian.core.util.FileUtils.copyFile((InputStream)is, (File)newFile, (boolean)true);
            Map<String, String> map = FileChecksumCalculator.calculateChecksums(newFile, "md5", "sha1");
            return map;
        }
        catch (Exception e) {
            this.log.warn("Caught exception while saving dependency file" + e.getLocalizedMessage());
        }
        finally {
            IOUtils.closeQuietly(is);
        }
        return null;
    }

    @Override
    public boolean isFileExistsLocally(String filePath, String md5, String sha1) throws IOException {
        File localFile = new File(filePath);
        if (!localFile.exists()) {
            return false;
        }
        if (localFile.isDirectory()) {
            return true;
        }
        try {
            Map<String, String> checksumsMap = FileChecksumCalculator.calculateChecksums(localFile, "md5", "sha1");
            return checksumsMap != null && StringUtils.isNotBlank(md5) && StringUtils.equals(md5, checksumsMap.get("md5")) && StringUtils.isNotBlank(sha1) && StringUtils.equals(sha1, checksumsMap.get("sha1"));
        }
        catch (NoSuchAlgorithmException e) {
            this.log.warn("Could not find checksum algorithm: " + e.getLocalizedMessage());
            return false;
        }
    }

    @Override
    public void removeUnusedArtifactsFromLocal(Set<String> allResolvesFiles, Set<String> forDeletionFiles) throws IOException {
        try {
            for (String resolvedFile : forDeletionFiles) {
                File resolvedFileParent = FileUtils.getFile(resolvedFile).getParentFile();
                File[] fileSiblings = resolvedFileParent.listFiles();
                if (fileSiblings == null || fileSiblings.length == 0) continue;
                for (File sibling : fileSiblings) {
                    if (this.isResolvedOrParentOfResolvedFile(allResolvesFiles, sibling.getPath())) continue;
                    this.log.info("Deleted unresolved file '" + sibling.getPath() + "'");
                    sibling.delete();
                }
            }
        }
        catch (Exception e) {
            this.log.warn("Caught interrupted exception: " + e.getLocalizedMessage());
        }
    }

    private boolean isResolvedOrParentOfResolvedFile(Set<String> resolvedFiles, final String path) {
        return Iterables.any(resolvedFiles, new Predicate<String>(){

            @Override
            public boolean apply(String filePath) {
                return StringUtils.equals(filePath, path) || StringUtils.startsWith(filePath, path);
            }
        });
    }

    public boolean getFlatDownload() {
        return this.flatDownload;
    }

    @Override
    public void setFlatDownload(boolean flat) {
        this.flatDownload = flat;
    }
}

