/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.util.generic;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.util.BuildUtils;
import com.atlassian.bamboo.utils.EscapeChars;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.trigger.DependencyTriggerReason;
import com.atlassian.bamboo.v2.build.trigger.ManualBuildTriggerReason;
import com.atlassian.bamboo.v2.build.trigger.TriggerReason;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jfrog.bamboo.builder.BaseBuildInfoHelper;
import org.jfrog.bamboo.context.GenericContext;
import org.jfrog.bamboo.util.TaskUtils;
import org.jfrog.build.api.Agent;
import org.jfrog.build.api.Artifact;
import org.jfrog.build.api.Build;
import org.jfrog.build.api.BuildType;
import org.jfrog.build.api.builder.ArtifactBuilder;
import org.jfrog.build.api.builder.BuildInfoBuilder;
import org.jfrog.build.api.builder.ModuleBuilder;
import org.jfrog.build.api.util.FileChecksumCalculator;
import org.jfrog.build.client.DeployDetails;
import org.jfrog.build.extractor.clientConfiguration.IncludeExcludePatterns;
import org.jfrog.build.extractor.clientConfiguration.PatternMatcher;
import org.jfrog.build.extractor.clientConfiguration.util.PublishedItemsHelper;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public class GenericBuildInfoHelper
extends BaseBuildInfoHelper {
    private static final Logger log = Logger.getLogger(GenericBuildInfoHelper.class);
    private final Map<String, String> env;
    private final String vcsRevision;
    private final String vcsUrl;

    public GenericBuildInfoHelper(Map<String, String> env, String vcsRevision, String vcsUrl) {
        this.env = env;
        this.vcsRevision = vcsRevision;
        this.vcsUrl = vcsUrl;
    }

    public Build extractBuildInfo(BuildContext buildContext, BuildLogger buildLogger, GenericContext context, String username) {
        String principal;
        String url = this.determineBambooBaseUrl();
        StringBuilder summaryUrl = new StringBuilder(url);
        if (!url.endsWith("/")) {
            summaryUrl.append("/");
        }
        String buildUrl = summaryUrl.append("browse/").append(EscapeChars.forFormSubmission((String)buildContext.getPlanResultKey().getKey())).toString();
        DateTime start = new DateTime(buildContext.getBuildResult().getCustomBuildData().get("buildTimeStamp"));
        DateTime end = new DateTime();
        long duration = -1L;
        if (start.isBefore((ReadableInstant)end)) {
            duration = new Interval((ReadableInstant)start, (ReadableInstant)end).toDurationMillis();
        } else {
            log.warn(buildLogger.addErrorLogEntry("Agent machine time is lower than the server machine time, please synchronize them."));
        }
        BuildInfoBuilder builder = new BuildInfoBuilder(buildContext.getPlanName()).number(String.valueOf(buildContext.getBuildNumber())).type(BuildType.GENERIC).agent(new Agent("Bamboo", BuildUtils.getVersionAndBuild())).artifactoryPrincipal(username).startedDate(new Date()).durationMillis(duration).url(buildUrl);
        if (StringUtils.isNotBlank(this.vcsRevision)) {
            builder.vcsRevision(this.vcsRevision);
        }
        if (StringUtils.isNotBlank(this.vcsUrl)) {
            builder.vcsUrl(this.vcsUrl);
        }
        if (StringUtils.isBlank(principal = this.getTriggeringUserNameRecursively(buildContext))) {
            principal = "auto";
        }
        builder.principal(principal);
        if (context.isIncludeEnvVars()) {
            HashMap<String, String> props = Maps.newHashMap(TaskUtils.getEscapedEnvMap(this.env));
            props.putAll(this.getBuildInfoConfigPropertiesFileParams((String)props.get("buildInfoConfig.propertiesFile")));
            IncludeExcludePatterns patterns = new IncludeExcludePatterns(context.getEnvVarsIncludePatterns(), context.getEnvVarsExcludePatterns());
            for (Map.Entry prop : props.entrySet()) {
                String varKey = (String)prop.getKey();
                if (PatternMatcher.pathConflicts(varKey, patterns)) continue;
                if (!StringUtils.startsWith(varKey, "artifactory.deploy.") && !StringUtils.startsWith(varKey, "buildInfo.property.")) {
                    varKey = "buildInfo.env." + varKey;
                }
                builder.addProperty(varKey, prop.getValue());
            }
        }
        return builder.build();
    }

    private List<Artifact> convertDeployDetailsToArtifacts(Set<DeployDetails> details) {
        ArrayList<Artifact> result = Lists.newArrayList();
        for (DeployDetails detail : details) {
            String ext = FilenameUtils.getExtension(detail.getFile().getName());
            Artifact artifact = new ArtifactBuilder(detail.getFile().getName()).md5(detail.getMd5()).sha1(detail.getSha1()).type(ext).build();
            result.add(artifact);
        }
        return result;
    }

    private String getTriggeringUserNameRecursively(BuildContext context) {
        BuildContext parentContext;
        String principal = null;
        TriggerReason triggerReason = context.getTriggerReason();
        if (triggerReason instanceof ManualBuildTriggerReason && StringUtils.isBlank(principal = ((ManualBuildTriggerReason)triggerReason).getUserName()) && (parentContext = context.getParentBuildContext()) != null) {
            principal = this.getTriggeringUserNameRecursively(parentContext);
        }
        return principal;
    }

    public Set<DeployDetails> createDeployDetailsAndAddToBuildInfo(Build build, Multimap<String, File> filesMap, BuildContext buildContext, GenericContext genericContext) throws IOException, NoSuchAlgorithmException {
        HashSet<DeployDetails> details = Sets.newHashSet();
        Map<String, String> dynamicPropertyMap = this.getDynamicPropertyMap(build);
        String repoKey = this.overrideParam(genericContext.getRepoKey(), "artifactory.override.deploy.repo");
        for (Map.Entry<String, File> entry : filesMap.entries()) {
            details.addAll(this.buildDeployDetailsFromFileSet(entry, repoKey, dynamicPropertyMap));
        }
        List<Artifact> artifacts = this.convertDeployDetailsToArtifacts(details);
        ModuleBuilder moduleBuilder = new ModuleBuilder().id(buildContext.getPlanName() + ":" + buildContext.getBuildNumber()).artifacts(artifacts);
        build.setModules(Lists.newArrayList(moduleBuilder.build()));
        return details;
    }

    public Map<String, String> getDynamicPropertyMap(Build build) {
        HashMap<String, String> filteredPropertyMap = new HashMap<String, String>();
        if (build.getProperties() != null) {
            for (Map.Entry<Object, Object> entry : build.getProperties().entrySet()) {
                String key = entry.getKey().toString();
                if (!StringUtils.startsWith(key, "artifactory.deploy.")) continue;
                filteredPropertyMap.put(StringUtils.removeStart(key, "artifactory.deploy."), (String)entry.getValue());
            }
        }
        return filteredPropertyMap;
    }

    private Set<DeployDetails> buildDeployDetailsFromFileSet(Map.Entry<String, File> fileEntry, String targetRepository, Map<String, String> propertyMap) throws IOException, NoSuchAlgorithmException {
        HashSet<DeployDetails> result = Sets.newHashSet();
        String targetPath = fileEntry.getKey();
        File artifactFile = fileEntry.getValue();
        String path = PublishedItemsHelper.calculateTargetPath(targetPath, artifactFile);
        path = StringUtils.replace(path, "//", "/");
        Map<String, String> checksums = FileChecksumCalculator.calculateChecksums(artifactFile, "SHA1", "MD5");
        DeployDetails.Builder deployDetails = new DeployDetails.Builder().file(artifactFile).md5(checksums.get("MD5")).sha1(checksums.get("SHA1")).targetRepository(targetRepository).artifactPath(path);
        this.addCommonProperties(propertyMap);
        deployDetails.addProperties(propertyMap);
        result.add(deployDetails.build());
        return result;
    }

    public void addCommonProperties(Map<String, String> propertyMap) {
        propertyMap.put("build.name", this.context.getPlanName());
        propertyMap.put("build.number", String.valueOf(this.context.getBuildNumber()));
        if (StringUtils.isNotBlank(this.vcsRevision)) {
            propertyMap.put("vcs.revision", this.vcsRevision);
        }
        if (StringUtils.isNotBlank(this.vcsUrl)) {
            propertyMap.put("vcs.url", this.vcsUrl);
        }
        String buildTimeStampVal = (String)this.context.getBuildResult().getCustomBuildData().get("buildTimeStamp");
        long buildTimeStamp = System.currentTimeMillis();
        if (StringUtils.isNotBlank(buildTimeStampVal)) {
            buildTimeStamp = new DateTime((Object)buildTimeStampVal).getMillis();
        }
        String buildTimeStampString = String.valueOf(buildTimeStamp);
        propertyMap.put("build.timestamp", buildTimeStampString);
        this.addBuildParentProperties(propertyMap, this.context.getTriggerReason());
    }

    private void addBuildParentProperties(Map<String, String> propertyMap, TriggerReason triggerReason) {
        String triggeringBuildResultKey;
        if (triggerReason instanceof DependencyTriggerReason && StringUtils.isNotBlank(triggeringBuildResultKey = ((DependencyTriggerReason)triggerReason).getTriggeringBuildResultKey()) && StringUtils.split(triggeringBuildResultKey, "-").length == 3) {
            String triggeringBuildKey = triggeringBuildResultKey.substring(0, triggeringBuildResultKey.lastIndexOf("-"));
            String triggeringBuildNumber = triggeringBuildResultKey.substring(triggeringBuildResultKey.lastIndexOf("-") + 1);
            String parentBuildName = this.getBuildName(triggeringBuildKey);
            if (StringUtils.isBlank(parentBuildName)) {
                log.error("Received a null build parent name.");
            }
            propertyMap.put("build.parentName", parentBuildName);
            propertyMap.put("build.parentNumber", triggeringBuildNumber);
        }
    }
}

