/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.util.version;

import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.storage.StorageLocationService;
import com.atlassian.spring.container.ContainerManager;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Closeables;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.dispatcher.Parameter;
import org.jfrog.bamboo.context.AbstractBuildContext;
import org.jfrog.bamboo.context.GradleBuildContext;
import org.jfrog.bamboo.release.action.ModuleVersionHolder;
import org.jfrog.bamboo.util.version.VersionHelper;

public class GradleVersionHelper
extends VersionHelper {
    protected GradleVersionHelper(AbstractBuildContext context) {
        super(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ModuleVersionHolder> filterPropertiesForRelease(Plan plan, int latestBuildNumberWithBi) throws RepositoryException, IOException {
        List<ModuleVersionHolder> result;
        block3: {
            result = Lists.newArrayList();
            StorageLocationService storageLocationService = (StorageLocationService)ContainerManager.getComponent((String)"storageLocationService");
            File directory = storageLocationService.getDefaultArtifactDirectoryBuilder().getBuildDirectory(PlanKeys.getPlanResultKey((String)plan.getKey(), (int)latestBuildNumberWithBi));
            File gradlePropertiesFile = new File(directory, "gradle/gradle.properties");
            if (!gradlePropertiesFile.exists()) break block3;
            Properties props = new Properties();
            FileInputStream stream = null;
            try {
                stream = new FileInputStream(gradlePropertiesFile);
                props.load(stream);
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(stream);
                throw throwable;
            }
            Closeables.closeQuietly(stream);
            result = this.context.releaseManagementContext.filterPropsForRelease(Maps.fromProperties(props));
        }
        for (ModuleVersionHolder holder : result) {
            holder.setReleaseValue(this.calculateReleaseVersion(holder.getOriginalValue()));
            if (holder.isReleaseProp()) continue;
            holder.setNextIntegValue(this.calculateNextVersion(holder.getReleaseValue()));
        }
        return result;
    }

    @Override
    public void addVersionFieldsToConfiguration(Map parameters, Map<String, String> configuration, String useCurrentVersion, Map<String, String> taskConfiguration) {
        if (Boolean.valueOf(useCurrentVersion).booleanValue()) {
            return;
        }
        GradleBuildContext buildContext = new GradleBuildContext(taskConfiguration);
        String releaseProps = buildContext.getReleaseProps();
        String[] split = StringUtils.split(releaseProps, ", ");
        int index = 0;
        Parameter moduleKeysParams = (Parameter)parameters.get("version.key");
        if (moduleKeysParams != null) {
            for (String key : moduleKeysParams.getMultipleValues()) {
                configuration.put("version.key." + index, key);
                configuration.put("version.releaseProp." + index, String.valueOf(this.isReleaseProp(split, key)));
                ++index;
            }
        }
        index = 0;
        Parameter originalValuesParams = (Parameter)parameters.get("version.currentValue");
        if (originalValuesParams != null) {
            for (String key : originalValuesParams.getMultipleValues()) {
                configuration.put("version.currentValue." + index, key);
                ++index;
            }
        }
        index = 0;
        Parameter nextIntegrationKeysParams = (Parameter)parameters.get("version.nextIntegValue");
        if (nextIntegrationKeysParams != null) {
            for (String key : nextIntegrationKeysParams.getMultipleValues()) {
                configuration.put("version.nextIntegValue." + index, key);
                configuration.put("version.releaseProp." + index, "false");
                ++index;
            }
        }
        index = 0;
        Parameter releaseValueKeysParams = (Parameter)parameters.get("version.releaseValue");
        if (releaseValueKeysParams != null) {
            for (String key : releaseValueKeysParams.getMultipleValues()) {
                configuration.put("version.releaseValue." + index, key);
                ++index;
            }
        }
    }

    private boolean isReleaseProp(String[] releaseProps, String prop) {
        for (String releaseProp : releaseProps) {
            if (!StringUtils.equals(releaseProp, prop)) continue;
            return true;
        }
        return false;
    }
}

