/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.util.version;

import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.storage.StorageLocationService;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityContext;
import com.atlassian.spring.container.ContainerManager;
import com.google.common.collect.Lists;
import com.google.common.io.CharStreams;
import com.google.common.io.Closeables;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.dispatcher.Parameter;
import org.jfrog.bamboo.context.AbstractBuildContext;
import org.jfrog.bamboo.release.action.ModuleVersionHolder;
import org.jfrog.bamboo.util.version.VersionHelper;
import org.jfrog.build.api.Build;
import org.jfrog.build.api.Module;
import org.jfrog.build.extractor.BuildInfoExtractorUtils;

public class MavenVersionHelper
extends VersionHelper {
    private static final Logger log = Logger.getLogger(MavenVersionHelper.class);
    private final CapabilityContext capabilityContext;

    protected MavenVersionHelper(AbstractBuildContext context, CapabilityContext capabilityContext) {
        super(context);
        this.capabilityContext = capabilityContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ModuleVersionHolder> filterPropertiesForRelease(Plan plan, int latestBuildNumberWithBi) throws RepositoryException, IOException {
        ArrayList<ModuleVersionHolder> result = Lists.newArrayList();
        StorageLocationService storageLocationService = (StorageLocationService)ContainerManager.getComponent((String)"storageLocationService");
        File directory = storageLocationService.getDefaultArtifactDirectoryBuilder().getBuildDirectory(PlanKeys.getPlanResultKey((String)plan.getKey(), (int)latestBuildNumberWithBi));
        File buildInfoFile = new File(directory, "buildInfo/build-info.json.zip");
        if (buildInfoFile.exists()) {
            InputStreamReader reader = null;
            try {
                reader = new InputStreamReader(new GZIPInputStream(new FileInputStream(buildInfoFile)));
                String buildInfoString = CharStreams.toString(reader);
                Build build = BuildInfoExtractorUtils.jsonStringToBuildInfo(buildInfoString);
                List<Module> modules = build.getModules();
                for (Module module : modules) {
                    String id = module.getId();
                    String[] split = StringUtils.split(id, ":");
                    ModuleVersionHolder holder = new ModuleVersionHolder(split[0] + ":" + split[1], split[2]);
                    holder.setReleaseValue(this.calculateReleaseVersion(holder.getOriginalValue()));
                    holder.setNextIntegValue(this.calculateNextVersion(holder.getReleaseValue()));
                    result.add(holder);
                }
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(reader);
                throw throwable;
            }
            Closeables.closeQuietly(reader);
        }
        return result;
    }

    @Override
    public void addVersionFieldsToConfiguration(Map parameters, Map<String, String> configuration, String versionConfiguration, Map<String, String> taskConfiguration) {
        if (versionConfiguration.equals("useExistingVersion")) {
            return;
        }
        if (versionConfiguration.equals("oneVersionAllModules")) {
            this.addGlobalVersion(parameters, configuration);
        }
        if (versionConfiguration.equals("versionPerModule")) {
            this.addPerModuleVersioning(parameters, configuration);
        }
    }

    private void addPerModuleVersioning(Map parameters, Map<String, String> configuration) {
        Parameter releaseValueKeysParams;
        Parameter nextIntegrationKeysParams;
        int index = 0;
        Parameter moduleKeysParams = (Parameter)parameters.get("version.key");
        if (moduleKeysParams != null) {
            for (String key : moduleKeysParams.getMultipleValues()) {
                configuration.put("version.key." + index, key);
                ++index;
            }
        }
        index = 0;
        Parameter originalValuesParams = (Parameter)parameters.get("version.currentValue");
        if (originalValuesParams != null) {
            for (String key : originalValuesParams.getMultipleValues()) {
                configuration.put("version.currentValue." + index, key);
                ++index;
            }
        }
        if ((nextIntegrationKeysParams = (Parameter)parameters.get("version.nextIntegValue")) != null) {
            String[] nextIntegrationKeys = nextIntegrationKeysParams.getMultipleValues();
            for (index = 1; index < nextIntegrationKeys.length; ++index) {
                String key = nextIntegrationKeys[index];
                configuration.put("version.nextIntegValue." + (index - 1), key);
            }
        }
        if ((releaseValueKeysParams = (Parameter)parameters.get("version.releaseValue")) != null) {
            String[] releaseValueKeys = releaseValueKeysParams.getMultipleValues();
            for (index = 1; index < releaseValueKeys.length; ++index) {
                String key;
                key = releaseValueKeys[index];
                configuration.put("version.releaseValue." + (index - 1), key);
            }
        }
    }

    private void addGlobalVersion(Map parameters, Map<String, String> configuration) {
        int index = 0;
        Parameter moduleKeysParams = (Parameter)parameters.get("version.key");
        if (moduleKeysParams != null) {
            Parameter releaseValueKeysParam = (Parameter)parameters.get("version.releaseValue");
            Parameter nextIntegrationKeysParam = (Parameter)parameters.get("version.nextIntegValue");
            for (String key : moduleKeysParams.getMultipleValues()) {
                configuration.put("version.key." + index, key);
                configuration.put("version.releaseValue." + index, releaseValueKeysParam.getValue());
                configuration.put("version.nextIntegValue." + index, nextIntegrationKeysParam.getValue());
                ++index;
            }
        }
    }
}

