/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.util.version;

import com.atlassian.bamboo.v2.build.BuildContext;
import java.io.File;
import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.Nullable;

public abstract class VcsHelper {
    @Nullable
    public static File getCheckoutDirectory(BuildContext buildContext) {
        Iterator repoIdIterator = buildContext.getRelevantRepositoryIds().iterator();
        if (repoIdIterator.hasNext()) {
            long repoId = (Long)repoIdIterator.next();
            String checkoutLocation = (String)buildContext.getCheckoutLocation().get(repoId);
            if (StringUtils.isNotBlank(checkoutLocation)) {
                return new File(checkoutLocation);
            }
        }
        return null;
    }

    @Nullable
    public static String getRevisionKey(BuildContext buildContext) {
        Iterator repoIdIterator = buildContext.getRelevantRepositoryIds().iterator();
        if (repoIdIterator.hasNext()) {
            long repoId = (Long)repoIdIterator.next();
            String key = buildContext.getBuildChanges().getVcsRevisionKey(repoId);
            if (StringUtils.isNotBlank(key)) {
                return key;
            }
        }
        return null;
    }

    @Nullable
    public static String getVcsUrl(BuildContext buildContext) {
        int repoSize = buildContext.getRelevantRepositoryIds().size();
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i <= repoSize; ++i) {
            String vcsUrl = (String)buildContext.getCurrentResult().getCustomBuildData().get("planRepository." + i + ".repositoryUrl");
            if (StringUtils.isBlank(vcsUrl) && StringUtils.isNotBlank((String)buildContext.getCurrentResult().getCustomBuildData().get("planRepository." + i + ".depot"))) {
                vcsUrl = "depot:" + (String)buildContext.getCurrentResult().getCustomBuildData().get("planRepository." + i + ".depot") + ",client:" + (String)buildContext.getCurrentResult().getCustomBuildData().get("planRepository." + i + ".client") + ",port:" + (String)buildContext.getCurrentResult().getCustomBuildData().get("planRepository." + i + ".port");
            }
            if (!StringUtils.isNotBlank(vcsUrl)) continue;
            if (i != 1) {
                sb.append(";").append(vcsUrl);
                continue;
            }
            sb.append(vcsUrl);
        }
        return sb.toString();
    }
}

