/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.client;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.util.EntityUtils;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.client.ArtifactoryUploadResponse;
import org.jfrog.build.client.ArtifactoryVersion;
import org.jfrog.build.client.PreemptiveHttpClient;
import org.jfrog.build.client.ProxyConfiguration;
import org.jfrog.build.util.URI;

public class ArtifactoryHttpClient {
    public static final ArtifactoryVersion UNKNOWN_PROPERTIES_TOLERANT_ARTIFACTORY_VERSION = new ArtifactoryVersion("2.2.3");
    public static final ArtifactoryVersion NON_NUMERIC_BUILD_NUMBERS_TOLERANT_ARTIFACTORY_VERSION = new ArtifactoryVersion("2.2.4");
    public static final ArtifactoryVersion STANDALONE_BUILD_RETENTION_SUPPORTED_ARTIFACTORY_VERSION = new ArtifactoryVersion("5.2.1");
    public static final ArtifactoryVersion MINIMAL_ARTIFACTORY_VERSION = new ArtifactoryVersion("2.2.3");
    public static final String VERSION_INFO_URL = "/api/system/version";
    private static final int DEFAULT_CONNECTION_TIMEOUT_SECS = 300;
    public static final int DEFAULT_CONNECTION_RETRY = 3;
    private final Log log;
    private final String artifactoryUrl;
    private final String username;
    private final String password;
    private int connectionTimeout = 300;
    private int connectionRetries = 3;
    private ProxyConfiguration proxyConfiguration;
    private PreemptiveHttpClient deployClient;

    public ArtifactoryHttpClient(String artifactoryUrl, String username, String password, Log log) {
        this.artifactoryUrl = org.apache.commons.lang.StringUtils.stripEnd(artifactoryUrl, "/");
        this.username = username;
        this.password = password;
        this.log = log;
    }

    public static String encodeUrl(String unescaped) {
        byte[] rawdata = URLCodec.encodeUrl(URI.allowed_query, StringUtils.getBytesUtf8(unescaped));
        return StringUtils.newStringUsAscii(rawdata);
    }

    public void setProxyConfiguration(String host, int port) {
        this.setProxyConfiguration(host, port, null, null);
    }

    public void setProxyConfiguration(String host, int port, String username, String password) {
        this.proxyConfiguration = new ProxyConfiguration();
        this.proxyConfiguration.host = host;
        this.proxyConfiguration.port = port;
        this.proxyConfiguration.username = username;
        this.proxyConfiguration.password = password;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setConnectionRetries(int connectionRetries) {
        this.connectionRetries = connectionRetries;
    }

    public int getConnectionRetries() {
        return this.connectionRetries;
    }

    public void close() {
        if (this.deployClient != null) {
            this.deployClient.close();
        }
    }

    public PreemptiveHttpClient getHttpClient() {
        return this.getHttpClient(this.connectionTimeout);
    }

    public PreemptiveHttpClient getHttpClient(int connectionTimeout) {
        if (this.deployClient == null) {
            this.deployClient = new PreemptiveHttpClient(this.username, this.password, connectionTimeout, this.proxyConfiguration, this.connectionRetries);
            this.deployClient.setLog(this.log);
        }
        return this.deployClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArtifactoryVersion getVersion() throws IOException {
        HttpGet httpGet;
        String versionUrl = this.artifactoryUrl + VERSION_INFO_URL;
        PreemptiveHttpClient client = this.getHttpClient();
        HttpResponse response = client.execute(httpGet = new HttpGet(versionUrl));
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode == 404) {
            HttpEntity httpEntity = response.getEntity();
            if (httpEntity != null) {
                EntityUtils.consume(httpEntity);
            }
            return ArtifactoryVersion.NOT_FOUND;
        }
        if (statusCode != 200) {
            if (response.getEntity() != null) {
                EntityUtils.consume(response.getEntity());
            }
            throw new IOException(response.getStatusLine().getReasonPhrase());
        }
        HttpEntity httpEntity = response.getEntity();
        if (httpEntity != null) {
            InputStream content = httpEntity.getContent();
            try {
                JsonParser parser = this.createJsonParser(content);
                EntityUtils.consume(httpEntity);
                JsonNode result = (JsonNode)parser.readValueAsTree();
                this.log.debug("Version result: " + result);
                String version = result.get("version").asText();
                JsonNode addonsNode = result.get("addons");
                boolean hasAddons = addonsNode != null && addonsNode.iterator().hasNext();
                ArtifactoryVersion artifactoryVersion = new ArtifactoryVersion(version, hasAddons);
                return artifactoryVersion;
            }
            finally {
                if (content != null) {
                    content.close();
                }
            }
        }
        return ArtifactoryVersion.NOT_FOUND;
    }

    public JsonParser createJsonParser(InputStream in) throws IOException {
        JsonFactory jsonFactory = this.createJsonFactory();
        return jsonFactory.createJsonParser(in);
    }

    public JsonParser createJsonParser(String content) throws IOException {
        JsonFactory jsonFactory = this.createJsonFactory();
        return jsonFactory.createJsonParser(content);
    }

    public JsonFactory createJsonFactory() {
        JsonFactory jsonFactory = new JsonFactory();
        ObjectMapper mapper = new ObjectMapper(jsonFactory);
        mapper.setAnnotationIntrospector(new JacksonAnnotationIntrospector());
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        jsonFactory.setCodec(mapper);
        return jsonFactory;
    }

    public ArtifactoryUploadResponse upload(HttpPut httpPut, HttpEntity fileEntity) throws IOException {
        httpPut.setEntity(fileEntity);
        return this.execute(httpPut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArtifactoryUploadResponse execute(HttpPut httpPut) throws IOException {
        InputStream in;
        String content;
        HttpResponse response = this.getHttpClient().execute(httpPut);
        ArtifactoryUploadResponse artifactoryResponse = null;
        if (response.getEntity() != null && response.getEntity().getContent() != null && org.apache.commons.lang.StringUtils.isNotEmpty(content = IOUtils.toString(in = response.getEntity().getContent(), "UTF-8"))) {
            try {
                JsonParser parser = this.createJsonParser(content);
                artifactoryResponse = parser.readValueAs(ArtifactoryUploadResponse.class);
            }
            catch (Exception e) {
                this.log.info("Response received: \n\n" + content + "\n\n");
                this.log.error("Failed while reading the response from: " + httpPut, e);
            }
            finally {
                in.close();
            }
        }
        if (artifactoryResponse == null) {
            artifactoryResponse = new ArtifactoryUploadResponse();
        }
        StatusLine statusLine = response.getStatusLine();
        artifactoryResponse.setStatusLine(statusLine);
        return artifactoryResponse;
    }
}

