/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.context;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.jfrog.build.api.Dependency;
import org.jfrog.build.api.Module;
import org.jfrog.build.client.DeployDetails;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;

public class BuildContext {
    private final Set<DeployDetails> deployDetails;
    private final List<Module> modules;
    private final List<Dependency> dependencies;
    private final ArtifactoryClientConfiguration clientConf;
    private long buildStartTime;

    public BuildContext(ArtifactoryClientConfiguration clientConf) {
        this.clientConf = clientConf;
        this.deployDetails = new TreeSet<DeployDetails>(new Comparator<DeployDetails>(){

            @Override
            public int compare(DeployDetails details, DeployDetails otherDetails) {
                return details.getFile().compareTo(otherDetails.getFile());
            }
        });
        this.modules = new ArrayList<Module>();
        this.dependencies = new ArrayList<Dependency>();
        this.buildStartTime = System.currentTimeMillis();
    }

    public void addDeployDetailsForModule(DeployDetails deployDetails) {
        this.deployDetails.add(deployDetails);
    }

    public void addModule(Module module) {
        this.modules.add(module);
    }

    public List<Module> getModules() {
        return this.modules;
    }

    public Set<DeployDetails> getDeployDetails() {
        return this.deployDetails;
    }

    public void addDependency(Dependency dependency) {
        this.dependencies.add(dependency);
    }

    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    public ArtifactoryClientConfiguration getClientConf() {
        return this.clientConf;
    }

    public long getBuildStartTime() {
        return this.buildStartTime;
    }

    public void setBuildStartTime(long buildStartTime) {
        this.buildStartTime = buildStartTime;
    }
}

