/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor;

import com.google.common.primitives.Bytes;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class EolDetectingInputStream
extends InputStream {
    private static final byte[] lfBytes = new byte[]{10};
    private static final byte[] crBytes = new byte[]{13};
    private boolean lf;
    private boolean cr;
    private InputStream inputStream;

    public EolDetectingInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    @Override
    public int read() throws IOException {
        int readByte = this.inputStream.read();
        if (!(this.lf && this.cr || readByte == -1)) {
            byte[] bytes = new byte[]{(byte)(readByte >>> 24), (byte)(readByte >>> 16), (byte)(readByte >>> 8), (byte)readByte};
            this.isByteEol(bytes);
        }
        return readByte;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int readBytes = this.inputStream.read(b);
        if (!(this.lf && this.cr || readBytes == -1)) {
            this.isByteEol(b);
        }
        return readBytes;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int readBytes = this.inputStream.read(b, off, len);
        if (!(this.lf && this.cr || readBytes == -1)) {
            this.isByteEol(Arrays.copyOfRange(b, off, off + (readBytes - 1)));
        }
        return readBytes;
    }

    @Override
    public long skip(long n) throws IOException {
        return this.inputStream.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.inputStream.available();
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    @Override
    public void mark(int readlimit) {
        this.inputStream.mark(readlimit);
    }

    @Override
    public void reset() throws IOException {
        this.inputStream.reset();
    }

    @Override
    public boolean markSupported() {
        return this.inputStream.markSupported();
    }

    public boolean isLf() {
        return this.lf;
    }

    public boolean isCr() {
        return this.cr;
    }

    public String getEol() {
        String eol = "";
        if (this.cr) {
            eol = eol + "\r";
        }
        if (this.lf) {
            eol = eol + "\n";
        }
        return eol;
    }

    private void isByteEol(byte[] bytes) {
        if (!this.lf) {
            this.lf = this.isByteEol(bytes, lfBytes);
        }
        if (!this.cr) {
            this.cr = this.isByteEol(bytes, crBytes);
        }
    }

    private boolean isByteEol(byte[] bytesToCheck, byte[] eolType) {
        return Bytes.indexOf(bytesToCheck, eolType) != -1;
    }
}

