/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration.client;

import org.apache.commons.lang.StringUtils;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.client.ArtifactoryHttpClient;
import org.jfrog.build.client.ProxyConfiguration;

public abstract class ArtifactoryBaseClient {
    protected String artifactoryUrl;
    protected ArtifactoryHttpClient httpClient;
    protected final Log log;

    public ArtifactoryBaseClient(String artifactoryUrl, String username, String password, Log logger) {
        this.artifactoryUrl = StringUtils.stripEnd(artifactoryUrl, "/");
        this.httpClient = new ArtifactoryHttpClient(this.artifactoryUrl, username, password, logger);
        this.log = logger;
    }

    public void close() {
        if (this.httpClient != null) {
            this.httpClient.close();
        }
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.httpClient.setConnectionTimeout(connectionTimeout);
    }

    public void setConnectionRetries(int connectionRetries) {
        this.httpClient.setConnectionRetries(connectionRetries);
    }

    public void setProxyConfiguration(String host, int port) {
        this.httpClient.setProxyConfiguration(host, port, null, null);
    }

    public void setProxyConfiguration(String host, int port, String username, String password) {
        this.httpClient.setProxyConfiguration(host, port, username, password);
    }

    public void setProxyConfiguration(ProxyConfiguration proxy) {
        this.httpClient.setProxyConfiguration(proxy.host, proxy.port, proxy.username, proxy.password);
    }

    public void setLog(Log log) {
        this.httpClient.getHttpClient().setLog(log);
    }

    public String getArtifactoryUrl() {
        return this.artifactoryUrl;
    }
}

