/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration.client;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Function;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.jfrog.build.api.Build;
import org.jfrog.build.api.BuildRetention;
import org.jfrog.build.api.release.BintrayUploadInfoOverride;
import org.jfrog.build.api.release.Distribution;
import org.jfrog.build.api.release.Promotion;
import org.jfrog.build.api.util.FileChecksumCalculator;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.client.ArtifactoryHttpClient;
import org.jfrog.build.client.ArtifactoryUploadResponse;
import org.jfrog.build.client.ArtifactoryVersion;
import org.jfrog.build.client.DeployDetails;
import org.jfrog.build.client.PreemptiveHttpClient;
import org.jfrog.build.client.bintrayResponse.BintrayResponse;
import org.jfrog.build.client.bintrayResponse.BintrayResponseFactory;
import org.jfrog.build.extractor.clientConfiguration.client.ArtifactoryBaseClient;
import org.jfrog.build.extractor.clientConfiguration.util.DeploymentUrlUtils;
import org.jfrog.build.util.VersionCompatibilityType;
import org.jfrog.build.util.VersionException;

public class ArtifactoryBuildInfoClient
extends ArtifactoryBaseClient {
    private static final String LOCAL_REPOS_REST_URL = "/api/repositories?type=local";
    private static final String REMOTE_REPOS_REST_URL = "/api/repositories?type=remote";
    private static final String VIRTUAL_REPOS_REST_URL = "/api/repositories?type=virtual";
    private static final String PUSH_TO_BINTRAY_REST_URL = "/api/build/pushToBintray/";
    private static final String BUILD_REST_URL = "/api/build";
    private static final String BUILD_RETENTION_REST_URL = "/api/build/retention/";
    private static final String BUILD_RETENTION_REST_ASYNC_PARAM = "?async=";
    private static final int CHECKSUM_DEPLOY_MIN_FILE_SIZE = 10240;
    public static final String BUILD_BROWSE_URL = "/webapp/builds";
    public static final String APPLICATION_VND_ORG_JFROG_ARTIFACTORY_JSON = "application/vnd.org.jfrog.artifactory+json";
    public static final String APPLICATION_JSON = "application/json";
    private ArtifactoryVersion artifactoryVersion;

    public ArtifactoryBuildInfoClient(String artifactoryUrl, Log log) {
        this(artifactoryUrl, null, null, log);
    }

    public ArtifactoryBuildInfoClient(String artifactoryUrl, String username, String password, Log log) {
        super(artifactoryUrl, username, password, log);
    }

    public List<String> getLocalRepositoriesKeys() throws IOException {
        return this.getRepositoriesList(LOCAL_REPOS_REST_URL);
    }

    public List<String> getLocalAndCacheRepositoriesKeys() throws IOException {
        List<String> localRepositoriesKeys = this.getLocalRepositoriesKeys();
        List<String> remoteRepositories = this.getRemoteRepositoriesKeys();
        List<String> cacheRepositories = Lists.transform(remoteRepositories, new Function<String, String>(){

            @Override
            public String apply(String repoKey) {
                return repoKey + "-cache";
            }
        });
        return Lists.newArrayList(Iterables.concat(localRepositoriesKeys, cacheRepositories));
    }

    public List<String> getRemoteRepositoriesKeys() throws IOException {
        return this.getRepositoriesList(REMOTE_REPOS_REST_URL);
    }

    public List<String> getVirtualRepositoryKeys() throws IOException {
        return this.getRepositoriesList(VIRTUAL_REPOS_REST_URL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getRepositoriesList(String restUrl) throws IOException {
        ArrayList<String> repositories = new ArrayList<String>();
        PreemptiveHttpClient client = this.httpClient.getHttpClient();
        String reposUrl = this.artifactoryUrl + restUrl;
        this.log.debug("Requesting repositories list from: " + reposUrl);
        HttpGet httpget = new HttpGet(reposUrl);
        HttpResponse response = client.execute(httpget);
        StatusLine statusLine = response.getStatusLine();
        HttpEntity entity = response.getEntity();
        if (statusLine.getStatusCode() != 200) {
            throw new IOException("Failed to obtain list of repositories. Status code: " + statusLine.getStatusCode() + this.getMessageFromEntity(entity));
        }
        if (entity != null) {
            repositories = new ArrayList();
            InputStream content = entity.getContent();
            try {
                JsonParser parser = this.httpClient.createJsonParser(content);
                JsonNode result = (JsonNode)parser.readValueAsTree();
                this.log.debug("Repositories result = " + result);
                for (JsonNode jsonNode : result) {
                    String repositoryKey = jsonNode.get("key").asText();
                    repositories.add(repositoryKey);
                }
            }
            finally {
                if (content != null) {
                    content.close();
                }
            }
        }
        return repositories;
    }

    public void sendBuildInfo(String buildInfoJson) throws IOException {
        String url = this.artifactoryUrl + BUILD_REST_URL;
        HttpPut httpPut = new HttpPut(url);
        try {
            this.sendDescriptor(httpPut, buildInfoJson, APPLICATION_VND_ORG_JFROG_ARTIFACTORY_JSON);
        }
        catch (IOException e) {
            throw new IOException("Failed to send build descriptor. " + e.getMessage(), e);
        }
    }

    public void sendBuildRetetion(BuildRetention buildRetention, String buildName, boolean async) throws IOException {
        String buildRetentionJson = this.toJsonString(buildRetention);
        String url = this.artifactoryUrl + BUILD_RETENTION_REST_URL + buildName + BUILD_RETENTION_REST_ASYNC_PARAM + async;
        HttpPost httpPost = new HttpPost(url);
        try {
            this.log.info(this.createBuildRetentionLogMsg(buildRetention, async));
            this.log.debug(buildRetentionJson);
            this.sendRequest(httpPost, buildRetentionJson, APPLICATION_JSON, true);
        }
        catch (IOException e) {
            this.log.error("Failed to execute build retention.", e);
            throw new IOException("Failed to execute build retention: " + e.getMessage(), e);
        }
    }

    private String createBuildRetentionLogMsg(BuildRetention buildRetention, boolean async) {
        StringBuilder strBuilder = new StringBuilder().append("Sending");
        if (async) {
            strBuilder.append(" async");
        }
        strBuilder.append(" request for build retention");
        if (buildRetention.isDeleteBuildArtifacts()) {
            strBuilder.append(", deleting build artifacts");
        }
        if (buildRetention.getCount() != -1) {
            strBuilder.append(", max number of builds to store: ").append(buildRetention.getCount());
        }
        if (buildRetention.getMinimumBuildDate() != null) {
            strBuilder.append(", min build date: ").append(buildRetention.getMinimumBuildDate());
        }
        if (!buildRetention.getBuildNumbersNotToBeDiscarded().isEmpty()) {
            strBuilder.append(", build numbers not to be discarded: ").append(buildRetention.getBuildNumbersNotToBeDiscarded());
        }
        strBuilder.append(".");
        return strBuilder.toString();
    }

    public void sendBuildInfo(Build buildInfo) throws IOException {
        this.log.debug("Sending build info: " + buildInfo);
        try {
            this.sendBuildInfo(this.buildInfoToJsonString(buildInfo));
        }
        catch (Exception e) {
            this.log.error("Could not build the build-info object.", e);
            throw new IOException("Could not publish build-info: " + e.getMessage());
        }
        String url = this.artifactoryUrl + BUILD_BROWSE_URL + "/" + ArtifactoryHttpClient.encodeUrl(buildInfo.getName()) + "/" + ArtifactoryHttpClient.encodeUrl(buildInfo.getNumber());
        this.log.info("Build successfully deployed. Browse it in Artifactory under " + url);
    }

    public void sendModuleInfo(Build build) throws IOException {
        this.log.debug("Sending build info modules: " + build);
        try {
            String url = this.artifactoryUrl + BUILD_REST_URL + "/append/" + ArtifactoryHttpClient.encodeUrl(build.getName()) + "/" + ArtifactoryHttpClient.encodeUrl(build.getNumber());
            HttpPost httpPost = new HttpPost(url);
            String modulesAsJsonString = this.toJsonString(build.getModules());
            this.sendDescriptor(httpPost, modulesAsJsonString, APPLICATION_VND_ORG_JFROG_ARTIFACTORY_JSON);
        }
        catch (Exception e) {
            this.log.error("Could not build the build-info modules object.", e);
            throw new IOException("Could not publish build-info modules: " + e.getMessage(), e);
        }
    }

    private void sendDescriptor(HttpEntityEnclosingRequestBase request, String content, String contentType) throws IOException {
        this.log.info("Deploying build descriptor to: " + request.getURI().toString());
        this.sendRequest(request, content, contentType, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendRequest(HttpEntityEnclosingRequestBase request, String content, String contentType, boolean retry) throws IOException {
        StringEntity stringEntity = new StringEntity(content, "UTF-8");
        stringEntity.setContentType(contentType);
        request.setEntity(stringEntity);
        int connectionRetries = this.httpClient.getConnectionRetries();
        try {
            HttpResponse response;
            StatusLine statusLine;
            if (!retry) {
                this.httpClient.setConnectionRetries(0);
            }
            if ((statusLine = (response = this.httpClient.getHttpClient().execute(request)).getStatusLine()).getStatusCode() != 204) {
                HttpEntity responseEntity = response.getEntity();
                throw new IOException(statusLine.getStatusCode() + this.getMessageFromEntity(responseEntity));
            }
        }
        finally {
            this.httpClient.setConnectionRetries(connectionRetries);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getItemLastModified(String path) throws IOException, ParseException {
        String url = this.artifactoryUrl + "/api/storage/" + path + "?lastModified&deep=1";
        HttpGet get = new HttpGet(url);
        HttpResponse response = this.httpClient.getHttpClient().execute(get);
        StatusLine statusLine = response.getStatusLine();
        if (statusLine.getStatusCode() != 200) {
            HttpEntity entity = response.getEntity();
            throw new IOException("Failed to obtain item info. Status code: " + statusLine.getStatusCode() + this.getMessageFromEntity(entity));
        }
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            InputStream content = entity.getContent();
            try {
                JsonParser parser = this.httpClient.createJsonParser(content);
                JsonNode result = (JsonNode)parser.readValueAsTree();
                String string = result.get("lastModified").asText();
                return string;
            }
            finally {
                if (content != null) {
                    content.close();
                }
                EntityUtils.consume(entity);
            }
        }
        return null;
    }

    public ArtifactoryUploadResponse deployArtifact(DeployDetails details) throws IOException {
        StringBuilder deploymentPathBuilder = new StringBuilder(this.artifactoryUrl);
        deploymentPathBuilder.append("/").append(details.getTargetRepository());
        if (!details.getArtifactPath().startsWith("/")) {
            deploymentPathBuilder.append("/");
        }
        deploymentPathBuilder.append(details.getArtifactPath());
        String deploymentPath = deploymentPathBuilder.toString();
        this.log.info("Deploying artifact: " + deploymentPath);
        deploymentPath = ArtifactoryHttpClient.encodeUrl(deploymentPath);
        ArtifactoryUploadResponse response = this.uploadFile(details, deploymentPath);
        if (!this.getArtifactoryVersion().isAtLeast(new ArtifactoryVersion("2.3.2"))) {
            this.uploadChecksums(details, deploymentPath);
        }
        return response;
    }

    public ArtifactoryVersion verifyCompatibleArtifactoryVersion() throws VersionException {
        ArtifactoryVersion version;
        try {
            version = this.httpClient.getVersion();
        }
        catch (IOException e) {
            throw new VersionException("Error occurred while requesting version information: " + e.getMessage(), e, VersionCompatibilityType.NOT_FOUND);
        }
        if (version.isNotFound()) {
            throw new VersionException("There is either an incompatible or no instance of Artifactory at the provided URL.", VersionCompatibilityType.NOT_FOUND);
        }
        boolean isCompatibleArtifactory = version.isAtLeast(ArtifactoryHttpClient.MINIMAL_ARTIFACTORY_VERSION);
        if (!isCompatibleArtifactory) {
            throw new VersionException("This plugin is compatible with version " + ArtifactoryHttpClient.MINIMAL_ARTIFACTORY_VERSION + " of Artifactory and above. Please upgrade your Artifactory server!", VersionCompatibilityType.INCOMPATIBLE);
        }
        return version;
    }

    public BintrayResponse pushToBintray(String buildName, String buildNumber, String signMethod, String passphrase, BintrayUploadInfoOverride bintrayUploadInfo) throws IOException, URISyntaxException {
        if (StringUtils.isBlank(buildName)) {
            throw new IllegalArgumentException("Build name is required for promotion.");
        }
        if (StringUtils.isBlank(buildNumber)) {
            throw new IllegalArgumentException("Build number is required for promotion.");
        }
        String requestUrl = this.createRequestUrl(buildName, buildNumber, signMethod, passphrase);
        String requestBody = this.createJsonRequestBody(bintrayUploadInfo);
        HttpPost httpPost = new HttpPost(requestUrl);
        StringEntity entity = new StringEntity(requestBody);
        entity.setContentType(APPLICATION_JSON);
        httpPost.setEntity(entity);
        HttpResponse response = this.httpClient.getHttpClient().execute(httpPost);
        return this.parseResponse(response);
    }

    private String createRequestUrl(String buildName, String buildNumber, String signMethod, String passphrase) throws URISyntaxException {
        URIBuilder urlBuilder = new URIBuilder();
        urlBuilder.setPath(this.artifactoryUrl + PUSH_TO_BINTRAY_REST_URL + buildName + "/" + buildNumber);
        if (StringUtils.isNotEmpty(passphrase)) {
            urlBuilder.setParameter("gpgPassphrase", passphrase);
        }
        if (!StringUtils.equals(signMethod, "descriptor")) {
            urlBuilder.setParameter("gpgSign", signMethod);
        }
        return urlBuilder.toString();
    }

    private String createJsonRequestBody(BintrayUploadInfoOverride info) throws IOException {
        String bintrayInfoJson = !info.isValid() ? "{}" : this.toJsonString(info);
        return bintrayInfoJson;
    }

    private BintrayResponse parseResponse(HttpResponse response) throws IOException {
        InputStream content = response.getEntity().getContent();
        int status = response.getStatusLine().getStatusCode();
        JsonParser parser = this.httpClient.createJsonFactory().createJsonParser(content);
        BintrayResponse responseObject = BintrayResponseFactory.createResponse(status, parser);
        return responseObject;
    }

    public HttpResponse stageBuild(String buildName, String buildNumber, Promotion promotion) throws IOException {
        if (StringUtils.isBlank(buildName)) {
            throw new IllegalArgumentException("Build name is required for promotion.");
        }
        if (StringUtils.isBlank(buildNumber)) {
            throw new IllegalArgumentException("Build number is required for promotion.");
        }
        StringBuilder urlBuilder = new StringBuilder(this.artifactoryUrl).append(BUILD_REST_URL).append("/promote/").append(ArtifactoryHttpClient.encodeUrl(buildName)).append("/").append(ArtifactoryHttpClient.encodeUrl(buildNumber));
        String promotionJson = this.toJsonString(promotion);
        HttpPost httpPost = new HttpPost(urlBuilder.toString());
        StringEntity stringEntity = new StringEntity(promotionJson);
        stringEntity.setContentType("application/vnd.org.jfrog.artifactory.build.PromotionRequest+json");
        httpPost.setEntity(stringEntity);
        this.log.info("Promoting build " + buildName + ", #" + buildNumber);
        return this.httpClient.getHttpClient().execute(httpPost);
    }

    public HttpResponse distributeBuild(String buildName, String buildNumber, Distribution promotion) throws IOException {
        if (StringUtils.isBlank(buildName)) {
            throw new IllegalArgumentException("Build name is required for distribution.");
        }
        if (StringUtils.isBlank(buildNumber)) {
            throw new IllegalArgumentException("Build number is required for distribution.");
        }
        StringBuilder urlBuilder = new StringBuilder(this.artifactoryUrl).append(BUILD_REST_URL).append("/distribute/").append(ArtifactoryHttpClient.encodeUrl(buildName)).append("/").append(ArtifactoryHttpClient.encodeUrl(buildNumber));
        String distributionJson = this.toJsonString(promotion);
        HttpPost httpPost = new HttpPost(urlBuilder.toString());
        StringEntity stringEntity = new StringEntity(distributionJson);
        stringEntity.setContentType(APPLICATION_JSON);
        httpPost.setEntity(stringEntity);
        this.log.info("Distributing build " + buildName + ", #" + buildNumber);
        return this.httpClient.getHttpClient().execute(httpPost);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<Map>> getUserPluginInfo() throws IOException {
        String url = this.artifactoryUrl + "/api/plugins";
        HttpGet getPlugins = new HttpGet(url);
        HttpResponse getResponse = this.httpClient.getHttpClient().execute(getPlugins);
        StatusLine statusLine = getResponse.getStatusLine();
        HttpEntity responseEntity = getResponse.getEntity();
        if (statusLine.getStatusCode() != 200) {
            throw new IOException("Failed to obtain user plugin information. Status code: " + statusLine.getStatusCode() + this.getMessageFromEntity(responseEntity));
        }
        if (responseEntity != null) {
            InputStream content = responseEntity.getContent();
            try {
                JsonParser parser = this.httpClient.createJsonParser(content);
                Map map = parser.readValueAs(Map.class);
                return map;
            }
            finally {
                if (content != null) {
                    content.close();
                }
            }
        }
        return Maps.newHashMap();
    }

    public HttpResponse executeUserPlugin(String executionName, Map<String, String> requestParams) throws IOException {
        StringBuilder urlBuilder = new StringBuilder(this.artifactoryUrl).append("/api/plugins/execute/").append(executionName).append("?");
        this.appendParamsToUrl(requestParams, urlBuilder);
        HttpPost postRequest = new HttpPost(urlBuilder.toString());
        return this.httpClient.getHttpClient().execute(postRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getStagingStrategy(String strategyName, String buildName, Map<String, String> requestParams) throws IOException {
        StringBuilder urlBuilder = new StringBuilder(this.artifactoryUrl).append("/api/plugins/build/staging/").append(ArtifactoryHttpClient.encodeUrl(strategyName)).append("?buildName=").append(ArtifactoryHttpClient.encodeUrl(buildName)).append("&");
        this.appendParamsToUrl(requestParams, urlBuilder);
        HttpGet getRequest = new HttpGet(urlBuilder.toString());
        HttpResponse response = this.httpClient.getHttpClient().execute(getRequest);
        StatusLine statusLine = response.getStatusLine();
        HttpEntity responseEntity = response.getEntity();
        if (statusLine.getStatusCode() != 200) {
            throw new IOException("Failed to obtain staging strategy. Status code: " + statusLine.getStatusCode() + this.getMessageFromEntity(responseEntity));
        }
        if (responseEntity != null) {
            InputStream content = responseEntity.getContent();
            try {
                JsonParser parser = this.httpClient.createJsonParser(content);
                Map map = parser.readValueAs(Map.class);
                return map;
            }
            finally {
                if (content != null) {
                    content.close();
                }
            }
        }
        return Maps.newHashMap();
    }

    public HttpResponse executePromotionUserPlugin(String promotionName, String buildName, String buildNumber, Map<String, String> requestParams) throws IOException {
        StringBuilder urlBuilder = new StringBuilder(this.artifactoryUrl).append("/api/plugins/build/promote/").append(promotionName).append("/").append(ArtifactoryHttpClient.encodeUrl(buildName)).append("/").append(ArtifactoryHttpClient.encodeUrl(buildNumber)).append("?");
        this.appendParamsToUrl(requestParams, urlBuilder);
        HttpPost postRequest = new HttpPost(urlBuilder.toString());
        return this.httpClient.getHttpClient().execute(postRequest);
    }

    public HttpResponse executeUpdateFileProperty(String itemPath, String properties) throws IOException {
        StringBuilder urlBuilder = new StringBuilder(this.artifactoryUrl).append("/api/storage/").append(ArtifactoryHttpClient.encodeUrl(itemPath)).append("?").append("properties=").append(ArtifactoryHttpClient.encodeUrl(properties));
        HttpPut postRequest = new HttpPut(urlBuilder.toString());
        return this.httpClient.getHttpClient().execute(postRequest);
    }

    private void appendParamsToUrl(Map<String, String> requestParams, StringBuilder urlBuilder) throws UnsupportedEncodingException {
        if (requestParams != null && !requestParams.isEmpty()) {
            urlBuilder.append("params=");
            Iterator<Map.Entry<String, String>> paramEntryIterator = requestParams.entrySet().iterator();
            String encodedPipe = ArtifactoryHttpClient.encodeUrl("|");
            while (paramEntryIterator.hasNext()) {
                Map.Entry<String, String> paramEntry = paramEntryIterator.next();
                urlBuilder.append(ArtifactoryHttpClient.encodeUrl(paramEntry.getKey()));
                String paramValue = paramEntry.getValue();
                if (StringUtils.isNotBlank(paramValue)) {
                    urlBuilder.append("=").append(ArtifactoryHttpClient.encodeUrl(paramValue));
                }
                if (!paramEntryIterator.hasNext()) continue;
                urlBuilder.append(encodedPipe);
            }
        }
    }

    public String buildInfoToJsonString(Build buildInfo) throws Exception {
        ArtifactoryVersion version = this.verifyCompatibleArtifactoryVersion();
        if (!version.isAtLeast(ArtifactoryHttpClient.UNKNOWN_PROPERTIES_TOLERANT_ARTIFACTORY_VERSION)) {
            buildInfo.setBuildAgent(null);
            buildInfo.setParentName(null);
            buildInfo.setParentNumber(null);
            buildInfo.setVcsRevision(null);
        }
        if (!version.isAtLeast(ArtifactoryHttpClient.NON_NUMERIC_BUILD_NUMBERS_TOLERANT_ARTIFACTORY_VERSION)) {
            String buildNumber = buildInfo.getNumber();
            this.verifyNonNumericBuildNumber(buildNumber);
            String parentBuildNumber = buildInfo.getParentNumber();
            this.verifyNonNumericBuildNumber(parentBuildNumber);
        }
        return this.toJsonString(buildInfo);
    }

    String toJsonString(Object object) throws IOException {
        JsonFactory jsonFactory = this.httpClient.createJsonFactory();
        StringWriter writer = new StringWriter();
        JsonGenerator jsonGenerator = jsonFactory.createJsonGenerator(writer);
        jsonGenerator.useDefaultPrettyPrinter();
        jsonGenerator.writeObject(object);
        String result = writer.getBuffer().toString();
        return result;
    }

    private void verifyNonNumericBuildNumber(String buildNumber) {
        if (buildNumber != null) {
            try {
                Long.parseLong(buildNumber);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Cannot handle build/parent build number: " + buildNumber + ". Non-numeric build numbers are supported by Artifactory version " + ArtifactoryHttpClient.NON_NUMERIC_BUILD_NUMBERS_TOLERANT_ARTIFACTORY_VERSION + " and above. Please upgrade your Artifactory or use numeric build numbers.");
            }
        }
    }

    private ArtifactoryUploadResponse uploadFile(DeployDetails details, String uploadUrl) throws IOException {
        FileEntity fileEntity;
        int statusCode;
        ArtifactoryUploadResponse response = this.tryChecksumDeploy(details, uploadUrl);
        if (response != null) {
            return response;
        }
        HttpPut httpPut = this.createHttpPutMethod(details, uploadUrl);
        httpPut.addHeader("Expect", "100-continue");
        if (details.isExplode()) {
            httpPut.addHeader("X-Explode-Archive", "true");
        }
        if ((statusCode = (response = this.httpClient.upload(httpPut, fileEntity = new FileEntity(details.getFile(), "binary/octet-stream"))).getStatusLine().getStatusCode()) != 201 && statusCode != 200) {
            throw new IOException("Failed to deploy file. Status code: " + statusCode + this.getMessage(response));
        }
        return response;
    }

    private ArtifactoryUploadResponse tryChecksumDeploy(DeployDetails details, String uploadUrl) throws UnsupportedEncodingException {
        long fileLength = details.getFile().length();
        if (fileLength < 10240L) {
            this.log.debug("Skipping checksum deploy of file size " + fileLength + " , falling back to regular deployment.");
            return null;
        }
        if (details.isExplode()) {
            this.log.debug("Skipping checksum deploy due to explode file request.");
            return null;
        }
        if (!this.getArtifactoryVersion().isAtLeast(new ArtifactoryVersion("2.5.1"))) {
            return null;
        }
        HttpPut httpPut = this.createHttpPutMethod(details, uploadUrl);
        httpPut.addHeader("X-Checksum-Deploy", "true");
        String fileAbsolutePath = details.getFile().getAbsolutePath();
        try {
            ArtifactoryUploadResponse response = this.httpClient.execute(httpPut);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 201 || statusCode == 200) {
                this.log.debug("Successfully performed checksum deploy of file " + fileAbsolutePath + " : " + details.getSha1());
                return response;
            }
            this.log.debug("Failed checksum deploy of checksum '" + details.getSha1() + "' with statusCode: " + statusCode);
        }
        catch (IOException e) {
            this.log.debug("Failed artifact checksum deploy of file " + fileAbsolutePath + " : " + details.getSha1());
        }
        return null;
    }

    public void logParams(ArrayListMultimap<String, String> matrixParams) {
        this.log.info("Artifacts properties (Build-Info):");
        if (matrixParams != null && !matrixParams.isEmpty()) {
            for (String propertyKey : matrixParams.keySet()) {
                for (String propertyValue : matrixParams.get((Object)propertyKey)) {
                    this.log.info(String.format("name: %s value: %s", propertyKey, propertyValue));
                }
            }
        }
    }

    private HttpPut createHttpPutMethod(DeployDetails details, String uploadUrl) throws UnsupportedEncodingException {
        StringBuilder deploymentPathBuilder = new StringBuilder().append(uploadUrl);
        this.logParams(details.getProperties());
        deploymentPathBuilder.append(DeploymentUrlUtils.buildMatrixParamsString(details.getProperties()));
        HttpPut httpPut = new HttpPut(deploymentPathBuilder.toString());
        httpPut.addHeader("X-Checksum-Sha1", details.getSha1());
        httpPut.addHeader("X-Checksum-Md5", details.getMd5());
        this.log.debug("Full Artifact Http path: " + httpPut.toString() + "\n@Http Headers: " + Arrays.toString(httpPut.getAllHeaders()));
        return httpPut;
    }

    public void uploadChecksums(DeployDetails details, String uploadUrl) throws IOException {
        String md5;
        Map<String, String> checksums = this.getChecksumMap(details);
        String fileAbsolutePath = details.getFile().getAbsolutePath();
        String sha1 = checksums.get("SHA1");
        if (StringUtils.isNotBlank(sha1)) {
            this.log.debug("Uploading SHA1 for file " + fileAbsolutePath + " : " + sha1);
            this.logParams(details.getProperties());
            String sha1Url = uploadUrl + ".sha1" + DeploymentUrlUtils.buildMatrixParamsString(details.getProperties());
            HttpPut putSha1 = new HttpPut(sha1Url);
            StringEntity sha1StringEntity = new StringEntity(sha1);
            ArtifactoryUploadResponse response = this.httpClient.upload(putSha1, sha1StringEntity);
            StatusLine sha1StatusLine = response.getStatusLine();
            int sha1StatusCode = sha1StatusLine.getStatusCode();
            if (sha1StatusCode != 201 && sha1StatusCode != 200) {
                throw new IOException("Failed to deploy SHA1 checksum. Status code: " + sha1StatusCode + this.getMessage(response));
            }
        }
        if (StringUtils.isNotBlank(md5 = checksums.get("MD5"))) {
            this.log.debug("Uploading MD5 for file " + fileAbsolutePath + " : " + md5);
            this.logParams(details.getProperties());
            String md5Url = uploadUrl + ".md5" + DeploymentUrlUtils.buildMatrixParamsString(details.getProperties());
            HttpPut putMd5 = new HttpPut(md5Url);
            StringEntity md5StringEntity = new StringEntity(md5);
            ArtifactoryUploadResponse response = this.httpClient.upload(putMd5, md5StringEntity);
            StatusLine md5StatusLine = response.getStatusLine();
            int md5StatusCode = md5StatusLine.getStatusCode();
            if (md5StatusCode != 201 && md5StatusCode != 200) {
                throw new IOException("Failed to deploy MD5 checksum. Status code: " + md5StatusCode + this.getMessage(response));
            }
        }
    }

    private Map<String, String> getChecksumMap(DeployDetails details) throws IOException {
        HashMap<String, String> checksums = Maps.newHashMap();
        ArrayList<String> checksumTypeList = Lists.newArrayList();
        if (StringUtils.isBlank(details.getMd5())) {
            checksumTypeList.add("MD5");
        } else {
            checksums.put("MD5", details.getMd5());
        }
        if (StringUtils.isBlank(details.getSha1())) {
            checksumTypeList.add("SHA1");
        } else {
            checksums.put("SHA1", details.getSha1());
        }
        if (!checksumTypeList.isEmpty()) {
            try {
                checksums.putAll(FileChecksumCalculator.calculateChecksums(details.getFile(), checksumTypeList.toArray(new String[checksumTypeList.size()])));
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
        return checksums;
    }

    private void throwHttpIOException(String message, StatusLine statusLine) throws IOException {
        String errorMessage = message + " HTTP response code: " + statusLine.getStatusCode() + ". HTTP response message: " + statusLine.getReasonPhrase();
        throw new IOException(errorMessage);
    }

    public ArtifactoryVersion getArtifactoryVersion() {
        if (this.artifactoryVersion == null) {
            try {
                this.artifactoryVersion = this.httpClient.getVersion();
            }
            catch (IOException e) {
                this.artifactoryVersion = ArtifactoryVersion.NOT_FOUND;
            }
        }
        return this.artifactoryVersion;
    }

    private String getMessage(ArtifactoryUploadResponse response) {
        String responseMessage = "";
        if (response.getErrors() != null && StringUtils.isNotBlank(responseMessage = this.getResponseMessage(response.getErrors()))) {
            responseMessage = " Response message: " + responseMessage;
        }
        return responseMessage;
    }

    private String getResponseMessage(List<ArtifactoryUploadResponse.Error> errorList) {
        if (errorList == null || errorList.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder("Artifactory returned the following errors: ");
        for (ArtifactoryUploadResponse.Error error : errorList) {
            builder.append("\n").append(error.getMessage()).append(" Status code: ").append(error.getStatus());
        }
        return builder.toString();
    }

    private String getMessageFromEntity(HttpEntity entity) throws IOException {
        String responseMessage = "";
        if (entity != null) {
            responseMessage = this.getResponseEntityContent(entity);
            EntityUtils.consume(entity);
            if (StringUtils.isNotBlank(responseMessage)) {
                responseMessage = " Response message: " + responseMessage;
            }
        }
        return responseMessage;
    }

    private String getResponseEntityContent(HttpEntity responseEntity) throws IOException {
        InputStream in = responseEntity.getContent();
        if (in != null) {
            return IOUtils.toString(in, "UTF-8");
        }
        return "";
    }
}

