/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.InputMismatchException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.jfrog.build.api.Dependency;
import org.jfrog.build.api.builder.DependencyBuilder;
import org.jfrog.build.api.dependency.BuildPatternArtifacts;
import org.jfrog.build.api.dependency.BuildPatternArtifactsRequest;
import org.jfrog.build.api.dependency.DownloadableArtifact;
import org.jfrog.build.api.dependency.pattern.PatternType;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.api.util.ZipUtils;
import org.jfrog.build.extractor.clientConfiguration.client.ArtifactoryDependenciesClient;
import org.jfrog.build.extractor.clientConfiguration.util.AqlDependenciesHelper;
import org.jfrog.build.extractor.clientConfiguration.util.DependenciesDownloader;
import org.jfrog.build.extractor.clientConfiguration.util.DependenciesDownloaderImpl;
import org.jfrog.build.extractor.clientConfiguration.util.WildcardsDependenciesHelper;
import org.jfrog.build.extractor.clientConfiguration.util.spec.FileSpec;
import org.jfrog.build.extractor.clientConfiguration.util.spec.Spec;
import org.jfrog.build.extractor.clientConfiguration.util.spec.SpecsHelper;

public class DependenciesDownloaderHelper {
    private DependenciesDownloader downloader;
    private Log log;
    private final String LATEST = "LATEST";
    private final String LAST_RELEASE = "LAST_RELEASE";
    private static final String DELIMITER = "/";
    private static final String ESCAPE_CHAR = "\\";

    public DependenciesDownloaderHelper(DependenciesDownloader downloader, Log log) {
        this.downloader = downloader;
        this.log = log;
    }

    public DependenciesDownloaderHelper(ArtifactoryDependenciesClient client, String workingDirectory, Log log) {
        this.downloader = new DependenciesDownloaderImpl(client, workingDirectory, log);
        this.log = log;
    }

    public List<Dependency> downloadDependencies(Spec downloadSpec) throws IOException {
        AqlDependenciesHelper aqlHelper = new AqlDependenciesHelper(this.downloader, "", this.log);
        WildcardsDependenciesHelper wildcardHelper = new WildcardsDependenciesHelper(this.downloader, "", this.log);
        ArrayList<Dependency> resolvedDependencies = Lists.newArrayList();
        for (FileSpec file : downloadSpec.getFiles()) {
            this.log.debug("Downloading dependencies using spec: \n" + file.toString());
            this.validateFileSpec(file);
            String buildName = this.getBuildName(file.getBuild());
            String buildNumber = this.getBuildNumber(buildName, file.getBuild());
            if (StringUtils.isNotBlank(buildName) && StringUtils.isBlank(buildNumber)) {
                return resolvedDependencies;
            }
            if (file.getPattern() != null) {
                wildcardHelper.setTarget(file.getTarget());
                wildcardHelper.setFlatDownload(BooleanUtils.toBoolean(file.getFlat()));
                wildcardHelper.setRecursive(!"false".equalsIgnoreCase(file.getRecursive()));
                wildcardHelper.setProps(file.getProps());
                wildcardHelper.setBuildName(buildName);
                wildcardHelper.setBuildNumber(buildNumber);
                this.log.info(String.format("Downloading artifacts using pattern: %s%s", file.getPattern(), SpecsHelper.getExcludePatternsLogStr(file.getExcludePatterns())));
                resolvedDependencies.addAll(wildcardHelper.retrievePublishedDependencies(file.getPattern(), file.getExcludePatterns(), Boolean.valueOf(file.getExplode())));
                continue;
            }
            if (file.getAql() == null) continue;
            aqlHelper.setTarget(file.getTarget());
            aqlHelper.setFlatDownload(BooleanUtils.toBoolean(file.getFlat()));
            aqlHelper.setBuildName(buildName);
            aqlHelper.setBuildNumber(buildNumber);
            resolvedDependencies.addAll(aqlHelper.retrievePublishedDependencies(file.getAql(), null, Boolean.valueOf(file.getExplode())));
        }
        return resolvedDependencies;
    }

    private String getBuildName(String build) {
        if (StringUtils.isBlank(build)) {
            return build;
        }
        String buildName = StringUtils.substringBeforeLast(build, DELIMITER);
        while (StringUtils.isNotBlank(buildName) && buildName.contains(DELIMITER) && buildName.endsWith(ESCAPE_CHAR)) {
            buildName = StringUtils.substringBeforeLast(buildName, DELIMITER);
        }
        return buildName.endsWith(ESCAPE_CHAR) ? build : buildName;
    }

    public List<Dependency> downloadDependencies(Set<DownloadableArtifact> downloadableArtifacts) throws IOException {
        ArrayList<Dependency> dependencies = Lists.newArrayList();
        HashSet<DownloadableArtifact> downloadedArtifacts = Sets.newHashSet();
        for (DownloadableArtifact downloadableArtifact : downloadableArtifacts) {
            Dependency dependency = this.downloadArtifact(downloadableArtifact);
            if (dependency == null) continue;
            dependencies.add(dependency);
            downloadedArtifacts.add(downloadableArtifact);
            this.explodeDependenciesIfNeeded(downloadableArtifact);
        }
        this.removeUnusedArtifactsFromLocal(downloadedArtifacts);
        return dependencies;
    }

    private void explodeDependenciesIfNeeded(DownloadableArtifact downloadableArtifact) throws IOException {
        if (!downloadableArtifact.isExplode()) {
            return;
        }
        String fileDestination = this.downloader.getTargetDir(downloadableArtifact.getTargetDirPath(), downloadableArtifact.getRelativeDirPath());
        this.log.info("Extracting Archive: " + fileDestination);
        File sourceArchive = new File(fileDestination);
        File parentFile = FileUtils.getFile(fileDestination).getParentFile();
        ZipUtils.extract(sourceArchive, parentFile);
        this.log.info("Finished extracting archive to " + parentFile);
        this.log.debug("Deleting archive...");
        FileUtils.deleteQuietly(sourceArchive);
    }

    private String getBuildNumber(String buildName, String build) throws IOException {
        String buildNumber = "";
        if (StringUtils.isNotBlank(buildName)) {
            if (!build.startsWith(buildName)) {
                throw new IllegalStateException("build '" + build + "' does not start with build name '" + buildName + "'.");
            }
            if (build.equals(buildName)) {
                buildNumber = "LATEST";
            } else {
                buildNumber = build.substring(buildName.length() + DELIMITER.length());
                buildNumber = buildNumber.replace("\\/", DELIMITER);
            }
            if ("LATEST".equals(buildNumber.trim()) || "LAST_RELEASE".equals(buildNumber.trim())) {
                if (this.downloader.getClient().isArtifactoryOSS()) {
                    throw new IllegalArgumentException(buildNumber + " is not supported in Artifactory OSS.");
                }
                ArrayList<BuildPatternArtifactsRequest> artifactsRequest = Lists.newArrayList();
                artifactsRequest.add(new BuildPatternArtifactsRequest(buildName, buildNumber));
                List<BuildPatternArtifacts> artifactsResponses = this.downloader.getClient().retrievePatternArtifacts(artifactsRequest);
                if (artifactsResponses.get(0) != null) {
                    buildNumber = artifactsResponses.get(0).getBuildNumber();
                } else {
                    this.logBuildNotFound(buildName, buildNumber);
                    return null;
                }
            }
        }
        return buildNumber;
    }

    private void logBuildNotFound(String buildName, String buildNumber) {
        StringBuilder sb = new StringBuilder("The build name ").append(buildName);
        if ("LAST_RELEASE".equals(buildNumber.trim())) {
            sb.append(" with the status RELEASED");
        }
        sb.append(" could not be found.");
        this.log.warn(sb.toString());
    }

    private void validateFileSpec(FileSpec file) throws IOException {
        if (file.getPattern() != null && file.getAql() != null) {
            throw new InputMismatchException("Spec can include either the 'aql' or 'pattern' properties, but not both.");
        }
    }

    private void removeUnusedArtifactsFromLocal(Set<DownloadableArtifact> downloadableArtifacts) throws IOException {
        HashSet<String> forDeletionFiles = Sets.newHashSet();
        HashSet<String> allResolvesFiles = Sets.newHashSet();
        for (DownloadableArtifact downloadableArtifact : downloadableArtifacts) {
            String fileDestination = this.downloader.getTargetDir(downloadableArtifact.getTargetDirPath(), downloadableArtifact.getRelativeDirPath());
            allResolvesFiles.add(fileDestination);
            if (!PatternType.DELETE.equals((Object)downloadableArtifact.getPatternType())) continue;
            forDeletionFiles.add(fileDestination);
        }
        this.downloader.removeUnusedArtifactsFromLocal(allResolvesFiles, forDeletionFiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dependency downloadArtifact(DownloadableArtifact downloadableArtifact) throws IOException {
        Dependency dependencyResult = null;
        String filePath = downloadableArtifact.getFilePath();
        String matrixParams = downloadableArtifact.getMatrixParameters();
        String uri = downloadableArtifact.getRepoUrl() + '/' + filePath;
        String uriWithParams = StringUtils.isBlank(matrixParams) ? uri : uri + ';' + matrixParams;
        Checksums checksums = this.downloadArtifactCheckSums(uriWithParams);
        if (StringUtils.isBlank(checksums.getMd5()) && StringUtils.isBlank(checksums.getSha1())) {
            return null;
        }
        String fileDestination = this.downloader.getTargetDir(downloadableArtifact.getTargetDirPath(), downloadableArtifact.getRelativeDirPath());
        dependencyResult = this.getDependencyLocally(checksums, fileDestination);
        if (dependencyResult == null) {
            this.log.info("Downloading '" + uriWithParams + "' ...");
            HttpResponse httpResponse = null;
            try {
                httpResponse = this.downloader.getClient().downloadArtifact(uriWithParams);
                InputStream inputStream = httpResponse.getEntity().getContent();
                Map<String, String> checksumsMap = this.downloader.saveDownloadedFile(inputStream, fileDestination);
                if (checksumsMap == null) {
                    throw new IOException("Received null checksums map for downloaded file.");
                }
                String md5 = this.validateMd5Checksum(httpResponse, checksumsMap.get("md5"));
                String sha1 = this.validateSha1Checksum(httpResponse, checksumsMap.get("sha1"));
                this.log.info("Successfully downloaded '" + uriWithParams + "' to '" + fileDestination + "'");
                dependencyResult = new DependencyBuilder().md5(md5).sha1(sha1).id(filePath.substring(filePath.lastIndexOf(DELIMITER) + 1)).build();
                this.consumeEntity(httpResponse);
            }
            catch (Throwable throwable) {
                this.consumeEntity(httpResponse);
                throw throwable;
            }
        }
        return dependencyResult;
    }

    private Dependency getDependencyLocally(Checksums checksums, String filePath) throws IOException {
        if (this.downloader.isFileExistsLocally(filePath, checksums.getMd5(), checksums.getSha1())) {
            this.log.info("The file '" + filePath + "' exists locally.");
            return new DependencyBuilder().md5(checksums.getMd5()).sha1(checksums.getSha1()).id(filePath.substring(filePath.lastIndexOf(String.valueOf(IOUtils.DIR_SEPARATOR)) + 1)).build();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Checksums downloadArtifactCheckSums(String url) throws IOException {
        HttpResponse response = null;
        try {
            response = this.downloader.getClient().getArtifactChecksums(url);
            Checksums checksums = new Checksums();
            checksums.setMd5(this.getMD5ChecksumFromResponse(response));
            checksums.setSha1(this.getSHA1ChecksumFromResponse(response));
            Checksums checksums2 = checksums;
            this.consumeEntity(response);
            return checksums2;
        }
        catch (Throwable throwable) {
            this.consumeEntity(response);
            throw throwable;
        }
    }

    private void consumeEntity(HttpResponse response) {
        if (response != null) {
            try {
                EntityUtils.consume(response.getEntity());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private String validateMd5Checksum(HttpResponse httpResponse, String calculatedMd5) throws IOException {
        String md5ChecksumFromResponse = this.getMD5ChecksumFromResponse(httpResponse);
        if (!StringUtils.equals(this.getMD5ChecksumFromResponse(httpResponse), calculatedMd5)) {
            String errorMessage = "Calculated MD5 checksum is different from original, Original: '" + md5ChecksumFromResponse + "' Calculated: '" + calculatedMd5 + "'";
            throw new IOException(errorMessage);
        }
        return md5ChecksumFromResponse == null ? "" : md5ChecksumFromResponse;
    }

    private String validateSha1Checksum(HttpResponse httpResponse, String calculatedSha1) throws IOException {
        String sha1ChecksumFromResponse = this.getSHA1ChecksumFromResponse(httpResponse);
        if (!StringUtils.equals(sha1ChecksumFromResponse, calculatedSha1)) {
            String errorMessage = "Calculated SHA-1 checksum is different from original, Original: '" + sha1ChecksumFromResponse + "' Calculated: '" + calculatedSha1 + "'";
            throw new IOException(errorMessage);
        }
        return sha1ChecksumFromResponse == null ? "" : sha1ChecksumFromResponse;
    }

    private String getSHA1ChecksumFromResponse(HttpResponse artifactChecksums) {
        String sha1 = null;
        Header sha1Header = artifactChecksums.getFirstHeader("X-Checksum-Sha1");
        if (sha1Header != null) {
            sha1 = sha1Header.getValue();
        }
        return sha1;
    }

    private String getMD5ChecksumFromResponse(HttpResponse artifactChecksums) {
        String md5 = null;
        Header md5Header = artifactChecksums.getFirstHeader("X-Checksum-Md5");
        if (md5Header != null) {
            md5 = md5Header.getValue();
        }
        return md5;
    }

    private static class Checksums {
        private String sha1;
        private String md5;

        private Checksums() {
        }

        public String getSha1() {
            return this.sha1;
        }

        public void setSha1(String sha1) {
            this.sha1 = sha1;
        }

        public String getMd5() {
            return this.md5;
        }

        public void setMd5(String md5) {
            this.md5 = md5;
        }
    }
}

