/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration.util;

import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public abstract class DeploymentUrlUtils {
    public static String getDeploymentUrl(String artifactoryUrl, Properties properties) throws UnsupportedEncodingException {
        Map<Object, Object> filteredProperties = Maps.filterKeys(properties, new Predicate<Object>(){

            @Override
            public boolean apply(Object input) {
                String inputKey = (String)input;
                return inputKey.startsWith("artifactory.deploy.");
            }
        });
        StringBuilder deploymentUrl = new StringBuilder(artifactoryUrl);
        Set<Map.Entry<Object, Object>> propertyEntries = filteredProperties.entrySet();
        for (Map.Entry<Object, Object> propertyEntry : propertyEntries) {
            String key = StringUtils.removeStart((String)propertyEntry.getKey(), "artifactory.deploy.");
            deploymentUrl.append(";").append(URLEncoder.encode(key, "UTF-8")).append("=").append(URLEncoder.encode((String)propertyEntry.getValue(), "UTF-8"));
        }
        return deploymentUrl.toString();
    }

    public static String buildMatrixParamsString(ArrayListMultimap<String, String> matrixParams) throws UnsupportedEncodingException {
        StringBuilder matrix = new StringBuilder();
        if (matrixParams != null && !matrixParams.isEmpty()) {
            for (String propertyKey : matrixParams.keySet()) {
                for (String propertyValue : matrixParams.get((Object)propertyKey)) {
                    matrix.append(";").append(DeploymentUrlUtils.encode(propertyKey)).append("=").append(DeploymentUrlUtils.encode(propertyValue));
                }
            }
        }
        return matrix.toString();
    }

    private static String encode(String s) throws UnsupportedEncodingException {
        if (s != null) {
            return URLEncoder.encode(s, "UTF-8").replace("%2F", "/");
        }
        return null;
    }
}

