/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.listener;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.ivy.Ivy;
import org.apache.ivy.ant.IvyAntSettings;
import org.apache.ivy.ant.IvyTask;
import org.apache.ivy.core.event.EventManager;
import org.apache.ivy.core.event.IvyListener;
import org.apache.ivy.core.resolve.ResolveEngine;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.UnknownElement;
import org.jfrog.build.api.Agent;
import org.jfrog.build.api.BlackDuckProperties;
import org.jfrog.build.api.Build;
import org.jfrog.build.api.BuildAgent;
import org.jfrog.build.api.BuildType;
import org.jfrog.build.api.Governance;
import org.jfrog.build.api.Issue;
import org.jfrog.build.api.IssueTracker;
import org.jfrog.build.api.Issues;
import org.jfrog.build.api.LicenseControl;
import org.jfrog.build.api.MatrixParameter;
import org.jfrog.build.api.Vcs;
import org.jfrog.build.api.builder.BuildInfoBuilder;
import org.jfrog.build.client.DeployDetails;
import org.jfrog.build.context.BuildContext;
import org.jfrog.build.extractor.BuildInfoExtractorUtils;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;
import org.jfrog.build.extractor.clientConfiguration.IncludeExcludePatterns;
import org.jfrog.build.extractor.clientConfiguration.PatternMatcher;
import org.jfrog.build.extractor.clientConfiguration.client.ArtifactoryBuildInfoClient;
import org.jfrog.build.extractor.retention.Utils;
import org.jfrog.build.extractor.trigger.ArtifactoryBuildInfoTrigger;
import org.jfrog.build.util.IvyBuildInfoLog;

public class ArtifactoryBuildListener
implements BuildListener {
    private static final ArtifactoryBuildInfoTrigger DEPENDENCY_TRIGGER = new ArtifactoryBuildInfoTrigger("post-resolve");
    private static final ArtifactoryBuildInfoTrigger PUBLISH_TRIGGER = new ArtifactoryBuildInfoTrigger("post-publish-artifact");
    private boolean isDidDeploy;
    private BuildContext ctx;
    private IvyBuildInfoLog buildInfoLog;

    private void assertInitialized(BuildEvent event) {
        if (this.buildInfoLog != null) {
            this.buildInfoLog.setProject(event.getProject());
            return;
        }
        try {
            this.buildInfoLog = new IvyBuildInfoLog(event.getProject());
            ArtifactoryClientConfiguration clientConf = new ArtifactoryClientConfiguration(this.buildInfoLog);
            Properties props = this.getMergedEnvAndSystemProps();
            clientConf.fillFromProperties(props);
            this.ctx = new BuildContext(clientConf);
            DEPENDENCY_TRIGGER.setIvyBuildContext(this.ctx);
            PUBLISH_TRIGGER.setIvyBuildContext(this.ctx);
            this.buildInfoLog.info("[buildinfo:ant] Artifactory Build Info Listener Initialized");
        }
        catch (Exception e) {
            RuntimeException re = new RuntimeException("Fail to initialize the Ivy listeners for the Artifactory Ivy plugin, due to: " + e.getMessage(), e);
            if (this.buildInfoLog != null && this.buildInfoLog.getProject() != null) {
                this.buildInfoLog.error(re.getMessage(), e);
            }
            throw re;
        }
    }

    private Properties getMergedEnvAndSystemProps() {
        Properties props = new Properties();
        props.putAll(System.getenv());
        return BuildInfoExtractorUtils.mergePropertiesWithSystemAndPropertyFile(props, this.buildInfoLog);
    }

    public IvyBuildInfoLog getBuildInfoLog(BuildEvent event) {
        this.assertInitialized(event);
        return this.buildInfoLog;
    }

    public void buildStarted(BuildEvent event) {
        try {
            this.getBuildInfoLog(event).debug("[buildinfo:ant] Received Build Started Event");
            this.ctx.setBuildStartTime(System.currentTimeMillis());
            this.getBuildInfoLog(event).info("[buildinfo:ant] Build Started timestamp=" + this.ctx.getBuildStartTime());
        }
        catch (Exception e) {
            RuntimeException re = new RuntimeException("Fail to register start of build, due to: " + e.getMessage(), e);
            this.getBuildInfoLog(event).error(re.getMessage(), e);
            throw re;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildFinished(BuildEvent event) {
        block8: {
            try {
                if (event.getException() != null) {
                    this.getBuildInfoLog(event).info("[buildinfo:ant] Received Build Finished Event with exception => No deployment");
                    return;
                }
                this.getBuildInfoLog(event).debug("[buildinfo:ant] Received Build Finished Event");
                if (this.isDidDeploy) break block8;
                try {
                    this.doDeploy(event);
                }
                catch (Exception e) {
                    RuntimeException re = new RuntimeException("Fail to activate deployment using the Artifactory Ivy plugin, due to: " + e.getMessage(), e);
                    this.getBuildInfoLog(event).error(re.getMessage(), e);
                    throw re;
                }
            }
            finally {
                File file;
                String propertyFilePath = System.getenv("buildInfoConfig.propertiesFile");
                if (StringUtils.isNotBlank(propertyFilePath) && (file = new File(propertyFilePath)).exists()) {
                    file.delete();
                }
            }
        }
    }

    private Task extractIvyTask(BuildEvent event) {
        String taskType;
        Task task = event.getTask();
        if (task instanceof UnknownElement) {
            UnknownElement unknown = (UnknownElement)task;
            Object realThing = unknown.getRealThing();
            if (realThing == null) {
                unknown.maybeConfigure();
            }
            if ((realThing = unknown.getRealThing()) instanceof Task) {
                task = (Task)realThing;
            }
        }
        if ((taskType = task.getTaskType()) != null && (taskType.contains("org.apache.ivy") || taskType.contains("fr.jayasoft.ivy") || task instanceof IvyTask)) {
            return task;
        }
        return null;
    }

    public void taskStarted(BuildEvent event) {
        try {
            Task task = this.extractIvyTask(event);
            if (task != null) {
                List<EventManager> eventManagers;
                String taskType = task.getTaskType();
                this.getBuildInfoLog(event).debug("[buildinfo:ant] Received Task of type '" + taskType + "' Started Event");
                if (taskType.endsWith("retrieve") || taskType.endsWith("resolve")) {
                    this.getBuildInfoLog(event).debug("[buildinfo:ant] Adding Ivy Resolution Listeners if needed.");
                    eventManagers = this.getEventManager(task);
                    for (EventManager eventManager : eventManagers) {
                        if (eventManager.hasIvyListener(DEPENDENCY_TRIGGER)) continue;
                        eventManager.addIvyListener((IvyListener)DEPENDENCY_TRIGGER, DEPENDENCY_TRIGGER.getEventFilter());
                        this.getBuildInfoLog(event).info("[buildinfo:ant] Added resolution report Ivy Listener.");
                    }
                }
                if (taskType.endsWith("publish")) {
                    this.getBuildInfoLog(event).debug("[buildinfo:ant] Adding Ivy Publish Listeners if needed.");
                    eventManagers = this.getEventManager(task);
                    for (EventManager eventManager : eventManagers) {
                        if (eventManager.hasIvyListener(PUBLISH_TRIGGER)) continue;
                        eventManager.addIvyListener((IvyListener)PUBLISH_TRIGGER, PUBLISH_TRIGGER.getEventFilter());
                        this.getBuildInfoLog(event).info("[buildinfo:ant] Added publish end Ivy Listener to Ivy Engine.");
                    }
                }
            }
        }
        catch (Exception e) {
            RuntimeException re = new RuntimeException("Fail to add the Ivy listeners for the Artifactory Ivy plugin, due to: " + e.getMessage(), e);
            this.getBuildInfoLog(event).error(re.getMessage(), e);
            throw re;
        }
    }

    private List<EventManager> getEventManager(Task task) {
        ArrayList<EventManager> results = new ArrayList<EventManager>();
        Project project = task.getProject();
        Enumeration elements = project.getReferences().elements();
        while (elements.hasMoreElements()) {
            UnknownElement unknown;
            Object element = elements.nextElement();
            if (element instanceof UnknownElement && (element = (unknown = (UnknownElement)element).getRealThing()) == null) {
                unknown.maybeConfigure();
                element = unknown.getRealThing();
            }
            if (!(element instanceof IvyAntSettings)) continue;
            results.add(((IvyAntSettings)((Object)element)).getConfiguredIvyInstance(task).getResolveEngine().getEventManager());
        }
        if (results.isEmpty()) {
            ResolveEngine engine = IvyAntSettings.getDefaultInstance(task).getConfiguredIvyInstance(task).getResolveEngine();
            results.add(engine.getEventManager());
        }
        return results;
    }

    public void taskFinished(BuildEvent event) {
        Task task = this.extractIvyTask(event);
        if (task != null) {
            this.getBuildInfoLog(event).debug("[buildinfo:ant] Received Task " + task.getTaskType() + " Finished Event");
        }
    }

    public void targetStarted(BuildEvent event) {
    }

    public void targetFinished(BuildEvent event) {
    }

    public void messageLogged(BuildEvent event) {
    }

    private void doDeploy(BuildEvent event) {
        String parentBuildNumber;
        String parentBuildName;
        String artifactoryPluginVersion;
        String vcsUrl;
        String buildUrl;
        String buildNumber;
        String buildName;
        IvyBuildInfoLog log = this.getBuildInfoLog(event);
        log.info("[buildinfo:ant] Starting deployment");
        Project project = event.getProject();
        Set<DeployDetails> deployDetails = this.ctx.getDeployDetails();
        BuildInfoBuilder builder = new BuildInfoBuilder(project.getName()).modules(this.ctx.getModules()).number("0").durationMillis(System.currentTimeMillis() - this.ctx.getBuildStartTime()).startedDate(new Date(this.ctx.getBuildStartTime())).buildAgent(new BuildAgent("Ivy", Ivy.getIvyVersion())).agent(new Agent("Ivy", Ivy.getIvyVersion()));
        builder.type(BuildType.IVY);
        ArtifactoryClientConfiguration clientConf = this.ctx.getClientConf();
        String agentName = clientConf.info.getAgentName();
        String agentVersion = clientConf.info.getAgentVersion();
        if (StringUtils.isNotBlank(agentName) && StringUtils.isNotBlank(agentVersion)) {
            builder.agent(new Agent(agentName, agentVersion));
        }
        String buildAgentName = clientConf.info.getBuildAgentName();
        String buildAgentVersion = clientConf.info.getBuildAgentVersion();
        if (StringUtils.isNotBlank(buildAgentName) && StringUtils.isNotBlank(buildAgentVersion)) {
            builder.buildAgent(new BuildAgent(buildAgentName, buildAgentVersion));
        }
        if (StringUtils.isNotBlank(buildName = clientConf.info.getBuildName())) {
            builder.name(buildName);
        }
        if (StringUtils.isNotBlank(buildNumber = clientConf.info.getBuildNumber())) {
            builder.number(buildNumber);
        }
        if (StringUtils.isNotBlank(buildUrl = clientConf.info.getBuildUrl())) {
            builder.url(buildUrl);
        }
        Vcs vcs = new Vcs();
        String vcsRevision = clientConf.info.getVcsRevision();
        if (StringUtils.isNotBlank(vcsRevision)) {
            vcs.setRevision(vcsRevision);
            builder.vcsRevision(vcsRevision);
        }
        if (StringUtils.isNotBlank(vcsUrl = clientConf.info.getVcsUrl())) {
            vcs.setUrl(vcsUrl);
            builder.vcsUrl(vcsUrl);
        }
        if (!vcs.isEmpty()) {
            builder.vcs(Arrays.asList(vcs));
        }
        if (StringUtils.isNotBlank(artifactoryPluginVersion = clientConf.info.getArtifactoryPluginVersion())) {
            builder.artifactoryPluginVersion(artifactoryPluginVersion);
        } else {
            builder.artifactoryPluginVersion("Unknown");
        }
        String principal = clientConf.info.getPrincipal();
        if (StringUtils.isNotBlank(principal)) {
            builder.principal(principal);
        }
        if (StringUtils.isNotBlank(parentBuildName = clientConf.info.getParentBuildName())) {
            builder.parentName(parentBuildName);
        }
        if (StringUtils.isNotBlank(parentBuildNumber = clientConf.info.getParentBuildNumber())) {
            builder.parentNumber(parentBuildNumber);
        }
        LicenseControl licenseControl = new LicenseControl(clientConf.info.licenseControl.isRunChecks());
        String notificationRecipients = clientConf.info.licenseControl.getViolationRecipients();
        if (StringUtils.isNotBlank(notificationRecipients)) {
            licenseControl.setLicenseViolationsRecipientsList(notificationRecipients);
        }
        licenseControl.setIncludePublishedArtifacts(clientConf.info.licenseControl.isIncludePublishedArtifacts());
        String scopes = clientConf.info.licenseControl.getScopes();
        if (StringUtils.isNotBlank(scopes)) {
            licenseControl.setScopesList(scopes);
        }
        licenseControl.setAutoDiscover(clientConf.info.licenseControl.isAutoDiscover());
        builder.licenseControl(licenseControl);
        BlackDuckProperties blackDuckProperties = clientConf.info.blackDuckProperties.isRunChecks() ? clientConf.info.blackDuckProperties.copyBlackDuckProperties() : new BlackDuckProperties();
        Governance governance = new Governance();
        governance.setBlackDuckProperties(blackDuckProperties);
        builder.governance(governance);
        String issueTrackerName = clientConf.info.issues.getIssueTrackerName();
        if (StringUtils.isNotBlank(issueTrackerName)) {
            Issues issues = new Issues();
            issues.setAggregateBuildIssues(clientConf.info.issues.getAggregateBuildIssues());
            issues.setAggregationBuildStatus(clientConf.info.issues.getAggregationBuildStatus());
            issues.setTracker(new IssueTracker(issueTrackerName, clientConf.info.issues.getIssueTrackerVersion()));
            Set<Issue> affectedIssuesSet = clientConf.info.issues.getAffectedIssuesSet();
            if (!affectedIssuesSet.isEmpty()) {
                issues.setAffectedIssues(affectedIssuesSet);
            }
            builder.issues(issues);
        }
        for (Map.Entry<String, String> runParam : clientConf.info.getRunParameters().entrySet()) {
            MatrixParameter matrixParameter = new MatrixParameter(runParam.getKey(), runParam.getValue());
            builder.addRunParameters(matrixParameter);
        }
        if (clientConf.isIncludeEnvVars().booleanValue()) {
            Properties envProperties = new Properties();
            envProperties.putAll(clientConf.getAllProperties());
            envProperties = BuildInfoExtractorUtils.getEnvProperties(envProperties, clientConf.getLog());
            for (Map.Entry<Object, Object> envProp : envProperties.entrySet()) {
                builder.addProperty(envProp.getKey(), envProp.getValue());
            }
        }
        Build build = builder.build();
        String contextUrl = clientConf.publisher.getContextUrl();
        String username = clientConf.publisher.getUsername();
        String password = clientConf.publisher.getPassword();
        ArtifactoryBuildInfoClient client = new ArtifactoryBuildInfoClient(contextUrl, username, password, log);
        try {
            this.configureProxy(clientConf, client);
            this.configConnectionTimeout(clientConf, client);
            this.configRetriesParams(clientConf, client);
            if (clientConf.publisher.isPublishArtifacts().booleanValue()) {
                IncludeExcludePatterns patterns = new IncludeExcludePatterns(clientConf.publisher.getIncludePatterns(), clientConf.publisher.getExcludePatterns());
                this.deployArtifacts(project, client, deployDetails, patterns);
            }
            if (clientConf.publisher.isPublishBuildInfo().booleanValue()) {
                Utils.sendBuildAndBuildRetention(client, build, clientConf);
            }
            this.isDidDeploy = true;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            client.close();
        }
    }

    private void deployArtifacts(Project project, ArtifactoryBuildInfoClient client, Set<DeployDetails> deployDetails, IncludeExcludePatterns patterns) throws IOException {
        for (DeployDetails deployDetail : deployDetails) {
            String artifactPath = deployDetail.getArtifactPath();
            if (PatternMatcher.pathConflicts(artifactPath, patterns)) {
                project.log("[buildinfo:deploy] Skipping the deployment of '" + artifactPath + "' due to the defined include-exclude patterns.", 2);
                continue;
            }
            client.deployArtifact(deployDetail);
        }
    }

    protected void configureProxy(ArtifactoryClientConfiguration clientConf, ArtifactoryBuildInfoClient client) {
        ArtifactoryClientConfiguration.ProxyHandler proxy = clientConf.proxy;
        String proxyHost = proxy.getHost();
        if (StringUtils.isNotBlank(proxyHost) && proxy.getPort() != null) {
            this.buildInfoLog.debug("Found proxy host '" + proxyHost + "'");
            String proxyUserName = proxy.getUsername();
            if (StringUtils.isNotBlank(proxyUserName)) {
                this.buildInfoLog.debug("Found proxy user name '" + proxyUserName + "'");
                client.setProxyConfiguration(proxyHost, proxy.getPort(), proxyUserName, proxy.getPassword());
            } else {
                this.buildInfoLog.debug("No proxy user name and password found, using anonymous proxy");
                client.setProxyConfiguration(proxyHost, proxy.getPort());
            }
        }
    }

    protected void configConnectionTimeout(ArtifactoryClientConfiguration clientConf, ArtifactoryBuildInfoClient client) {
        if (clientConf.getTimeout() != null) {
            client.setConnectionTimeout(clientConf.getTimeout());
        }
    }

    protected void configRetriesParams(ArtifactoryClientConfiguration clientConf, ArtifactoryBuildInfoClient client) {
        if (clientConf.getConnectionRetries() != null) {
            client.setConnectionRetries(clientConf.getConnectionRetries());
        }
    }
}

