/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.maven.reader;

import com.google.common.collect.Maps;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.jfrog.build.extractor.maven.reader.ModuleName;

public class ProjectReader {
    private final File rootPom;

    public ProjectReader(File rootPom) {
        this.rootPom = rootPom;
    }

    public Map<ModuleName, File> read() throws IOException {
        HashMap<ModuleName, File> result = Maps.newHashMap();
        this.readRecursive(result, this.rootPom);
        return result;
    }

    private void readRecursive(Map<ModuleName, File> modules, File current) throws IOException {
        if (!current.exists()) {
            throw new IllegalArgumentException("Root pom file: " + current.getAbsolutePath() + " does not exist");
        }
        Model model = this.readModel(current);
        String groupId = model.getGroupId();
        if (StringUtils.isBlank(groupId)) {
            groupId = model.getParent().getGroupId();
        }
        modules.put(new ModuleName(groupId, model.getArtifactId()), current);
        List<String> children = model.getModules();
        for (String child : children) {
            if (!child.endsWith("pom.xml")) {
                child = child + "/pom.xml";
            }
            File childPom = new File(current.getParentFile().getAbsolutePath(), child);
            this.readRecursive(modules, childPom);
        }
    }

    private Model readModel(File pom) throws IOException {
        Model model;
        MavenXpp3Reader reader = new MavenXpp3Reader();
        StringReader stringReader = null;
        try {
            stringReader = new StringReader(Files.toString(pom, Charset.forName("UTF-8")));
            model = reader.read(stringReader);
        }
        catch (XmlPullParserException e) {
            try {
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(stringReader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(stringReader);
        return model;
    }
}

