/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.maven.resolver;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.util.repository.AuthenticationBuilder;
import org.jfrog.build.extractor.maven.resolver.ResolutionHelper;

@Named
@Component(role=ArtifactoryEclipseResolversHelper.class)
public class ArtifactoryEclipseResolversHelper {
    @Requirement
    private ResolutionHelper resolutionHelper;
    @Requirement
    private Logger logger;
    private List<RemoteRepository> resolutionRepositories = null;
    private RemoteRepository releaseRepository = null;
    private RemoteRepository snapshotRepository = null;

    public void initResolutionRepositories(RepositorySystemSession session) {
        this.getResolutionRepositories(session);
    }

    public List<RemoteRepository> getResolutionRepositories(RepositorySystemSession session) {
        if (this.resolutionRepositories == null) {
            Properties allMavenProps = new Properties();
            allMavenProps.putAll(session.getSystemProperties());
            allMavenProps.putAll(session.getUserProperties());
            this.resolutionHelper.init(allMavenProps);
            String releaseRepoUrl = this.resolutionHelper.getRepoReleaseUrl();
            String snapshotRepoUrl = this.resolutionHelper.getRepoSnapshotUrl();
            Authentication authentication = null;
            if (StringUtils.isNotBlank(this.resolutionHelper.getRepoUsername())) {
                authentication = new AuthenticationBuilder().addString("username", this.resolutionHelper.getRepoUsername()).addSecret("password", this.resolutionHelper.getRepoPassword()).build();
            }
            Proxy proxy = null;
            if (StringUtils.isNotBlank(this.resolutionHelper.getProxyHost())) {
                Authentication auth = new AuthenticationBuilder().addString("username", this.resolutionHelper.getProxyUsername()).addSecret("password", this.resolutionHelper.getProxyPassword()).build();
                proxy = new Proxy(null, this.resolutionHelper.getProxyHost(), this.resolutionHelper.getProxyPort(), auth);
            }
            if (StringUtils.isNotBlank(snapshotRepoUrl)) {
                this.logger.debug("[buildinfo] Enforcing snapshot repository for resolution: " + snapshotRepoUrl);
                RepositoryPolicy releasePolicy = new RepositoryPolicy(false, "daily", "warn");
                RepositoryPolicy snapshotPolicy = new RepositoryPolicy(true, "daily", "warn");
                RemoteRepository.Builder builder = new RemoteRepository.Builder("artifactory-snapshot", "default", snapshotRepoUrl);
                builder.setReleasePolicy(releasePolicy);
                builder.setSnapshotPolicy(snapshotPolicy);
                if (authentication != null) {
                    this.logger.debug("[buildinfo] Enforcing repository authentication: " + authentication + " for snapshot resolution repository");
                    builder.setAuthentication(authentication);
                }
                if (proxy != null) {
                    this.logger.debug("[buildinfo] Enforcing proxy: " + proxy + " for snapshot resolution repository");
                    builder.setProxy(proxy);
                }
                this.snapshotRepository = builder.build();
            }
            if (StringUtils.isNotBlank(releaseRepoUrl)) {
                this.logger.debug("[buildinfo] Enforcing release repository for resolution: " + releaseRepoUrl);
                boolean snapshotPolicyEnabled = this.snapshotRepository == null;
                String repositoryId = snapshotPolicyEnabled ? "artifactory-release-snapshot" : "artifactory-release";
                RepositoryPolicy releasePolicy = new RepositoryPolicy(true, "daily", "warn");
                RepositoryPolicy snapshotPolicy = new RepositoryPolicy(snapshotPolicyEnabled, "daily", "warn");
                RemoteRepository.Builder builder = new RemoteRepository.Builder(repositoryId, "default", releaseRepoUrl);
                builder.setReleasePolicy(releasePolicy);
                builder.setSnapshotPolicy(snapshotPolicy);
                if (authentication != null) {
                    this.logger.debug("[buildinfo] Enforcing repository authentication: " + authentication + " for release resolution repository");
                    builder.setAuthentication(authentication);
                }
                if (proxy != null) {
                    this.logger.debug("[buildinfo] Enforcing proxy: " + proxy + " for release resolution repository");
                    builder.setProxy(proxy);
                }
                this.releaseRepository = builder.build();
            }
            ArrayList<RemoteRepository> tempRepositories = Lists.newArrayList();
            if (this.releaseRepository != null) {
                tempRepositories.add(this.releaseRepository);
            }
            if (this.snapshotRepository != null) {
                tempRepositories.add(this.snapshotRepository);
            }
            this.resolutionRepositories = tempRepositories;
        }
        return this.resolutionRepositories;
    }

    public RemoteRepository getSnapshotRepository(RepositorySystemSession session) {
        this.initResolutionRepositories(session);
        if (this.snapshotRepository != null) {
            return this.snapshotRepository;
        }
        return this.releaseRepository;
    }

    public RemoteRepository getReleaseRepository(RepositorySystemSession session) {
        this.initResolutionRepositories(session);
        return this.releaseRepository;
    }
}

