/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.maven.resolver;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.jfrog.build.extractor.maven.resolver.ResolutionHelper;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.repository.Authentication;
import org.sonatype.aether.repository.Proxy;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.repository.RepositoryPolicy;

@Named
@Component(role=ArtifactorySonatypeResolversHelper.class)
public class ArtifactorySonatypeResolversHelper {
    @Requirement
    private ResolutionHelper resolutionHelper;
    @Requirement
    private Logger logger;
    private List<RemoteRepository> resolutionRepositories = null;
    private RemoteRepository releaseRepository = null;
    private RemoteRepository snapshotRepository = null;

    public void initResolutionRepositories(RepositorySystemSession session) {
        this.getResolutionRepositories(session);
    }

    public List<RemoteRepository> getResolutionRepositories(RepositorySystemSession session) {
        if (this.resolutionRepositories == null) {
            Properties allMavenProps = new Properties();
            allMavenProps.putAll(session.getSystemProperties());
            allMavenProps.putAll(session.getUserProperties());
            this.resolutionHelper.init(allMavenProps);
            String releaseRepoUrl = this.resolutionHelper.getRepoReleaseUrl();
            String snapshotRepoUrl = this.resolutionHelper.getRepoSnapshotUrl();
            Authentication authentication = null;
            if (StringUtils.isNotBlank(this.resolutionHelper.getRepoUsername())) {
                authentication = new Authentication(this.resolutionHelper.getRepoUsername(), this.resolutionHelper.getRepoPassword());
            }
            Proxy proxy = null;
            if (StringUtils.isNotBlank(this.resolutionHelper.getProxyHost())) {
                proxy = new Proxy(null, this.resolutionHelper.getProxyHost(), this.resolutionHelper.getProxyPort(), new Authentication(this.resolutionHelper.getProxyUsername(), this.resolutionHelper.getProxyPassword()));
            }
            if (StringUtils.isNotBlank(snapshotRepoUrl)) {
                this.logger.debug("Enforcing snapshot repository for resolution: " + snapshotRepoUrl);
                RepositoryPolicy releasePolicy = new RepositoryPolicy(false, "daily", "warn");
                RepositoryPolicy snapshotPolicy = new RepositoryPolicy(true, "daily", "warn");
                this.snapshotRepository = new RemoteRepository("artifactory-snapshot", "default", snapshotRepoUrl);
                if (authentication != null) {
                    this.logger.debug("Enforcing repository authentication: " + authentication + " for snapshot resolution repository");
                    this.snapshotRepository.setAuthentication(authentication);
                }
                if (proxy != null) {
                    this.logger.debug("Enforcing proxy: " + proxy + " for snapshot resolution repository");
                    this.snapshotRepository.setProxy(proxy);
                }
                this.snapshotRepository.setPolicy(false, releasePolicy);
                this.snapshotRepository.setPolicy(true, snapshotPolicy);
            }
            if (StringUtils.isNotBlank(releaseRepoUrl)) {
                this.logger.debug("Enforcing release repository for resolution: " + releaseRepoUrl);
                boolean snapshotPolicyEnabled = this.snapshotRepository == null;
                String repositoryId = snapshotPolicyEnabled ? "artifactory-release-snapshot" : "artifactory-release";
                RepositoryPolicy releasePolicy = new RepositoryPolicy(true, "daily", "warn");
                RepositoryPolicy snapshotPolicy = new RepositoryPolicy(snapshotPolicyEnabled, "daily", "warn");
                this.releaseRepository = new RemoteRepository(repositoryId, "default", releaseRepoUrl);
                if (authentication != null) {
                    this.logger.debug("Enforcing repository authentication: " + authentication + " for release resolution repository");
                    this.releaseRepository.setAuthentication(authentication);
                }
                if (proxy != null) {
                    this.logger.debug("Enforcing proxy: " + proxy + " for release resolution repository");
                    this.releaseRepository.setProxy(proxy);
                }
                this.releaseRepository.setPolicy(false, releasePolicy);
                this.releaseRepository.setPolicy(true, snapshotPolicy);
            }
            ArrayList<RemoteRepository> tempRepositories = Lists.newArrayList();
            if (this.releaseRepository != null) {
                tempRepositories.add(this.releaseRepository);
            }
            if (this.snapshotRepository != null) {
                tempRepositories.add(this.snapshotRepository);
            }
            this.resolutionRepositories = tempRepositories;
        }
        return this.resolutionRepositories;
    }

    public RemoteRepository getSnapshotRepository(RepositorySystemSession session) {
        this.initResolutionRepositories(session);
        if (this.snapshotRepository != null) {
            return this.snapshotRepository;
        }
        return this.releaseRepository;
    }

    public RemoteRepository getReleaseRepository(RepositorySystemSession session) {
        this.initResolutionRepositories(session);
        return this.releaseRepository;
    }
}

