/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.trigger;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.event.IvyEvent;
import org.apache.ivy.core.event.IvyEventFilter;
import org.apache.ivy.core.event.publish.PublishEvent;
import org.apache.ivy.core.event.resolve.EndResolveEvent;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.report.ConfigurationResolveReport;
import org.apache.ivy.core.report.ResolveReport;
import org.apache.ivy.plugins.matcher.ExactPatternMatcher;
import org.apache.ivy.plugins.trigger.Trigger;
import org.apache.ivy.util.filter.Filter;
import org.apache.tools.ant.Project;
import org.jfrog.build.api.Artifact;
import org.jfrog.build.api.Dependency;
import org.jfrog.build.api.Module;
import org.jfrog.build.api.builder.ArtifactBuilder;
import org.jfrog.build.api.builder.DependencyBuilder;
import org.jfrog.build.api.builder.ModuleBuilder;
import org.jfrog.build.api.util.FileChecksumCalculator;
import org.jfrog.build.client.DeployDetails;
import org.jfrog.build.context.BuildContext;
import org.jfrog.build.extractor.BuildInfoExtractorUtils;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;
import org.jfrog.build.extractor.clientConfiguration.IncludeExcludePatterns;
import org.jfrog.build.extractor.clientConfiguration.PatternMatcher;
import org.jfrog.build.util.IvyResolverHelper;

public class ArtifactoryBuildInfoTrigger
implements Trigger {
    private static final String MD5 = "MD5";
    private static final String SHA1 = "SHA1";
    private final Filter filter;
    private BuildContext ctx;
    private String eventName;

    public ArtifactoryBuildInfoTrigger(String eventName) {
        this.eventName = eventName;
        this.filter = new IvyEventFilter(eventName, null, ExactPatternMatcher.INSTANCE);
    }

    public void setIvyBuildContext(BuildContext ctx) {
        this.ctx = ctx;
    }

    @Override
    public Filter getEventFilter() {
        return this.filter;
    }

    @Override
    public void progress(IvyEvent event) {
        try {
            Project project = (Project)IvyContext.peekInContextStack("ant-project");
            if (project != null) {
                project.log("[buildinfo:collect] Received Event: " + event.getName(), 4);
            }
            if ("post-resolve".equals(event.getName())) {
                this.collectDependencyInformation(event);
            } else if ("post-publish-artifact".equals(event.getName())) {
                this.collectModuleInformation(event);
            }
        }
        catch (Exception e) {
            RuntimeException re = new RuntimeException("Fail to collect dependencies and modules using the progress trigger in the Artifactory Ivy plugin, due to: " + e.getMessage(), e);
            re.printStackTrace();
            throw re;
        }
    }

    private void collectDependencyInformation(IvyEvent event) {
        Project project = (Project)IvyContext.peekInContextStack("ant-project");
        ResolveReport report = ((EndResolveEvent)event).getReport();
        Map attributes = event.getAttributes();
        Module module = this.getOrCreateModule(attributes);
        project.log("[buildinfo:collect] Collecting dependencies for " + module.getId(), 2);
        if (module.getDependencies() == null || module.getDependencies().isEmpty()) {
            String[] configurations = report.getConfigurations();
            ArrayList<Dependency> moduleDependencies = Lists.newArrayList();
            for (String configuration : configurations) {
                ArtifactDownloadReport[] allArtifactsReports;
                project.log("[buildinfo:collect] Configuration: " + configuration + " Dependencies", 4);
                ConfigurationResolveReport configurationReport = report.getConfigurationReport(configuration);
                for (ArtifactDownloadReport artifactsReport : allArtifactsReports = configurationReport.getAllArtifactsReports()) {
                    project.log("[buildinfo:collect] Artifact Download Report for configuration: " + configuration + " : " + artifactsReport, 4);
                    ModuleRevisionId id = artifactsReport.getArtifact().getModuleRevisionId();
                    String type = this.getType(artifactsReport.getArtifact());
                    Dependency dependency = this.findDependencyInList(id, type, moduleDependencies);
                    if (dependency == null) {
                        Map<String, String> checksums;
                        DependencyBuilder dependencyBuilder = new DependencyBuilder();
                        dependencyBuilder.type(type).scopes(Sets.newHashSet(configuration));
                        String idString = BuildInfoExtractorUtils.getModuleIdString(id.getOrganisation(), id.getName(), id.getRevision());
                        dependencyBuilder.id(idString);
                        File file = artifactsReport.getLocalFile();
                        try {
                            checksums = FileChecksumCalculator.calculateChecksums(file, MD5, SHA1);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                        String md5 = checksums.get(MD5);
                        String sha1 = checksums.get(SHA1);
                        dependencyBuilder.md5(md5).sha1(sha1);
                        dependency = dependencyBuilder.build();
                        moduleDependencies.add(dependency);
                        project.log("[buildinfo:collect] Added dependency '" + dependency.getId() + "'", 4);
                        continue;
                    }
                    if (!dependency.getScopes().contains(configuration)) {
                        dependency.getScopes().add(configuration);
                        project.log("[buildinfo:collect] Added scope " + configuration + " to dependency '" + dependency.getId() + "'", 4);
                        continue;
                    }
                    project.log("[buildinfo:collect] Find same dependency twice in configuration '" + configuration + "' for dependency '" + artifactsReport + "'", 1);
                }
            }
            module.setDependencies(moduleDependencies);
        }
    }

    private void collectModuleInformation(IvyEvent event) {
        List<Artifact> excludedArtifacts;
        ArtifactoryClientConfiguration.PublisherHandler publisher = this.ctx.getClientConf().publisher;
        IncludeExcludePatterns patterns = new IncludeExcludePatterns(publisher.getIncludePatterns(), publisher.getExcludePatterns());
        boolean excludeArtifactsFromBuild = publisher.isFilterExcludedArtifactsFromBuild();
        Project project = (Project)IvyContext.peekInContextStack("ant-project");
        Map map = event.getAttributes();
        Module module = this.getOrCreateModule(map);
        List<Artifact> artifacts = module.getArtifacts();
        if (artifacts == null) {
            module.setArtifacts(Lists.<Artifact>newArrayList());
        }
        if ((excludedArtifacts = module.getExcludedArtifacts()) == null) {
            module.setExcludedArtifacts(Lists.<Artifact>newArrayList());
        }
        org.apache.ivy.core.module.descriptor.Artifact pubArtifact = ((PublishEvent)event).getArtifact();
        Map extraAttributes = pubArtifact.getExtraAttributes();
        String file = (String)map.get("file");
        ModuleRevisionId mrid = pubArtifact.getModuleRevisionId();
        String moduleName = mrid.getName();
        String type = this.getType(pubArtifact);
        String name = pubArtifact.getName() + "-" + mrid.getRevision() + "." + pubArtifact.getExt();
        String fullPath = IvyResolverHelper.calculateArtifactPath(publisher, map, extraAttributes);
        int lastSlash = fullPath.lastIndexOf(47);
        if (lastSlash > 0 && lastSlash + 1 < fullPath.length()) {
            name = fullPath.substring(lastSlash + 1);
        }
        project.log("[buildinfo:collect] Collecting artifact " + name + " for module " + moduleName + " using file " + file, 2);
        if (this.isArtifactExist(module.getArtifacts(), name) || this.isArtifactExist(module.getExcludedArtifacts(), name)) {
            return;
        }
        ArtifactBuilder artifactBuilder = new ArtifactBuilder(name);
        artifactBuilder.type(type);
        File artifactFile = new File(file);
        Map<String, String> checksums = this.calculateFileChecksum(artifactFile);
        String md5 = checksums.get(MD5);
        String sha1 = checksums.get(SHA1);
        artifactBuilder.md5(md5).sha1(sha1);
        Artifact artifact = artifactBuilder.build();
        if (excludeArtifactsFromBuild && PatternMatcher.pathConflicts(fullPath, patterns)) {
            module.getExcludedArtifacts().add(artifact);
        } else {
            module.getArtifacts().add(artifact);
        }
        DeployDetails deployDetails = this.buildDeployDetails(artifactFile, artifact, this.ctx, map, extraAttributes);
        this.ctx.addDeployDetailsForModule(deployDetails);
        List<Module> contextModules = this.ctx.getModules();
        if (contextModules.indexOf(module) == -1) {
            this.ctx.addModule(module);
        }
    }

    private String getType(org.apache.ivy.core.module.descriptor.Artifact ivyArtifact) {
        return BuildInfoExtractorUtils.getTypeString(ivyArtifact.getType(), ivyArtifact.getExtraAttribute("classifier"), ivyArtifact.getExt());
    }

    private String getName(org.apache.ivy.core.module.descriptor.Artifact ivyArtifact) {
        return BuildInfoExtractorUtils.getTypeString(ivyArtifact.getType(), ivyArtifact.getExtraAttribute("classifier"), ivyArtifact.getExt());
    }

    private DeployDetails buildDeployDetails(File artifactFile, Artifact artifact, BuildContext ctx, Map<String, String> map, Map<String, String> extraAttributes) {
        String buildTimestamp;
        ArtifactoryClientConfiguration clientConf = ctx.getClientConf();
        DeployDetails.Builder builder = new DeployDetails.Builder().file(artifactFile).sha1(artifact.getSha1()).md5(artifact.getMd5());
        builder.artifactPath(IvyResolverHelper.calculateArtifactPath(clientConf.publisher, map, extraAttributes));
        builder.targetRepository(clientConf.publisher.getRepoKey());
        if (StringUtils.isNotBlank(clientConf.info.getVcsRevision())) {
            builder.addProperty("vcs.revision", clientConf.info.getVcsRevision());
        }
        if (StringUtils.isNotBlank(clientConf.info.getVcsUrl())) {
            builder.addProperty("vcs.url", clientConf.info.getVcsUrl());
        }
        if (StringUtils.isNotBlank(clientConf.info.getBuildName())) {
            builder.addProperty("build.name", clientConf.info.getBuildName());
        }
        if (StringUtils.isNotBlank(clientConf.info.getBuildNumber())) {
            builder.addProperty("build.number", clientConf.info.getBuildNumber());
        }
        if (StringUtils.isBlank(buildTimestamp = clientConf.info.getBuildTimestamp())) {
            buildTimestamp = ctx.getBuildStartTime() + "";
        }
        builder.addProperty("build.timestamp", buildTimestamp);
        if (StringUtils.isNotBlank(clientConf.info.getParentBuildName())) {
            builder.addProperty("build.parentName", clientConf.info.getParentBuildName());
        }
        if (StringUtils.isNotBlank(clientConf.info.getParentBuildNumber())) {
            builder.addProperty("build.parentNumber", clientConf.info.getParentBuildNumber());
        }
        builder.addProperties(clientConf.publisher.getMatrixParams());
        return builder.build();
    }

    private Map<String, String> calculateFileChecksum(File file) {
        Map<String, String> checksums;
        try {
            checksums = FileChecksumCalculator.calculateChecksums(file, MD5, SHA1);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return checksums;
    }

    private Dependency findDependencyInList(ModuleRevisionId id, final String type, List<Dependency> moduleDependencies) {
        final String idToFind = BuildInfoExtractorUtils.getModuleIdString(id.getOrganisation(), id.getName(), "");
        return Iterables.find(moduleDependencies, new Predicate<Dependency>(){

            @Override
            public boolean apply(Dependency input) {
                return input.getId().startsWith(idToFind) && input.getType().equals(type);
            }
        }, null);
    }

    private Module findModule(List<Module> modules, final String moduleKey) {
        return Iterables.find(modules, new Predicate<Module>(){

            @Override
            public boolean apply(Module input) {
                return input.getId().startsWith(moduleKey);
            }
        }, null);
    }

    private Module getOrCreateModule(Map<String, String> attributes) {
        List<Module> modules = this.ctx.getModules();
        String org = attributes.get("organisation");
        String moduleName = attributes.get("module");
        String moduleKey = BuildInfoExtractorUtils.getModuleIdString(org, moduleName, "");
        String moduleId = BuildInfoExtractorUtils.getModuleIdString(org, moduleName, attributes.get("revision"));
        Module module = this.findModule(modules, moduleKey);
        if (module == null) {
            ModuleBuilder moduleBuilder = new ModuleBuilder().id(moduleId);
            module = moduleBuilder.build();
            modules.add(module);
        } else {
            module.setId(moduleId);
        }
        return module;
    }

    private boolean isArtifactExist(List<Artifact> artifacts, final String artifactName) {
        return Iterables.any(artifacts, new Predicate<Artifact>(){

            @Override
            public boolean apply(Artifact input) {
                return input.getName().equals(artifactName);
            }
        });
    }
}

