/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jfrog.build.client.DeployDetails;
import org.jfrog.build.client.DeployableArtifactDetail;

public class DeployableArtifactsUtils {
    public static void saveDeployableArtifactsToFile(Set<DeployDetails> deployDetails, File toFile) throws IOException {
        List<DeployableArtifactDetail> deployableArtifacts = DeployableArtifactsUtils.getDeployableArtifactsPaths(deployDetails);
        ObjectMapper mapper = new ObjectMapper();
        mapper.writeValue(toFile, deployableArtifacts);
    }

    public static List<DeployableArtifactDetail> loadDeployableArtifactsFromFile(File fromFile) throws IOException, ClassNotFoundException {
        if (fromFile == null || fromFile.length() == 0L) {
            return new ArrayList<DeployableArtifactDetail>();
        }
        ObjectMapper mapper = new ObjectMapper();
        return (List)mapper.readValue(fromFile, (TypeReference)new TypeReference<List<DeployableArtifactDetail>>(){});
    }

    private static List<DeployableArtifactDetail> getDeployableArtifactsPaths(Set<DeployDetails> deployDetails) {
        ArrayList<DeployableArtifactDetail> deployableArtifacts = new ArrayList<DeployableArtifactDetail>();
        for (DeployDetails artifact : deployDetails) {
            deployableArtifacts.add(new DeployableArtifactDetail(artifact.getFile().getAbsolutePath(), artifact.getArtifactPath(), artifact.getSha1()));
        }
        return deployableArtifacts;
    }
}

