/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.gradle.plugin.artifactory;

import org.gradle.api.Project;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;
import org.jfrog.gradle.plugin.artifactory.dsl.ArtifactoryPluginConvention;

public class ArtifactoryPluginUtil {
    public static ArtifactoryPluginConvention getArtifactoryConvention(Project project) {
        return (ArtifactoryPluginConvention)project.getRootProject().getConvention().findPlugin(ArtifactoryPluginConvention.class);
    }

    public static ArtifactoryPluginConvention getPublisherConvention(Project project) {
        while (project != null) {
            ArtifactoryClientConfiguration.PublisherHandler publisher;
            ArtifactoryPluginConvention acc = (ArtifactoryPluginConvention)project.getConvention().findPlugin(ArtifactoryPluginConvention.class);
            if (acc != null && (publisher = acc.getClientConfig().publisher).getContextUrl() != null && publisher.getRepoKey() != null) {
                return acc;
            }
            project = project.getParent();
        }
        return null;
    }

    public static ArtifactoryClientConfiguration.PublisherHandler getPublisherHandler(Project project) {
        ArtifactoryPluginConvention convention = ArtifactoryPluginUtil.getPublisherConvention(project);
        if (convention != null) {
            return convention.getClientConfig().publisher;
        }
        return null;
    }

    public static ArtifactoryClientConfiguration.ResolverHandler getResolverHandler(Project project) {
        while (project != null) {
            ArtifactoryClientConfiguration.ResolverHandler resolver;
            ArtifactoryPluginConvention acc = (ArtifactoryPluginConvention)project.getConvention().findPlugin(ArtifactoryPluginConvention.class);
            if (acc != null && (resolver = acc.getClientConfig().resolver).getContextUrl() != null && resolver.getRepoKey() != null) {
                return resolver;
            }
            project = project.getParent();
        }
        return null;
    }
}

