/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.gradle.plugin.artifactory.extractor;

import com.google.common.collect.Sets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.gradle.StartParameter;
import org.gradle.api.Project;
import org.jfrog.build.extractor.BuildInfoExtractorUtils;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;

public class GradleArtifactoryClientConfigUpdater {
    public static void update(ArtifactoryClientConfiguration config, Project project) {
        Properties props = new Properties();
        GradleArtifactoryClientConfigUpdater.fillProperties(project, props);
        StartParameter startParameter = project.getGradle().getStartParameter();
        Map startProps = startParameter.getProjectProperties();
        props.putAll(BuildInfoExtractorUtils.filterStringEntries(startProps));
        Properties mergedProps = BuildInfoExtractorUtils.mergePropertiesWithSystemAndPropertyFile(props, config.info.getLog());
        Properties buildInfoProperties = BuildInfoExtractorUtils.filterDynamicProperties(mergedProps, BuildInfoExtractorUtils.BUILD_INFO_PROP_PREDICATE);
        buildInfoProperties = BuildInfoExtractorUtils.stripPrefixFromProperties(buildInfoProperties, "buildInfo.property.");
        mergedProps.putAll((Map<?, ?>)buildInfoProperties);
        String prefix = "buildInfo.";
        HashSet<String> excludeIfExist = Sets.newHashSet(prefix + "build.number", prefix + "build.name", prefix + "build.started");
        config.fillFromProperties(mergedProps, excludeIfExist);
        GradleArtifactoryClientConfigUpdater.setMissingBuildAttributes(config, project);
    }

    public static void setMissingBuildAttributes(ArtifactoryClientConfiguration config, Project project) {
        String buildTimestamp;
        String buildNumber;
        String buildName = config.info.getBuildName();
        if (StringUtils.isBlank(buildName)) {
            buildName = project.getRootProject().getName();
            config.info.setBuildName(buildName);
        }
        if (StringUtils.isBlank(config.publisher.getMatrixParam("build.name"))) {
            config.publisher.addMatrixParam("build.name", buildName);
        }
        if (StringUtils.isBlank(buildNumber = config.info.getBuildNumber())) {
            buildNumber = new Date().getTime() + "";
            config.info.setBuildNumber(buildNumber);
        }
        if (StringUtils.isBlank(config.publisher.getMatrixParam("build.number"))) {
            config.publisher.addMatrixParam("build.number", buildNumber);
        }
        if (StringUtils.isBlank(buildTimestamp = config.info.getBuildTimestamp())) {
            Date buildStartDate;
            String buildStartedIso = config.info.getBuildStarted();
            try {
                buildStartDate = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").parse(buildStartedIso);
            }
            catch (ParseException e) {
                throw new RuntimeException("Build start date format error: " + buildStartedIso, e);
            }
            buildTimestamp = String.valueOf(buildStartDate.getTime());
            config.info.setBuildTimestamp(buildTimestamp);
        }
        if (StringUtils.isBlank(config.publisher.getMatrixParam("build.timestamp"))) {
            config.publisher.addMatrixParam("build.timestamp", buildTimestamp);
        }
        String buildAgentName = config.info.getBuildAgentName();
        String buildAgentVersion = config.info.getBuildAgentVersion();
        if (StringUtils.isBlank(buildAgentName) && StringUtils.isBlank(buildAgentVersion)) {
            config.info.setBuildAgentName("Gradle");
            config.info.setBuildAgentVersion(project.getGradle().getGradleVersion());
        }
    }

    private static void fillProperties(Project project, Properties props) {
        Project parent = project.getParent();
        if (parent != null) {
            GradleArtifactoryClientConfigUpdater.fillProperties(parent, props);
        }
        Map projectProperties = project.getProperties();
        props.putAll(BuildInfoExtractorUtils.filterStringEntries(projectProperties));
    }
}

