/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.gradle.plugin.artifactory.task;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.publish.Publication;
import org.gradle.api.publish.ivy.IvyPublication;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.util.ConfigureUtil;
import org.jfrog.build.extractor.clientConfiguration.ArtifactSpecs;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;
import org.jfrog.gradle.plugin.artifactory.ArtifactoryPluginUtil;
import org.jfrog.gradle.plugin.artifactory.dsl.ArtifactoryPluginConvention;
import org.jfrog.gradle.plugin.artifactory.dsl.PropertiesConfig;
import org.jfrog.gradle.plugin.artifactory.dsl.PublisherConfig;
import org.jfrog.gradle.plugin.artifactory.extractor.GradleDeployDetails;
import org.jfrog.gradle.plugin.artifactory.task.helper.TaskHelperConfigurations;
import org.jfrog.gradle.plugin.artifactory.task.helper.TaskHelperPublications;

public class ArtifactoryTask
extends DefaultTask {
    public static final String DEPLOY_TASK_NAME = "artifactoryDeploy";
    public static final String ARTIFACTORY_PUBLISH_TASK_NAME = "artifactoryPublish";
    public static final String PUBLISH_ARTIFACTS = "publishArtifacts";
    public static final String PUBLISH_IVY = "publishIvy";
    public static final String PUBLISH_POM = "publishPom";
    private static final Logger log = Logging.getLogger(ArtifactoryTask.class);
    private final Map<String, Boolean> flags = Maps.newHashMap();
    private boolean evaluated = false;
    @InputFile
    @Optional
    public File ivyDescriptor;
    @InputFile
    @Optional
    public File mavenDescriptor;
    @InputFiles
    @Optional
    public Set<Configuration> publishConfigs = Sets.newHashSet();
    @Input
    @Optional
    public Set<IvyPublication> ivyPublications = Sets.newHashSet();
    @Input
    @Optional
    public Set<MavenPublication> mavenPublications = Sets.newHashSet();
    private boolean addArchivesConfigToTask = false;
    public TaskHelperConfigurations helperConfigurations = new TaskHelperConfigurations(this);
    public TaskHelperPublications helperPublications = new TaskHelperPublications(this);
    public final Set<GradleDeployDetails> deployDetails = Sets.newTreeSet();
    private final Multimap<String, CharSequence> properties = ArrayListMultimap.create();
    @Input
    public final ArtifactSpecs artifactSpecs = new ArtifactSpecs();
    @Input
    public boolean skip = false;

    @Input
    Set<Publication> getPublications() {
        HashSet<Publication> publications = new HashSet<Publication>();
        publications.addAll(this.ivyPublications);
        publications.addAll(this.mavenPublications);
        return publications;
    }

    public void checkDependsOnArtifactsToPublish() {
        if (this.addArchivesConfigToTask) {
            this.helperConfigurations.AddDefaultArchiveConfiguration(this.getProject());
        }
        if (this.helperConfigurations.hasConfigurations()) {
            this.helperConfigurations.checkDependsOnArtifactsToPublish();
        }
        if (this.helperPublications.hasPublications()) {
            this.helperPublications.checkDependsOnArtifactsToPublish();
        }
    }

    public void collectDescriptorsAndArtifactsForUpload() throws IOException {
        if (this.helperConfigurations.hasConfigurations()) {
            this.helperConfigurations.collectDescriptorsAndArtifactsForUpload();
        }
        if (this.helperPublications.hasPublications()) {
            this.helperPublications.collectDescriptorsAndArtifactsForUpload();
        }
    }

    public boolean hasModules() {
        return this.helperConfigurations.hasModules() || this.helperPublications.hasModules();
    }

    public boolean hasPublications() {
        return this.helperPublications.hasPublications();
    }

    public boolean hasConfigurations() {
        return this.helperConfigurations.hasConfigurations();
    }

    public void publishConfigs(Object ... confs) {
        this.helperConfigurations.publishConfigs(confs);
    }

    public void publications(Object ... publications) {
        this.helperPublications.publications(publications);
    }

    public Set<IvyPublication> getIvyPublications() {
        return this.ivyPublications;
    }

    public File getIvyDescriptor() {
        return this.ivyDescriptor;
    }

    public File getMavenDescriptor() {
        return this.mavenDescriptor;
    }

    public void setAddArchivesConfigToTask(boolean addArchivesConfigToTask) {
        this.addArchivesConfigToTask = addArchivesConfigToTask;
    }

    @Input
    public Multimap<String, CharSequence> getProperties() {
        return this.properties;
    }

    @Input
    @Optional
    @Nullable
    public Boolean getPublishArtifacts() {
        return this.getFlag(PUBLISH_ARTIFACTS);
    }

    @Input
    @Optional
    @Nullable
    public Boolean getPublishIvy() {
        return this.getFlag(PUBLISH_IVY);
    }

    @Input
    @Optional
    @Nullable
    public Boolean getPublishPom() {
        return this.getFlag(PUBLISH_POM);
    }

    public void projectsEvaluated() {
        Project project = this.getProject();
        if (this.isSkip()) {
            log.debug("artifactoryPublish task '{}' skipped for project '{}'.", (Object)this.getPath(), (Object)project.getName());
        } else {
            ArtifactoryPluginConvention convention = ArtifactoryPluginUtil.getPublisherConvention(project);
            if (convention != null) {
                ArtifactoryClientConfiguration acc = convention.getClientConfig();
                this.artifactSpecs.clear();
                this.artifactSpecs.addAll(acc.publisher.getArtifactSpecs());
                PublisherConfig config = convention.getPublisherConfig();
                if (config != null) {
                    Closure defaultsClosure = config.getDefaultsClosure();
                    ConfigureUtil.configure((Closure)defaultsClosure, (Object)((Object)this));
                }
            }
            Task deployTask = (Task)project.getRootProject().getTasks().findByName(DEPLOY_TASK_NAME);
            this.finalizedBy(new Object[]{deployTask});
            for (Project sub : project.getSubprojects()) {
                Task subArtifactoryTask = (Task)sub.getTasks().findByName(ARTIFACTORY_PUBLISH_TASK_NAME);
                if (subArtifactoryTask == null) continue;
                this.dependsOn(new Object[]{subArtifactoryTask});
            }
            this.checkDependsOnArtifactsToPublish();
        }
        this.evaluated = true;
    }

    public boolean isEvaluated() {
        return this.evaluated;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setProperties(Map<String, CharSequence> props) {
        if (props == null || props.isEmpty()) {
            return;
        }
        this.properties.clear();
        for (Map.Entry<String, CharSequence> entry : props.entrySet()) {
            CharSequence value;
            String key = entry.getKey();
            if (!StringUtils.isNotBlank(key) || (value = entry.getValue()) == null) continue;
            this.properties.put(key, value);
        }
    }

    public Set<GradleDeployDetails> getDeployDetails() {
        return this.deployDetails;
    }

    public ArtifactSpecs getArtifactSpecs() {
        return this.artifactSpecs;
    }

    public void properties(Closure closure) {
        Project project = this.getProject();
        PropertiesConfig propertiesConfig = new PropertiesConfig(project);
        ConfigureUtil.configure((Closure)closure, (Object)propertiesConfig);
        this.artifactSpecs.clear();
        this.artifactSpecs.addAll(propertiesConfig.getArtifactSpecs());
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public void setPublishIvy(Object publishIvy) {
        this.setFlag(PUBLISH_IVY, this.toBoolean(publishIvy));
    }

    public void setPublishPom(Object publishPom) {
        this.setFlag(PUBLISH_POM, this.toBoolean(publishPom));
    }

    public void setPublishArtifacts(Object publishArtifacts) {
        this.setFlag(PUBLISH_ARTIFACTS, this.toBoolean(publishArtifacts));
    }

    @Nullable
    private Boolean getFlag(String flagName) {
        return this.flags.get(flagName);
    }

    private Boolean toBoolean(Object o) {
        return Boolean.valueOf(o.toString());
    }

    private void setFlag(String flagName, Boolean newValue) {
        this.flags.put(flagName, newValue);
    }
}

