/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.plexus.locators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.codehaus.plexus.classworlds.realm.ClassRealm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassRealmUtils {
    private static final boolean GET_IMPORT_REALMS_SUPPORTED;
    private static Map<ClassRealm, RealmInfo> realmCache;

    private ClassRealmUtils() {
    }

    public static ClassRealm contextRealm() {
        for (ClassLoader tccl = Thread.currentThread().getContextClassLoader(); tccl != null; tccl = tccl.getParent()) {
            if (!(tccl instanceof ClassRealm)) continue;
            return (ClassRealm)tccl;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> visibleRealmNames(ClassRealm contextRealm) {
        if (!GET_IMPORT_REALMS_SUPPORTED || null == contextRealm) {
            return Collections.emptySet();
        }
        Map<ClassRealm, RealmInfo> map = realmCache;
        synchronized (map) {
            RealmInfo realmInfo = realmCache.get(contextRealm);
            if (null == realmInfo) {
                realmInfo = new RealmInfo(contextRealm);
                realmCache.put(contextRealm, realmInfo);
            }
            return realmInfo.getVisibleRealmNames();
        }
    }

    static {
        new ClassRealmUtils();
        boolean getImportRealmsSupported = true;
        try {
            ClassRealm.class.getDeclaredMethod("getImportRealms", new Class[0]);
        }
        catch (Throwable e) {
            getImportRealmsSupported = false;
        }
        GET_IMPORT_REALMS_SUPPORTED = getImportRealmsSupported;
        realmCache = new WeakHashMap<ClassRealm, RealmInfo>();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RealmInfo {
        private final Set<String> visibleRealmNames = new HashSet<String>();

        RealmInfo(ClassRealm forRealm) {
            ArrayList<ClassRealm> searchRealms = new ArrayList<ClassRealm>();
            searchRealms.add(forRealm);
            for (int i = 0; i < searchRealms.size(); ++i) {
                ClassRealm realm = (ClassRealm)searchRealms.get(i);
                if (!this.visibleRealmNames.add(realm.toString())) continue;
                searchRealms.addAll(realm.getImportRealms());
                ClassRealm parent = realm.getParentRealm();
                if (null == parent) continue;
                searchRealms.add(parent);
            }
        }

        public Set<String> getVisibleRealmNames() {
            return this.visibleRealmNames;
        }
    }
}

