/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.framework.configuration;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;

public abstract class AbstractConfiguration
implements Configuration {
    protected abstract String getPrefix() throws ConfigurationException;

    public int getValueAsInteger() throws ConfigurationException {
        String value2 = this.getValue().trim();
        try {
            if (value2.startsWith("0x")) {
                return Integer.parseInt(value2.substring(2), 16);
            }
            if (value2.startsWith("0o")) {
                return Integer.parseInt(value2.substring(2), 8);
            }
            if (value2.startsWith("0b")) {
                return Integer.parseInt(value2.substring(2), 2);
            }
            return Integer.parseInt(value2);
        }
        catch (Exception nfe) {
            String message = "Cannot parse the value \"" + value2 + "\" as an integer in the configuration element \"" + this.getName() + "\" at " + this.getLocation();
            throw new ConfigurationException(message);
        }
    }

    public int getValueAsInteger(int defaultValue) {
        try {
            return this.getValueAsInteger();
        }
        catch (ConfigurationException ce) {
            return defaultValue;
        }
    }

    public long getValueAsLong() throws ConfigurationException {
        String value2 = this.getValue().trim();
        try {
            if (value2.startsWith("0x")) {
                return Long.parseLong(value2.substring(2), 16);
            }
            if (value2.startsWith("0o")) {
                return Long.parseLong(value2.substring(2), 8);
            }
            if (value2.startsWith("0b")) {
                return Long.parseLong(value2.substring(2), 2);
            }
            return Long.parseLong(value2);
        }
        catch (Exception nfe) {
            String message = "Cannot parse the value \"" + value2 + "\" as a long in the configuration element \"" + this.getName() + "\" at " + this.getLocation();
            throw new ConfigurationException(message);
        }
    }

    public long getValueAsLong(long defaultValue) {
        try {
            return this.getValueAsLong();
        }
        catch (ConfigurationException ce) {
            return defaultValue;
        }
    }

    public float getValueAsFloat() throws ConfigurationException {
        String value2 = this.getValue().trim();
        try {
            return Float.parseFloat(value2);
        }
        catch (Exception nfe) {
            String message = "Cannot parse the value \"" + value2 + "\" as a float in the configuration element \"" + this.getName() + "\" at " + this.getLocation();
            throw new ConfigurationException(message);
        }
    }

    public float getValueAsFloat(float defaultValue) {
        try {
            return this.getValueAsFloat();
        }
        catch (ConfigurationException ce) {
            return defaultValue;
        }
    }

    public double getValueAsDouble() throws ConfigurationException {
        String value2 = this.getValue().trim();
        try {
            return Double.parseDouble(value2);
        }
        catch (Exception nfe) {
            String message = "Cannot parse the value \"" + value2 + "\" as a double in the configuration element \"" + this.getName() + "\" at " + this.getLocation();
            throw new ConfigurationException(message);
        }
    }

    public double getValueAsDouble(double defaultValue) {
        try {
            return this.getValueAsDouble();
        }
        catch (ConfigurationException ce) {
            return defaultValue;
        }
    }

    public boolean getValueAsBoolean() throws ConfigurationException {
        String value2 = this.getValue().trim();
        if (this.isTrue(value2)) {
            return true;
        }
        if (this.isFalse(value2)) {
            return false;
        }
        String message = "Cannot parse the value \"" + value2 + "\" as a boolean in the configuration element \"" + this.getName() + "\" at " + this.getLocation();
        throw new ConfigurationException(message);
    }

    public boolean getValueAsBoolean(boolean defaultValue) {
        try {
            return this.getValueAsBoolean();
        }
        catch (ConfigurationException ce) {
            return defaultValue;
        }
    }

    public String getValue(String defaultValue) {
        try {
            return this.getValue();
        }
        catch (ConfigurationException ce) {
            return defaultValue;
        }
    }

    public int getAttributeAsInteger(String name) throws ConfigurationException {
        String value2 = this.getAttribute(name).trim();
        try {
            if (value2.startsWith("0x")) {
                return Integer.parseInt(value2.substring(2), 16);
            }
            if (value2.startsWith("0o")) {
                return Integer.parseInt(value2.substring(2), 8);
            }
            if (value2.startsWith("0b")) {
                return Integer.parseInt(value2.substring(2), 2);
            }
            return Integer.parseInt(value2);
        }
        catch (Exception nfe) {
            String message = "Cannot parse the value \"" + value2 + "\" as an integer in the attribute \"" + name + "\" at " + this.getLocation();
            throw new ConfigurationException(message);
        }
    }

    public int getAttributeAsInteger(String name, int defaultValue) {
        try {
            return this.getAttributeAsInteger(name);
        }
        catch (ConfigurationException ce) {
            return defaultValue;
        }
    }

    public long getAttributeAsLong(String name) throws ConfigurationException {
        String value2 = this.getAttribute(name);
        try {
            if (value2.startsWith("0x")) {
                return Long.parseLong(value2.substring(2), 16);
            }
            if (value2.startsWith("0o")) {
                return Long.parseLong(value2.substring(2), 8);
            }
            if (value2.startsWith("0b")) {
                return Long.parseLong(value2.substring(2), 2);
            }
            return Long.parseLong(value2);
        }
        catch (Exception nfe) {
            String message = "Cannot parse the value \"" + value2 + "\" as a long in the attribute \"" + name + "\" at " + this.getLocation();
            throw new ConfigurationException(message);
        }
    }

    public long getAttributeAsLong(String name, long defaultValue) {
        try {
            return this.getAttributeAsLong(name);
        }
        catch (ConfigurationException ce) {
            return defaultValue;
        }
    }

    public float getAttributeAsFloat(String name) throws ConfigurationException {
        String value2 = this.getAttribute(name);
        try {
            return Float.parseFloat(value2);
        }
        catch (Exception e) {
            String message = "Cannot parse the value \"" + value2 + "\" as a float in the attribute \"" + name + "\" at " + this.getLocation();
            throw new ConfigurationException(message);
        }
    }

    public float getAttributeAsFloat(String name, float defaultValue) {
        try {
            return this.getAttributeAsFloat(name);
        }
        catch (ConfigurationException ce) {
            return defaultValue;
        }
    }

    public double getAttributeAsDouble(String name) throws ConfigurationException {
        String value2 = this.getAttribute(name);
        try {
            return Double.parseDouble(value2);
        }
        catch (Exception e) {
            String message = "Cannot parse the value \"" + value2 + "\" as a double in the attribute \"" + name + "\" at " + this.getLocation();
            throw new ConfigurationException(message);
        }
    }

    public double getAttributeAsDouble(String name, double defaultValue) {
        try {
            return this.getAttributeAsDouble(name);
        }
        catch (ConfigurationException ce) {
            return defaultValue;
        }
    }

    public boolean getAttributeAsBoolean(String name) throws ConfigurationException {
        String value2 = this.getAttribute(name);
        if (this.isTrue(value2)) {
            return true;
        }
        if (this.isFalse(value2)) {
            return false;
        }
        String message = "Cannot parse the value \"" + value2 + "\" as a boolean in the attribute \"" + name + "\" at " + this.getLocation();
        throw new ConfigurationException(message);
    }

    private boolean isTrue(String value2) {
        return value2.equalsIgnoreCase("true") || value2.equalsIgnoreCase("yes") || value2.equalsIgnoreCase("on") || value2.equalsIgnoreCase("1");
    }

    private boolean isFalse(String value2) {
        return value2.equalsIgnoreCase("false") || value2.equalsIgnoreCase("no") || value2.equalsIgnoreCase("off") || value2.equalsIgnoreCase("0");
    }

    public boolean getAttributeAsBoolean(String name, boolean defaultValue) {
        try {
            return this.getAttributeAsBoolean(name);
        }
        catch (ConfigurationException ce) {
            return defaultValue;
        }
    }

    public String getAttribute(String name, String defaultValue) {
        try {
            return this.getAttribute(name);
        }
        catch (ConfigurationException ce) {
            return defaultValue;
        }
    }

    public Configuration getChild(String name) {
        return this.getChild(name, true);
    }

    public Configuration getChild(String name, boolean createNew) {
        Configuration[] children2 = this.getChildren(name);
        if (children2.length > 0) {
            return children2[0];
        }
        if (createNew) {
            return new DefaultConfiguration(name, "-");
        }
        return null;
    }

    public String toString() {
        return this.getName() + "::" + this.getValue("<no value>") + ":@" + this.getLocation();
    }
}

