/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.batik.bridge.BaseScriptingEnvironment;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.Messages;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.ScriptingEnvironment;
import org.apache.batik.bridge.UpdateManager;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.dom.events.NodeEventTarget;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.util.DOMUtilities;
import org.apache.batik.dom.util.SAXDocumentFactory;
import org.apache.batik.script.Interpreter;
import org.apache.batik.script.InterpreterException;
import org.apache.batik.script.ScriptEventWrapper;
import org.apache.batik.script.Window;
import org.apache.batik.util.EncodingUtilities;
import org.apache.batik.util.ParsedURL;
import org.apache.batik.util.RunnableQueue;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.MutationEvent;
import org.w3c.dom.svg.SVGDocument;

public class ScriptingEnvironment
extends BaseScriptingEnvironment {
    public static final String[] SVG_EVENT_ATTRS = new String[]{"onabort", "onerror", "onresize", "onscroll", "onunload", "onzoom", "onbegin", "onend", "onrepeat", "onfocusin", "onfocusout", "onactivate", "onclick", "onmousedown", "onmouseup", "onmouseover", "onmouseout", "onmousemove", "onkeypress", "onkeydown", "onkeyup"};
    public static final String[] SVG_DOM_EVENT = new String[]{"SVGAbort", "SVGError", "SVGResize", "SVGScroll", "SVGUnload", "SVGZoom", "beginEvent", "endEvent", "repeatEvent", "DOMFocusIn", "DOMFocusOut", "DOMActivate", "click", "mousedown", "mouseup", "mouseover", "mouseout", "mousemove", "keypress", "keydown", "keyup"};
    protected Timer timer = new Timer(true);
    protected UpdateManager updateManager;
    protected RunnableQueue updateRunnableQueue;
    protected EventListener domNodeInsertedListener;
    protected EventListener domNodeRemovedListener;
    protected EventListener domAttrModifiedListener;
    protected EventListener svgAbortListener = new ScriptingEventListener("onabort");
    protected EventListener svgErrorListener = new ScriptingEventListener("onerror");
    protected EventListener svgResizeListener = new ScriptingEventListener("onresize");
    protected EventListener svgScrollListener = new ScriptingEventListener("onscroll");
    protected EventListener svgUnloadListener = new ScriptingEventListener("onunload");
    protected EventListener svgZoomListener = new ScriptingEventListener("onzoom");
    protected EventListener beginListener = new ScriptingEventListener("onbegin");
    protected EventListener endListener = new ScriptingEventListener("onend");
    protected EventListener repeatListener = new ScriptingEventListener("onrepeat");
    protected EventListener focusinListener = new ScriptingEventListener("onfocusin");
    protected EventListener focusoutListener = new ScriptingEventListener("onfocusout");
    protected EventListener activateListener = new ScriptingEventListener("onactivate");
    protected EventListener clickListener = new ScriptingEventListener("onclick");
    protected EventListener mousedownListener = new ScriptingEventListener("onmousedown");
    protected EventListener mouseupListener = new ScriptingEventListener("onmouseup");
    protected EventListener mouseoverListener = new ScriptingEventListener("onmouseover");
    protected EventListener mouseoutListener = new ScriptingEventListener("onmouseout");
    protected EventListener mousemoveListener = new ScriptingEventListener("onmousemove");
    protected EventListener keypressListener = new ScriptingEventListener("onkeypress");
    protected EventListener keydownListener = new ScriptingEventListener("onkeydown");
    protected EventListener keyupListener = new ScriptingEventListener("onkeyup");
    protected EventListener[] listeners = new EventListener[]{this.svgAbortListener, this.svgErrorListener, this.svgResizeListener, this.svgScrollListener, this.svgUnloadListener, this.svgZoomListener, this.beginListener, this.endListener, this.repeatListener, this.focusinListener, this.focusoutListener, this.activateListener, this.clickListener, this.mousedownListener, this.mouseupListener, this.mouseoverListener, this.mouseoutListener, this.mousemoveListener, this.keypressListener, this.keydownListener, this.keyupListener};
    Map attrToDOMEvent = new HashMap(SVG_EVENT_ATTRS.length);
    Map attrToListener = new HashMap(SVG_EVENT_ATTRS.length);

    public ScriptingEnvironment(BridgeContext ctx) {
        super(ctx);
        for (int i = 0; i < SVG_EVENT_ATTRS.length; ++i) {
            this.attrToDOMEvent.put(SVG_EVENT_ATTRS[i], SVG_DOM_EVENT[i]);
            this.attrToListener.put(SVG_EVENT_ATTRS[i], this.listeners[i]);
        }
        this.updateManager = ctx.getUpdateManager();
        this.updateRunnableQueue = this.updateManager.getUpdateRunnableQueue();
        this.addScriptingListeners(this.document.getDocumentElement());
        this.addDocumentListeners();
    }

    protected void addDocumentListeners() {
        this.domNodeInsertedListener = new DOMNodeInsertedListener();
        this.domNodeRemovedListener = new DOMNodeRemovedListener();
        this.domAttrModifiedListener = new DOMAttrModifiedListener();
        NodeEventTarget et = (NodeEventTarget)((Object)this.document);
        et.addEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeInserted", this.domNodeInsertedListener, false, null);
        et.addEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeRemoved", this.domNodeRemovedListener, false, null);
        et.addEventListenerNS("http://www.w3.org/2001/xml-events", "DOMAttrModified", this.domAttrModifiedListener, false, null);
    }

    protected void removeDocumentListeners() {
        NodeEventTarget et = (NodeEventTarget)((Object)this.document);
        et.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeInserted", this.domNodeInsertedListener, false);
        et.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeRemoved", this.domNodeRemovedListener, false);
        et.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMAttrModified", this.domAttrModifiedListener, false);
    }

    public org.apache.batik.script.Window createWindow(Interpreter interp, String lang) {
        return new Window(interp, lang);
    }

    public void runEventHandler(String script, Event evt, String lang, String desc) {
        Interpreter interpreter = this.getInterpreter(lang);
        if (interpreter == null) {
            return;
        }
        try {
            this.checkCompatibleScriptURL(lang, this.docPURL);
            Object event = evt instanceof ScriptEventWrapper ? ((ScriptEventWrapper)((Object)evt)).getEventObject() : evt;
            interpreter.bindObject("event", event);
            interpreter.bindObject("evt", event);
            interpreter.evaluate(new StringReader(script), desc);
        }
        catch (IOException ioe) {
        }
        catch (InterpreterException ie) {
            this.handleInterpreterException(ie);
        }
        catch (SecurityException se) {
            this.handleSecurityException(se);
        }
    }

    public void interrupt() {
        this.timer.cancel();
        this.removeScriptingListeners(this.document.getDocumentElement());
        this.removeDocumentListeners();
    }

    public void addScriptingListeners(Node node) {
        if (node.getNodeType() == 1) {
            this.addScriptingListenersOn((Element)node);
        }
        for (Node n = node.getFirstChild(); n != null; n = n.getNextSibling()) {
            this.addScriptingListeners(n);
        }
    }

    protected void addScriptingListenersOn(Element elt) {
        NodeEventTarget target = (NodeEventTarget)((Object)elt);
        if ("http://www.w3.org/2000/svg".equals(elt.getNamespaceURI())) {
            if ("svg".equals(elt.getLocalName())) {
                if (elt.hasAttributeNS(null, "onabort")) {
                    target.addEventListenerNS("http://www.w3.org/2001/xml-events", "SVGAbort", this.svgAbortListener, false, null);
                }
                if (elt.hasAttributeNS(null, "onerror")) {
                    target.addEventListenerNS("http://www.w3.org/2001/xml-events", "SVGError", this.svgErrorListener, false, null);
                }
                if (elt.hasAttributeNS(null, "onresize")) {
                    target.addEventListenerNS("http://www.w3.org/2001/xml-events", "SVGResize", this.svgResizeListener, false, null);
                }
                if (elt.hasAttributeNS(null, "onscroll")) {
                    target.addEventListenerNS("http://www.w3.org/2001/xml-events", "SVGScroll", this.svgScrollListener, false, null);
                }
                if (elt.hasAttributeNS(null, "onunload")) {
                    target.addEventListenerNS("http://www.w3.org/2001/xml-events", "SVGUnload", this.svgUnloadListener, false, null);
                }
                if (elt.hasAttributeNS(null, "onzoom")) {
                    target.addEventListenerNS("http://www.w3.org/2001/xml-events", "SVGZoom", this.svgZoomListener, false, null);
                }
            } else {
                String name = elt.getLocalName();
                if (name.equals("set") || name.startsWith("animate")) {
                    if (elt.hasAttributeNS(null, "onbegin")) {
                        target.addEventListenerNS("http://www.w3.org/2001/xml-events", "beginEvent", this.beginListener, false, null);
                    }
                    if (elt.hasAttributeNS(null, "onend")) {
                        target.addEventListenerNS("http://www.w3.org/2001/xml-events", "endEvent", this.endListener, false, null);
                    }
                    if (elt.hasAttributeNS(null, "onrepeat")) {
                        target.addEventListenerNS("http://www.w3.org/2001/xml-events", "repeatEvent", this.repeatListener, false, null);
                    }
                    return;
                }
            }
        }
        if (elt.hasAttributeNS(null, "onfocusin")) {
            target.addEventListenerNS("http://www.w3.org/2001/xml-events", "DOMFocusIn", this.focusinListener, false, null);
        }
        if (elt.hasAttributeNS(null, "onfocusout")) {
            target.addEventListenerNS("http://www.w3.org/2001/xml-events", "DOMFocusOut", this.focusoutListener, false, null);
        }
        if (elt.hasAttributeNS(null, "onactivate")) {
            target.addEventListenerNS("http://www.w3.org/2001/xml-events", "DOMActivate", this.activateListener, false, null);
        }
        if (elt.hasAttributeNS(null, "onclick")) {
            target.addEventListenerNS("http://www.w3.org/2001/xml-events", "click", this.clickListener, false, null);
        }
        if (elt.hasAttributeNS(null, "onmousedown")) {
            target.addEventListenerNS("http://www.w3.org/2001/xml-events", "mousedown", this.mousedownListener, false, null);
        }
        if (elt.hasAttributeNS(null, "onmouseup")) {
            target.addEventListenerNS("http://www.w3.org/2001/xml-events", "mouseup", this.mouseupListener, false, null);
        }
        if (elt.hasAttributeNS(null, "onmouseover")) {
            target.addEventListenerNS("http://www.w3.org/2001/xml-events", "mouseover", this.mouseoverListener, false, null);
        }
        if (elt.hasAttributeNS(null, "onmouseout")) {
            target.addEventListenerNS("http://www.w3.org/2001/xml-events", "mouseout", this.mouseoutListener, false, null);
        }
        if (elt.hasAttributeNS(null, "onmousemove")) {
            target.addEventListenerNS("http://www.w3.org/2001/xml-events", "mousemove", this.mousemoveListener, false, null);
        }
        if (elt.hasAttributeNS(null, "onkeypress")) {
            target.addEventListenerNS("http://www.w3.org/2001/xml-events", "keypress", this.keypressListener, false, null);
        }
        if (elt.hasAttributeNS(null, "onkeydown")) {
            target.addEventListenerNS("http://www.w3.org/2001/xml-events", "keydown", this.keydownListener, false, null);
        }
        if (elt.hasAttributeNS(null, "onkeyup")) {
            target.addEventListenerNS("http://www.w3.org/2001/xml-events", "keyup", this.keyupListener, false, null);
        }
    }

    protected void removeScriptingListeners(Node node) {
        if (node.getNodeType() == 1) {
            this.removeScriptingListenersOn((Element)node);
        }
        for (Node n = node.getFirstChild(); n != null; n = n.getNextSibling()) {
            this.removeScriptingListeners(n);
        }
    }

    protected void removeScriptingListenersOn(Element elt) {
        NodeEventTarget target = (NodeEventTarget)((Object)elt);
        if ("http://www.w3.org/2000/svg".equals(elt.getNamespaceURI())) {
            if ("svg".equals(elt.getLocalName())) {
                target.removeEventListenerNS("http://www.w3.org/2001/xml-events", "SVGAbort", this.svgAbortListener, false);
                target.removeEventListenerNS("http://www.w3.org/2001/xml-events", "SVGError", this.svgErrorListener, false);
                target.removeEventListenerNS("http://www.w3.org/2001/xml-events", "SVGResize", this.svgResizeListener, false);
                target.removeEventListenerNS("http://www.w3.org/2001/xml-events", "SVGScroll", this.svgScrollListener, false);
                target.removeEventListenerNS("http://www.w3.org/2001/xml-events", "SVGUnload", this.svgUnloadListener, false);
                target.removeEventListenerNS("http://www.w3.org/2001/xml-events", "SVGZoom", this.svgZoomListener, false);
            } else {
                String name = elt.getLocalName();
                if (name.equals("set") || name.startsWith("animate")) {
                    target.removeEventListenerNS("http://www.w3.org/2001/xml-events", "beginEvent", this.beginListener, false);
                    target.removeEventListenerNS("http://www.w3.org/2001/xml-events", "endEvent", this.endListener, false);
                    target.removeEventListenerNS("http://www.w3.org/2001/xml-events", "repeatEvent", this.repeatListener, false);
                    return;
                }
            }
        }
        target.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMFocusIn", this.focusinListener, false);
        target.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMFocusOut", this.focusoutListener, false);
        target.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMActivate", this.activateListener, false);
        target.removeEventListenerNS("http://www.w3.org/2001/xml-events", "click", this.clickListener, false);
        target.removeEventListenerNS("http://www.w3.org/2001/xml-events", "mousedown", this.mousedownListener, false);
        target.removeEventListenerNS("http://www.w3.org/2001/xml-events", "mouseup", this.mouseupListener, false);
        target.removeEventListenerNS("http://www.w3.org/2001/xml-events", "mouseover", this.mouseoverListener, false);
        target.removeEventListenerNS("http://www.w3.org/2001/xml-events", "mouseout", this.mouseoutListener, false);
        target.removeEventListenerNS("http://www.w3.org/2001/xml-events", "mousemove", this.mousemoveListener, false);
        target.removeEventListenerNS("http://www.w3.org/2001/xml-events", "keypress", this.keypressListener, false);
        target.removeEventListenerNS("http://www.w3.org/2001/xml-events", "keydown", this.keydownListener, false);
        target.removeEventListenerNS("http://www.w3.org/2001/xml-events", "keyup", this.keyupListener, false);
    }

    protected void updateScriptingListeners(Element elt, String attr) {
        String domEvt = (String)this.attrToDOMEvent.get(attr);
        if (domEvt == null) {
            return;
        }
        EventListener listener = (EventListener)this.attrToListener.get(attr);
        NodeEventTarget target = (NodeEventTarget)((Object)elt);
        if (elt.hasAttributeNS(null, attr)) {
            target.addEventListenerNS("http://www.w3.org/2001/xml-events", domEvt, listener, false, null);
        } else {
            target.removeEventListenerNS("http://www.w3.org/2001/xml-events", domEvt, listener, false);
        }
    }

    protected class ScriptingEventListener
    implements EventListener {
        protected String attribute;

        public ScriptingEventListener(String attr) {
            this.attribute = attr;
        }

        public void handleEvent(Event evt) {
            Element elt = (Element)((Object)evt.getCurrentTarget());
            String script = elt.getAttributeNS(null, this.attribute);
            if (script.length() == 0) {
                return;
            }
            DocumentLoader dl = ScriptingEnvironment.this.bridgeContext.getDocumentLoader();
            SVGDocument d = (SVGDocument)elt.getOwnerDocument();
            int line = dl.getLineNumber(elt);
            String desc = Messages.formatMessage("BaseScriptingEnvironment.constant.event.script.description", new Object[]{d.getURL(), this.attribute, new Integer(line)});
            Element e = elt;
            while (!(e == null || "http://www.w3.org/2000/svg".equals(e.getNamespaceURI()) && "svg".equals(e.getLocalName()))) {
                e = SVGUtilities.getParentElement(e);
            }
            if (e == null) {
                return;
            }
            String lang = e.getAttributeNS(null, "contentScriptType");
            ScriptingEnvironment.this.runEventHandler(script, evt, lang, desc);
        }
    }

    protected class DOMAttrModifiedListener
    implements EventListener {
        protected DOMAttrModifiedListener() {
        }

        public void handleEvent(Event evt) {
            MutationEvent me = (MutationEvent)evt;
            if (me.getAttrChange() != 1) {
                ScriptingEnvironment.this.updateScriptingListeners((Element)((Object)me.getTarget()), me.getAttrName());
            }
        }
    }

    protected class DOMNodeRemovedListener
    implements EventListener {
        protected DOMNodeRemovedListener() {
        }

        public void handleEvent(Event evt) {
            ScriptingEnvironment.this.removeScriptingListeners((Node)((Object)evt.getTarget()));
        }
    }

    protected class DOMNodeInsertedListener
    implements EventListener {
        protected DOMNodeInsertedListener() {
        }

        public void handleEvent(Event evt) {
            ScriptingEnvironment.this.addScriptingListeners((Node)((Object)evt.getTarget()));
        }
    }

    protected class Window
    implements org.apache.batik.script.Window {
        protected Interpreter interpreter;
        protected String language;
        static final String DEFLATE = "deflate";
        static final String GZIP = "gzip";
        static final String UTF_8 = "UTF-8";

        public Window(Interpreter interp, String lang) {
            this.interpreter = interp;
            this.language = lang;
        }

        public Object setInterval(String script, long interval) {
            TimerTask tt = new TimerTask(this, script){
                EvaluateIntervalRunnable eir;
                private final /* synthetic */ String val$script;
                private final /* synthetic */ Window this$1;
                {
                    this.this$1 = this$1;
                    this.val$script = val$script;
                    this.eir = Window.access$000(this.this$1).new EvaluateIntervalRunnable(this.val$script, this.this$1.interpreter);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Object object = this.eir;
                    synchronized (object) {
                        if (this.eir.count > 1) {
                            return;
                        }
                        ++this.eir.count;
                    }
                    object = Window.access$000((Window)this.this$1).updateRunnableQueue.getIteratorLock();
                    synchronized (object) {
                        if (Window.access$000((Window)this.this$1).updateRunnableQueue.getThread() == null) {
                            this.cancel();
                            return;
                        }
                        Window.access$000((Window)this.this$1).updateRunnableQueue.invokeLater(this.eir);
                    }
                    object = this.eir;
                    synchronized (object) {
                        if (this.eir.error) {
                            this.cancel();
                        }
                    }
                }
            };
            ScriptingEnvironment.this.timer.schedule(tt, interval, interval);
            return tt;
        }

        public Object setInterval(Runnable r, long interval) {
            TimerTask tt = new TimerTask(this, r){
                EvaluateRunnableRunnable eihr;
                private final /* synthetic */ Runnable val$r;
                private final /* synthetic */ Window this$1;
                {
                    this.this$1 = this$1;
                    this.val$r = val$r;
                    this.eihr = Window.access$000(this.this$1).new EvaluateRunnableRunnable(this.val$r);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    EvaluateRunnableRunnable evaluateRunnableRunnable = this.eihr;
                    synchronized (evaluateRunnableRunnable) {
                        if (this.eihr.count > 1) {
                            return;
                        }
                        ++this.eihr.count;
                    }
                    Window.access$000((Window)this.this$1).updateRunnableQueue.invokeLater(this.eihr);
                    evaluateRunnableRunnable = this.eihr;
                    synchronized (evaluateRunnableRunnable) {
                        if (this.eihr.error) {
                            this.cancel();
                        }
                    }
                }
            };
            ScriptingEnvironment.this.timer.schedule(tt, interval, interval);
            return tt;
        }

        public void clearInterval(Object interval) {
            if (interval == null) {
                return;
            }
            ((TimerTask)interval).cancel();
        }

        public Object setTimeout(String script, long timeout) {
            TimerTask tt = new TimerTask(this, script){
                private final /* synthetic */ String val$script;
                private final /* synthetic */ Window this$1;
                {
                    this.this$1 = this$1;
                    this.val$script = val$script;
                }

                public void run() {
                    Window.access$000((Window)this.this$1).updateRunnableQueue.invokeLater(Window.access$000(this.this$1).new EvaluateRunnable(this.val$script, this.this$1.interpreter));
                }
            };
            ScriptingEnvironment.this.timer.schedule(tt, timeout);
            return tt;
        }

        public Object setTimeout(Runnable r, long timeout) {
            TimerTask tt = new TimerTask(this, r){
                private final /* synthetic */ Runnable val$r;
                private final /* synthetic */ Window this$1;
                {
                    this.this$1 = this$1;
                    this.val$r = val$r;
                }

                public void run() {
                    Window.access$000((Window)this.this$1).updateRunnableQueue.invokeLater(new Runnable(this){
                        private final /* synthetic */ 4 this$2;
                        {
                            this.this$2 = this$2;
                        }

                        public void run() {
                            block2: {
                                try {
                                    4.access$100(this.this$2).run();
                                }
                                catch (Exception e) {
                                    if (Window.access$000((Window)4.access$200(this.this$2)).userAgent == null) break block2;
                                    Window.access$000((Window)4.access$200(this.this$2)).userAgent.displayError(e);
                                }
                            }
                        }
                    });
                }

                static /* synthetic */ Runnable access$100(4 x0) {
                    return x0.val$r;
                }

                static /* synthetic */ Window access$200(4 x0) {
                    return x0.this$1;
                }
            };
            ScriptingEnvironment.this.timer.schedule(tt, timeout);
            return tt;
        }

        public void clearTimeout(Object timeout) {
            if (timeout == null) {
                return;
            }
            ((TimerTask)timeout).cancel();
        }

        public Node parseXML(String text2, Document doc) {
            String uri;
            Node res;
            SAXSVGDocumentFactory df = new SAXSVGDocumentFactory(XMLResourceDescriptor.getXMLParserClassName());
            URL urlObj = null;
            if (doc instanceof SVGOMDocument) {
                urlObj = ((SVGOMDocument)doc).getURLObject();
            }
            if (urlObj == null) {
                urlObj = ((SVGOMDocument)ScriptingEnvironment.this.bridgeContext.getDocument()).getURLObject();
            }
            if ((res = DOMUtilities.parseXML(text2, doc, uri = urlObj == null ? "" : urlObj.toString(), null, null, df)) != null) {
                return res;
            }
            if (doc instanceof SVGOMDocument) {
                HashMap<String, String> prefixes = new HashMap<String, String>();
                prefixes.put("xmlns", "http://www.w3.org/2000/xmlns/");
                prefixes.put("xmlns:xlink", "http://www.w3.org/1999/xlink");
                res = DOMUtilities.parseXML(text2, doc, uri, prefixes, "svg", df);
                if (res != null) {
                    return res;
                }
            }
            SAXDocumentFactory sdf = doc != null ? new SAXDocumentFactory(doc.getImplementation(), XMLResourceDescriptor.getXMLParserClassName()) : new SAXDocumentFactory(new GenericDOMImplementation(), XMLResourceDescriptor.getXMLParserClassName());
            return DOMUtilities.parseXML(text2, doc, uri, null, null, sdf);
        }

        public void getURL(String uri, Window.URLResponseHandler h) {
            this.getURL(uri, h, null);
        }

        public void getURL(String uri, Window.URLResponseHandler h, String enc) {
            Thread t = new Thread(this, uri, enc, h){
                private final /* synthetic */ String val$uri;
                private final /* synthetic */ String val$enc;
                private final /* synthetic */ Window.URLResponseHandler val$h;
                private final /* synthetic */ Window this$1;
                {
                    this.this$1 = this$1;
                    this.val$uri = val$uri;
                    this.val$enc = val$enc;
                    this.val$h = val$h;
                }

                public void run() {
                    try {
                        int read;
                        Reader r;
                        ParsedURL burl = ((SVGOMDocument)Window.access$000((Window)this.this$1).document).getParsedURL();
                        ParsedURL purl = new ParsedURL(burl, this.val$uri);
                        String e = null;
                        if (this.val$enc != null) {
                            e = EncodingUtilities.javaEncoding(this.val$enc);
                            e = e == null ? this.val$enc : e;
                        }
                        InputStream is = purl.openStream();
                        if (e == null) {
                            r = new InputStreamReader(is);
                        } else {
                            try {
                                r = new InputStreamReader(is, e);
                            }
                            catch (UnsupportedEncodingException uee) {
                                r = new InputStreamReader(is);
                            }
                        }
                        r = new BufferedReader(r);
                        StringBuffer sb = new StringBuffer();
                        char[] buf = new char[4096];
                        while ((read = r.read(buf, 0, buf.length)) != -1) {
                            sb.append(buf, 0, read);
                        }
                        r.close();
                        Window.access$000((Window)this.this$1).updateRunnableQueue.invokeLater(new Runnable(this, purl, sb){
                            private final /* synthetic */ ParsedURL val$purl;
                            private final /* synthetic */ StringBuffer val$sb;
                            private final /* synthetic */ 6 this$2;
                            {
                                this.this$2 = this$2;
                                this.val$purl = val$purl;
                                this.val$sb = val$sb;
                            }

                            public void run() {
                                block2: {
                                    try {
                                        6.access$300(this.this$2).getURLDone(true, this.val$purl.getContentType(), this.val$sb.toString());
                                    }
                                    catch (Exception e) {
                                        if (Window.access$000((Window)6.access$400(this.this$2)).userAgent == null) break block2;
                                        Window.access$000((Window)6.access$400(this.this$2)).userAgent.displayError(e);
                                    }
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        if (e instanceof SecurityException) {
                            Window.access$000((Window)this.this$1).userAgent.displayError(e);
                        }
                        Window.access$000((Window)this.this$1).updateRunnableQueue.invokeLater(new Runnable(this){
                            private final /* synthetic */ 6 this$2;
                            {
                                this.this$2 = this$2;
                            }

                            public void run() {
                                block2: {
                                    try {
                                        6.access$300(this.this$2).getURLDone(false, null, null);
                                    }
                                    catch (Exception e) {
                                        if (Window.access$000((Window)6.access$400(this.this$2)).userAgent == null) break block2;
                                        Window.access$000((Window)6.access$400(this.this$2)).userAgent.displayError(e);
                                    }
                                }
                            }
                        });
                    }
                }

                static /* synthetic */ Window.URLResponseHandler access$300(6 x0) {
                    return x0.val$h;
                }

                static /* synthetic */ Window access$400(6 x0) {
                    return x0.this$1;
                }
            };
            t.setPriority(1);
            t.start();
        }

        public void postURL(String uri, String content, Window.URLResponseHandler h) {
            this.postURL(uri, content, h, "text/plain", null);
        }

        public void postURL(String uri, String content, Window.URLResponseHandler h, String mimeType) {
            this.postURL(uri, content, h, mimeType, null);
        }

        public void postURL(String uri, String content, Window.URLResponseHandler h, String mimeType, String fEnc) {
            Thread t = new Thread(this, uri, mimeType, fEnc, content, h){
                private final /* synthetic */ String val$uri;
                private final /* synthetic */ String val$mimeType;
                private final /* synthetic */ String val$fEnc;
                private final /* synthetic */ String val$content;
                private final /* synthetic */ Window.URLResponseHandler val$h;
                private final /* synthetic */ Window this$1;
                {
                    this.this$1 = this$1;
                    this.val$uri = val$uri;
                    this.val$mimeType = val$mimeType;
                    this.val$fEnc = val$fEnc;
                    this.val$content = val$content;
                    this.val$h = val$h;
                }

                public void run() {
                    try {
                        int read;
                        String base = ((SVGOMDocument)Window.access$000((Window)this.this$1).document).getDocumentURI();
                        URL url = base == null ? new URL(this.val$uri) : new URL(new URL(base), this.val$uri);
                        URLConnection conn = url.openConnection();
                        conn.setDoOutput(true);
                        conn.setDoInput(true);
                        conn.setUseCaches(false);
                        conn.setRequestProperty("Content-Type", this.val$mimeType);
                        OutputStream os = conn.getOutputStream();
                        String e = null;
                        String enc = this.val$fEnc;
                        if (enc != null) {
                            if (enc.startsWith("deflate")) {
                                os = new DeflaterOutputStream(os);
                                enc = enc.length() > "deflate".length() ? enc.substring("deflate".length() + 1) : "";
                                conn.setRequestProperty("Content-Encoding", "deflate");
                            }
                            if (enc.startsWith("gzip")) {
                                os = new GZIPOutputStream(os);
                                enc = enc.length() > "gzip".length() ? enc.substring("gzip".length() + 1) : "";
                                conn.setRequestProperty("Content-Encoding", "deflate");
                            }
                            if (enc.length() != 0) {
                                e = EncodingUtilities.javaEncoding(enc);
                                if (e == null) {
                                    e = "UTF-8";
                                }
                            } else {
                                e = "UTF-8";
                            }
                        }
                        OutputStreamWriter w = e == null ? new OutputStreamWriter(os) : new OutputStreamWriter(os, e);
                        w.write(this.val$content);
                        ((Writer)w).flush();
                        ((Writer)w).close();
                        os.close();
                        InputStream is = conn.getInputStream();
                        e = "UTF-8";
                        Reader r = e == null ? new InputStreamReader(is) : new InputStreamReader(is, e);
                        r = new BufferedReader(r);
                        StringBuffer sb = new StringBuffer();
                        char[] buf = new char[4096];
                        while ((read = r.read(buf, 0, buf.length)) != -1) {
                            sb.append(buf, 0, read);
                        }
                        r.close();
                        Window.access$000((Window)this.this$1).updateRunnableQueue.invokeLater(new Runnable(this, conn, sb){
                            private final /* synthetic */ URLConnection val$conn;
                            private final /* synthetic */ StringBuffer val$sb;
                            private final /* synthetic */ 9 this$2;
                            {
                                this.this$2 = this$2;
                                this.val$conn = val$conn;
                                this.val$sb = val$sb;
                            }

                            public void run() {
                                block2: {
                                    try {
                                        9.access$500(this.this$2).getURLDone(true, this.val$conn.getContentType(), this.val$sb.toString());
                                    }
                                    catch (Exception e) {
                                        if (Window.access$000((Window)9.access$600(this.this$2)).userAgent == null) break block2;
                                        Window.access$000((Window)9.access$600(this.this$2)).userAgent.displayError(e);
                                    }
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        if (e instanceof SecurityException) {
                            Window.access$000((Window)this.this$1).userAgent.displayError(e);
                        }
                        Window.access$000((Window)this.this$1).updateRunnableQueue.invokeLater(new Runnable(this){
                            private final /* synthetic */ 9 this$2;
                            {
                                this.this$2 = this$2;
                            }

                            public void run() {
                                block2: {
                                    try {
                                        9.access$500(this.this$2).getURLDone(false, null, null);
                                    }
                                    catch (Exception e) {
                                        if (Window.access$000((Window)9.access$600(this.this$2)).userAgent == null) break block2;
                                        Window.access$000((Window)9.access$600(this.this$2)).userAgent.displayError(e);
                                    }
                                }
                            }
                        });
                    }
                }

                static /* synthetic */ Window.URLResponseHandler access$500(9 x0) {
                    return x0.val$h;
                }

                static /* synthetic */ Window access$600(9 x0) {
                    return x0.this$1;
                }
            };
            t.setPriority(1);
            t.start();
        }

        public void alert(String message) {
            if (ScriptingEnvironment.this.userAgent != null) {
                ScriptingEnvironment.this.userAgent.showAlert(message);
            }
        }

        public boolean confirm(String message) {
            if (ScriptingEnvironment.this.userAgent != null) {
                return ScriptingEnvironment.this.userAgent.showConfirm(message);
            }
            return false;
        }

        public String prompt(String message) {
            if (ScriptingEnvironment.this.userAgent != null) {
                return ScriptingEnvironment.this.userAgent.showPrompt(message);
            }
            return null;
        }

        public String prompt(String message, String defVal) {
            if (ScriptingEnvironment.this.userAgent != null) {
                return ScriptingEnvironment.this.userAgent.showPrompt(message, defVal);
            }
            return null;
        }

        public BridgeContext getBridgeContext() {
            return ScriptingEnvironment.this.bridgeContext;
        }

        public Interpreter getInterpreter() {
            return this.interpreter;
        }

        static /* synthetic */ ScriptingEnvironment access$000(Window x0) {
            return x0.ScriptingEnvironment.this;
        }
    }

    protected class EvaluateRunnableRunnable
    implements Runnable {
        public int count;
        public boolean error;
        protected Runnable runnable;

        public EvaluateRunnableRunnable(Runnable r) {
            this.runnable = r;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            EvaluateRunnableRunnable evaluateRunnableRunnable = this;
            synchronized (evaluateRunnableRunnable) {
                if (this.error) {
                    return;
                }
                --this.count;
            }
            try {
                this.runnable.run();
            }
            catch (Exception e) {
                if (ScriptingEnvironment.this.userAgent != null) {
                    ScriptingEnvironment.this.userAgent.displayError(e);
                } else {
                    e.printStackTrace();
                }
                EvaluateRunnableRunnable evaluateRunnableRunnable2 = this;
                synchronized (evaluateRunnableRunnable2) {
                    this.error = true;
                }
            }
        }
    }

    protected class EvaluateIntervalRunnable
    implements Runnable {
        public int count;
        public boolean error;
        protected Interpreter interpreter;
        protected String script;

        public EvaluateIntervalRunnable(String s2, Interpreter interp) {
            this.interpreter = interp;
            this.script = s2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            EvaluateIntervalRunnable evaluateIntervalRunnable = this;
            synchronized (evaluateIntervalRunnable) {
                if (this.error) {
                    return;
                }
                --this.count;
            }
            try {
                this.interpreter.evaluate(this.script);
            }
            catch (InterpreterException ie) {
                ScriptingEnvironment.this.handleInterpreterException(ie);
                EvaluateIntervalRunnable evaluateIntervalRunnable2 = this;
                synchronized (evaluateIntervalRunnable2) {
                    this.error = true;
                }
            }
            catch (Exception e) {
                if (ScriptingEnvironment.this.userAgent != null) {
                    ScriptingEnvironment.this.userAgent.displayError(e);
                } else {
                    e.printStackTrace();
                }
                EvaluateIntervalRunnable evaluateIntervalRunnable3 = this;
                synchronized (evaluateIntervalRunnable3) {
                    this.error = true;
                }
            }
        }
    }

    protected class EvaluateRunnable
    implements Runnable {
        protected Interpreter interpreter;
        protected String script;

        public EvaluateRunnable(String s2, Interpreter interp) {
            this.interpreter = interp;
            this.script = s2;
        }

        public void run() {
            try {
                this.interpreter.evaluate(this.script);
            }
            catch (InterpreterException ie) {
                ScriptingEnvironment.this.handleInterpreterException(ie);
            }
        }
    }
}

