/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.extension.svg;

import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.text.AttributedCharacterIterator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.batik.extension.svg.GlyphIterator;
import org.apache.batik.extension.svg.LineInfo;
import org.apache.batik.extension.svg.MarginInfo;
import org.apache.batik.extension.svg.RegionInfo;
import org.apache.batik.gvt.font.GVTGlyphVector;
import org.apache.batik.gvt.font.MultiGlyphVector;
import org.apache.batik.gvt.text.GlyphLayout;

public class FlowExtGlyphLayout
extends GlyphLayout {
    public FlowExtGlyphLayout(AttributedCharacterIterator aci, int[] charMap, Point2D offset, FontRenderContext frc) {
        super(aci, charMap, offset, frc);
    }

    public static void textWrapTextChunk(AttributedCharacterIterator[] acis, List chunkLayouts, List flowRects) {
        GVTGlyphVector[] gvs = new GVTGlyphVector[acis.length];
        List[] chunkLineInfos = new List[acis.length];
        GlyphIterator[] gis = new GlyphIterator[acis.length];
        Iterator clIter = chunkLayouts.iterator();
        Iterator flowRectsIter = flowRects.iterator();
        RegionInfo currentRegion = null;
        float height = 0.0f;
        if (flowRectsIter.hasNext()) {
            currentRegion = (RegionInfo)flowRectsIter.next();
            height = (float)currentRegion.getHeight();
        }
        boolean lineHeightRelative = true;
        float lineHeight = 1.0f;
        float nextLineMult = 0.0f;
        float dy = 0.0f;
        Point2D.Float verticalAlignOffset = new Point2D.Float(0.0f, 0.0f);
        float prevBotMargin = 0.0f;
        int chunk = 0;
        while (clIter.hasNext()) {
            List extraP;
            AttributedCharacterIterator aci = acis[chunk];
            if (currentRegion != null && (extraP = (List)aci.getAttribute(FLOW_EMPTY_PARAGRAPH)) != null) {
                Iterator epi = extraP.iterator();
                while (epi.hasNext()) {
                    float inc;
                    MarginInfo emi = (MarginInfo)epi.next();
                    float f = inc = prevBotMargin > emi.getTopMargin() ? prevBotMargin : emi.getTopMargin();
                    if (dy + inc <= height && !emi.isFlowRegionBreak()) {
                        dy += inc;
                        prevBotMargin = emi.getBottomMargin();
                        continue;
                    }
                    if (!flowRectsIter.hasNext()) {
                        currentRegion = null;
                        break;
                    }
                    currentRegion = (RegionInfo)flowRectsIter.next();
                    height = (float)currentRegion.getHeight();
                    verticalAlignOffset = new Point2D.Float(0.0f, 0.0f);
                    dy = 0.0f;
                    prevBotMargin = 0.0f;
                }
                if (currentRegion == null) break;
            }
            LinkedList<GVTGlyphVector> gvl = new LinkedList<GVTGlyphVector>();
            List layouts = (List)clIter.next();
            Iterator iter2 = layouts.iterator();
            while (iter2.hasNext()) {
                GlyphLayout gl = (GlyphLayout)iter2.next();
                gvl.add(gl.getGlyphVector());
            }
            MultiGlyphVector gv = new MultiGlyphVector(gvl);
            gvs[chunk] = gv;
            int numGlyphs = gv.getNumGlyphs();
            aci.first();
            MarginInfo mi = (MarginInfo)aci.getAttribute(FLOW_PARAGRAPH);
            if (mi != null) {
                if (currentRegion == null) {
                    for (int idx = 0; idx < numGlyphs; ++idx) {
                        gv.setGlyphVisible(idx, false);
                    }
                } else {
                    GlyphIterator gi;
                    LinkedList<LineInfo> lineInfos;
                    float inc;
                    float f = inc = prevBotMargin > mi.getTopMargin() ? prevBotMargin : mi.getTopMargin();
                    if (dy + inc <= height) {
                        dy += inc;
                    } else {
                        if (!flowRectsIter.hasNext()) {
                            currentRegion = null;
                            break;
                        }
                        currentRegion = (RegionInfo)flowRectsIter.next();
                        height = (float)currentRegion.getHeight();
                        verticalAlignOffset = new Point2D.Float(0.0f, 0.0f);
                        dy = mi.getTopMargin();
                    }
                    prevBotMargin = mi.getBottomMargin();
                    float leftMargin = mi.getLeftMargin();
                    float rightMargin = mi.getRightMargin();
                    if (((GlyphLayout)layouts.get(0)).isLeftToRight()) {
                        leftMargin += mi.getIndent();
                    } else {
                        rightMargin += mi.getIndent();
                    }
                    float x0 = (float)currentRegion.getX() + leftMargin;
                    float y0 = (float)currentRegion.getY();
                    float width = (float)(currentRegion.getWidth() - (double)(leftMargin + rightMargin));
                    height = (float)currentRegion.getHeight();
                    chunkLineInfos[chunk] = lineInfos = new LinkedList<LineInfo>();
                    float prevDesc = 0.0f;
                    gis[chunk] = gi = new GlyphIterator(aci, gv);
                    GlyphIterator breakGI = null;
                    GlyphIterator newBreakGI = null;
                    if (!gi.done() && !gi.isPrinting()) {
                        FlowExtGlyphLayout.updateVerticalAlignOffset(verticalAlignOffset, currentRegion, dy);
                        lineInfos.add(gi.newLine(new Point2D.Float(x0, y0 + dy), width, true, verticalAlignOffset));
                    }
                    GlyphIterator lineGI = gi.copy();
                    boolean firstLine = true;
                    while (!gi.done()) {
                        boolean doBreak = false;
                        boolean partial = false;
                        if (gi.isPrinting() && gi.getAdv() > width) {
                            if (breakGI == null) {
                                if (!flowRectsIter.hasNext()) {
                                    currentRegion = null;
                                    gi = lineGI.copy(gi);
                                    break;
                                }
                                currentRegion = (RegionInfo)flowRectsIter.next();
                                x0 = (float)currentRegion.getX() + leftMargin;
                                y0 = (float)currentRegion.getY();
                                width = (float)(currentRegion.getWidth() - (double)(leftMargin + rightMargin));
                                height = (float)currentRegion.getHeight();
                                verticalAlignOffset = new Point2D.Float(0.0f, 0.0f);
                                dy = firstLine ? mi.getTopMargin() : 0.0f;
                                prevDesc = 0.0f;
                                gi = lineGI.copy(gi);
                                continue;
                            }
                            gi = breakGI.copy(gi);
                            nextLineMult = 1.0f;
                            doBreak = true;
                            partial = false;
                        } else if (gi.isLastChar()) {
                            nextLineMult = 1.0f;
                            doBreak = true;
                            partial = true;
                        }
                        int lnBreaks = gi.getLineBreaks();
                        if (lnBreaks != 0) {
                            if (doBreak) {
                                nextLineMult -= 1.0f;
                            }
                            nextLineMult += (float)lnBreaks;
                            doBreak = true;
                            partial = true;
                        }
                        if (!doBreak) {
                            if (gi.isBreakChar() || breakGI == null || !breakGI.isBreakChar()) {
                                newBreakGI = gi.copy(newBreakGI);
                                gi.nextChar();
                                if (gi.getChar() == '\u200d') continue;
                                GlyphIterator tmpGI = breakGI;
                                breakGI = newBreakGI;
                                newBreakGI = tmpGI;
                                continue;
                            }
                            gi.nextChar();
                            continue;
                        }
                        float lineSize = gi.getMaxAscent() + gi.getMaxDescent();
                        float lineBoxHeight = lineHeightRelative ? gi.getMaxFontSize() * lineHeight : lineHeight;
                        float halfLeading = (lineBoxHeight - lineSize) / 2.0f;
                        float ladv = prevDesc + halfLeading + gi.getMaxAscent();
                        float newDesc = halfLeading + gi.getMaxDescent();
                        dy += ladv;
                        float bottomEdge = newDesc;
                        if (newDesc < gi.getMaxDescent()) {
                            bottomEdge = gi.getMaxDescent();
                        }
                        if (dy + bottomEdge > height) {
                            if (!flowRectsIter.hasNext()) {
                                currentRegion = null;
                                gi = lineGI.copy(gi);
                                break;
                            }
                            float oldWidth = width;
                            currentRegion = (RegionInfo)flowRectsIter.next();
                            x0 = (float)currentRegion.getX() + leftMargin;
                            y0 = (float)currentRegion.getY();
                            width = (float)(currentRegion.getWidth() - (double)(leftMargin + rightMargin));
                            height = (float)currentRegion.getHeight();
                            verticalAlignOffset = new Point2D.Float(0.0f, 0.0f);
                            dy = firstLine ? mi.getTopMargin() : 0.0f;
                            prevDesc = 0.0f;
                            if (!(oldWidth > width) && lnBreaks == 0) continue;
                            gi = lineGI.copy(gi);
                            continue;
                        }
                        prevDesc = newDesc + (nextLineMult - 1.0f) * lineBoxHeight;
                        nextLineMult = 0.0f;
                        FlowExtGlyphLayout.updateVerticalAlignOffset(verticalAlignOffset, currentRegion, dy + bottomEdge);
                        lineInfos.add(gi.newLine(new Point2D.Float(x0, y0 + dy), width, partial, verticalAlignOffset));
                        x0 -= leftMargin;
                        width += leftMargin + rightMargin;
                        leftMargin = mi.getLeftMargin();
                        rightMargin = mi.getRightMargin();
                        x0 += leftMargin;
                        width -= leftMargin + rightMargin;
                        firstLine = false;
                        lineGI = gi.copy(lineGI);
                        breakGI = null;
                    }
                    dy += prevDesc;
                    int idx = gi.getGlyphIndex();
                    while (idx < numGlyphs) {
                        gv.setGlyphVisible(idx++, false);
                    }
                    if (mi.isFlowRegionBreak()) {
                        currentRegion = null;
                        if (flowRectsIter.hasNext()) {
                            currentRegion = (RegionInfo)flowRectsIter.next();
                            height = (float)currentRegion.getHeight();
                            dy = 0.0f;
                            prevBotMargin = 0.0f;
                            verticalAlignOffset = new Point2D.Float(0.0f, 0.0f);
                        }
                    }
                }
            }
            ++chunk;
        }
        for (chunk = 0; chunk < acis.length; ++chunk) {
            List lineInfos = chunkLineInfos[chunk];
            if (lineInfos == null) continue;
            AttributedCharacterIterator aci = acis[chunk];
            aci.first();
            MarginInfo mi = (MarginInfo)aci.getAttribute(FLOW_PARAGRAPH);
            if (mi == null) continue;
            int justification = mi.getJustification();
            GVTGlyphVector gv = gvs[chunk];
            if (gv == null) break;
            GlyphIterator gi = gis[chunk];
            FlowExtGlyphLayout.layoutChunk(gv, gi.getOrigin(), justification, lineInfos);
        }
    }

    public static void updateVerticalAlignOffset(Point2D.Float verticalAlignOffset, RegionInfo region, float maxDescent) {
        float freeSpace = (float)region.getHeight() - maxDescent;
        verticalAlignOffset.setLocation(0.0f, region.getVerticalAlignment() * freeSpace);
    }

    public static void layoutChunk(GVTGlyphVector gv, Point2D origin, int justification, List lineInfos) {
        int i;
        Iterator lInfoIter = lineInfos.iterator();
        int numGlyphs = gv.getNumGlyphs();
        float[] gp = gv.getGlyphPositions(0, numGlyphs + 1, null);
        Point2D.Float lineLoc = null;
        float lineAdv = 0.0f;
        float lineVAdv = 0.0f;
        float xOrig = (float)origin.getX();
        float yOrig = (float)origin.getY();
        float xScale = 1.0f;
        float xAdj = 0.0f;
        float charW = 0.0f;
        float lineWidth = 0.0f;
        boolean partial = false;
        float verticalAlignOffset = 0.0f;
        int lineEnd = 0;
        Point2D.Float pos = new Point2D.Float();
        for (i = 0; i < numGlyphs; ++i) {
            if (i == lineEnd) {
                xOrig += lineAdv;
                if (!lInfoIter.hasNext()) break;
                LineInfo li = (LineInfo)lInfoIter.next();
                lineEnd = li.getEndIdx();
                lineLoc = li.getLocation();
                lineAdv = li.getAdvance();
                lineVAdv = li.getVisualAdvance();
                charW = li.getLastCharWidth();
                lineWidth = li.getLineWidth();
                partial = li.isPartialLine();
                verticalAlignOffset = li.getVerticalAlignOffset().y;
                xAdj = 0.0f;
                xScale = 1.0f;
                switch (justification) {
                    default: {
                        break;
                    }
                    case 1: {
                        xAdj = (lineWidth - lineVAdv) / 2.0f;
                        break;
                    }
                    case 2: {
                        xAdj = lineWidth - lineVAdv;
                        break;
                    }
                    case 3: {
                        if (partial || lineEnd == i + 1) break;
                        xScale = (lineWidth - charW) / (lineVAdv - charW);
                    }
                }
            }
            pos.x = lineLoc.x + (gp[2 * i] - xOrig) * xScale + xAdj;
            pos.y = lineLoc.y + (gp[2 * i + 1] - yOrig + verticalAlignOffset);
            gv.setGlyphPosition(i, pos);
        }
        pos.x = xOrig;
        pos.y = yOrig;
        if (lineLoc != null) {
            pos.x = lineLoc.x + (gp[2 * i] - xOrig) * xScale + xAdj;
            pos.y = lineLoc.y + (gp[2 * i + 1] - yOrig) + verticalAlignOffset;
        }
        gv.setGlyphPosition(i, pos);
    }
}

