/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.complexscripts.scripts;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.complexscripts.bidi.BidiClass;
import org.apache.fop.complexscripts.fonts.GlyphDefinitionTable;
import org.apache.fop.complexscripts.scripts.DefaultScriptProcessor;
import org.apache.fop.complexscripts.util.GlyphContextTester;
import org.apache.fop.complexscripts.util.GlyphSequence;
import org.apache.fop.complexscripts.util.ScriptContextTester;

public class ArabicScriptProcessor
extends DefaultScriptProcessor {
    private static final Log log = LogFactory.getLog(ArabicScriptProcessor.class);
    private static final String[] gsubFeatures = new String[]{"calt", "ccmp", "fina", "init", "isol", "liga", "medi", "rlig"};
    private static final String[] gposFeatures = new String[]{"curs", "kern", "mark", "mkmk"};
    private final ScriptContextTester subContextTester = new SubstitutionScriptContextTester();
    private final ScriptContextTester posContextTester = new PositioningScriptContextTester();
    private static int[] isolatedInitials = new int[]{1569, 1570, 1571, 1572, 1573, 1575, 1583, 1584, 1585, 1586, 1608, 1649, 1650, 1651, 1653, 1654, 1655, 1672, 1673, 1674, 1675, 1676, 1677, 1678, 1679, 1680, 1681, 1682, 1683, 1684, 1685, 1686, 1687, 1688, 1689, 1732, 1733, 1734, 1735, 1736, 1737, 1738, 1739, 1743, 1774, 1775};
    private static int[] isolatedFinals = new int[]{1569};

    ArabicScriptProcessor(String script) {
        super(script);
    }

    public String[] getSubstitutionFeatures() {
        return gsubFeatures;
    }

    public ScriptContextTester getSubstitutionContextTester() {
        return this.subContextTester;
    }

    public String[] getPositioningFeatures() {
        return gposFeatures;
    }

    public ScriptContextTester getPositioningContextTester() {
        return this.posContextTester;
    }

    public GlyphSequence reorderCombiningMarks(GlyphDefinitionTable gdef, GlyphSequence gs, int[][] gpa, String script, String language2) {
        return gs;
    }

    private static boolean inFinalContext(String script, String language2, String feature, GlyphSequence gs, int index2, int flags) {
        int e;
        GlyphSequence.CharAssociation a = gs.getAssociation(index2);
        int[] ca = gs.getCharacterArray(false);
        int nc = gs.getCharacterCount();
        if (nc == 0) {
            return false;
        }
        int s2 = a.getStart();
        if (!ArabicScriptProcessor.hasFinalPrecedingContext(ca, nc, s2, e = a.getEnd())) {
            return false;
        }
        if (ArabicScriptProcessor.forcesFinalThisContext(ca, nc, s2, e)) {
            return true;
        }
        return ArabicScriptProcessor.hasFinalFollowingContext(ca, nc, s2, e);
    }

    private static boolean inInitialContext(String script, String language2, String feature, GlyphSequence gs, int index2, int flags) {
        int e;
        GlyphSequence.CharAssociation a = gs.getAssociation(index2);
        int[] ca = gs.getCharacterArray(false);
        int nc = gs.getCharacterCount();
        if (nc == 0) {
            return false;
        }
        int s2 = a.getStart();
        if (!ArabicScriptProcessor.hasInitialPrecedingContext(ca, nc, s2, e = a.getEnd())) {
            return false;
        }
        return ArabicScriptProcessor.hasInitialFollowingContext(ca, nc, s2, e);
    }

    private static boolean inIsolateContext(String script, String language2, String feature, GlyphSequence gs, int index2, int flags) {
        GlyphSequence.CharAssociation a = gs.getAssociation(index2);
        int nc = gs.getCharacterCount();
        if (nc == 0) {
            return false;
        }
        return a.getStart() == 0 && a.getEnd() == nc;
    }

    private static boolean inLigatureContext(String script, String language2, String feature, GlyphSequence gs, int index2, int flags) {
        int e;
        GlyphSequence.CharAssociation a = gs.getAssociation(index2);
        int[] ca = gs.getCharacterArray(false);
        int nc = gs.getCharacterCount();
        if (nc == 0) {
            return false;
        }
        int s2 = a.getStart();
        if (!ArabicScriptProcessor.hasLigaturePrecedingContext(ca, nc, s2, e = a.getEnd())) {
            return false;
        }
        return ArabicScriptProcessor.hasLigatureFollowingContext(ca, nc, s2, e);
    }

    private static boolean inMedialContext(String script, String language2, String feature, GlyphSequence gs, int index2, int flags) {
        int e;
        GlyphSequence.CharAssociation a = gs.getAssociation(index2);
        int[] ca = gs.getCharacterArray(false);
        int nc = gs.getCharacterCount();
        if (nc == 0) {
            return false;
        }
        int s2 = a.getStart();
        if (!ArabicScriptProcessor.hasMedialPrecedingContext(ca, nc, s2, e = a.getEnd())) {
            return false;
        }
        if (!ArabicScriptProcessor.hasMedialThisContext(ca, nc, s2, e)) {
            return false;
        }
        return ArabicScriptProcessor.hasMedialFollowingContext(ca, nc, s2, e);
    }

    private static boolean hasFinalPrecedingContext(int[] ca, int nc, int s2, int e) {
        int k;
        int chp = 0;
        int clp = 0;
        for (int i = s2; i > 0 && ((k = i - 1) < 0 || k >= nc || (clp = BidiClass.getBidiClass(chp = ca[k])) == 14); --i) {
        }
        if (clp != 5) {
            return false;
        }
        return !ArabicScriptProcessor.hasIsolateInitial(chp);
    }

    private static boolean forcesFinalThisContext(int[] ca, int nc, int s2, int e) {
        int k;
        int j;
        int chl = 0;
        int cll = 0;
        int n = e - s2;
        for (int i = 0; i < n && ((j = s2 + (k = n - i - 1)) < 0 || j >= nc || (cll = BidiClass.getBidiClass(chl = ca[j])) == 14); ++i) {
        }
        if (cll != 5) {
            return false;
        }
        return ArabicScriptProcessor.hasIsolateInitial(chl);
    }

    private static boolean hasFinalFollowingContext(int[] ca, int nc, int s2, int e) {
        int chf = 0;
        int clf = 0;
        int n = nc;
        for (int i = e; i < n && (clf = BidiClass.getBidiClass(chf = ca[i])) == 14; ++i) {
        }
        if (clf != 5) {
            return true;
        }
        return ArabicScriptProcessor.hasIsolateFinal(chf);
    }

    private static boolean hasInitialPrecedingContext(int[] ca, int nc, int s2, int e) {
        int k;
        int chp = 0;
        int clp = 0;
        for (int i = s2; i > 0 && ((k = i - 1) < 0 || k >= nc || (clp = BidiClass.getBidiClass(chp = ca[k])) == 14); --i) {
        }
        if (clp != 5) {
            return true;
        }
        return ArabicScriptProcessor.hasIsolateInitial(chp);
    }

    private static boolean hasInitialFollowingContext(int[] ca, int nc, int s2, int e) {
        int chf = 0;
        int clf = 0;
        int n = nc;
        for (int i = e; i < n && (clf = BidiClass.getBidiClass(chf = ca[i])) == 14; ++i) {
        }
        if (clf != 5) {
            return false;
        }
        return !ArabicScriptProcessor.hasIsolateFinal(chf);
    }

    private static boolean hasMedialPrecedingContext(int[] ca, int nc, int s2, int e) {
        int k;
        int chp = 0;
        int clp = 0;
        for (int i = s2; i > 0 && ((k = i - 1) < 0 || k >= nc || (clp = BidiClass.getBidiClass(chp = ca[k])) == 14); --i) {
        }
        if (clp != 5) {
            return false;
        }
        return !ArabicScriptProcessor.hasIsolateInitial(chp);
    }

    private static boolean hasMedialThisContext(int[] ca, int nc, int s2, int e) {
        int k;
        int j;
        int k2;
        int chf = 0;
        int clf = 0;
        int n = e - s2;
        for (int i = 0; i < n && ((k2 = s2 + i) < 0 || k2 >= nc || (clf = BidiClass.getBidiClass(chf = ca[s2 + i])) == 14); ++i) {
        }
        if (clf != 5) {
            return false;
        }
        int chl = 0;
        int cll = 0;
        int n2 = e - s2;
        for (int i = 0; i < n2 && ((j = s2 + (k = n2 - i - 1)) < 0 || j >= nc || (cll = BidiClass.getBidiClass(chl = ca[j])) == 14); ++i) {
        }
        if (cll != 5) {
            return false;
        }
        if (ArabicScriptProcessor.hasIsolateFinal(chf)) {
            return false;
        }
        return !ArabicScriptProcessor.hasIsolateInitial(chl);
    }

    private static boolean hasMedialFollowingContext(int[] ca, int nc, int s2, int e) {
        int chf = 0;
        int clf = 0;
        int n = nc;
        for (int i = e; i < n && (clf = BidiClass.getBidiClass(chf = ca[i])) == 14; ++i) {
        }
        if (clf != 5) {
            return false;
        }
        return !ArabicScriptProcessor.hasIsolateFinal(chf);
    }

    private static boolean hasLigaturePrecedingContext(int[] ca, int nc, int s2, int e) {
        return true;
    }

    private static boolean hasLigatureFollowingContext(int[] ca, int nc, int s2, int e) {
        int chf = 0;
        int clf = 0;
        int n = nc;
        for (int i = e; i < n && (clf = BidiClass.getBidiClass(chf = ca[i])) == 14; ++i) {
        }
        return clf == 5;
    }

    private static boolean hasIsolateInitial(int ch) {
        return Arrays.binarySearch(isolatedInitials, ch) >= 0;
    }

    private static boolean hasIsolateFinal(int ch) {
        return Arrays.binarySearch(isolatedFinals, ch) >= 0;
    }

    private static class PositioningScriptContextTester
    implements ScriptContextTester {
        private static Map testerMap = new HashMap();

        private PositioningScriptContextTester() {
        }

        public GlyphContextTester getTester(String feature) {
            return (GlyphContextTester)testerMap.get(feature);
        }
    }

    private static class SubstitutionScriptContextTester
    implements ScriptContextTester {
        private static Map testerMap = new HashMap();

        private SubstitutionScriptContextTester() {
        }

        public GlyphContextTester getTester(String feature) {
            return (GlyphContextTester)testerMap.get(feature);
        }

        static {
            testerMap.put("fina", new GlyphContextTester(){

                public boolean test(String script, String language2, String feature, GlyphSequence gs, int index2, int flags) {
                    return ArabicScriptProcessor.inFinalContext(script, language2, feature, gs, index2, flags);
                }
            });
            testerMap.put("init", new GlyphContextTester(){

                public boolean test(String script, String language2, String feature, GlyphSequence gs, int index2, int flags) {
                    return ArabicScriptProcessor.inInitialContext(script, language2, feature, gs, index2, flags);
                }
            });
            testerMap.put("isol", new GlyphContextTester(){

                public boolean test(String script, String language2, String feature, GlyphSequence gs, int index2, int flags) {
                    return ArabicScriptProcessor.inIsolateContext(script, language2, feature, gs, index2, flags);
                }
            });
            testerMap.put("liga", new GlyphContextTester(){

                public boolean test(String script, String language2, String feature, GlyphSequence gs, int index2, int flags) {
                    return ArabicScriptProcessor.inLigatureContext(script, language2, feature, gs, index2, flags);
                }
            });
            testerMap.put("medi", new GlyphContextTester(){

                public boolean test(String script, String language2, String feature, GlyphSequence gs, int index2, int flags) {
                    return ArabicScriptProcessor.inMedialContext(script, language2, feature, gs, index2, flags);
                }
            });
        }
    }
}

