/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.complexscripts.util;

import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GlyphSequence
implements Cloneable {
    private static final int DEFAULT_CHARS_CAPACITY = 8;
    private IntBuffer characters;
    private IntBuffer glyphs;
    private List associations;
    private boolean predications;

    public GlyphSequence(IntBuffer characters2, IntBuffer glyphs, List associations, boolean predications) {
        if (characters2 == null) {
            characters2 = IntBuffer.allocate(8);
        }
        if (glyphs == null) {
            glyphs = IntBuffer.allocate(characters2.capacity());
        }
        if (associations == null) {
            associations = GlyphSequence.makeIdentityAssociations(characters2.limit(), glyphs.limit());
        }
        this.characters = characters2;
        this.glyphs = glyphs;
        this.associations = associations;
        this.predications = predications;
    }

    public GlyphSequence(IntBuffer characters2, IntBuffer glyphs, List associations) {
        this(characters2, glyphs, associations, false);
    }

    public GlyphSequence(GlyphSequence gs) {
        this(gs.characters.duplicate(), GlyphSequence.copyBuffer(gs.glyphs), GlyphSequence.copyAssociations(gs.associations), gs.predications);
    }

    public GlyphSequence(GlyphSequence gs, int[] bga, int[] iga, int[] lga, CharAssociation[] bal, CharAssociation[] ial, CharAssociation[] lal) {
        this(gs.characters.duplicate(), GlyphSequence.concatGlyphs(bga, iga, lga), GlyphSequence.concatAssociations(bal, ial, lal), gs.predications);
    }

    public IntBuffer getCharacters() {
        return this.characters;
    }

    public int[] getCharacterArray(boolean copy) {
        if (copy) {
            return GlyphSequence.toArray(this.characters);
        }
        return this.characters.array();
    }

    public int getCharacterCount() {
        return this.characters.limit();
    }

    public int getGlyph(int index2) throws IndexOutOfBoundsException {
        return this.glyphs.get(index2);
    }

    public void setGlyph(int index2, int gi) throws IndexOutOfBoundsException {
        if (gi > 65535) {
            gi = 65535;
        }
        this.glyphs.put(index2, gi);
    }

    public IntBuffer getGlyphs() {
        return this.glyphs;
    }

    public int[] getGlyphs(int offset, int count2) {
        int ng = this.getGlyphCount();
        if (offset < 0) {
            offset = 0;
        } else if (offset > ng) {
            offset = ng;
        }
        if (count2 < 0) {
            count2 = ng - offset;
        }
        int[] ga = new int[count2];
        int n = offset + count2;
        int k = 0;
        for (int i = offset; i < n; ++i) {
            if (k >= ga.length) continue;
            ga[k++] = this.glyphs.get(i);
        }
        return ga;
    }

    public int[] getGlyphArray(boolean copy) {
        if (copy) {
            return GlyphSequence.toArray(this.glyphs);
        }
        return this.glyphs.array();
    }

    public int getGlyphCount() {
        return this.glyphs.limit();
    }

    public CharAssociation getAssociation(int index2) throws IndexOutOfBoundsException {
        return (CharAssociation)this.associations.get(index2);
    }

    public List getAssociations() {
        return this.associations;
    }

    public CharAssociation[] getAssociations(int offset, int count2) {
        int ng = this.getGlyphCount();
        if (offset < 0) {
            offset = 0;
        } else if (offset > ng) {
            offset = ng;
        }
        if (count2 < 0) {
            count2 = ng - offset;
        }
        CharAssociation[] aa = new CharAssociation[count2];
        int n = offset + count2;
        int k = 0;
        for (int i = offset; i < n; ++i) {
            if (k >= aa.length) continue;
            aa[k++] = (CharAssociation)this.associations.get(i);
        }
        return aa;
    }

    public void setPredications(boolean enable) {
        this.predications = enable;
    }

    public boolean getPredications() {
        return this.predications;
    }

    public void setPredication(int offset, String key, Object value2) {
        if (this.predications) {
            CharAssociation[] aa = this.getAssociations(offset, 1);
            CharAssociation ca = aa[0];
            ca.setPredication(key, value2);
        }
    }

    public Object getPredication(int offset, String key) {
        if (this.predications) {
            CharAssociation[] aa = this.getAssociations(offset, 1);
            CharAssociation ca = aa[0];
            return ca.getPredication(key);
        }
        return null;
    }

    public int compareGlyphs(IntBuffer gb) {
        int ng = this.getGlyphCount();
        int n = gb.limit();
        for (int i = 0; i < n; ++i) {
            if (i < ng) {
                int g2;
                int g1 = this.glyphs.get(i);
                if (g1 > (g2 = gb.get(i))) {
                    return 1;
                }
                if (g1 >= g2) continue;
                return -1;
            }
            return -1;
        }
        return 0;
    }

    public Object clone() {
        try {
            GlyphSequence gs = (GlyphSequence)super.clone();
            gs.characters = GlyphSequence.copyBuffer(this.characters);
            gs.glyphs = GlyphSequence.copyBuffer(this.glyphs);
            gs.associations = GlyphSequence.copyAssociations(this.associations);
            return gs;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('{');
        sb.append("chars = [");
        sb.append(this.characters);
        sb.append("], glyphs = [");
        sb.append(this.glyphs);
        sb.append("], associations = [");
        sb.append(this.associations);
        sb.append("]");
        sb.append('}');
        return sb.toString();
    }

    public static boolean sameGlyphs(int[] ga1, int[] ga2) {
        if (ga1 == ga2) {
            return true;
        }
        if (ga1 == null || ga2 == null) {
            return false;
        }
        if (ga1.length != ga2.length) {
            return false;
        }
        int n = ga1.length;
        for (int i = 0; i < n; ++i) {
            if (ga1[i] == ga2[i]) continue;
            return false;
        }
        return true;
    }

    public static IntBuffer concatGlyphs(int[] bga, int[] iga, int[] lga) {
        int ng = 0;
        if (bga != null) {
            ng += bga.length;
        }
        if (iga != null) {
            ng += iga.length;
        }
        if (lga != null) {
            ng += lga.length;
        }
        IntBuffer gb = IntBuffer.allocate(ng);
        if (bga != null) {
            gb.put(bga);
        }
        if (iga != null) {
            gb.put(iga);
        }
        if (lga != null) {
            gb.put(lga);
        }
        gb.flip();
        return gb;
    }

    public static List concatAssociations(CharAssociation[] baa, CharAssociation[] iaa, CharAssociation[] laa) {
        int na = 0;
        if (baa != null) {
            na += baa.length;
        }
        if (iaa != null) {
            na += iaa.length;
        }
        if (laa != null) {
            na += laa.length;
        }
        if (na > 0) {
            int i;
            ArrayList<CharAssociation> gl = new ArrayList<CharAssociation>(na);
            if (baa != null) {
                for (i = 0; i < baa.length; ++i) {
                    gl.add(baa[i]);
                }
            }
            if (iaa != null) {
                for (i = 0; i < iaa.length; ++i) {
                    gl.add(iaa[i]);
                }
            }
            if (laa != null) {
                for (i = 0; i < laa.length; ++i) {
                    gl.add(laa[i]);
                }
            }
            return gl;
        }
        return null;
    }

    public static GlyphSequence join(GlyphSequence gs, GlyphSequence[] sa) {
        assert (sa != null);
        int tg = 0;
        int ta = 0;
        int n = sa.length;
        for (int i = 0; i < n; ++i) {
            GlyphSequence s2 = sa[i];
            IntBuffer ga = s2.getGlyphs();
            assert (ga != null);
            int ng = ga.limit();
            List al = s2.getAssociations();
            assert (al != null);
            int na = al.size();
            assert (na == ng);
            tg += ng;
            ta += na;
        }
        IntBuffer uga = IntBuffer.allocate(tg);
        ArrayList ual = new ArrayList(ta);
        for (GlyphSequence s3 : sa) {
            uga.put(s3.getGlyphs());
            ual.addAll(s3.getAssociations());
        }
        return new GlyphSequence(gs.getCharacters(), uga, ual, gs.getPredications());
    }

    public static GlyphSequence reorder(GlyphSequence gs, int source, int count2, int target) {
        if (source != target) {
            int ng = gs.getGlyphCount();
            int[] ga = gs.getGlyphArray(false);
            int[] nga = new int[ng];
            CharAssociation[] aa = gs.getAssociations(0, ng);
            CharAssociation[] naa = new CharAssociation[ng];
            if (source < target) {
                int t = 0;
                int s2 = 0;
                int e = source;
                while (s2 < e) {
                    nga[t] = ga[s2];
                    naa[t] = aa[s2];
                    ++s2;
                    ++t;
                }
                s2 = source + count2;
                e = target;
                while (s2 < e) {
                    nga[t] = ga[s2];
                    naa[t] = aa[s2];
                    ++s2;
                    ++t;
                }
                s2 = source;
                e = source + count2;
                while (s2 < e) {
                    nga[t] = ga[s2];
                    naa[t] = aa[s2];
                    ++s2;
                    ++t;
                }
                s2 = target;
                e = ng;
                while (s2 < e) {
                    nga[t] = ga[s2];
                    naa[t] = aa[s2];
                    ++s2;
                    ++t;
                }
            } else {
                int t = 0;
                int s3 = 0;
                int e = target;
                while (s3 < e) {
                    nga[t] = ga[s3];
                    naa[t] = aa[s3];
                    ++s3;
                    ++t;
                }
                s3 = source;
                e = source + count2;
                while (s3 < e) {
                    nga[t] = ga[s3];
                    naa[t] = aa[s3];
                    ++s3;
                    ++t;
                }
                s3 = target;
                e = source;
                while (s3 < e) {
                    nga[t] = ga[s3];
                    naa[t] = aa[s3];
                    ++s3;
                    ++t;
                }
                s3 = source + count2;
                e = ng;
                while (s3 < e) {
                    nga[t] = ga[s3];
                    naa[t] = aa[s3];
                    ++s3;
                    ++t;
                }
            }
            return new GlyphSequence(gs, null, nga, null, null, naa, null);
        }
        return gs;
    }

    private static int[] toArray(IntBuffer ib) {
        if (ib != null) {
            int n = ib.limit();
            int[] ia = new int[n];
            ib.get(ia, 0, n);
            return ia;
        }
        return new int[0];
    }

    private static List makeIdentityAssociations(int numChars, int numGlyphs) {
        int nc = numChars;
        int ng = numGlyphs;
        ArrayList<CharAssociation> av = new ArrayList<CharAssociation>(ng);
        int n = ng;
        for (int i = 0; i < n; ++i) {
            int k = i > nc ? nc : i;
            av.add(new CharAssociation(i, k == nc ? 0 : 1));
        }
        return av;
    }

    private static IntBuffer copyBuffer(IntBuffer ib) {
        if (ib != null) {
            int[] ia = new int[ib.capacity()];
            int p = ib.position();
            int l = ib.limit();
            System.arraycopy(ib.array(), 0, ia, 0, ia.length);
            return IntBuffer.wrap(ia, p, l - p);
        }
        return null;
    }

    private static List copyAssociations(List ca) {
        if (ca != null) {
            return new ArrayList(ca);
        }
        return ca;
    }

    public static class CharAssociation
    implements Cloneable {
        private final int offset;
        private final int count;
        private final int[] subIntervals;
        private Map<String, Object> predications;
        private static volatile Map<String, PredicationMerger> predicationMergers;
        private static final int[] sortIncrements16;
        private static final int[] sortIncrements03;

        public CharAssociation(int offset, int count2, int[] subIntervals) {
            this.offset = offset;
            this.count = count2;
            this.subIntervals = subIntervals != null && subIntervals.length > 2 ? subIntervals : null;
        }

        public CharAssociation(int offset, int count2) {
            this(offset, count2, null);
        }

        public CharAssociation(int[] subIntervals) {
            this(CharAssociation.getSubIntervalsStart(subIntervals), CharAssociation.getSubIntervalsLength(subIntervals), subIntervals);
        }

        public int getOffset() {
            return this.offset;
        }

        public int getCount() {
            return this.count;
        }

        public int getStart() {
            return this.getOffset();
        }

        public int getEnd() {
            return this.getOffset() + this.getCount();
        }

        public boolean isDisjoint() {
            return this.subIntervals != null;
        }

        public int[] getSubIntervals() {
            return this.subIntervals;
        }

        public int getSubIntervalCount() {
            return this.subIntervals != null ? this.subIntervals.length / 2 : 0;
        }

        public boolean contained(int offset, int count2) {
            int s2 = offset;
            int e = offset + count2;
            if (!this.isDisjoint()) {
                int s0 = this.getStart();
                int e0 = this.getEnd();
                return s0 >= s2 && e0 <= e;
            }
            int ns = this.getSubIntervalCount();
            for (int i = 0; i < ns; ++i) {
                int s0 = this.subIntervals[2 * i + 0];
                int e0 = this.subIntervals[2 * i + 1];
                if (s0 < s2 || e0 > e) continue;
                return true;
            }
            return false;
        }

        public void setPredication(String key, Object value2) {
            if (this.predications == null) {
                this.predications = new HashMap<String, Object>();
            }
            if (this.predications != null) {
                this.predications.put(key, value2);
            }
        }

        public Object getPredication(String key) {
            if (this.predications != null) {
                return this.predications.get(key);
            }
            return null;
        }

        public void mergePredication(String key, Object value2) {
            if (this.predications == null) {
                this.predications = new HashMap<String, Object>();
            }
            if (this.predications != null) {
                if (this.predications.containsKey(key)) {
                    Object v1 = this.predications.get(key);
                    Object v2 = value2;
                    this.predications.put(key, CharAssociation.mergePredicationValues(key, v1, v2));
                } else {
                    this.predications.put(key, value2);
                }
            }
        }

        public static Object mergePredicationValues(String key, Object v1, Object v2) {
            PredicationMerger pm = CharAssociation.getPredicationMerger(key);
            if (pm != null) {
                return pm.merge(key, v1, v2);
            }
            if (v2 != null) {
                return v2;
            }
            return v1;
        }

        public void mergePredications(CharAssociation ca) {
            if (ca.predications != null) {
                for (Map.Entry<String, Object> e : ca.predications.entrySet()) {
                    this.mergePredication(e.getKey(), e.getValue());
                }
            }
        }

        public Object clone() {
            try {
                CharAssociation ca = (CharAssociation)super.clone();
                if (this.predications != null) {
                    ca.predications = new HashMap<String, Object>(this.predications);
                }
                return ca;
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }

        public static void setPredicationMerger(String key, PredicationMerger pm) {
            if (predicationMergers == null) {
                predicationMergers = new HashMap<String, PredicationMerger>();
            }
            if (predicationMergers != null) {
                predicationMergers.put(key, pm);
            }
        }

        public static PredicationMerger getPredicationMerger(String key) {
            if (predicationMergers != null) {
                return predicationMergers.get(key);
            }
            return null;
        }

        public static CharAssociation[] replicate(CharAssociation a, int repeat) {
            CharAssociation[] aa = new CharAssociation[repeat];
            int n = aa.length;
            for (int i = 0; i < n; ++i) {
                aa[i] = (CharAssociation)a.clone();
            }
            return aa;
        }

        public static CharAssociation join(CharAssociation[] aa) {
            CharAssociation ca;
            int[] ia = CharAssociation.extractIntervals(aa);
            if (ia == null || ia.length == 0) {
                ca = new CharAssociation(0, 0);
            } else if (ia.length == 2) {
                int s2 = ia[0];
                int e = ia[1];
                ca = new CharAssociation(s2, e - s2);
            } else {
                ca = new CharAssociation(CharAssociation.mergeIntervals(ia));
            }
            return CharAssociation.mergePredicates(ca, aa);
        }

        private static CharAssociation mergePredicates(CharAssociation ca, CharAssociation[] aa) {
            for (CharAssociation a : aa) {
                ca.mergePredications(a);
            }
            return ca;
        }

        private static int getSubIntervalsStart(int[] ia) {
            int us = Integer.MAX_VALUE;
            int ue = Integer.MIN_VALUE;
            if (ia != null) {
                int n = ia.length;
                for (int i = 0; i < n; i += 2) {
                    int s2 = ia[i + 0];
                    int e = ia[i + 1];
                    if (s2 < us) {
                        us = s2;
                    }
                    if (e <= ue) continue;
                    ue = e;
                }
                if (ue < 0) {
                    ue = 0;
                }
                if (us > ue) {
                    us = ue;
                }
            }
            return us;
        }

        private static int getSubIntervalsLength(int[] ia) {
            int us = Integer.MAX_VALUE;
            int ue = Integer.MIN_VALUE;
            if (ia != null) {
                int n = ia.length;
                for (int i = 0; i < n; i += 2) {
                    int s2 = ia[i + 0];
                    int e = ia[i + 1];
                    if (s2 < us) {
                        us = s2;
                    }
                    if (e <= ue) continue;
                    ue = e;
                }
                if (ue < 0) {
                    ue = 0;
                }
                if (us > ue) {
                    us = ue;
                }
            }
            return ue - us;
        }

        private static int[] extractIntervals(CharAssociation[] aa) {
            int ni = 0;
            int n = aa.length;
            for (int i = 0; i < n; ++i) {
                CharAssociation a = aa[i];
                if (a.isDisjoint()) {
                    ni += a.getSubIntervalCount();
                    continue;
                }
                ++ni;
            }
            int[] sa = new int[ni];
            int[] ea = new int[ni];
            int k = 0;
            for (int i = 0; i < aa.length; ++i) {
                CharAssociation a = aa[i];
                if (a.isDisjoint()) {
                    int[] da = a.getSubIntervals();
                    for (int j = 0; j < da.length; j += 2) {
                        sa[k] = da[j + 0];
                        ea[k] = da[j + 1];
                        ++k;
                    }
                    continue;
                }
                sa[k] = a.getStart();
                ea[k] = a.getEnd();
                ++k;
            }
            return CharAssociation.sortIntervals(sa, ea);
        }

        private static int[] sortIntervals(int[] sa, int[] ea) {
            assert (sa != null);
            assert (ea != null);
            assert (sa.length == ea.length);
            int ni = sa.length;
            int[] incr = ni < 21 ? sortIncrements03 : sortIncrements16;
            for (int k = 0; k < incr.length; ++k) {
                int h;
                int n = ni;
                for (int i = h = incr[k]; i < n; ++i) {
                    int s1 = sa[i];
                    int e1 = ea[i];
                    for (int j = i; j >= h; j -= h) {
                        int s2 = sa[j - h];
                        int e2 = ea[j - h];
                        if (s2 > s1) {
                            sa[j] = s2;
                            ea[j] = e2;
                            continue;
                        }
                        if (s2 != s1 || e2 <= e1) break;
                        sa[j] = s2;
                        ea[j] = e2;
                    }
                    sa[j] = s1;
                    ea[j] = e1;
                }
            }
            int[] ia = new int[ni * 2];
            for (int i = 0; i < ni; ++i) {
                ia[i * 2 + 0] = sa[i];
                ia[i * 2 + 1] = ea[i];
            }
            return ia;
        }

        private static int[] mergeIntervals(int[] ia) {
            int i;
            int ni = ia.length;
            int n = ni;
            int nm = 0;
            int ie = -1;
            int is = -1;
            for (i = 0; i < n; i += 2) {
                int s2 = ia[i + 0];
                int e = ia[i + 1];
                if (ie < 0 || s2 > ie) {
                    is = s2;
                    ie = e;
                    ++nm;
                    continue;
                }
                if (s2 < is || e <= ie) continue;
                ie = e;
            }
            int[] mi = new int[nm * 2];
            n = ni;
            nm = 0;
            ie = -1;
            is = -1;
            for (i = 0; i < n; i += 2) {
                int s3 = ia[i + 0];
                int e = ia[i + 1];
                int k = nm * 2;
                if (ie < 0 || s3 > ie) {
                    is = s3;
                    ie = e;
                    mi[k + 0] = is;
                    mi[k + 1] = ie;
                    ++nm;
                    continue;
                }
                if (s3 < is) continue;
                if (e > ie) {
                    ie = e;
                }
                mi[k - 1] = ie;
            }
            return mi;
        }

        static {
            sortIncrements16 = new int[]{1391376, 463792, 198768, 86961, 33936, 13776, 4592, 1968, 861, 336, 112, 48, 21, 7, 3, 1};
            sortIncrements03 = new int[]{7, 3, 1};
        }

        static interface PredicationMerger {
            public Object merge(String var1, Object var2, Object var3);
        }
    }
}

