/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import org.apache.fop.fo.Constants;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.properties.FixedLength;
import org.apache.fop.fo.properties.LengthProperty;
import org.apache.fop.fo.properties.PercentLength;
import org.apache.fop.fo.properties.Property;

public class FontSizePropertyMaker
extends LengthProperty.Maker
implements Constants {
    private static final int FONT_SIZE_NORMAL = 12000;
    private static final double FONT_SIZE_GROWTH_FACTOR = 1.2;

    public FontSizePropertyMaker(int propId) {
        super(propId);
    }

    public Property make(PropertyList propertyList, String value2, FObj fo) throws PropertyException {
        Property p = super.make(propertyList, value2, fo);
        if (p instanceof PercentLength) {
            Property pp = propertyList.getFromParent(this.propId);
            p = FixedLength.getInstance((double)pp.getLength().getValue() * ((PercentLength)p).getPercentage() / 100.0);
        }
        return p;
    }

    public Property convertProperty(Property p, PropertyList propertyList, FObj fo) throws PropertyException {
        if (p.getEnum() == 71 || p.getEnum() == 132) {
            Property pp = propertyList.getFromParent(this.propId);
            int baseFontSize = this.computeClosestAbsoluteFontSize(pp.getLength().getValue());
            if (p.getEnum() == 71) {
                return FixedLength.getInstance(Math.round((double)baseFontSize * 1.2));
            }
            return FixedLength.getInstance(Math.round((double)baseFontSize / 1.2));
        }
        return super.convertProperty(p, propertyList, fo);
    }

    private int computeClosestAbsoluteFontSize(int baseFontSize) {
        double scale = 1.2;
        int lastStepFontSize = 12000;
        if (baseFontSize < 12000) {
            scale = 0.8333333333333334;
        }
        int nextStepFontSize = (int)Math.round((double)lastStepFontSize * scale);
        while (scale < 1.0 && nextStepFontSize > baseFontSize || scale > 1.0 && nextStepFontSize < baseFontSize) {
            lastStepFontSize = nextStepFontSize;
            nextStepFontSize = (int)Math.round((double)lastStepFontSize * scale);
        }
        if (Math.abs(lastStepFontSize - baseFontSize) <= Math.abs(baseFontSize - nextStepFontSize)) {
            return lastStepFontSize;
        }
        return nextStepFontSize;
    }
}

