/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.ArrayList;
import java.util.List;
import org.apache.fop.traits.MinOptMax;
import org.apache.fop.traits.SpaceVal;

public class SpaceSpecifier
implements Cloneable {
    private boolean startsReferenceArea;
    private boolean hasForcing = false;
    private List spaceVals = new ArrayList();

    public SpaceSpecifier(boolean startsReferenceArea) {
        this.startsReferenceArea = startsReferenceArea;
    }

    public Object clone() {
        try {
            SpaceSpecifier ss = (SpaceSpecifier)super.clone();
            ss.startsReferenceArea = this.startsReferenceArea;
            ss.hasForcing = this.hasForcing;
            ss.spaceVals = new ArrayList();
            ss.spaceVals.addAll(this.spaceVals);
            return ss;
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }

    public void clear() {
        this.hasForcing = false;
        this.spaceVals.clear();
    }

    public boolean hasSpaces() {
        return !this.spaceVals.isEmpty();
    }

    public void addSpace(SpaceVal space) {
        if (!this.startsReferenceArea || !space.isConditional() || this.hasSpaces()) {
            if (space.isForcing()) {
                if (!this.hasForcing) {
                    this.spaceVals.clear();
                    this.hasForcing = true;
                }
                this.spaceVals.add(space);
            } else if (!this.hasForcing && space.getSpace().isNonZero()) {
                this.spaceVals.add(space);
            }
        }
    }

    public MinOptMax resolve(boolean endsReferenceArea) {
        int lastIndex;
        if (endsReferenceArea) {
            SpaceVal spaceVal;
            for (lastIndex = this.spaceVals.size(); lastIndex > 0 && (spaceVal = (SpaceVal)this.spaceVals.get(lastIndex - 1)).isConditional(); --lastIndex) {
            }
        }
        MinOptMax resolvedSpace = MinOptMax.ZERO;
        int maxPrecedence = -1;
        for (int index2 = 0; index2 < lastIndex; ++index2) {
            SpaceVal spaceVal = (SpaceVal)this.spaceVals.get(index2);
            MinOptMax space = spaceVal.getSpace();
            if (this.hasForcing) {
                resolvedSpace = resolvedSpace.plus(space);
                continue;
            }
            int precedence = spaceVal.getPrecedence();
            if (precedence > maxPrecedence) {
                maxPrecedence = precedence;
                resolvedSpace = space;
                continue;
            }
            if (precedence != maxPrecedence) continue;
            if (space.getOpt() > resolvedSpace.getOpt()) {
                resolvedSpace = space;
                continue;
            }
            if (space.getOpt() != resolvedSpace.getOpt()) continue;
            if (resolvedSpace.getMin() < space.getMin()) {
                resolvedSpace = MinOptMax.getInstance(space.getMin(), resolvedSpace.getOpt(), resolvedSpace.getMax());
            }
            if (resolvedSpace.getMax() <= space.getMax()) continue;
            resolvedSpace = MinOptMax.getInstance(resolvedSpace.getMin(), resolvedSpace.getOpt(), space.getMax());
        }
        return resolvedSpace;
    }

    public String toString() {
        return "Space Specifier (resolved at begin/end of ref. area:):\n" + this.resolve(false) + "\n" + this.resolve(true);
    }
}

