/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFNumber;
import org.apache.fop.pdf.PDFReference;
import org.apache.fop.pdf.PDFText;
import org.apache.fop.pdf.PDFWritable;

public abstract class PDFObject
implements PDFWritable {
    protected static final Log log = LogFactory.getLog(PDFObject.class.getName());
    private int objnum;
    private int generation = 0;
    private PDFDocument document;
    private PDFObject parent;

    public int getObjectNumber() {
        if (this.objnum == 0) {
            throw new IllegalStateException("Object has no number assigned: " + this.toString());
        }
        return this.objnum;
    }

    public PDFObject() {
    }

    public PDFObject(PDFObject parent) {
        this.setParent(parent);
    }

    public boolean hasObjectNumber() {
        return this.objnum > 0;
    }

    public void setObjectNumber(int objnum) {
        this.objnum = objnum;
        PDFDocument doc = this.getDocument();
        this.setParent(null);
        this.setDocument(doc);
        if (log.isTraceEnabled()) {
            log.trace("Assigning " + this + " object number " + objnum);
        }
    }

    public int getGeneration() {
        return this.generation;
    }

    public final PDFDocument getDocument() {
        if (this.document != null) {
            return this.document;
        }
        if (this.getParent() != null) {
            return this.getParent().getDocument();
        }
        return null;
    }

    public final PDFDocument getDocumentSafely() {
        PDFDocument doc = this.getDocument();
        if (doc == null) {
            throw new IllegalStateException("Parent PDFDocument is unavailable on " + this.getClass().getName());
        }
        return doc;
    }

    public void setDocument(PDFDocument doc) {
        this.document = doc;
    }

    public PDFObject getParent() {
        return this.parent;
    }

    public void setParent(PDFObject parent) {
        this.parent = parent;
    }

    public String getObjectID() {
        return this.getObjectNumber() + " " + this.getGeneration() + " obj\n";
    }

    public String referencePDF() {
        if (!this.hasObjectNumber()) {
            throw new IllegalArgumentException("Cannot reference this object. It doesn't have an object number");
        }
        String ref = this.getObjectNumber() + " " + this.getGeneration() + " R";
        return ref;
    }

    public PDFReference makeReference() {
        return new PDFReference(this);
    }

    public int output(OutputStream stream) throws IOException {
        byte[] pdf = this.toPDF();
        stream.write(pdf);
        return pdf.length;
    }

    public void outputInline(OutputStream out, StringBuilder textBuffer) throws IOException {
        if (this.hasObjectNumber()) {
            textBuffer.append(this.referencePDF());
        } else {
            PDFDocument.flushTextBuffer(textBuffer, out);
            this.output(out);
        }
    }

    protected byte[] toPDF() {
        return PDFObject.encode(this.toPDFString());
    }

    protected String toPDFString() {
        throw new UnsupportedOperationException("Not implemented. Use output(OutputStream) instead.");
    }

    public static final byte[] encode(String text2) {
        return PDFDocument.encode(text2);
    }

    protected byte[] encodeText(String text2) {
        if (this.getDocumentSafely().isEncryptionActive()) {
            byte[] buf = PDFText.toUTF16(text2);
            return PDFText.escapeByteArray(this.getDocument().getEncryption().encrypt(buf, this));
        }
        return PDFObject.encode(PDFText.escapeText(text2, false));
    }

    protected byte[] encodeString(String string2) {
        return this.encodeText(string2);
    }

    protected void encodeBinaryToHexString(byte[] data2, OutputStream out) throws IOException {
        out.write(60);
        if (this.getDocumentSafely().isEncryptionActive()) {
            data2 = this.getDocument().getEncryption().encrypt(data2, this);
        }
        String hex = PDFText.toHex(data2, false);
        byte[] encoded = hex.getBytes("US-ASCII");
        out.write(encoded);
        out.write(62);
    }

    protected void formatObject(Object obj, OutputStream out, StringBuilder textBuffer) throws IOException {
        if (obj == null) {
            textBuffer.append("null");
        } else if (obj instanceof PDFWritable) {
            ((PDFWritable)obj).outputInline(out, textBuffer);
        } else if (obj instanceof Number) {
            if (obj instanceof Double || obj instanceof Float) {
                textBuffer.append(PDFNumber.doubleOut(((Number)obj).doubleValue()));
            } else {
                textBuffer.append(obj.toString());
            }
        } else if (obj instanceof Boolean) {
            textBuffer.append(obj.toString());
        } else if (obj instanceof byte[]) {
            PDFDocument.flushTextBuffer(textBuffer, out);
            this.encodeBinaryToHexString((byte[])obj, out);
        } else {
            PDFDocument.flushTextBuffer(textBuffer, out);
            out.write(this.encodeText(obj.toString()));
        }
    }

    protected boolean contentEquals(PDFObject o) {
        return this.equals(o);
    }
}

