/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.intermediate;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.fop.accessibility.StructureTreeEventHandler;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.render.PrintRendererConfigurator;
import org.apache.fop.render.RenderingContext;
import org.apache.fop.render.intermediate.AbstractXMLWritingIFDocumentHandler;
import org.apache.fop.render.intermediate.IFConstants;
import org.apache.fop.render.intermediate.IFDocumentHandler;
import org.apache.fop.render.intermediate.IFDocumentHandlerConfigurator;
import org.apache.fop.render.intermediate.IFDocumentNavigationHandler;
import org.apache.fop.render.intermediate.IFException;
import org.apache.fop.render.intermediate.IFPainter;
import org.apache.fop.render.intermediate.IFState;
import org.apache.fop.render.intermediate.IFStructureTreeBuilder;
import org.apache.fop.render.intermediate.IFUtil;
import org.apache.fop.render.intermediate.extensions.AbstractAction;
import org.apache.fop.render.intermediate.extensions.Bookmark;
import org.apache.fop.render.intermediate.extensions.BookmarkTree;
import org.apache.fop.render.intermediate.extensions.DocumentNavigationExtensionConstants;
import org.apache.fop.render.intermediate.extensions.Link;
import org.apache.fop.render.intermediate.extensions.NamedDestination;
import org.apache.fop.traits.BorderProps;
import org.apache.fop.traits.RuleStyle;
import org.apache.fop.util.DOM2SAX;
import org.apache.fop.util.LanguageTags;
import org.apache.fop.util.XMLConstants;
import org.apache.fop.util.XMLUtil;
import org.apache.xmlgraphics.java2d.color.ColorUtil;
import org.apache.xmlgraphics.util.QName;
import org.apache.xmlgraphics.util.XMLizable;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class IFSerializer
extends AbstractXMLWritingIFDocumentHandler
implements IFConstants,
IFPainter,
IFDocumentNavigationHandler {
    public static final String VERSION = "2.0";
    private IFDocumentHandler mimicHandler;
    private int pageSequenceIndex;
    private IFState state;
    private String currentID = "";
    private IFStructureTreeBuilder structureTreeBuilder;
    private Map incompleteActions = new HashMap();
    private List completeActions = new LinkedList();

    protected String getMainNamespace() {
        return "http://xmlgraphics.apache.org/fop/intermediate";
    }

    public boolean supportsPagesOutOfOrder() {
        return false;
    }

    public String getMimeType() {
        return "application/X-fop-intermediate-format";
    }

    public IFDocumentHandlerConfigurator getConfigurator() {
        if (this.mimicHandler != null) {
            return this.getMimickedDocumentHandler().getConfigurator();
        }
        return new PrintRendererConfigurator(this.getUserAgent());
    }

    public IFDocumentNavigationHandler getDocumentNavigationHandler() {
        return this;
    }

    public void mimicDocumentHandler(IFDocumentHandler targetHandler) {
        this.mimicHandler = targetHandler;
    }

    public IFDocumentHandler getMimickedDocumentHandler() {
        return this.mimicHandler;
    }

    public FontInfo getFontInfo() {
        if (this.mimicHandler != null) {
            return this.mimicHandler.getFontInfo();
        }
        return null;
    }

    public void setFontInfo(FontInfo fontInfo) {
        if (this.mimicHandler != null) {
            this.mimicHandler.setFontInfo(fontInfo);
        }
    }

    public void setDefaultFontInfo(FontInfo fontInfo) {
        if (this.mimicHandler != null) {
            this.mimicHandler.setDefaultFontInfo(fontInfo);
        }
    }

    public StructureTreeEventHandler getStructureTreeEventHandler() {
        if (this.structureTreeBuilder == null) {
            this.structureTreeBuilder = new IFStructureTreeBuilder();
        }
        return this.structureTreeBuilder;
    }

    public void startDocument() throws IFException {
        super.startDocument();
        try {
            this.handler.startDocument();
            this.handler.startPrefixMapping("", "http://xmlgraphics.apache.org/fop/intermediate");
            this.handler.startPrefixMapping("xlink", "http://www.w3.org/1999/xlink");
            this.handler.startPrefixMapping("nav", "http://xmlgraphics.apache.org/fop/intermediate/document-navigation");
            this.handler.startPrefixMapping("foi", "http://xmlgraphics.apache.org/fop/internal");
            AttributesImpl atts = new AttributesImpl();
            this.addAttribute(atts, "version", VERSION);
            this.handler.startElement("document", (Attributes)atts);
        }
        catch (SAXException e) {
            throw new IFException("SAX error in startDocument()", e);
        }
    }

    public void setDocumentLocale(Locale locale) {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("http://www.w3.org/XML/1998/namespace", "lang", "xml:lang", "CDATA", LanguageTags.toLanguageTag(locale));
        try {
            this.handler.startElement("locale", (Attributes)atts);
            this.handler.endElement("locale");
        }
        catch (SAXException e) {
            throw new RuntimeException("Unable to create the locale element.", e);
        }
    }

    public void startDocumentHeader() throws IFException {
        try {
            this.handler.startElement("header");
        }
        catch (SAXException e) {
            throw new IFException("SAX error in startDocumentHeader()", e);
        }
    }

    public void endDocumentHeader() throws IFException {
        try {
            this.handler.endElement("header");
        }
        catch (SAXException e) {
            throw new IFException("SAX error in startDocumentHeader()", e);
        }
    }

    public void startDocumentTrailer() throws IFException {
        try {
            this.handler.startElement("trailer");
        }
        catch (SAXException e) {
            throw new IFException("SAX error in startDocumentTrailer()", e);
        }
    }

    public void endDocumentTrailer() throws IFException {
        try {
            this.handler.endElement("trailer");
        }
        catch (SAXException e) {
            throw new IFException("SAX error in endDocumentTrailer()", e);
        }
    }

    public void endDocument() throws IFException {
        try {
            this.handler.endElement("document");
            this.handler.endDocument();
            this.finishDocumentNavigation();
        }
        catch (SAXException e) {
            throw new IFException("SAX error in endDocument()", e);
        }
    }

    public void startPageSequence(String id) throws IFException {
        try {
            Locale lang;
            AttributesImpl atts = new AttributesImpl();
            if (id != null) {
                atts.addAttribute("http://www.w3.org/XML/1998/namespace", "id", "xml:id", "CDATA", id);
            }
            if ((lang = this.getContext().getLanguage()) != null) {
                atts.addAttribute("http://www.w3.org/XML/1998/namespace", "lang", "xml:lang", "CDATA", LanguageTags.toLanguageTag(lang));
            }
            XMLUtil.addAttribute(atts, XMLConstants.XML_SPACE, "preserve");
            this.addForeignAttributes(atts);
            this.handler.startElement("page-sequence", (Attributes)atts);
            if (this.getUserAgent().isAccessibilityEnabled()) {
                assert (this.structureTreeBuilder != null);
                this.structureTreeBuilder.replayEventsForPageSequence(this.handler, this.pageSequenceIndex++);
            }
        }
        catch (SAXException e) {
            throw new IFException("SAX error in startPageSequence()", e);
        }
    }

    public void endPageSequence() throws IFException {
        try {
            this.handler.endElement("page-sequence");
        }
        catch (SAXException e) {
            throw new IFException("SAX error in endPageSequence()", e);
        }
    }

    public void startPage(int index2, String name, String pageMasterName, Dimension size2) throws IFException {
        try {
            AttributesImpl atts = new AttributesImpl();
            this.addAttribute(atts, "index", Integer.toString(index2));
            this.addAttribute(atts, "name", name);
            this.addAttribute(atts, "page-master-name", pageMasterName);
            this.addAttribute(atts, "width", Integer.toString(size2.width));
            this.addAttribute(atts, "height", Integer.toString(size2.height));
            this.addForeignAttributes(atts);
            this.handler.startElement("page", (Attributes)atts);
        }
        catch (SAXException e) {
            throw new IFException("SAX error in startPage()", e);
        }
    }

    public void startPageHeader() throws IFException {
        try {
            this.handler.startElement("page-header");
        }
        catch (SAXException e) {
            throw new IFException("SAX error in startPageHeader()", e);
        }
    }

    public void endPageHeader() throws IFException {
        try {
            this.handler.endElement("page-header");
        }
        catch (SAXException e) {
            throw new IFException("SAX error in endPageHeader()", e);
        }
    }

    public IFPainter startPageContent() throws IFException {
        try {
            this.handler.startElement("content");
            this.state = IFState.create();
            return this;
        }
        catch (SAXException e) {
            throw new IFException("SAX error in startPageContent()", e);
        }
    }

    public void endPageContent() throws IFException {
        try {
            this.state = null;
            this.currentID = "";
            this.handler.endElement("content");
        }
        catch (SAXException e) {
            throw new IFException("SAX error in endPageContent()", e);
        }
    }

    public void startPageTrailer() throws IFException {
        try {
            this.handler.startElement("page-trailer");
        }
        catch (SAXException e) {
            throw new IFException("SAX error in startPageTrailer()", e);
        }
    }

    public void endPageTrailer() throws IFException {
        try {
            this.commitNavigation();
            this.handler.endElement("page-trailer");
        }
        catch (SAXException e) {
            throw new IFException("SAX error in endPageTrailer()", e);
        }
    }

    public void endPage() throws IFException {
        try {
            this.handler.endElement("page");
        }
        catch (SAXException e) {
            throw new IFException("SAX error in endPage()", e);
        }
    }

    public void startViewport(AffineTransform transform2, Dimension size2, Rectangle clipRect) throws IFException {
        this.startViewport(IFUtil.toString(transform2), size2, clipRect);
    }

    public void startViewport(AffineTransform[] transforms, Dimension size2, Rectangle clipRect) throws IFException {
        this.startViewport(IFUtil.toString(transforms), size2, clipRect);
    }

    private void startViewport(String transform2, Dimension size2, Rectangle clipRect) throws IFException {
        try {
            AttributesImpl atts = new AttributesImpl();
            if (transform2 != null && transform2.length() > 0) {
                this.addAttribute(atts, "transform", transform2);
            }
            this.addAttribute(atts, "width", Integer.toString(size2.width));
            this.addAttribute(atts, "height", Integer.toString(size2.height));
            if (clipRect != null) {
                this.addAttribute(atts, "clip-rect", IFUtil.toString(clipRect));
            }
            this.handler.startElement("viewport", (Attributes)atts);
        }
        catch (SAXException e) {
            throw new IFException("SAX error in startViewport()", e);
        }
    }

    public void endViewport() throws IFException {
        try {
            this.handler.endElement("viewport");
        }
        catch (SAXException e) {
            throw new IFException("SAX error in endViewport()", e);
        }
    }

    public void startGroup(AffineTransform[] transforms) throws IFException {
        this.startGroup(IFUtil.toString(transforms));
    }

    public void startGroup(AffineTransform transform2) throws IFException {
        this.startGroup(IFUtil.toString(transform2));
    }

    private void startGroup(String transform2) throws IFException {
        try {
            AttributesImpl atts = new AttributesImpl();
            if (transform2 != null && transform2.length() > 0) {
                this.addAttribute(atts, "transform", transform2);
            }
            this.handler.startElement("g", (Attributes)atts);
        }
        catch (SAXException e) {
            throw new IFException("SAX error in startGroup()", e);
        }
    }

    public void endGroup() throws IFException {
        try {
            this.handler.endElement("g");
        }
        catch (SAXException e) {
            throw new IFException("SAX error in endGroup()", e);
        }
    }

    public void drawImage(String uri, Rectangle rect) throws IFException {
        try {
            this.addID();
            AttributesImpl atts = new AttributesImpl();
            this.addAttribute(atts, XLINK_HREF, uri);
            this.addAttribute(atts, "x", Integer.toString(rect.x));
            this.addAttribute(atts, "y", Integer.toString(rect.y));
            this.addAttribute(atts, "width", Integer.toString(rect.width));
            this.addAttribute(atts, "height", Integer.toString(rect.height));
            this.addForeignAttributes(atts);
            this.addStructureReference(atts);
            this.handler.element("image", (Attributes)atts);
        }
        catch (SAXException e) {
            throw new IFException("SAX error in startGroup()", e);
        }
    }

    private void addForeignAttributes(AttributesImpl atts) throws SAXException {
        Map foreignAttributes = this.getContext().getForeignAttributes();
        if (!foreignAttributes.isEmpty()) {
            for (Map.Entry entry : foreignAttributes.entrySet()) {
                this.addAttribute(atts, (QName)entry.getKey(), entry.getValue().toString());
            }
        }
    }

    public void drawImage(Document doc, Rectangle rect) throws IFException {
        try {
            this.addID();
            AttributesImpl atts = new AttributesImpl();
            this.addAttribute(atts, "x", Integer.toString(rect.x));
            this.addAttribute(atts, "y", Integer.toString(rect.y));
            this.addAttribute(atts, "width", Integer.toString(rect.width));
            this.addAttribute(atts, "height", Integer.toString(rect.height));
            this.addForeignAttributes(atts);
            this.addStructureReference(atts);
            this.handler.startElement("image", (Attributes)atts);
            new DOM2SAX(this.handler).writeDocument(doc, true);
            this.handler.endElement("image");
        }
        catch (SAXException e) {
            throw new IFException("SAX error in startGroup()", e);
        }
    }

    private static String toString(Paint paint) {
        if (paint instanceof Color) {
            return org.apache.fop.util.ColorUtil.colorToString((Color)paint);
        }
        throw new UnsupportedOperationException("Paint not supported: " + paint);
    }

    public void clipRect(Rectangle rect) throws IFException {
        try {
            AttributesImpl atts = new AttributesImpl();
            this.addAttribute(atts, "x", Integer.toString(rect.x));
            this.addAttribute(atts, "y", Integer.toString(rect.y));
            this.addAttribute(atts, "width", Integer.toString(rect.width));
            this.addAttribute(atts, "height", Integer.toString(rect.height));
            this.handler.element("clip-rect", (Attributes)atts);
        }
        catch (SAXException e) {
            throw new IFException("SAX error in clipRect()", e);
        }
    }

    public void fillRect(Rectangle rect, Paint fill2) throws IFException {
        if (fill2 == null) {
            return;
        }
        try {
            AttributesImpl atts = new AttributesImpl();
            this.addAttribute(atts, "x", Integer.toString(rect.x));
            this.addAttribute(atts, "y", Integer.toString(rect.y));
            this.addAttribute(atts, "width", Integer.toString(rect.width));
            this.addAttribute(atts, "height", Integer.toString(rect.height));
            this.addAttribute(atts, "fill", IFSerializer.toString(fill2));
            this.handler.element("rect", (Attributes)atts);
        }
        catch (SAXException e) {
            throw new IFException("SAX error in fillRect()", e);
        }
    }

    public void drawBorderRect(Rectangle rect, BorderProps top, BorderProps bottom, BorderProps left, BorderProps right) throws IFException {
        if (top == null && bottom == null && left == null && right == null) {
            return;
        }
        try {
            AttributesImpl atts = new AttributesImpl();
            this.addAttribute(atts, "x", Integer.toString(rect.x));
            this.addAttribute(atts, "y", Integer.toString(rect.y));
            this.addAttribute(atts, "width", Integer.toString(rect.width));
            this.addAttribute(atts, "height", Integer.toString(rect.height));
            if (top != null) {
                this.addAttribute(atts, "top", top.toString());
            }
            if (bottom != null) {
                this.addAttribute(atts, "bottom", bottom.toString());
            }
            if (left != null) {
                this.addAttribute(atts, "left", left.toString());
            }
            if (right != null) {
                this.addAttribute(atts, "right", right.toString());
            }
            this.handler.element("border-rect", (Attributes)atts);
        }
        catch (SAXException e) {
            throw new IFException("SAX error in drawBorderRect()", e);
        }
    }

    public void drawLine(Point start, Point end, int width, Color color, RuleStyle style) throws IFException {
        try {
            this.addID();
            AttributesImpl atts = new AttributesImpl();
            this.addAttribute(atts, "x1", Integer.toString(start.x));
            this.addAttribute(atts, "y1", Integer.toString(start.y));
            this.addAttribute(atts, "x2", Integer.toString(end.x));
            this.addAttribute(atts, "y2", Integer.toString(end.y));
            this.addAttribute(atts, "stroke-width", Integer.toString(width));
            this.addAttribute(atts, "color", org.apache.fop.util.ColorUtil.colorToString(color));
            this.addAttribute(atts, "style", style.getName());
            this.handler.element("line", (Attributes)atts);
        }
        catch (SAXException e) {
            throw new IFException("SAX error in drawLine()", e);
        }
    }

    public void drawText(int x, int y, int letterSpacing, int wordSpacing, int[][] dp, String text2) throws IFException {
        try {
            this.addID();
            AttributesImpl atts = new AttributesImpl();
            this.addAttribute(atts, "x", Integer.toString(x));
            this.addAttribute(atts, "y", Integer.toString(y));
            if (letterSpacing != 0) {
                this.addAttribute(atts, "letter-spacing", Integer.toString(letterSpacing));
            }
            if (wordSpacing != 0) {
                this.addAttribute(atts, "word-spacing", Integer.toString(wordSpacing));
            }
            if (dp != null && !IFUtil.isDPIdentity(dp)) {
                if (IFUtil.isDPOnlyDX(dp)) {
                    int[] dx = IFUtil.convertDPToDX(dp);
                    this.addAttribute(atts, "dx", IFUtil.toString(dx));
                } else {
                    this.addAttribute(atts, "dp", XMLUtil.encodePositionAdjustments(dp));
                }
            }
            this.addStructureReference(atts);
            this.handler.startElement("text", (Attributes)atts);
            char[] chars = text2.toCharArray();
            this.handler.characters(chars, 0, chars.length);
            this.handler.endElement("text");
        }
        catch (SAXException e) {
            throw new IFException("SAX error in setFont()", e);
        }
    }

    public void setFont(String family, String style, Integer weight, String variant, Integer size2, Color color) throws IFException {
        try {
            boolean changed;
            AttributesImpl atts = new AttributesImpl();
            if (family != null) {
                boolean bl = changed = !family.equals(this.state.getFontFamily());
                if (changed) {
                    this.state.setFontFamily(family);
                    this.addAttribute(atts, "family", family);
                }
            }
            if (style != null) {
                boolean bl = changed = !style.equals(this.state.getFontStyle());
                if (changed) {
                    this.state.setFontStyle(style);
                    this.addAttribute(atts, "style", style);
                }
            }
            if (weight != null) {
                boolean bl = changed = weight.intValue() != this.state.getFontWeight();
                if (changed) {
                    this.state.setFontWeight(weight);
                    this.addAttribute(atts, "weight", weight.toString());
                }
            }
            if (variant != null) {
                boolean bl = changed = !variant.equals(this.state.getFontVariant());
                if (changed) {
                    this.state.setFontVariant(variant);
                    this.addAttribute(atts, "variant", variant);
                }
            }
            if (size2 != null) {
                boolean bl = changed = size2.intValue() != this.state.getFontSize();
                if (changed) {
                    this.state.setFontSize(size2);
                    this.addAttribute(atts, "size", size2.toString());
                }
            }
            if (color != null) {
                boolean bl = changed = !ColorUtil.isSameColor(color, this.state.getTextColor());
                if (changed) {
                    this.state.setTextColor(color);
                    this.addAttribute(atts, "color", IFSerializer.toString(color));
                }
            }
            if (atts.getLength() > 0) {
                this.handler.element("font", (Attributes)atts);
            }
        }
        catch (SAXException e) {
            throw new IFException("SAX error in setFont()", e);
        }
    }

    public void handleExtensionObject(Object extension2) throws IFException {
        if (extension2 instanceof XMLizable) {
            try {
                ((XMLizable)extension2).toSAX(this.handler);
            }
            catch (SAXException e) {
                throw new IFException("SAX error while handling extension object", e);
            }
        } else {
            throw new UnsupportedOperationException("Extension must implement XMLizable: " + extension2 + " (" + extension2.getClass().getName() + ")");
        }
    }

    protected RenderingContext createRenderingContext() throws IllegalStateException {
        throw new IllegalStateException("Should never be called!");
    }

    private void addAttribute(AttributesImpl atts, QName attribute, String value2) throws SAXException {
        this.handler.startPrefixMapping(attribute.getPrefix(), attribute.getNamespaceURI());
        XMLUtil.addAttribute(atts, attribute, value2);
    }

    private void addAttribute(AttributesImpl atts, String localName, String value2) {
        XMLUtil.addAttribute(atts, localName, value2);
    }

    private void addStructureReference(AttributesImpl atts) {
        IFStructureTreeBuilder.IFStructureTreeElement structureTreeElement = (IFStructureTreeBuilder.IFStructureTreeElement)this.getContext().getStructureTreeElement();
        if (structureTreeElement != null) {
            this.addStructRefAttribute(atts, structureTreeElement.getId());
        }
    }

    private void addStructRefAttribute(AttributesImpl atts, String id) {
        atts.addAttribute("http://xmlgraphics.apache.org/fop/internal", "struct-ref", "foi:struct-ref", "CDATA", id);
    }

    private void addID() throws SAXException {
        String id = this.getContext().getID();
        if (!this.currentID.equals(id)) {
            AttributesImpl atts = new AttributesImpl();
            this.addAttribute(atts, "name", id);
            this.handler.startElement("id", (Attributes)atts);
            this.handler.endElement("id");
            this.currentID = id;
        }
    }

    private void noteAction(AbstractAction action) {
        if (action == null) {
            throw new NullPointerException("action must not be null");
        }
        if (!action.isComplete()) {
            assert (action.hasID());
            this.incompleteActions.put(action.getID(), action);
        }
    }

    public void renderNamedDestination(NamedDestination destination) throws IFException {
        this.noteAction(destination.getAction());
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute(null, "name", "name", "CDATA", destination.getName());
        try {
            this.handler.startElement(DocumentNavigationExtensionConstants.NAMED_DESTINATION, (Attributes)atts);
            this.serializeXMLizable(destination.getAction());
            this.handler.endElement(DocumentNavigationExtensionConstants.NAMED_DESTINATION);
        }
        catch (SAXException e) {
            throw new IFException("SAX error serializing named destination", e);
        }
    }

    public void renderBookmarkTree(BookmarkTree tree) throws IFException {
        AttributesImpl atts = new AttributesImpl();
        try {
            this.handler.startElement(DocumentNavigationExtensionConstants.BOOKMARK_TREE, (Attributes)atts);
            for (Bookmark b : tree.getBookmarks()) {
                if (b.getAction() == null) continue;
                this.serializeBookmark(b);
            }
            this.handler.endElement(DocumentNavigationExtensionConstants.BOOKMARK_TREE);
        }
        catch (SAXException e) {
            throw new IFException("SAX error serializing bookmark tree", e);
        }
    }

    private void serializeBookmark(Bookmark bookmark) throws SAXException, IFException {
        this.noteAction(bookmark.getAction());
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute(null, "title", "title", "CDATA", bookmark.getTitle());
        atts.addAttribute(null, "starting-state", "starting-state", "CDATA", bookmark.isShown() ? "show" : "hide");
        this.handler.startElement(DocumentNavigationExtensionConstants.BOOKMARK, (Attributes)atts);
        this.serializeXMLizable(bookmark.getAction());
        for (Bookmark b : bookmark.getChildBookmarks()) {
            if (b.getAction() == null) continue;
            this.serializeBookmark(b);
        }
        this.handler.endElement(DocumentNavigationExtensionConstants.BOOKMARK);
    }

    public void renderLink(Link link2) throws IFException {
        this.noteAction(link2.getAction());
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute(null, "rect", "rect", "CDATA", IFUtil.toString(link2.getTargetRect()));
        if (this.getUserAgent().isAccessibilityEnabled()) {
            this.addStructRefAttribute(atts, ((IFStructureTreeBuilder.IFStructureTreeElement)link2.getAction().getStructureTreeElement()).getId());
        }
        try {
            this.handler.startElement(DocumentNavigationExtensionConstants.LINK, (Attributes)atts);
            this.serializeXMLizable(link2.getAction());
            this.handler.endElement(DocumentNavigationExtensionConstants.LINK);
        }
        catch (SAXException e) {
            throw new IFException("SAX error serializing link", e);
        }
    }

    public void addResolvedAction(AbstractAction action) throws IFException {
        assert (action.isComplete());
        assert (action.hasID());
        AbstractAction noted = (AbstractAction)this.incompleteActions.remove(action.getID());
        if (noted != null) {
            this.completeActions.add(action);
        }
    }

    private void commitNavigation() throws IFException {
        Iterator iter2 = this.completeActions.iterator();
        while (iter2.hasNext()) {
            AbstractAction action = (AbstractAction)iter2.next();
            iter2.remove();
            this.serializeXMLizable(action);
        }
        assert (this.completeActions.size() == 0);
    }

    private void finishDocumentNavigation() {
        assert (this.incompleteActions.size() == 0) : "Still holding incomplete actions!";
    }

    private void serializeXMLizable(XMLizable object) throws IFException {
        try {
            object.toSAX(this.handler);
        }
        catch (SAXException e) {
            throw new IFException("SAX error serializing object", e);
        }
    }
}

