/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.trax;

import java.io.IOException;
import org.apache.xml.serializer.NamespaceMappings;
import org.apache.xml.serializer.SerializationHandler;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class DOM2TO
implements XMLReader,
Locator {
    private static final String EMPTYSTRING = "";
    private static final String XMLNS_PREFIX = "xmlns";
    private Node _dom;
    private SerializationHandler _handler;

    public DOM2TO(Node root2, SerializationHandler handler) {
        this._dom = root2;
        this._handler = handler;
    }

    public ContentHandler getContentHandler() {
        return null;
    }

    public void setContentHandler(ContentHandler handler) {
    }

    public void parse(InputSource unused) throws IOException, SAXException {
        this.parse(this._dom);
    }

    public void parse() throws IOException, SAXException {
        if (this._dom != null) {
            boolean isIncomplete;
            boolean bl = isIncomplete = this._dom.getNodeType() != 9;
            if (isIncomplete) {
                this._handler.startDocument();
                this.parse(this._dom);
                this._handler.endDocument();
            } else {
                this.parse(this._dom);
            }
        }
    }

    private void parse(Node node) throws IOException, SAXException {
        if (node == null) {
            return;
        }
        switch (node.getNodeType()) {
            case 2: 
            case 5: 
            case 6: 
            case 10: 
            case 12: {
                break;
            }
            case 4: {
                this._handler.startCDATA();
                this._handler.characters(node.getNodeValue());
                this._handler.endCDATA();
                break;
            }
            case 8: {
                this._handler.comment(node.getNodeValue());
                break;
            }
            case 9: {
                this._handler.startDocument();
                Node next2 = node.getFirstChild();
                while (next2 != null) {
                    this.parse(next2);
                    next2 = next2.getNextSibling();
                }
                this._handler.endDocument();
                break;
            }
            case 11: {
                Node next2 = node.getFirstChild();
                while (next2 != null) {
                    this.parse(next2);
                    next2 = next2.getNextSibling();
                }
                break;
            }
            case 1: {
                String prefix;
                String qname = node.getNodeName();
                this._handler.startElement(null, null, qname);
                NamedNodeMap map2 = node.getAttributes();
                int length = map2.getLength();
                NamespaceMappings nm = new NamespaceMappings();
                int i = 0;
                while (i < length) {
                    int colon2;
                    String uriAttr;
                    Node attr = map2.item(i);
                    String qnameAttr = attr.getNodeName();
                    if (qnameAttr.startsWith(XMLNS_PREFIX)) {
                        uriAttr = attr.getNodeValue();
                        colon2 = qnameAttr.lastIndexOf(58);
                        prefix = colon2 > 0 ? qnameAttr.substring(colon2 + 1) : EMPTYSTRING;
                        this._handler.namespaceAfterStartElement(prefix, uriAttr);
                    } else {
                        uriAttr = attr.getNamespaceURI();
                        if (uriAttr != null && !uriAttr.equals(EMPTYSTRING)) {
                            colon2 = qnameAttr.lastIndexOf(58);
                            String newPrefix = nm.lookupPrefix(uriAttr);
                            if (newPrefix == null) {
                                newPrefix = nm.generateNextPrefix();
                            }
                            prefix = colon2 > 0 ? qnameAttr.substring(0, colon2) : newPrefix;
                            this._handler.namespaceAfterStartElement(prefix, uriAttr);
                            this._handler.addAttribute(prefix + ":" + qnameAttr, attr.getNodeValue());
                        } else {
                            this._handler.addAttribute(qnameAttr, attr.getNodeValue());
                        }
                    }
                    ++i;
                }
                String uri = node.getNamespaceURI();
                String localName = node.getLocalName();
                if (uri != null) {
                    int colon3 = qname.lastIndexOf(58);
                    prefix = colon3 > 0 ? qname.substring(0, colon3) : EMPTYSTRING;
                    this._handler.namespaceAfterStartElement(prefix, uri);
                } else if (uri == null && localName != null) {
                    prefix = EMPTYSTRING;
                    this._handler.namespaceAfterStartElement(prefix, EMPTYSTRING);
                }
                Node next2 = node.getFirstChild();
                while (next2 != null) {
                    this.parse(next2);
                    next2 = next2.getNextSibling();
                }
                this._handler.endElement(qname);
                break;
            }
            case 7: {
                this._handler.processingInstruction(node.getNodeName(), node.getNodeValue());
                break;
            }
            case 3: {
                this._handler.characters(node.getNodeValue());
            }
        }
    }

    public DTDHandler getDTDHandler() {
        return null;
    }

    public ErrorHandler getErrorHandler() {
        return null;
    }

    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return false;
    }

    public void setFeature(String name, boolean value2) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    public void parse(String sysId) throws IOException, SAXException {
        throw new IOException("This method is not yet implemented.");
    }

    public void setDTDHandler(DTDHandler handler) throws NullPointerException {
    }

    public void setEntityResolver(EntityResolver resolver) throws NullPointerException {
    }

    public EntityResolver getEntityResolver() {
        return null;
    }

    public void setErrorHandler(ErrorHandler handler) throws NullPointerException {
    }

    public void setProperty(String name, Object value2) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return null;
    }

    public int getColumnNumber() {
        return 0;
    }

    public int getLineNumber() {
        return 0;
    }

    public String getPublicId() {
        return null;
    }

    public String getSystemId() {
        return null;
    }

    private String getNodeTypeFromCode(short code) {
        String retval = null;
        switch (code) {
            case 2: {
                retval = "ATTRIBUTE_NODE";
                break;
            }
            case 4: {
                retval = "CDATA_SECTION_NODE";
                break;
            }
            case 8: {
                retval = "COMMENT_NODE";
                break;
            }
            case 11: {
                retval = "DOCUMENT_FRAGMENT_NODE";
                break;
            }
            case 9: {
                retval = "DOCUMENT_NODE";
                break;
            }
            case 10: {
                retval = "DOCUMENT_TYPE_NODE";
                break;
            }
            case 1: {
                retval = "ELEMENT_NODE";
                break;
            }
            case 6: {
                retval = "ENTITY_NODE";
                break;
            }
            case 5: {
                retval = "ENTITY_REFERENCE_NODE";
                break;
            }
            case 12: {
                retval = "NOTATION_NODE";
                break;
            }
            case 7: {
                retval = "PROCESSING_INSTRUCTION_NODE";
                break;
            }
            case 3: {
                retval = "TEXT_NODE";
            }
        }
        return retval;
    }
}

