/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.writer.internal;

import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.xmlgraphics.image.codec.tiff.TIFFEncodeParam;
import org.apache.xmlgraphics.image.codec.tiff.TIFFField;
import org.apache.xmlgraphics.image.codec.tiff.TIFFImageEncoder;
import org.apache.xmlgraphics.image.writer.AbstractImageWriter;
import org.apache.xmlgraphics.image.writer.ImageWriterParams;
import org.apache.xmlgraphics.image.writer.MultiImageWriter;

public class TIFFImageWriter
extends AbstractImageWriter {
    public void writeImage(RenderedImage image2, OutputStream out) throws IOException {
        this.writeImage(image2, out, null);
    }

    public void writeImage(RenderedImage image2, OutputStream out, ImageWriterParams params) throws IOException {
        TIFFEncodeParam encodeParams = this.createTIFFEncodeParams(params);
        TIFFImageEncoder encoder2 = new TIFFImageEncoder(out, encodeParams);
        encoder2.encode(image2);
    }

    private TIFFEncodeParam createTIFFEncodeParams(ImageWriterParams params) {
        TIFFEncodeParam encodeParams = new TIFFEncodeParam();
        if (params == null) {
            encodeParams.setCompression(1);
        } else {
            if (params.getCompressionMethod() == null) {
                encodeParams.setCompression(32773);
            } else if ("PackBits".equalsIgnoreCase(params.getCompressionMethod())) {
                encodeParams.setCompression(32773);
            } else if ("NONE".equalsIgnoreCase(params.getCompressionMethod())) {
                encodeParams.setCompression(1);
            } else if ("Deflate".equalsIgnoreCase(params.getCompressionMethod())) {
                encodeParams.setCompression(32946);
            } else {
                throw new UnsupportedOperationException("Compression method not supported: " + params.getCompressionMethod());
            }
            if (params.getResolution() != null) {
                float pixSzMM = 25.4f / params.getResolution().floatValue();
                int numPix = (int)((double)(100000.0f / pixSzMM) + 0.5);
                int denom = 10000;
                long[] rational = new long[]{numPix, denom};
                TIFFField[] fields = new TIFFField[]{new TIFFField(296, 3, 1, new char[]{'\u0003'}), new TIFFField(282, 5, 1, new long[][]{rational}), new TIFFField(283, 5, 1, new long[][]{rational})};
                encodeParams.setExtraFields(fields);
            }
        }
        return encodeParams;
    }

    public String getMIMEType() {
        return "image/tiff";
    }

    public MultiImageWriter createMultiImageWriter(OutputStream out) throws IOException {
        return new TIFFMultiImageWriter(out);
    }

    public boolean supportsMultiImageWriter() {
        return true;
    }

    private class TIFFMultiImageWriter
    implements MultiImageWriter {
        private OutputStream out;
        private TIFFEncodeParam encodeParams;
        private TIFFImageEncoder encoder;
        private Object context;

        public TIFFMultiImageWriter(OutputStream out) throws IOException {
            this.out = out;
        }

        public void writeImage(RenderedImage image2, ImageWriterParams params) throws IOException {
            if (this.encoder == null) {
                this.encodeParams = TIFFImageWriter.this.createTIFFEncodeParams(params);
                this.encoder = new TIFFImageEncoder(this.out, this.encodeParams);
            }
            this.context = this.encoder.encodeMultiple(this.context, image2);
        }

        public void close() throws IOException {
            if (this.encoder != null) {
                this.encoder.finishMultiple(this.context);
            }
            this.encoder = null;
            this.encodeParams = null;
            this.out.flush();
        }
    }
}

