/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.functions;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.Properties;
import javax.xml.transform.TransformerException;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xpath.XPathContext;
import org.apache.xpath.functions.FunctionOneArg;
import org.apache.xpath.functions.ObjectFactory;
import org.apache.xpath.functions.SecuritySupport;
import org.apache.xpath.objects.XNumber;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.objects.XString;

public class FuncSystemProperty
extends FunctionOneArg {
    static String XSLT_PROPERTIES = "org/apache/xalan/res/XSLTInfo.properties";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public XObject execute(XPathContext xctxt) throws TransformerException {
        String result2;
        String propName;
        block12: {
            String fullName;
            block13: {
                fullName = this.m_arg0.execute(xctxt).str();
                int indexOfNSSep = fullName.indexOf(58);
                propName = "";
                Properties xsltInfo = new Properties();
                this.loadPropertyFile(XSLT_PROPERTIES, xsltInfo);
                if (indexOfNSSep <= 0) break block13;
                String prefix = indexOfNSSep >= 0 ? fullName.substring(0, indexOfNSSep) : "";
                String namespace = xctxt.getNamespaceContext().getNamespaceForPrefix(prefix);
                String string2 = propName = indexOfNSSep < 0 ? fullName : fullName.substring(indexOfNSSep + 1);
                if (namespace.startsWith("http://www.w3.org/XSL/Transform") || namespace.equals("http://www.w3.org/1999/XSL/Transform")) {
                    result2 = xsltInfo.getProperty(propName);
                    if (null == result2) {
                        this.warn(xctxt, "WG_PROPERTY_NOT_SUPPORTED", new Object[]{fullName});
                        return XString.EMPTYSTRING;
                    }
                    break block12;
                } else {
                    this.warn(xctxt, "WG_DONT_DO_ANYTHING_WITH_NS", new Object[]{namespace, fullName});
                    try {
                        result2 = System.getProperty(propName);
                        if (null == result2) {
                            return XString.EMPTYSTRING;
                        }
                        break block12;
                    }
                    catch (SecurityException se) {
                        this.warn(xctxt, "WG_SECURITY_EXCEPTION", new Object[]{fullName});
                        return XString.EMPTYSTRING;
                    }
                }
            }
            try {
                result2 = System.getProperty(fullName);
                if (null == result2) {
                    return XString.EMPTYSTRING;
                }
            }
            catch (SecurityException se) {
                this.warn(xctxt, "WG_SECURITY_EXCEPTION", new Object[]{fullName});
                return XString.EMPTYSTRING;
            }
        }
        if (propName.equals("version") && result2.length() > 0) {
            try {
                return new XNumber(1.0);
            }
            catch (Exception ex) {
                return new XString(result2);
            }
        }
        return new XString(result2);
    }

    public void loadPropertyFile(String file, Properties target) {
        try {
            SecuritySupport ss = SecuritySupport.getInstance();
            InputStream is = ss.getResourceAsStream(ObjectFactory.findClassLoader(), file);
            BufferedInputStream bis = new BufferedInputStream(is);
            target.load(bis);
            bis.close();
        }
        catch (Exception ex) {
            throw new WrappedRuntimeException(ex);
        }
    }
}

