/*
 * Decompiled with CFR 0.152.
 */
package org.gedcom4j.relationship;

import java.util.ArrayList;
import java.util.List;
import org.gedcom4j.model.Individual;
import org.gedcom4j.relationship.SimpleRelationship;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Relationship
implements Comparable<Relationship> {
    public List<SimpleRelationship> chain = new ArrayList<SimpleRelationship>();
    public Individual individual1;
    public Individual individual2;

    public Relationship() {
    }

    public Relationship(Individual startingIndividual, Individual targetIndividual, List<SimpleRelationship> chain2) {
        this.individual1 = startingIndividual;
        this.individual2 = targetIndividual;
        this.chain.clear();
        for (SimpleRelationship sr : chain2) {
            this.chain.add(new SimpleRelationship(sr));
        }
    }

    @Override
    public int compareTo(Relationship other) {
        if (other == null) {
            return 1;
        }
        return Math.round(Math.signum(this.chain.size() - other.chain.size()));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Relationship)) {
            return false;
        }
        Relationship other = (Relationship)obj;
        if (this.chain == null ? other.chain != null : !((Object)this.chain).equals(other.chain)) {
            return false;
        }
        if (this.individual1 == null ? other.individual1 != null : !this.individual1.equals(other.individual1)) {
            return false;
        }
        return !(this.individual2 == null ? other.individual2 != null : !this.individual2.equals(other.individual2));
    }

    public int getTotalSimplicity() {
        int result2 = 0;
        for (SimpleRelationship sr : this.chain) {
            result2 += sr.name.simplicity;
        }
        return result2;
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.chain == null ? 0 : ((Object)this.chain).hashCode());
        result2 = 31 * result2 + (this.individual1 == null ? 0 : this.individual1.hashCode());
        result2 = 31 * result2 + (this.individual2 == null ? 0 : this.individual2.hashCode());
        return result2;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("<");
        boolean first = true;
        for (SimpleRelationship sr : this.chain) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            if (sr.individual1.names.isEmpty()) {
                sb.append("Unknown");
            } else {
                sb.append(sr.individual1.names.get(0));
            }
            sb.append("'s ").append((Object)sr.name).append(" ");
            if (sr.individual2.names.isEmpty()) {
                sb.append("Unknown");
                continue;
            }
            sb.append(sr.individual2.names.get(0));
        }
        sb.append(">, ").append(this.chain.size()).append(" step(s)");
        return sb.toString();
    }
}

