/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.Serializable;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.InterpretedFunction;
import org.mozilla.javascript.InterpreterData;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.NativeCall;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.NodeTransformer;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.Ref;
import org.mozilla.javascript.RegExpProxy;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptOrFnNode;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.SecurityUtilities;
import org.mozilla.javascript.UintMap;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.UniqueTag;
import org.mozilla.javascript.continuations.Continuation;
import org.mozilla.javascript.debug.DebugFrame;

public class Interpreter {
    private static final int Icode_DUP = -1;
    private static final int Icode_DUP2 = -2;
    private static final int Icode_SWAP = -3;
    private static final int Icode_POP = -4;
    private static final int Icode_POP_RESULT = -5;
    private static final int Icode_IFEQ_POP = -6;
    private static final int Icode_VAR_INC_DEC = -7;
    private static final int Icode_NAME_INC_DEC = -8;
    private static final int Icode_PROP_INC_DEC = -9;
    private static final int Icode_ELEM_INC_DEC = -10;
    private static final int Icode_REF_INC_DEC = -11;
    private static final int Icode_SCOPE_LOAD = -12;
    private static final int Icode_SCOPE_SAVE = -13;
    private static final int Icode_TYPEOFNAME = -14;
    private static final int Icode_NAME_AND_THIS = -15;
    private static final int Icode_PROP_AND_THIS = -16;
    private static final int Icode_ELEM_AND_THIS = -17;
    private static final int Icode_VALUE_AND_THIS = -18;
    private static final int Icode_CLOSURE_EXPR = -19;
    private static final int Icode_CLOSURE_STMT = -20;
    private static final int Icode_CALLSPECIAL = -21;
    private static final int Icode_RETUNDEF = -22;
    private static final int Icode_GOSUB = -23;
    private static final int Icode_STARTSUB = -24;
    private static final int Icode_RETSUB = -25;
    private static final int Icode_LINE = -26;
    private static final int Icode_SHORTNUMBER = -27;
    private static final int Icode_INTNUMBER = -28;
    private static final int Icode_LITERAL_NEW = -29;
    private static final int Icode_LITERAL_SET = -30;
    private static final int Icode_SPARE_ARRAYLIT = -31;
    private static final int Icode_REG_IND_C0 = -32;
    private static final int Icode_REG_IND_C1 = -33;
    private static final int Icode_REG_IND_C2 = -34;
    private static final int Icode_REG_IND_C3 = -35;
    private static final int Icode_REG_IND_C4 = -36;
    private static final int Icode_REG_IND_C5 = -37;
    private static final int Icode_REG_IND1 = -38;
    private static final int Icode_REG_IND2 = -39;
    private static final int Icode_REG_IND4 = -40;
    private static final int Icode_REG_STR_C0 = -41;
    private static final int Icode_REG_STR_C1 = -42;
    private static final int Icode_REG_STR_C2 = -43;
    private static final int Icode_REG_STR_C3 = -44;
    private static final int Icode_REG_STR1 = -45;
    private static final int Icode_REG_STR2 = -46;
    private static final int Icode_REG_STR4 = -47;
    private static final int Icode_GETVAR1 = -48;
    private static final int Icode_SETVAR1 = -49;
    private static final int Icode_UNDEF = -50;
    private static final int Icode_ZERO = -51;
    private static final int Icode_ONE = -52;
    private static final int Icode_ENTERDQ = -53;
    private static final int Icode_LEAVEDQ = -54;
    private static final int Icode_TAIL_CALL = -55;
    private static final int Icode_LOCAL_CLEAR = -56;
    private static final int MIN_ICODE = -56;
    private CompilerEnvirons compilerEnv;
    private boolean itsInFunctionFlag;
    private InterpreterData itsData;
    private ScriptOrFnNode scriptOrFn;
    private int itsICodeTop;
    private int itsStackDepth;
    private int itsLineNumber;
    private int itsDoubleTableTop;
    private ObjToIntMap itsStrings = new ObjToIntMap(20);
    private int itsLocalTop;
    private static final int MIN_LABEL_TABLE_SIZE = 32;
    private static final int MIN_FIXUP_TABLE_SIZE = 40;
    private int[] itsLabelTable;
    private int itsLabelTableTop;
    private long[] itsFixupTable;
    private int itsFixupTableTop;
    private ObjArray itsLiteralIds = new ObjArray();
    private int itsExceptionTableTop;
    private static final int EXCEPTION_TRY_START_SLOT = 0;
    private static final int EXCEPTION_TRY_END_SLOT = 1;
    private static final int EXCEPTION_HANDLER_SLOT = 2;
    private static final int EXCEPTION_TYPE_SLOT = 3;
    private static final int EXCEPTION_LOCAL_SLOT = 4;
    private static final int EXCEPTION_SCOPE_SLOT = 5;
    private static final int EXCEPTION_SLOT_SIZE = 6;
    private static final int ECF_TAIL = 1;

    private static String bytecodeName(int n) {
        if (!Interpreter.validBytecode(n)) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        return String.valueOf(n);
    }

    private static boolean validIcode(int n) {
        return -56 <= n && n <= -1;
    }

    private static boolean validTokenCode(int n) {
        return 2 <= n && n <= 76;
    }

    private static boolean validBytecode(int n) {
        return Interpreter.validIcode(n) || Interpreter.validTokenCode(n);
    }

    public Object compile(CompilerEnvirons compilerEnvirons, ScriptOrFnNode scriptOrFnNode, String string2, boolean bl) {
        this.compilerEnv = compilerEnvirons;
        new NodeTransformer().transform(scriptOrFnNode);
        if (bl) {
            scriptOrFnNode = scriptOrFnNode.getFunctionNode(0);
        }
        this.scriptOrFn = scriptOrFnNode;
        this.itsData = new InterpreterData(compilerEnvirons.getLanguageVersion(), this.scriptOrFn.getSourceName(), string2);
        this.itsData.topLevel = true;
        if (bl) {
            this.generateFunctionICode();
        } else {
            this.generateICodeFromTree(this.scriptOrFn);
        }
        return this.itsData;
    }

    public Script createScriptObject(Object object, Object object2) {
        if (object != this.itsData) {
            Kit.codeBug();
        }
        return InterpretedFunction.createScript(this.itsData, object2);
    }

    public Function createFunctionObject(Context context, Scriptable scriptable, Object object, Object object2) {
        if (object != this.itsData) {
            Kit.codeBug();
        }
        return InterpretedFunction.createFunction(context, scriptable, this.itsData, object2);
    }

    private void generateFunctionICode() {
        this.itsInFunctionFlag = true;
        FunctionNode functionNode = (FunctionNode)this.scriptOrFn;
        this.itsData.itsFunctionType = functionNode.getFunctionType();
        this.itsData.itsNeedsActivation = functionNode.requiresActivation();
        this.itsData.itsName = functionNode.getFunctionName();
        if (!functionNode.getIgnoreDynamicScope() && this.compilerEnv.isUseDynamicScope()) {
            this.itsData.useDynamicScope = true;
        }
        this.generateICodeFromTree(functionNode.getLastChild());
    }

    private void generateICodeFromTree(Node node) {
        Object object;
        this.generateNestedFunctions();
        this.generateRegExpLiterals();
        this.visitStatement(node);
        this.fixLabelGotos();
        if (this.itsData.itsFunctionType == 0) {
            this.addToken(62);
        }
        if (this.itsData.itsICode.length != this.itsICodeTop) {
            object = new byte[this.itsICodeTop];
            System.arraycopy(this.itsData.itsICode, 0, object, 0, this.itsICodeTop);
            this.itsData.itsICode = object;
        }
        if (this.itsStrings.size() == 0) {
            this.itsData.itsStringTable = null;
        } else {
            this.itsData.itsStringTable = new String[this.itsStrings.size()];
            object = this.itsStrings.newIterator();
            ((ObjToIntMap.Iterator)object).start();
            while (!((ObjToIntMap.Iterator)object).done()) {
                String string2 = (String)((ObjToIntMap.Iterator)object).getKey();
                int n = ((ObjToIntMap.Iterator)object).getValue();
                if (this.itsData.itsStringTable[n] != null) {
                    Kit.codeBug();
                }
                this.itsData.itsStringTable[n] = string2;
                ((ObjToIntMap.Iterator)object).next();
            }
        }
        if (this.itsDoubleTableTop == 0) {
            this.itsData.itsDoubleTable = null;
        } else if (this.itsData.itsDoubleTable.length != this.itsDoubleTableTop) {
            object = new double[this.itsDoubleTableTop];
            System.arraycopy(this.itsData.itsDoubleTable, 0, object, 0, this.itsDoubleTableTop);
            this.itsData.itsDoubleTable = (double[])object;
        }
        if (this.itsExceptionTableTop != 0 && this.itsData.itsExceptionTable.length != this.itsExceptionTableTop) {
            object = new int[this.itsExceptionTableTop];
            System.arraycopy(this.itsData.itsExceptionTable, 0, object, 0, this.itsExceptionTableTop);
            this.itsData.itsExceptionTable = (int[])object;
        }
        this.itsData.itsMaxVars = this.scriptOrFn.getParamAndVarCount();
        this.itsData.itsMaxFrameArray = this.itsData.itsMaxVars + this.itsData.itsMaxLocals + this.itsData.itsMaxStack;
        this.itsData.argNames = this.scriptOrFn.getParamAndVarNames();
        this.itsData.argCount = this.scriptOrFn.getParamCount();
        this.itsData.encodedSourceStart = this.scriptOrFn.getEncodedSourceStart();
        this.itsData.encodedSourceEnd = this.scriptOrFn.getEncodedSourceEnd();
        if (this.itsLiteralIds.size() != 0) {
            this.itsData.literalIds = this.itsLiteralIds.toArray();
        }
    }

    private void generateNestedFunctions() {
        int n = this.scriptOrFn.getFunctionCount();
        if (n == 0) {
            return;
        }
        InterpreterData[] interpreterDataArray = new InterpreterData[n];
        for (int i = 0; i != n; ++i) {
            FunctionNode functionNode = this.scriptOrFn.getFunctionNode(i);
            Interpreter interpreter = new Interpreter();
            interpreter.compilerEnv = this.compilerEnv;
            interpreter.scriptOrFn = functionNode;
            interpreter.itsData = new InterpreterData(this.itsData);
            interpreter.generateFunctionICode();
            interpreterDataArray[i] = interpreter.itsData;
        }
        this.itsData.itsNestedFunctions = interpreterDataArray;
    }

    private void generateRegExpLiterals() {
        int n = this.scriptOrFn.getRegexpCount();
        if (n == 0) {
            return;
        }
        Context context = Context.getContext();
        RegExpProxy regExpProxy = ScriptRuntime.checkRegExpProxy(context);
        Object[] objectArray = new Object[n];
        for (int i = 0; i != n; ++i) {
            String string2 = this.scriptOrFn.getRegexpString(i);
            String string3 = this.scriptOrFn.getRegexpFlags(i);
            objectArray[i] = regExpProxy.compileRegExp(context, string2, string3);
        }
        this.itsData.itsRegExpLiterals = objectArray;
    }

    private void updateLineNumber(Node node) {
        int n = node.getLineno();
        if (n != this.itsLineNumber && n >= 0) {
            if (this.itsData.firstLinePC < 0) {
                this.itsData.firstLinePC = n;
            }
            this.itsLineNumber = n;
            this.addIcode(-26);
            this.addUint16(n & 0xFFFF);
        }
    }

    private RuntimeException badTree(Node node) {
        throw new RuntimeException(node.toString());
    }

    private void visitStatement(Node node) {
        int n = node.getType();
        switch (n) {
            case 105: {
                int n2 = node.getExistingIntProp(1);
                int n3 = this.scriptOrFn.getFunctionNode(n2).getFunctionType();
                if (n3 == 3) {
                    this.addIndexOp(-20, n2);
                    break;
                }
                if (n3 == 1) break;
                throw Kit.codeBug();
            }
            case 119: 
            case 124: 
            case 125: 
            case 126: 
            case 128: 
            case 132: {
                Node node2;
                this.updateLineNumber(node);
                for (node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
                    this.visitStatement(node2);
                }
                break;
            }
            case 2: {
                Node node2;
                this.visitExpression(node2, 0);
                this.addToken(2);
                this.stackChange(-1);
                break;
            }
            case 3: {
                this.addToken(3);
                break;
            }
            case 137: {
                Node node2;
                int n4 = this.allocLocal();
                node.putIntProp(2, n4);
                this.updateLineNumber(node);
                while (node2 != null) {
                    this.visitStatement(node2);
                    node2 = node2.getNext();
                }
                this.addIndexOp(-56, n4);
                this.releaseLocal(n4);
                break;
            }
            case 110: {
                Node node2;
                this.updateLineNumber(node);
                this.visitExpression(node2, 0);
                for (Node.Jump jump = (Node.Jump)node2.getNext(); jump != null; jump = (Node.Jump)jump.getNext()) {
                    if (jump.getType() != 111) {
                        throw this.badTree(jump);
                    }
                    Node node3 = jump.getFirstChild();
                    this.addIcode(-1);
                    this.stackChange(1);
                    this.visitExpression(node3, 0);
                    this.addToken(45);
                    this.stackChange(-1);
                    this.addGoto(jump.target, -6);
                    this.stackChange(-1);
                }
                this.addIcode(-4);
                this.stackChange(-1);
                break;
            }
            case 127: {
                this.markTargetLabel(node);
                break;
            }
            case 6: 
            case 7: {
                Node node2;
                Node node4 = ((Node.Jump)node).target;
                this.visitExpression(node2, 0);
                this.addGoto(node4, n);
                this.stackChange(-1);
                break;
            }
            case 5: {
                Node node5 = ((Node.Jump)node).target;
                this.addGoto(node5, n);
                break;
            }
            case 131: {
                Node node6 = ((Node.Jump)node).target;
                this.addGoto(node6, -23);
                break;
            }
            case 121: {
                Node node2;
                this.stackChange(1);
                int n5 = this.getLocalBlockRef(node);
                this.addIndexOp(-24, n5);
                this.stackChange(-1);
                while (node2 != null) {
                    this.visitStatement(node2);
                    node2 = node2.getNext();
                }
                this.addIndexOp(-25, n5);
                break;
            }
            case 129: 
            case 130: {
                Node node2;
                this.updateLineNumber(node);
                this.visitExpression(node2, 0);
                this.addIcode(n == 129 ? -4 : -5);
                this.stackChange(-1);
                break;
            }
            case 77: {
                Node node7;
                Node node2;
                Node.Jump jump = (Node.Jump)node;
                int n6 = this.getLocalBlockRef(jump);
                int n7 = this.allocLocal();
                this.addIndexOp(-13, n7);
                int n8 = this.itsICodeTop;
                while (node2 != null) {
                    this.visitStatement(node2);
                    node2 = node2.getNext();
                }
                Node node8 = jump.target;
                if (node8 != null) {
                    int n9 = this.itsLabelTable[this.getTargetLabel(node8)];
                    this.addExceptionHandler(n8, n9, n9, false, n6, n7);
                }
                if ((node7 = jump.getFinally()) != null) {
                    int n10 = this.itsLabelTable[this.getTargetLabel(node7)];
                    this.addExceptionHandler(n8, n10, n10, true, n6, n7);
                }
                this.addIndexOp(-56, n7);
                this.releaseLocal(n7);
                break;
            }
            case 56: {
                Node node2;
                int n11 = this.getLocalBlockRef(node);
                int n12 = node.getExistingIntProp(14);
                String string2 = node2.getString();
                node2 = node2.getNext();
                this.visitExpression(node2, 0);
                this.addStringPrefix(string2);
                this.addIndexPrefix(n11);
                this.addToken(56);
                this.addUint8(n12 != 0 ? 1 : 0);
                this.stackChange(-1);
                break;
            }
            case 49: {
                Node node2;
                this.updateLineNumber(node);
                this.visitExpression(node2, 0);
                this.addToken(49);
                this.addUint16(this.itsLineNumber & 0xFFFF);
                this.stackChange(-1);
                break;
            }
            case 50: {
                this.updateLineNumber(node);
                this.addIndexOp(50, this.getLocalBlockRef(node));
                break;
            }
            case 4: {
                Node node2;
                this.updateLineNumber(node);
                if (node2 != null) {
                    this.visitExpression(node2, 1);
                    this.addToken(4);
                    this.stackChange(-1);
                    break;
                }
                this.addIcode(-22);
                break;
            }
            case 62: {
                this.updateLineNumber(node);
                this.addToken(62);
                break;
            }
            case 57: 
            case 58: {
                Node node2;
                this.visitExpression(node2, 0);
                this.addIndexOp(n, this.getLocalBlockRef(node));
                this.stackChange(-1);
                break;
            }
            default: {
                throw this.badTree(node);
            }
        }
        if (this.itsStackDepth != 0) {
            throw Kit.codeBug();
        }
    }

    private void visitExpression(Node node, int n) {
        int n2 = node.getType();
        int n3 = this.itsStackDepth;
        switch (n2) {
            case 105: {
                int n4 = node.getExistingIntProp(1);
                FunctionNode functionNode = this.scriptOrFn.getFunctionNode(n4);
                if (functionNode.getFunctionType() != 2) {
                    throw Kit.codeBug();
                }
                this.addIndexOp(-19, n4);
                this.stackChange(1);
                break;
            }
            case 53: {
                int n5 = this.getLocalBlockRef(node);
                this.addIndexOp(53, n5);
                this.stackChange(1);
                break;
            }
            case 85: {
                Node node2;
                Node node3 = node.getLastChild();
                for (node2 = node.getFirstChild(); node2 != node3; node2 = node2.getNext()) {
                    this.visitExpression(node2, 0);
                    this.addIcode(-4);
                    this.stackChange(-1);
                }
                this.visitExpression(node2, n & 1);
                break;
            }
            case 134: {
                this.stackChange(1);
                break;
            }
            case 30: 
            case 37: 
            case 68: {
                Node node2;
                if (n2 == 30) {
                    this.visitExpression(node2, 0);
                } else {
                    this.generateCallFunAndThis(node2);
                }
                int n6 = 0;
                while ((node2 = node2.getNext()) != null) {
                    this.visitExpression(node2, 0);
                    ++n6;
                }
                int n7 = node.getIntProp(10, 0);
                if (n7 != 0) {
                    this.addIndexOp(-21, n6);
                    this.addUint8(n7);
                    this.addUint8(n2 == 30 ? 1 : 0);
                    this.addUint16(this.itsLineNumber & 0xFFFF);
                } else {
                    if (n2 == 37 && (n & 1) != 0) {
                        n2 = -55;
                    }
                    this.addIndexOp(n2, n6);
                }
                if (n2 == 30) {
                    this.stackChange(-n6);
                } else {
                    this.stackChange(-1 - n6);
                }
                if (n6 <= this.itsData.itsMaxCalleeArgs) break;
                this.itsData.itsMaxCalleeArgs = n6;
                break;
            }
            case 100: 
            case 101: {
                Node node2;
                this.visitExpression(node2, 0);
                this.addIcode(-1);
                this.stackChange(1);
                int n8 = this.itsICodeTop;
                int n9 = n2 == 101 ? 7 : 6;
                this.addGotoOp(n9);
                this.stackChange(-1);
                this.addIcode(-4);
                this.stackChange(-1);
                node2 = node2.getNext();
                this.visitExpression(node2, n & 1);
                this.resolveForwardGoto(n8);
                break;
            }
            case 98: {
                Node node2;
                Node node4 = node2.getNext();
                Node node5 = node4.getNext();
                this.visitExpression(node2, 0);
                int n10 = this.itsICodeTop;
                this.addGotoOp(7);
                this.stackChange(-1);
                this.visitExpression(node4, n & 1);
                int n11 = this.itsICodeTop;
                this.addGotoOp(5);
                this.resolveForwardGoto(n10);
                this.itsStackDepth = n3;
                this.visitExpression(node5, n & 1);
                this.resolveForwardGoto(n11);
                break;
            }
            case 33: {
                Node node2;
                this.visitExpression(node2, 0);
                node2 = node2.getNext();
                this.addStringOp(33, node2.getString());
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 31: 
            case 35: 
            case 45: 
            case 46: 
            case 51: 
            case 52: {
                Node node2;
                this.visitExpression(node2, 0);
                node2 = node2.getNext();
                this.visitExpression(node2, 0);
                this.addToken(n2);
                this.stackChange(-1);
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 122: {
                Node node2;
                this.visitExpression(node2, 0);
                if (n2 == 122) {
                    this.addIcode(-4);
                    this.addIcode(-50);
                    break;
                }
                this.addToken(n2);
                break;
            }
            case 65: 
            case 67: {
                Node node2;
                this.visitExpression(node2, 0);
                this.addToken(n2);
                break;
            }
            case 34: 
            case 135: {
                Node node2;
                this.visitExpression(node2, 0);
                node2 = node2.getNext();
                String string2 = node2.getString();
                node2 = node2.getNext();
                if (n2 == 135) {
                    this.addIcode(-1);
                    this.stackChange(1);
                    this.addStringOp(33, string2);
                    this.stackChange(-1);
                }
                this.visitExpression(node2, 0);
                this.addStringOp(34, string2);
                this.stackChange(-1);
                break;
            }
            case 36: 
            case 136: {
                Node node2;
                this.visitExpression(node2, 0);
                node2 = node2.getNext();
                this.visitExpression(node2, 0);
                node2 = node2.getNext();
                if (n2 == 136) {
                    this.addIcode(-2);
                    this.stackChange(2);
                    this.addToken(35);
                    this.stackChange(-1);
                    this.stackChange(-1);
                }
                this.visitExpression(node2, 0);
                this.addToken(36);
                this.stackChange(-2);
                break;
            }
            case 66: 
            case 138: {
                Node node2;
                this.visitExpression(node2, 0);
                node2 = node2.getNext();
                if (n2 == 138) {
                    this.addIcode(-1);
                    this.stackChange(1);
                    this.addToken(65);
                    this.stackChange(-1);
                }
                this.visitExpression(node2, 0);
                this.addToken(66);
                this.stackChange(-1);
                break;
            }
            case 8: {
                Node node2;
                String string3 = node2.getString();
                this.visitExpression(node2, 0);
                node2 = node2.getNext();
                this.visitExpression(node2, 0);
                this.addStringOp(8, string3);
                this.stackChange(-1);
                break;
            }
            case 133: {
                String string4 = node.getString();
                int n12 = -1;
                if (this.itsInFunctionFlag && !this.itsData.itsNeedsActivation) {
                    n12 = this.scriptOrFn.getParamOrVarIndex(string4);
                }
                if (n12 == -1) {
                    this.addStringOp(-14, string4);
                    this.stackChange(1);
                    break;
                }
                this.addVarOp(54, n12);
                this.stackChange(1);
                this.addToken(32);
                break;
            }
            case 38: 
            case 40: 
            case 48: {
                this.addStringOp(n2, node.getString());
                this.stackChange(1);
                break;
            }
            case 102: 
            case 103: {
                Node node2;
                this.visitIncDec(node, node2);
                break;
            }
            case 39: {
                double d = node.getDouble();
                int n13 = (int)d;
                if ((double)n13 == d) {
                    if (n13 == 0) {
                        this.addIcode(-51);
                        if (1.0 / d < 0.0) {
                            this.addToken(29);
                        }
                    } else if (n13 == 1) {
                        this.addIcode(-52);
                    } else if ((short)n13 == n13) {
                        this.addIcode(-27);
                        this.addUint16(n13 & 0xFFFF);
                    } else {
                        this.addIcode(-28);
                        this.addInt(n13);
                    }
                } else {
                    int n14 = this.getDoubleIndex(d);
                    this.addIndexOp(39, n14);
                }
                this.stackChange(1);
                break;
            }
            case 54: {
                if (this.itsData.itsNeedsActivation) {
                    Kit.codeBug();
                }
                String string5 = node.getString();
                int n15 = this.scriptOrFn.getParamOrVarIndex(string5);
                this.addVarOp(54, n15);
                this.stackChange(1);
                break;
            }
            case 55: {
                Node node2;
                if (this.itsData.itsNeedsActivation) {
                    Kit.codeBug();
                }
                String string6 = node2.getString();
                node2 = node2.getNext();
                this.visitExpression(node2, 0);
                int n16 = this.scriptOrFn.getParamOrVarIndex(string6);
                this.addVarOp(55, n16);
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 61: {
                this.addToken(n2);
                this.stackChange(1);
                break;
            }
            case 59: 
            case 60: {
                this.addIndexOp(n2, this.getLocalBlockRef(node));
                this.stackChange(1);
                break;
            }
            case 47: {
                int n17 = node.getExistingIntProp(4);
                this.addIndexOp(47, n17);
                this.stackChange(1);
                break;
            }
            case 63: 
            case 64: {
                Node node2;
                this.visitLiteral(node, node2);
                break;
            }
            case 69: {
                Node node2;
                this.visitExpression(node2, 0);
                this.addStringOp(n2, (String)node.getProp(17));
                break;
            }
            case 73: 
            case 74: 
            case 75: 
            case 76: {
                Node node2;
                int n18 = node.getIntProp(16, 0);
                int n19 = 0;
                do {
                    this.visitExpression(node2, 0);
                    ++n19;
                } while ((node2 = node2.getNext()) != null);
                this.addIndexOp(n2, n18);
                this.stackChange(1 - n19);
                break;
            }
            case 142: {
                Node node2;
                this.updateLineNumber(node);
                this.visitExpression(node2, 0);
                this.addIcode(-53);
                this.stackChange(-1);
                int n20 = this.itsICodeTop;
                this.visitExpression(node2.getNext(), 0);
                this.addBackwardGoto(-54, n20);
                break;
            }
            case 70: 
            case 71: 
            case 72: {
                Node node2;
                this.visitExpression(node2, 0);
                this.addToken(n2);
                break;
            }
            default: {
                throw this.badTree(node);
            }
        }
        if (n3 + 1 != this.itsStackDepth) {
            Kit.codeBug();
        }
    }

    private void generateCallFunAndThis(Node node) {
        int n = node.getType();
        switch (n) {
            case 38: {
                String string2 = node.getString();
                this.addStringOp(-15, string2);
                this.stackChange(2);
                break;
            }
            case 33: 
            case 35: {
                Node node2 = node.getFirstChild();
                this.visitExpression(node2, 0);
                Node node3 = node2.getNext();
                if (n == 33) {
                    String string3 = node3.getString();
                    this.addStringOp(-16, string3);
                    this.stackChange(1);
                    break;
                }
                this.visitExpression(node3, 0);
                this.addIcode(-17);
                break;
            }
            default: {
                this.visitExpression(node, 0);
                this.addIcode(-18);
                this.stackChange(1);
            }
        }
    }

    private void visitIncDec(Node node, Node node2) {
        int n = node.getExistingIntProp(13);
        int n2 = node2.getType();
        switch (n2) {
            case 54: {
                if (this.itsData.itsNeedsActivation) {
                    Kit.codeBug();
                }
                String string2 = node2.getString();
                int n3 = this.scriptOrFn.getParamOrVarIndex(string2);
                this.addVarOp(-7, n3);
                this.addUint8(n);
                this.stackChange(1);
                break;
            }
            case 38: {
                String string3 = node2.getString();
                this.addStringOp(-8, string3);
                this.addUint8(n);
                this.stackChange(1);
                break;
            }
            case 33: {
                Node node3 = node2.getFirstChild();
                this.visitExpression(node3, 0);
                String string4 = node3.getNext().getString();
                this.addStringOp(-9, string4);
                this.addUint8(n);
                break;
            }
            case 35: {
                Node node4 = node2.getFirstChild();
                this.visitExpression(node4, 0);
                Node node5 = node4.getNext();
                this.visitExpression(node5, 0);
                this.addIcode(-10);
                this.addUint8(n);
                this.stackChange(-1);
                break;
            }
            case 65: {
                Node node6 = node2.getFirstChild();
                this.visitExpression(node6, 0);
                this.addIcode(-11);
                this.addUint8(n);
                break;
            }
            default: {
                throw this.badTree(node);
            }
        }
    }

    private void visitLiteral(Node node, Node node2) {
        Object object;
        int n;
        int n2 = node.getType();
        Object[] objectArray = null;
        if (n2 == 63) {
            n = 0;
            for (object = node2; object != null; object = ((Node)object).getNext()) {
                ++n;
            }
        } else if (n2 == 64) {
            objectArray = (Object[])node.getProp(12);
            n = objectArray.length;
        } else {
            throw this.badTree(node);
        }
        this.addIndexOp(-29, n);
        this.stackChange(1);
        while (node2 != null) {
            this.visitExpression(node2, 0);
            this.addIcode(-30);
            this.stackChange(-1);
            node2 = node2.getNext();
        }
        if (n2 == 63) {
            object = (int[])node.getProp(11);
            if (object == null) {
                this.addToken(63);
            } else {
                int n3 = this.itsLiteralIds.size();
                this.itsLiteralIds.add(object);
                this.addIndexOp(-31, n3);
            }
        } else {
            int n4 = this.itsLiteralIds.size();
            this.itsLiteralIds.add(objectArray);
            this.addIndexOp(64, n4);
        }
    }

    private int getLocalBlockRef(Node node) {
        Node node2 = (Node)node.getProp(3);
        return node2.getExistingIntProp(2);
    }

    private int getTargetLabel(Node node) {
        int n = node.labelId();
        if (n != -1) {
            return n;
        }
        n = this.itsLabelTableTop;
        if (this.itsLabelTable == null || n == this.itsLabelTable.length) {
            if (this.itsLabelTable == null) {
                this.itsLabelTable = new int[32];
            } else {
                int[] nArray = new int[this.itsLabelTable.length * 2];
                System.arraycopy(this.itsLabelTable, 0, nArray, 0, n);
                this.itsLabelTable = nArray;
            }
        }
        this.itsLabelTableTop = n + 1;
        this.itsLabelTable[n] = -1;
        node.labelId(n);
        return n;
    }

    private void markTargetLabel(Node node) {
        int n = this.getTargetLabel(node);
        if (this.itsLabelTable[n] != -1) {
            Kit.codeBug();
        }
        this.itsLabelTable[n] = this.itsICodeTop;
    }

    private void addGoto(Node node, int n) {
        int n2;
        int n3 = this.getTargetLabel(node);
        if (n3 >= this.itsLabelTableTop) {
            Kit.codeBug();
        }
        if ((n2 = this.itsLabelTable[n3]) != -1) {
            this.addBackwardGoto(n, n2);
        } else {
            int n4 = this.itsICodeTop;
            this.addGotoOp(n);
            int n5 = this.itsFixupTableTop;
            if (this.itsFixupTable == null || n5 == this.itsFixupTable.length) {
                if (this.itsFixupTable == null) {
                    this.itsFixupTable = new long[40];
                } else {
                    long[] lArray = new long[this.itsFixupTable.length * 2];
                    System.arraycopy(this.itsFixupTable, 0, lArray, 0, n5);
                    this.itsFixupTable = lArray;
                }
            }
            this.itsFixupTableTop = n5 + 1;
            this.itsFixupTable[n5] = (long)n3 << 32 | (long)n4;
        }
    }

    private void fixLabelGotos() {
        for (int i = 0; i < this.itsFixupTableTop; ++i) {
            long l = this.itsFixupTable[i];
            int n = (int)(l >> 32);
            int n2 = (int)l;
            int n3 = this.itsLabelTable[n];
            if (n3 == -1) {
                throw Kit.codeBug();
            }
            this.resolveGoto(n2, n3);
        }
        this.itsFixupTableTop = 0;
    }

    private void addBackwardGoto(int n, int n2) {
        int n3 = this.itsICodeTop;
        if (n3 <= n2) {
            throw Kit.codeBug();
        }
        this.addGotoOp(n);
        this.resolveGoto(n3, n2);
    }

    private void resolveForwardGoto(int n) {
        if (this.itsICodeTop < n + 3) {
            throw Kit.codeBug();
        }
        this.resolveGoto(n, this.itsICodeTop);
    }

    private void resolveGoto(int n, int n2) {
        int n3 = n2 - n;
        if (0 <= n3 && n3 <= 2) {
            throw Kit.codeBug();
        }
        int n4 = n + 1;
        if (n3 != (short)n3) {
            if (this.itsData.longJumps == null) {
                this.itsData.longJumps = new UintMap();
            }
            this.itsData.longJumps.put(n4, n2);
            n3 = 0;
        }
        byte[] byArray = this.itsData.itsICode;
        byArray[n4] = (byte)(n3 >> 8);
        byArray[n4 + 1] = (byte)n3;
    }

    private void addToken(int n) {
        if (!Interpreter.validTokenCode(n)) {
            throw Kit.codeBug();
        }
        this.addUint8(n);
    }

    private void addIcode(int n) {
        if (!Interpreter.validIcode(n)) {
            throw Kit.codeBug();
        }
        this.addUint8(n & 0xFF);
    }

    private void addUint8(int n) {
        if ((n & 0xFFFFFF00) != 0) {
            throw Kit.codeBug();
        }
        int n2 = this.itsICodeTop;
        byte[] byArray = this.itsData.itsICode;
        if (n2 == byArray.length) {
            byArray = this.increaseICodeCapasity(1);
        }
        byArray[n2] = (byte)n;
        this.itsICodeTop = n2 + 1;
    }

    private void addUint16(int n) {
        if ((n & 0xFFFF0000) != 0) {
            throw Kit.codeBug();
        }
        int n2 = this.itsICodeTop;
        byte[] byArray = this.itsData.itsICode;
        if (n2 + 2 > byArray.length) {
            byArray = this.increaseICodeCapasity(2);
        }
        byArray[n2] = (byte)(n >>> 8);
        byArray[n2 + 1] = (byte)n;
        this.itsICodeTop = n2 + 2;
    }

    private void addInt(int n) {
        int n2 = this.itsICodeTop;
        byte[] byArray = this.itsData.itsICode;
        if (n2 + 4 > byArray.length) {
            byArray = this.increaseICodeCapasity(4);
        }
        byArray[n2] = (byte)(n >>> 24);
        byArray[n2 + 1] = (byte)(n >>> 16);
        byArray[n2 + 2] = (byte)(n >>> 8);
        byArray[n2 + 3] = (byte)n;
        this.itsICodeTop = n2 + 4;
    }

    private int getDoubleIndex(double d) {
        int n = this.itsDoubleTableTop;
        if (n == 0) {
            this.itsData.itsDoubleTable = new double[64];
        } else if (this.itsData.itsDoubleTable.length == n) {
            double[] dArray = new double[n * 2];
            System.arraycopy(this.itsData.itsDoubleTable, 0, dArray, 0, n);
            this.itsData.itsDoubleTable = dArray;
        }
        this.itsData.itsDoubleTable[n] = d;
        this.itsDoubleTableTop = n + 1;
        return n;
    }

    private void addGotoOp(int n) {
        int n2 = this.itsICodeTop;
        byte[] byArray = this.itsData.itsICode;
        if (n2 + 3 > byArray.length) {
            byArray = this.increaseICodeCapasity(3);
        }
        byArray[n2] = (byte)n;
        this.itsICodeTop = n2 + 1 + 2;
    }

    private void addVarOp(int n, int n2) {
        switch (n) {
            case 54: 
            case 55: {
                if (n2 < 128) {
                    this.addIcode(n == 54 ? -48 : -49);
                    this.addUint8(n2);
                    return;
                }
            }
            case -7: {
                this.addIndexOp(n, n2);
                return;
            }
        }
        throw Kit.codeBug();
    }

    private void addStringOp(int n, String string2) {
        this.addStringPrefix(string2);
        if (Interpreter.validIcode(n)) {
            this.addIcode(n);
        } else {
            this.addToken(n);
        }
    }

    private void addIndexOp(int n, int n2) {
        this.addIndexPrefix(n2);
        if (Interpreter.validIcode(n)) {
            this.addIcode(n);
        } else {
            this.addToken(n);
        }
    }

    private void addStringPrefix(String string2) {
        int n = this.itsStrings.get(string2, -1);
        if (n == -1) {
            n = this.itsStrings.size();
            this.itsStrings.put(string2, n);
        }
        if (n < 4) {
            this.addIcode(-41 - n);
        } else if (n <= 255) {
            this.addIcode(-45);
            this.addUint8(n);
        } else if (n <= 65535) {
            this.addIcode(-46);
            this.addUint16(n);
        } else {
            this.addIcode(-47);
            this.addInt(n);
        }
    }

    private void addIndexPrefix(int n) {
        if (n < 0) {
            Kit.codeBug();
        }
        if (n < 6) {
            this.addIcode(-32 - n);
        } else if (n <= 255) {
            this.addIcode(-38);
            this.addUint8(n);
        } else if (n <= 65535) {
            this.addIcode(-39);
            this.addUint16(n);
        } else {
            this.addIcode(-40);
            this.addInt(n);
        }
    }

    private void addExceptionHandler(int n, int n2, int n3, boolean bl, int n4, int n5) {
        int n6 = this.itsExceptionTableTop;
        int[] nArray = this.itsData.itsExceptionTable;
        if (nArray == null) {
            if (n6 != 0) {
                Kit.codeBug();
            }
            this.itsData.itsExceptionTable = nArray = new int[12];
        } else if (nArray.length == n6) {
            nArray = new int[nArray.length * 2];
            System.arraycopy(this.itsData.itsExceptionTable, 0, nArray, 0, n6);
            this.itsData.itsExceptionTable = nArray;
        }
        nArray[n6 + 0] = n;
        nArray[n6 + 1] = n2;
        nArray[n6 + 2] = n3;
        nArray[n6 + 3] = bl ? 1 : 0;
        nArray[n6 + 4] = n4;
        nArray[n6 + 5] = n5;
        this.itsExceptionTableTop = n6 + 6;
    }

    private byte[] increaseICodeCapasity(int n) {
        int n2 = this.itsICodeTop;
        int n3 = this.itsData.itsICode.length;
        if (n2 + n <= n3) {
            throw Kit.codeBug();
        }
        if (n2 + n > (n3 *= 2)) {
            n3 = n2 + n;
        }
        byte[] byArray = new byte[n3];
        System.arraycopy(this.itsData.itsICode, 0, byArray, 0, n2);
        this.itsData.itsICode = byArray;
        return byArray;
    }

    private void stackChange(int n) {
        if (n <= 0) {
            this.itsStackDepth += n;
        } else {
            int n2 = this.itsStackDepth + n;
            if (n2 > this.itsData.itsMaxStack) {
                this.itsData.itsMaxStack = n2;
            }
            this.itsStackDepth = n2;
        }
    }

    private int allocLocal() {
        int n = this.itsLocalTop++;
        if (this.itsLocalTop > this.itsData.itsMaxLocals) {
            this.itsData.itsMaxLocals = this.itsLocalTop;
        }
        return n;
    }

    private void releaseLocal(int n) {
        --this.itsLocalTop;
        if (n != this.itsLocalTop) {
            Kit.codeBug();
        }
    }

    private static int getShort(byte[] byArray, int n) {
        return byArray[n] << 8 | byArray[n + 1] & 0xFF;
    }

    private static int getIndex(byte[] byArray, int n) {
        return (byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF;
    }

    private static int getInt(byte[] byArray, int n) {
        return byArray[n] << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
    }

    private static int getExceptionHandler(CallFrame callFrame, boolean bl) {
        int[] nArray = callFrame.idata.itsExceptionTable;
        if (nArray == null) {
            return -1;
        }
        int n = callFrame.pc - 1;
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i != nArray.length; i += 6) {
            int n5 = nArray[i + 0];
            int n6 = nArray[i + 1];
            if (n5 > n || n >= n6 || bl && nArray[i + 3] != 1) continue;
            if (n2 >= 0) {
                if (n4 < n6) continue;
                if (n3 > n5) {
                    Kit.codeBug();
                }
                if (n4 == n6) {
                    Kit.codeBug();
                }
            }
            n2 = i;
            n3 = n5;
            n4 = n6;
        }
        return n2;
    }

    private static void dumpICode(InterpreterData interpreterData) {
    }

    private static int bytecodeSpan(int n) {
        switch (n) {
            case 49: {
                return 3;
            }
            case -54: 
            case -23: 
            case -6: 
            case 5: 
            case 6: 
            case 7: {
                return 3;
            }
            case -21: {
                return 5;
            }
            case 56: {
                return 2;
            }
            case -11: 
            case -10: 
            case -9: 
            case -8: 
            case -7: {
                return 2;
            }
            case -27: {
                return 3;
            }
            case -28: {
                return 5;
            }
            case -38: {
                return 2;
            }
            case -39: {
                return 3;
            }
            case -40: {
                return 5;
            }
            case -45: {
                return 2;
            }
            case -46: {
                return 3;
            }
            case -47: {
                return 5;
            }
            case -49: 
            case -48: {
                return 2;
            }
            case -26: {
                return 3;
            }
        }
        if (!Interpreter.validBytecode(n)) {
            throw Kit.codeBug();
        }
        return 1;
    }

    static int[] getLineNumbers(InterpreterData interpreterData) {
        int n;
        UintMap uintMap = new UintMap();
        byte[] byArray = interpreterData.itsICode;
        int n2 = byArray.length;
        for (int i = 0; i != n2; i += n) {
            byte by2 = byArray[i];
            n = Interpreter.bytecodeSpan(by2);
            if (by2 != -26) continue;
            if (n != 3) {
                Kit.codeBug();
            }
            int n3 = Interpreter.getIndex(byArray, i + 1);
            uintMap.put(n3, 0);
        }
        return uintMap.getKeys();
    }

    static void captureInterpreterStackInfo(RhinoException rhinoException) {
        int n;
        Object[] objectArray;
        Context context = Context.getCurrentContext();
        if (context == null || context.lastInterpreterFrame == null) {
            rhinoException.interpreterStackInfo = null;
            rhinoException.interpreterLineData = null;
            return;
        }
        if (context.previousInterpreterInvocations == null || context.previousInterpreterInvocations.size() == 0) {
            objectArray = new CallFrame[1];
        } else {
            n = context.previousInterpreterInvocations.size();
            if (context.previousInterpreterInvocations.peek() == context.lastInterpreterFrame) {
                --n;
            }
            objectArray = new CallFrame[n + 1];
            context.previousInterpreterInvocations.toArray(objectArray);
        }
        objectArray[objectArray.length - 1] = (CallFrame)context.lastInterpreterFrame;
        n = 0;
        for (int i = 0; i != objectArray.length; ++i) {
            n += 1 + ((CallFrame)objectArray[i]).frameIndex;
        }
        int[] nArray = new int[n];
        int n2 = n;
        int n3 = objectArray.length;
        while (n3 != 0) {
            Object object = objectArray[--n3];
            while (object != null) {
                nArray[--n2] = ((CallFrame)object).pcSourceLineStart;
                object = ((CallFrame)object).parentFrame;
            }
        }
        if (n2 != 0) {
            Kit.codeBug();
        }
        rhinoException.interpreterStackInfo = objectArray;
        rhinoException.interpreterLineData = nArray;
    }

    static String getSourcePositionFromStack(Context context, int[] nArray) {
        CallFrame callFrame = (CallFrame)context.lastInterpreterFrame;
        InterpreterData interpreterData = callFrame.idata;
        nArray[0] = callFrame.pcSourceLineStart >= 0 ? Interpreter.getIndex(interpreterData.itsICode, callFrame.pcSourceLineStart) : 0;
        return interpreterData.itsSourceFile;
    }

    static String getPatchedStack(RhinoException rhinoException, String string2) {
        String string3 = "org.mozilla.javascript.Interpreter.interpretLoop";
        StringBuffer stringBuffer = new StringBuffer(string2.length() + 1000);
        String string4 = SecurityUtilities.getSystemProperty("line.separator");
        CallFrame[] callFrameArray = (CallFrame[])rhinoException.interpreterStackInfo;
        int[] nArray = rhinoException.interpreterLineData;
        int n = callFrameArray.length;
        int n2 = nArray.length;
        int n3 = 0;
        while (n != 0) {
            char c;
            --n;
            int n4 = string2.indexOf(string3, n3);
            if (n4 < 0) break;
            n4 += string3.length();
            while (n4 != string2.length() && (c = string2.charAt(n4)) != '\n' && c != '\r') {
                ++n4;
            }
            stringBuffer.append(string2.substring(n3, n4));
            n3 = n4;
            CallFrame callFrame = callFrameArray[n];
            while (callFrame != null) {
                if (n2 == 0) {
                    Kit.codeBug();
                }
                --n2;
                InterpreterData interpreterData = callFrame.idata;
                stringBuffer.append(string4);
                stringBuffer.append("\tat script");
                if (interpreterData.itsName != null && interpreterData.itsName.length() != 0) {
                    stringBuffer.append('.');
                    stringBuffer.append(interpreterData.itsName);
                }
                stringBuffer.append('(');
                stringBuffer.append(interpreterData.itsSourceFile);
                int n5 = nArray[n2];
                if (n5 >= 0) {
                    stringBuffer.append(':');
                    stringBuffer.append(Interpreter.getIndex(interpreterData.itsICode, n5));
                }
                stringBuffer.append(')');
                callFrame = callFrame.parentFrame;
            }
        }
        stringBuffer.append(string2.substring(n3));
        return stringBuffer.toString();
    }

    static String getEncodedSource(InterpreterData interpreterData) {
        if (interpreterData.encodedSource == null) {
            return null;
        }
        return interpreterData.encodedSource.substring(interpreterData.encodedSourceStart, interpreterData.encodedSourceEnd);
    }

    private static void initFunction(Context context, Scriptable scriptable, InterpretedFunction interpretedFunction, int n) {
        InterpretedFunction interpretedFunction2 = InterpretedFunction.createFunction(context, scriptable, interpretedFunction, n);
        ScriptRuntime.initFunction(context, scriptable, interpretedFunction2, interpretedFunction2.idata.itsFunctionType, interpretedFunction.idata.evalScriptFlag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object interpret(InterpretedFunction interpretedFunction, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!ScriptRuntime.hasTopCall(context)) {
            Kit.codeBug();
        }
        if (context.interpreterSecurityDomain != interpretedFunction.securityDomain) {
            Object object = context.interpreterSecurityDomain;
            context.interpreterSecurityDomain = interpretedFunction.securityDomain;
            try {
                Object object2 = interpretedFunction.securityController.callWithDomain(interpretedFunction.securityDomain, context, interpretedFunction, scriptable, scriptable2, objectArray);
                return object2;
            }
            finally {
                context.interpreterSecurityDomain = object;
            }
        }
        CallFrame callFrame = new CallFrame();
        Interpreter.initFrame(context, scriptable, scriptable2, objectArray, null, 0, objectArray.length, interpretedFunction, null, callFrame);
        return Interpreter.interpretLoop(context, callFrame, null);
    }

    public static Object restartContinuation(Continuation continuation, Context context, Scriptable scriptable, Object[] objectArray) {
        if (!ScriptRuntime.hasTopCall(context)) {
            return ScriptRuntime.doTopCall(continuation, context, scriptable, null, objectArray);
        }
        Object object = objectArray.length == 0 ? Undefined.instance : objectArray[0];
        CallFrame callFrame = (CallFrame)continuation.getImplementation();
        if (callFrame == null) {
            return object;
        }
        ContinuationJump continuationJump = new ContinuationJump(continuation, null);
        continuationJump.result = object;
        return Interpreter.interpretLoop(context, null, continuationJump);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static Object interpretLoop(Context var0, CallFrame var1_1, Object var2_2) {
        block268: {
            var3_3 = UniqueTag.DOUBLE_MARK;
            var4_4 = Undefined.instance;
            var5_5 = var0.instructionThreshold != 0;
            var8_6 = null;
            var9_7 = -1;
            if (var0.lastInterpreterFrame != null) {
                if (var0.previousInterpreterInvocations == null) {
                    var0.previousInterpreterInvocations = new ObjArray();
                }
                var0.previousInterpreterInvocations.push(var0.lastInterpreterFrame);
            }
            if (var2_2 != null && !(var2_2 instanceof ContinuationJump)) {
                Kit.codeBug();
            }
            var10_8 = null;
            var11_9 = 0.0;
            block145: while (true) {
                block269: {
                    block267: {
                        try {
                            block146: while (true) {
                                if (var2_2 != null) {
                                    if (var9_7 >= 0) {
                                        if (var1_1.frozen) {
                                            var1_1 = var1_1.cloneFrozen();
                                        }
                                        var13_10 = var1_1.idata.itsExceptionTable;
                                        var1_1.pc = (int)var13_10[var9_7 + 2];
                                        if (var5_5) {
                                            var1_1.pcPrevBranch = var1_1.pc;
                                        }
                                        var1_1.savedStackTop = var1_1.emptyStackTop;
                                        var14_13 = var1_1.localShift + var13_10[var9_7 + 5];
                                        var15_16 = var1_1.localShift + var13_10[var9_7 + 4];
                                        var1_1.scope = (Scriptable)var1_1.stack[var14_13];
                                        var1_1.stack[var15_16] = var2_2;
                                        var2_2 = null;
                                    } else {
                                        var13_10 = (Object[])var2_2;
                                        var2_2 = null;
                                        if (var13_10.branchFrame != var1_1) {
                                            Kit.codeBug();
                                        }
                                        if (var13_10.capturedFrame == null) {
                                            Kit.codeBug();
                                        }
                                        var14_14 = var13_10.capturedFrame.frameIndex + 1;
                                        if (var13_10.branchFrame != null) {
                                            var14_14 -= var13_10.branchFrame.frameIndex;
                                        }
                                        var15_17 = 0;
                                        var16_18 /* !! */  = null;
                                        var17_20 /* !! */  = (byte[])var13_10.capturedFrame;
                                        for (var18_21 = 0; var18_21 != var14_14; ++var18_21) {
                                            if (!var17_20 /* !! */ .frozen) {
                                                Kit.codeBug();
                                            }
                                            if (Interpreter.isFrameEnterExitRequired((CallFrame)var17_20 /* !! */ )) {
                                                if (var16_18 /* !! */  == null) {
                                                    var16_18 /* !! */  = (double[])new CallFrame[var14_14 - var18_21];
                                                }
                                                var16_18 /* !! */ [var15_17] = (double)var17_20 /* !! */ ;
                                                ++var15_17;
                                            }
                                            var17_20 /* !! */  = (byte[])var17_20 /* !! */ .parentFrame;
                                        }
                                        while (var15_17 != 0) {
                                            var17_20 /* !! */  = (byte[])var16_18 /* !! */ [--var15_17];
                                            Interpreter.enterFrame(var0, (CallFrame)var17_20 /* !! */ , ScriptRuntime.emptyArgs, true);
                                        }
                                        var1_1 = var13_10.capturedFrame.cloneFrozen();
                                        Interpreter.setCallResult(var1_1, var13_10.result, var13_10.resultDbl);
                                    }
                                } else if (var1_1.frozen) {
                                    Kit.codeBug();
                                }
                                var13_10 = var1_1.stack;
                                var14_12 = var1_1.sDbl;
                                var15_15 = var1_1.varSource.stack;
                                var16_18 /* !! */  = var1_1.varSource.sDbl;
                                var17_20 /* !! */  = var1_1.idata.itsICode;
                                var18_22 = var1_1.idata.itsStringTable;
                                var19_27 = var1_1.savedStackTop;
                                var0.lastInterpreterFrame = var1_1;
                                block149: while (true) {
                                    var20_29 = var17_20 /* !! */ [var1_1.pc++];
                                    switch (var20_29) {
                                        case 49: {
                                            var21_30 = var13_10[var19_27];
                                            if (var21_30 == var3_3) {
                                                var21_30 = ScriptRuntime.wrapNumber(var14_12[var19_27]);
                                            }
                                            --var19_27;
                                            var22_81 = Interpreter.getIndex(var17_20 /* !! */ , var1_1.pc);
                                            var2_2 = new JavaScriptException(var21_30, var1_1.idata.itsSourceFile, var22_81);
                                            break block267;
                                        }
                                        case 50: {
                                            var2_2 = var13_10[var9_7 += var1_1.localShift];
                                            break block267;
                                        }
                                        case 14: 
                                        case 15: 
                                        case 16: 
                                        case 17: {
                                            var21_31 = var13_10[--var19_27 + 1];
                                            var22_82 = var13_10[var19_27];
                                            if (var21_31 != var3_3) ** GOTO lbl97
                                            var24_126 = var14_12[var19_27 + 1];
                                            var26_139 = Interpreter.stack_double(var1_1, var19_27);
                                            ** GOTO lbl100
lbl97:
                                            // 1 sources

                                            if (var22_82 != var3_3) ** GOTO lbl115
                                            var24_126 = ScriptRuntime.toNumber(var21_31);
                                            var26_139 = var14_12[var19_27];
lbl100:
                                            // 2 sources

                                            switch (var20_29) {
                                                case 17: {
                                                    var23_109 = var26_139 >= var24_126;
                                                    ** GOTO lbl130
                                                }
                                                case 15: {
                                                    var23_109 = var26_139 <= var24_126;
                                                    ** GOTO lbl130
                                                }
                                                case 16: {
                                                    var23_109 = var26_139 > var24_126;
                                                    ** GOTO lbl130
                                                }
                                                case 14: {
                                                    var23_109 = var26_139 < var24_126;
                                                    ** GOTO lbl130
                                                }
                                                default: {
                                                    throw Kit.codeBug();
                                                }
                                            }
lbl115:
                                            // 1 sources

                                            switch (var20_29) {
                                                case 17: {
                                                    var23_109 = ScriptRuntime.cmp_LE(var21_31, var22_82);
                                                    break;
                                                }
                                                case 15: {
                                                    var23_109 = ScriptRuntime.cmp_LE(var22_82, var21_31);
                                                    break;
                                                }
                                                case 16: {
                                                    var23_109 = ScriptRuntime.cmp_LT(var21_31, var22_82);
                                                    break;
                                                }
                                                case 14: {
                                                    var23_109 = ScriptRuntime.cmp_LT(var22_82, var21_31);
                                                    break;
                                                }
                                                default: {
                                                    throw Kit.codeBug();
                                                }
                                            }
lbl130:
                                            // 8 sources

                                            var13_10[var19_27] = ScriptRuntime.wrapBoolean(var23_109);
                                            continue block149;
                                        }
                                        case 51: 
                                        case 52: {
                                            var21_32 = var13_10[var19_27];
                                            if (var21_32 == var3_3) {
                                                var21_32 = ScriptRuntime.wrapNumber(var14_12[var19_27]);
                                            }
                                            if ((var22_83 = var13_10[--var19_27]) == var3_3) {
                                                var22_83 = ScriptRuntime.wrapNumber(var14_12[var19_27]);
                                            }
                                            var23_110 = var20_29 == 51 ? ScriptRuntime.in(var22_83, var21_32, var0) : ScriptRuntime.instanceOf(var22_83, var21_32, var0);
                                            var13_10[var19_27] = ScriptRuntime.wrapBoolean(var23_110);
                                            continue block149;
                                        }
                                        case 12: 
                                        case 13: {
                                            var22_84 = var13_10[--var19_27 + 1];
                                            var23_111 = var13_10[var19_27];
                                            var21_33 = var22_84 == var3_3 ? (var23_111 == var3_3 ? var14_12[var19_27] == var14_12[var19_27 + 1] : ScriptRuntime.eqNumber(var14_12[var19_27 + 1], var23_111)) : (var23_111 == var3_3 ? ScriptRuntime.eqNumber(var14_12[var19_27], var22_84) : ScriptRuntime.eq(var23_111, var22_84));
                                            var13_10[var19_27] = ScriptRuntime.wrapBoolean(var21_33 ^= var20_29 == 13);
                                            continue block149;
                                        }
                                        case 45: 
                                        case 46: {
                                            var21_34 = var13_10[--var19_27 + 1];
                                            var22_85 = var13_10[var19_27];
                                            if (var21_34 != var3_3) ** GOTO lbl160
                                            var24_127 = var14_12[var19_27 + 1];
                                            if (var22_85 != var3_3) ** GOTO lbl155
                                            var26_140 = var14_12[var19_27];
                                            ** GOTO lbl172
lbl155:
                                            // 1 sources

                                            if (!(var22_85 instanceof Number)) ** GOTO lbl158
                                            var26_140 = ((Number)var22_85).doubleValue();
                                            ** GOTO lbl172
lbl158:
                                            // 1 sources

                                            var23_112 = false;
                                            ** GOTO lbl173
lbl160:
                                            // 1 sources

                                            if (var22_85 != var3_3) ** GOTO lbl170
                                            var26_140 = var14_12[var19_27];
                                            if (var21_34 != var3_3) ** GOTO lbl165
                                            var24_127 = var14_12[var19_27 + 1];
                                            ** GOTO lbl172
lbl165:
                                            // 1 sources

                                            if (!(var21_34 instanceof Number)) ** GOTO lbl168
                                            var24_127 = ((Number)var21_34).doubleValue();
                                            ** GOTO lbl172
lbl168:
                                            // 1 sources

                                            var23_112 = false;
                                            ** GOTO lbl173
lbl170:
                                            // 1 sources

                                            var23_112 = ScriptRuntime.shallowEq(var22_85, var21_34);
                                            ** GOTO lbl173
lbl172:
                                            // 4 sources

                                            var23_112 = var26_140 == var24_127;
lbl173:
                                            // 4 sources

                                            var13_10[var19_27] = ScriptRuntime.wrapBoolean(var23_112 ^= var20_29 == 46);
                                            continue block149;
                                        }
                                        case 7: {
                                            if (!Interpreter.stack_boolean(var1_1, var19_27--)) break;
                                            var1_1.pc += 2;
                                            continue block149;
                                        }
                                        case 6: {
                                            if (Interpreter.stack_boolean(var1_1, var19_27--)) break;
                                            var1_1.pc += 2;
                                            continue block149;
                                        }
                                        case -6: {
                                            if (!Interpreter.stack_boolean(var1_1, var19_27--)) {
                                                var1_1.pc += 2;
                                                continue block149;
                                            }
                                            var13_10[var19_27--] = null;
                                            break;
                                        }
                                        case 5: {
                                            break;
                                        }
                                        case -23: {
                                            var13_10[++var19_27] = var3_3;
                                            var14_12[var19_27] = var1_1.pc + 2;
                                            break;
                                        }
                                        case -24: {
                                            if (var19_27 == var1_1.emptyStackTop + 1) {
                                                var13_10[var9_7 += var1_1.localShift] = var13_10[var19_27];
                                                var14_12[var9_7] = var14_12[var19_27];
                                                --var19_27;
                                                continue block149;
                                            }
                                            if (var19_27 == var1_1.emptyStackTop) continue block149;
                                            Kit.codeBug();
                                            continue block149;
                                        }
                                        case -25: {
                                            if (var5_5) {
                                                Interpreter.addInstructionCount(var0, var1_1, 0);
                                            }
                                            if ((var21_35 = var13_10[var9_7 += var1_1.localShift]) != var3_3) {
                                                var2_2 = var21_35;
                                                break block267;
                                            }
                                            var1_1.pc = (int)var14_12[var9_7];
                                            if (!var5_5) continue block149;
                                            var1_1.pcPrevBranch = var1_1.pc;
                                            continue block149;
                                        }
                                        case -4: {
                                            var13_10[var19_27] = null;
                                            --var19_27;
                                            continue block149;
                                        }
                                        case -5: {
                                            var1_1.result = var13_10[var19_27];
                                            var1_1.resultDbl = var14_12[var19_27];
                                            var13_10[var19_27] = null;
                                            --var19_27;
                                            continue block149;
                                        }
                                        case -1: {
                                            var13_10[var19_27 + 1] = var13_10[var19_27];
                                            var14_12[var19_27 + 1] = var14_12[var19_27];
                                            ++var19_27;
                                            continue block149;
                                        }
                                        case -2: {
                                            var13_10[var19_27 + 1] = var13_10[var19_27 - 1];
                                            var14_12[var19_27 + 1] = var14_12[var19_27 - 1];
                                            var13_10[var19_27 + 2] = var13_10[var19_27];
                                            var14_12[var19_27 + 2] = var14_12[var19_27];
                                            var19_27 += 2;
                                            continue block149;
                                        }
                                        case -3: {
                                            var21_36 = var13_10[var19_27];
                                            var13_10[var19_27] = var13_10[var19_27 - 1];
                                            var13_10[var19_27 - 1] = var21_36;
                                            var22_86 = var14_12[var19_27];
                                            var14_12[var19_27] = var14_12[var19_27 - 1];
                                            var14_12[var19_27 - 1] = var22_86;
                                            continue block149;
                                        }
                                        case 4: {
                                            var1_1.result = var13_10[var19_27];
                                            var1_1.resultDbl = var14_12[var19_27];
                                            --var19_27;
                                            break block149;
                                        }
                                        case 62: {
                                            break block149;
                                        }
                                        case -22: {
                                            var1_1.result = var4_4;
                                            break block149;
                                        }
                                        case 27: {
                                            var21_37 = Interpreter.stack_int32(var1_1, var19_27);
                                            var13_10[var19_27] = var3_3;
                                            var14_12[var19_27] = ~var21_37;
                                            continue block149;
                                        }
                                        case 9: 
                                        case 10: 
                                        case 11: 
                                        case 18: 
                                        case 19: {
                                            var21_38 = Interpreter.stack_int32(var1_1, var19_27);
                                            var22_87 = Interpreter.stack_int32(var1_1, --var19_27);
                                            var13_10[var19_27] = var3_3;
                                            switch (var20_29) {
                                                case 11: {
                                                    var22_87 &= var21_38;
                                                    break;
                                                }
                                                case 9: {
                                                    var22_87 |= var21_38;
                                                    break;
                                                }
                                                case 10: {
                                                    var22_87 ^= var21_38;
                                                    break;
                                                }
                                                case 18: {
                                                    var22_87 <<= var21_38;
                                                    break;
                                                }
                                                case 19: {
                                                    var22_87 >>= var21_38;
                                                }
                                            }
                                            var14_12[var19_27] = var22_87;
                                            continue block149;
                                        }
                                        case 20: {
                                            var21_39 = Interpreter.stack_int32(var1_1, var19_27) & 31;
                                            var22_88 = Interpreter.stack_double(var1_1, --var19_27);
                                            var13_10[var19_27] = var3_3;
                                            var14_12[var19_27] = ScriptRuntime.toUint32(var22_88) >>> var21_39;
                                            continue block149;
                                        }
                                        case 28: 
                                        case 29: {
                                            var21_40 = Interpreter.stack_double(var1_1, var19_27);
                                            var13_10[var19_27] = var3_3;
                                            if (var20_29 == 29) {
                                                var21_40 = -var21_40;
                                            }
                                            var14_12[var19_27] = var21_40;
                                            continue block149;
                                        }
                                        case 21: {
                                            Interpreter.do_add(var13_10, var14_12, --var19_27, var0);
                                            continue block149;
                                        }
                                        case 22: 
                                        case 23: 
                                        case 24: 
                                        case 25: {
                                            var21_41 = Interpreter.stack_double(var1_1, var19_27);
                                            var23_113 = Interpreter.stack_double(var1_1, --var19_27);
                                            var13_10[var19_27] = var3_3;
                                            switch (var20_29) {
                                                case 22: {
                                                    var23_113 -= var21_41;
                                                    break;
                                                }
                                                case 23: {
                                                    var23_113 *= var21_41;
                                                    break;
                                                }
                                                case 24: {
                                                    var23_113 /= var21_41;
                                                    break;
                                                }
                                                case 25: {
                                                    var23_113 %= var21_41;
                                                }
                                            }
                                            var14_12[var19_27] = var23_113;
                                            continue block149;
                                        }
                                        case 26: {
                                            var13_10[var19_27] = ScriptRuntime.wrapBoolean(Interpreter.stack_boolean(var1_1, var19_27) == false);
                                            continue block149;
                                        }
                                        case 48: {
                                            var13_10[++var19_27] = ScriptRuntime.bind(var0, var1_1.scope, var8_6);
                                            continue block149;
                                        }
                                        case 8: {
                                            var21_42 = var13_10[var19_27];
                                            if (var21_42 == var3_3) {
                                                var21_42 = ScriptRuntime.wrapNumber(var14_12[var19_27]);
                                            }
                                            var22_89 = (Scriptable)var13_10[--var19_27];
                                            var13_10[var19_27] = ScriptRuntime.setName(var22_89, var21_42, var0, var1_1.scope, var8_6);
                                            continue block149;
                                        }
                                        case 31: {
                                            var21_43 = var13_10[var19_27];
                                            if (var21_43 == var3_3) {
                                                var21_43 = ScriptRuntime.wrapNumber(var14_12[var19_27]);
                                            }
                                            if ((var22_90 = var13_10[--var19_27]) == var3_3) {
                                                var22_90 = ScriptRuntime.wrapNumber(var14_12[var19_27]);
                                            }
                                            var13_10[var19_27] = ScriptRuntime.delete(var22_90, var21_43, var0);
                                            continue block149;
                                        }
                                        case 33: {
                                            var21_44 = var13_10[var19_27];
                                            if (var21_44 == var3_3) {
                                                var21_44 = ScriptRuntime.wrapNumber(var14_12[var19_27]);
                                            }
                                            var13_10[var19_27] = ScriptRuntime.getObjectProp(var21_44, var8_6, var0);
                                            continue block149;
                                        }
                                        case 34: {
                                            var21_45 = var13_10[var19_27];
                                            if (var21_45 == var3_3) {
                                                var21_45 = ScriptRuntime.wrapNumber(var14_12[var19_27]);
                                            }
                                            if ((var22_91 = var13_10[--var19_27]) == var3_3) {
                                                var22_91 = ScriptRuntime.wrapNumber(var14_12[var19_27]);
                                            }
                                            var13_10[var19_27] = ScriptRuntime.setObjectProp(var22_91, var8_6, var21_45, var0);
                                            continue block149;
                                        }
                                        case -9: {
                                            var21_46 = var13_10[var19_27];
                                            if (var21_46 == var3_3) {
                                                var21_46 = ScriptRuntime.wrapNumber(var14_12[var19_27]);
                                            }
                                            var13_10[var19_27] = ScriptRuntime.propIncrDecr(var21_46, var8_6, var0, var17_20 /* !! */ [var1_1.pc]);
                                            ++var1_1.pc;
                                            continue block149;
                                        }
                                        case 35: {
                                            var21_47 = var13_10[--var19_27];
                                            if (var21_47 == var3_3) {
                                                var21_47 = ScriptRuntime.wrapNumber(var14_12[var19_27]);
                                            }
                                            if ((var23_114 = var13_10[var19_27 + 1]) != var3_3) {
                                                var22_92 = ScriptRuntime.getObjectElem(var21_47, var23_114, var0);
                                            } else {
                                                var24_128 = var14_12[var19_27 + 1];
                                                var22_92 = ScriptRuntime.getObjectIndex(var21_47, var24_128, var0);
                                            }
                                            var13_10[var19_27] = var22_92;
                                            continue block149;
                                        }
                                        case 36: {
                                            var21_48 = var13_10[(var19_27 -= 2) + 2];
                                            if (var21_48 == var3_3) {
                                                var21_48 = ScriptRuntime.wrapNumber(var14_12[var19_27 + 2]);
                                            }
                                            if ((var22_93 = var13_10[var19_27]) == var3_3) {
                                                var22_93 = ScriptRuntime.wrapNumber(var14_12[var19_27]);
                                            }
                                            if ((var24_129 = var13_10[var19_27 + 1]) != var3_3) {
                                                var23_115 = ScriptRuntime.setObjectElem(var22_93, var24_129, var21_48, var0);
                                            } else {
                                                var25_136 = var14_12[var19_27 + 1];
                                                var23_115 = ScriptRuntime.setObjectIndex(var22_93, var25_136, var21_48, var0);
                                            }
                                            var13_10[var19_27] = var23_115;
                                            continue block149;
                                        }
                                        case -10: {
                                            var21_49 = var13_10[var19_27];
                                            if (var21_49 == var3_3) {
                                                var21_49 = ScriptRuntime.wrapNumber(var14_12[var19_27]);
                                            }
                                            if ((var22_94 = var13_10[--var19_27]) == var3_3) {
                                                var22_94 = ScriptRuntime.wrapNumber(var14_12[var19_27]);
                                            }
                                            var13_10[var19_27] = ScriptRuntime.elemIncrDecr(var22_94, var21_49, var0, var17_20 /* !! */ [var1_1.pc]);
                                            ++var1_1.pc;
                                            continue block149;
                                        }
                                        case 65: {
                                            var21_50 = (Ref)var13_10[var19_27];
                                            var13_10[var19_27] = ScriptRuntime.refGet(var21_50, var0);
                                            continue block149;
                                        }
                                        case 66: {
                                            var21_51 = var13_10[var19_27];
                                            if (var21_51 == var3_3) {
                                                var21_51 = ScriptRuntime.wrapNumber(var14_12[var19_27]);
                                            }
                                            var22_95 = (Ref)var13_10[--var19_27];
                                            var13_10[var19_27] = ScriptRuntime.refSet(var22_95, var21_51, var0);
                                            continue block149;
                                        }
                                        case 67: {
                                            var21_52 = (Ref)var13_10[var19_27];
                                            var13_10[var19_27] = ScriptRuntime.refDel(var21_52, var0);
                                            continue block149;
                                        }
                                        case -11: {
                                            var21_53 = (Ref)var13_10[var19_27];
                                            var13_10[var19_27] = ScriptRuntime.refIncrDecr(var21_53, var0, var17_20 /* !! */ [var1_1.pc]);
                                            ++var1_1.pc;
                                            continue block149;
                                        }
                                        case 53: {
                                            var13_10[++var19_27] = var13_10[var9_7 += var1_1.localShift];
                                            var14_12[var19_27] = var14_12[var9_7];
                                            continue block149;
                                        }
                                        case -56: {
                                            var13_10[var9_7 += var1_1.localShift] = null;
                                            continue block149;
                                        }
                                        case -15: {
                                            var13_10[++var19_27] = ScriptRuntime.getNameFunctionAndThis(var8_6, var0, var1_1.scope);
                                            var13_10[++var19_27] = ScriptRuntime.lastStoredScriptable(var0);
                                            continue block149;
                                        }
                                        case -16: {
                                            var21_54 = var13_10[var19_27];
                                            if (var21_54 == var3_3) {
                                                var21_54 = ScriptRuntime.wrapNumber(var14_12[var19_27]);
                                            }
                                            var13_10[var19_27] = ScriptRuntime.getPropFunctionAndThis(var21_54, var8_6, var0);
                                            var13_10[++var19_27] = ScriptRuntime.lastStoredScriptable(var0);
                                            continue block149;
                                        }
                                        case -17: {
                                            var21_55 = var13_10[var19_27 - 1];
                                            if (var21_55 == var3_3) {
                                                var21_55 = ScriptRuntime.wrapNumber(var14_12[var19_27 - 1]);
                                            }
                                            if ((var22_96 = var13_10[var19_27]) == var3_3) {
                                                var22_96 = ScriptRuntime.wrapNumber(var14_12[var19_27]);
                                            }
                                            var13_10[var19_27 - 1] = ScriptRuntime.getElemFunctionAndThis(var21_55, var22_96, var0);
                                            var13_10[var19_27] = ScriptRuntime.lastStoredScriptable(var0);
                                            continue block149;
                                        }
                                        case -18: {
                                            var21_56 = var13_10[var19_27];
                                            if (var21_56 == var3_3) {
                                                var21_56 = ScriptRuntime.wrapNumber(var14_12[var19_27]);
                                            }
                                            var13_10[var19_27] = ScriptRuntime.getValueFunctionAndThis(var21_56, var0);
                                            var13_10[++var19_27] = ScriptRuntime.lastStoredScriptable(var0);
                                            continue block149;
                                        }
                                        case -21: {
                                            if (var5_5) {
                                                var0.instructionCount += 100;
                                            }
                                            var21_57 = var17_20 /* !! */ [var1_1.pc] & 255;
                                            var22_97 = var17_20 /* !! */ [var1_1.pc + 1] != 0;
                                            var23_116 = Interpreter.getIndex(var17_20 /* !! */ , var1_1.pc + 2);
                                            if (var22_97) {
                                                var24_130 = var13_10[var19_27 -= var9_7];
                                                if (var24_130 == var3_3) {
                                                    var24_130 = ScriptRuntime.wrapNumber(var14_12[var19_27]);
                                                }
                                                var25_137 = Interpreter.getArgsArray(var13_10, var14_12, var19_27 + 1, var9_7);
                                                var13_10[var19_27] = ScriptRuntime.newSpecial(var0, var24_130, var25_137, var1_1.scope, var21_57);
                                            } else {
                                                var24_130 = (Scriptable)var13_10[(var19_27 -= 1 + var9_7) + 1];
                                                var25_137 = (Object[])var13_10[var19_27];
                                                var26_141 = Interpreter.getArgsArray(var13_10, var14_12, var19_27 + 2, var9_7);
                                                var13_10[var19_27] = ScriptRuntime.callSpecial(var0, (Callable)var25_137, (Scriptable)var24_130, var26_141, var1_1.scope, var1_1.thisObj, var21_57, var1_1.idata.itsSourceFile, var23_116);
                                            }
                                            var1_1.pc += 4;
                                            continue block149;
                                        }
                                        case -55: 
                                        case 37: 
                                        case 68: {
                                            if (var5_5) {
                                                var0.instructionCount += 100;
                                            }
                                            var21_58 = (Callable)var13_10[var19_27 -= 1 + var9_7];
                                            var22_98 = (Scriptable)var13_10[var19_27 + 1];
                                            if (var20_29 == 68) {
                                                var23_117 = Interpreter.getArgsArray(var13_10, var14_12, var19_27 + 2, var9_7);
                                                var13_10[var19_27] = ScriptRuntime.callRef(var21_58, var22_98, var23_117, var0);
                                                continue block149;
                                            }
                                            var23_118 = var1_1.scope;
                                            if (var1_1.useActivation) {
                                                var23_118 = ScriptableObject.getTopLevelScope(var1_1.scope);
                                            }
                                            if (var21_58 instanceof InterpretedFunction) {
                                                var24_131 = (InterpretedFunction)var21_58;
                                                if (var1_1.fnOrScript.securityDomain == var24_131.securityDomain) {
                                                    var25_138 = var1_1;
                                                    var26_142 = new CallFrame();
                                                    if (var20_29 == -55) {
                                                        var25_138 = var1_1.parentFrame;
                                                    }
                                                    Interpreter.initFrame(var0, var23_118, var22_98, var13_10, var14_12, var19_27 + 2, var9_7, var24_131, var25_138, var26_142);
                                                    if (var20_29 == -55) {
                                                        Interpreter.exitFrame(var0, var1_1, null);
                                                    } else {
                                                        var1_1.savedStackTop = var19_27;
                                                        var1_1.savedCallOp = var20_29;
                                                    }
                                                    var1_1 = var26_142;
                                                    continue block146;
                                                }
                                            }
                                            if (var21_58 instanceof Continuation) {
                                                var24_132 = new ContinuationJump((Continuation)var21_58, var1_1);
                                                if (var9_7 == 0) {
                                                    var24_132.result = var4_4;
                                                } else {
                                                    var24_132.result = var13_10[var19_27 + 2];
                                                    var24_132.resultDbl = var14_12[var19_27 + 2];
                                                }
                                                var2_2 = var24_132;
                                                break block267;
                                            }
                                            if (var21_58 instanceof IdFunctionObject && Continuation.isContinuationConstructor(var24_133 = (IdFunctionObject)var21_58)) {
                                                Interpreter.captureContinuation(var0, var1_1, var19_27);
                                                continue block149;
                                            }
                                            var24_134 = Interpreter.getArgsArray(var13_10, var14_12, var19_27 + 2, var9_7);
                                            var13_10[var19_27] = var21_58.call(var0, var23_118, var22_98, var24_134);
                                            continue block149;
                                        }
                                        case 30: {
                                            if (var5_5) {
                                                var0.instructionCount += 100;
                                            }
                                            if ((var21_59 = var13_10[var19_27 -= var9_7]) instanceof InterpretedFunction) {
                                                var22_99 = (InterpretedFunction)var21_59;
                                                if (var1_1.fnOrScript.securityDomain == var22_99.securityDomain) {
                                                    var23_119 = var22_99.createObject(var0, var1_1.scope);
                                                    var24_135 = new CallFrame();
                                                    Interpreter.initFrame(var0, var1_1.scope, var23_119, var13_10, var14_12, var19_27 + 1, var9_7, var22_99, var1_1, var24_135);
                                                    var13_10[var19_27] = var23_119;
                                                    var1_1.savedStackTop = var19_27;
                                                    var1_1.savedCallOp = var20_29;
                                                    var1_1 = var24_135;
                                                    continue block146;
                                                }
                                            }
                                            if (!(var21_59 instanceof Function)) {
                                                if (var21_59 == var3_3) {
                                                    var21_59 = ScriptRuntime.wrapNumber(var14_12[var19_27]);
                                                }
                                                throw ScriptRuntime.notFunctionError(var21_59);
                                            }
                                            var22_100 = (Function)var21_59;
                                            if (var22_100 instanceof IdFunctionObject && Continuation.isContinuationConstructor(var23_120 = (IdFunctionObject)var22_100)) {
                                                Interpreter.captureContinuation(var0, var1_1, var19_27);
                                                continue block149;
                                            }
                                            var23_121 = Interpreter.getArgsArray(var13_10, var14_12, var19_27 + 1, var9_7);
                                            var13_10[var19_27] = var22_100.construct(var0, var1_1.scope, var23_121);
                                            continue block149;
                                        }
                                        case 32: {
                                            var21_60 = var13_10[var19_27];
                                            if (var21_60 == var3_3) {
                                                var21_60 = ScriptRuntime.wrapNumber(var14_12[var19_27]);
                                            }
                                            var13_10[var19_27] = ScriptRuntime.typeof(var21_60);
                                            continue block149;
                                        }
                                        case -14: {
                                            var13_10[++var19_27] = ScriptRuntime.typeofName(var1_1.scope, var8_6);
                                            continue block149;
                                        }
                                        case 40: {
                                            var13_10[++var19_27] = var8_6;
                                            continue block149;
                                        }
                                        case -27: {
                                            var13_10[++var19_27] = var3_3;
                                            var14_12[var19_27] = Interpreter.getShort(var17_20 /* !! */ , var1_1.pc);
                                            var1_1.pc += 2;
                                            continue block149;
                                        }
                                        case -28: {
                                            var13_10[++var19_27] = var3_3;
                                            var14_12[var19_27] = Interpreter.getInt(var17_20 /* !! */ , var1_1.pc);
                                            var1_1.pc += 4;
                                            continue block149;
                                        }
                                        case 39: {
                                            var13_10[++var19_27] = var3_3;
                                            var14_12[var19_27] = var1_1.idata.itsDoubleTable[var9_7];
                                            continue block149;
                                        }
                                        case 38: {
                                            var13_10[++var19_27] = ScriptRuntime.name(var0, var1_1.scope, var8_6);
                                            continue block149;
                                        }
                                        case -8: {
                                            var13_10[++var19_27] = ScriptRuntime.nameIncrDecr(var1_1.scope, var8_6, var17_20 /* !! */ [var1_1.pc]);
                                            ++var1_1.pc;
                                            continue block149;
                                        }
                                        case -49: {
                                            var9_7 = var17_20 /* !! */ [var1_1.pc++];
                                        }
                                        case 55: {
                                            if (!var1_1.useActivation) {
                                                var15_15[var9_7] = var13_10[var19_27];
                                                var16_18 /* !! */ [var9_7] = var14_12[var19_27];
                                                continue block149;
                                            }
                                            var21_61 = var13_10[var19_27];
                                            if (var21_61 == var3_3) {
                                                var21_61 = ScriptRuntime.wrapNumber(var14_12[var19_27]);
                                            }
                                            var8_6 = var1_1.idata.argNames[var9_7];
                                            var1_1.scope.put(var8_6, var1_1.scope, var21_61);
                                            continue block149;
                                        }
                                        case -48: {
                                            var9_7 = var17_20 /* !! */ [var1_1.pc++];
                                        }
                                        case 54: {
                                            ++var19_27;
                                            if (!var1_1.useActivation) {
                                                var13_10[var19_27] = var15_15[var9_7];
                                                var14_12[var19_27] = var16_18 /* !! */ [var9_7];
                                                continue block149;
                                            }
                                            var8_6 = var1_1.idata.argNames[var9_7];
                                            var13_10[var19_27] = var1_1.scope.get(var8_6, var1_1.scope);
                                            continue block149;
                                        }
                                        case -7: {
                                            ++var19_27;
                                            var21_62 = var17_20 /* !! */ [var1_1.pc];
                                            if (!var1_1.useActivation) {
                                                var13_10[var19_27] = var3_3;
                                                var22_101 = var15_15[var9_7];
                                                if (var22_101 == var3_3) {
                                                    var23_122 = var16_18 /* !! */ [var9_7];
                                                } else {
                                                    var23_122 = ScriptRuntime.toNumber(var22_101);
                                                    var15_15[var9_7] = var3_3;
                                                }
                                                var16_18 /* !! */ [var9_7] = var25_136 = (var21_62 & 1) == 0 ? var23_122 + 1.0 : var23_122 - 1.0;
                                                var14_12[var19_27] = (var21_62 & 2) == 0 ? var25_136 : var23_122;
                                            } else {
                                                var22_101 = var1_1.idata.argNames[var9_7];
                                                var13_10[var19_27] = ScriptRuntime.nameIncrDecr(var1_1.scope, (String)var22_101, var21_62);
                                            }
                                            ++var1_1.pc;
                                            continue block149;
                                        }
                                        case -51: {
                                            var13_10[++var19_27] = var3_3;
                                            var14_12[var19_27] = 0.0;
                                            continue block149;
                                        }
                                        case -52: {
                                            var13_10[++var19_27] = var3_3;
                                            var14_12[var19_27] = 1.0;
                                            continue block149;
                                        }
                                        case 41: {
                                            var13_10[++var19_27] = null;
                                            continue block149;
                                        }
                                        case 42: {
                                            var13_10[++var19_27] = var1_1.thisObj;
                                            continue block149;
                                        }
                                        case 61: {
                                            var13_10[++var19_27] = var1_1.fnOrScript;
                                            continue block149;
                                        }
                                        case 43: {
                                            var13_10[++var19_27] = Boolean.FALSE;
                                            continue block149;
                                        }
                                        case 44: {
                                            var13_10[++var19_27] = Boolean.TRUE;
                                            continue block149;
                                        }
                                        case -50: {
                                            var13_10[++var19_27] = var4_4;
                                            continue block149;
                                        }
                                        case 2: {
                                            var21_63 = var13_10[var19_27];
                                            if (var21_63 == var3_3) {
                                                var21_63 = ScriptRuntime.wrapNumber(var14_12[var19_27]);
                                            }
                                            --var19_27;
                                            var1_1.scope = ScriptRuntime.enterWith(var21_63, var0, var1_1.scope);
                                            continue block149;
                                        }
                                        case 3: {
                                            var1_1.scope = ScriptRuntime.leaveWith(var1_1.scope);
                                            continue block149;
                                        }
                                        case 56: {
                                            var21_64 = var1_1.idata.itsICode[var1_1.pc] != 0;
                                            var22_102 = (Throwable)var13_10[--var19_27 + 1];
                                            var23_123 = var21_64 == false ? null : (Scriptable)var13_10[var9_7 += var1_1.localShift];
                                            var13_10[var9_7] = ScriptRuntime.newCatchScope(var22_102, var23_123, var8_6, var0, var1_1.scope);
                                            ++var1_1.pc;
                                            continue block149;
                                        }
                                        case 57: 
                                        case 58: {
                                            var21_65 = var13_10[var19_27];
                                            if (var21_65 == var3_3) {
                                                var21_65 = ScriptRuntime.wrapNumber(var14_12[var19_27]);
                                            }
                                            --var19_27;
                                            var13_10[var9_7 += var1_1.localShift] = ScriptRuntime.enumInit(var21_65, var0, var20_29 == 58);
                                            continue block149;
                                        }
                                        case 59: 
                                        case 60: {
                                            var21_66 = var13_10[var9_7 += var1_1.localShift];
                                            var13_10[++var19_27] = var20_29 == 59 ? ScriptRuntime.enumNext(var21_66) : ScriptRuntime.enumId(var21_66, var0);
                                            continue block149;
                                        }
                                        case 69: {
                                            var21_67 = var13_10[var19_27];
                                            if (var21_67 == var3_3) {
                                                var21_67 = ScriptRuntime.wrapNumber(var14_12[var19_27]);
                                            }
                                            var13_10[var19_27] = ScriptRuntime.specialRef(var21_67, var8_6, var0);
                                            continue block149;
                                        }
                                        case 73: {
                                            var21_68 = var13_10[var19_27];
                                            if (var21_68 == var3_3) {
                                                var21_68 = ScriptRuntime.wrapNumber(var14_12[var19_27]);
                                            }
                                            if ((var22_103 = var13_10[--var19_27]) == var3_3) {
                                                var22_103 = ScriptRuntime.wrapNumber(var14_12[var19_27]);
                                            }
                                            var13_10[var19_27] = ScriptRuntime.memberRef(var22_103, var21_68, var0, var9_7);
                                            continue block149;
                                        }
                                        case 74: {
                                            var21_69 = var13_10[var19_27];
                                            if (var21_69 == var3_3) {
                                                var21_69 = ScriptRuntime.wrapNumber(var14_12[var19_27]);
                                            }
                                            if ((var22_104 = var13_10[--var19_27]) == var3_3) {
                                                var22_104 = ScriptRuntime.wrapNumber(var14_12[var19_27]);
                                            }
                                            if ((var23_124 = var13_10[--var19_27]) == var3_3) {
                                                var23_124 = ScriptRuntime.wrapNumber(var14_12[var19_27]);
                                            }
                                            var13_10[var19_27] = ScriptRuntime.memberRef(var23_124, var22_104, var21_69, var0, var9_7);
                                            continue block149;
                                        }
                                        case 75: {
                                            var21_70 = var13_10[var19_27];
                                            if (var21_70 == var3_3) {
                                                var21_70 = ScriptRuntime.wrapNumber(var14_12[var19_27]);
                                            }
                                            var13_10[var19_27] = ScriptRuntime.nameRef(var21_70, var0, var1_1.scope, var9_7);
                                            continue block149;
                                        }
                                        case 76: {
                                            var21_71 = var13_10[var19_27];
                                            if (var21_71 == var3_3) {
                                                var21_71 = ScriptRuntime.wrapNumber(var14_12[var19_27]);
                                            }
                                            if ((var22_105 = var13_10[--var19_27]) == var3_3) {
                                                var22_105 = ScriptRuntime.wrapNumber(var14_12[var19_27]);
                                            }
                                            var13_10[var19_27] = ScriptRuntime.nameRef(var22_105, var21_71, var0, var1_1.scope, var9_7);
                                            continue block149;
                                        }
                                        case -12: {
                                            var1_1.scope = (Scriptable)var13_10[var9_7 += var1_1.localShift];
                                            continue block149;
                                        }
                                        case -13: {
                                            var13_10[var9_7 += var1_1.localShift] = var1_1.scope;
                                            continue block149;
                                        }
                                        case -19: {
                                            var13_10[++var19_27] = InterpretedFunction.createFunction(var0, var1_1.scope, var1_1.fnOrScript, var9_7);
                                            continue block149;
                                        }
                                        case -20: {
                                            Interpreter.initFunction(var0, var1_1.scope, var1_1.fnOrScript, var9_7);
                                            continue block149;
                                        }
                                        case 47: {
                                            var13_10[++var19_27] = var1_1.scriptRegExps[var9_7];
                                            continue block149;
                                        }
                                        case -29: {
                                            var13_10[++var19_27] = new Object[var9_7];
                                            var14_12[var19_27] = 0.0;
                                            continue block149;
                                        }
                                        case -30: {
                                            var21_72 = var13_10[var19_27];
                                            if (var21_72 == var3_3) {
                                                var21_72 = ScriptRuntime.wrapNumber(var14_12[var19_27]);
                                            }
                                            var22_106 = (int)var14_12[--var19_27];
                                            ((Object[])var13_10[var19_27])[var22_106] = var21_72;
                                            var14_12[var19_27] = var22_106 + 1;
                                            continue block149;
                                        }
                                        case -31: 
                                        case 63: 
                                        case 64: {
                                            var21_73 = (Object[])var13_10[var19_27];
                                            if (var20_29 == 64) {
                                                var23_125 /* !! */  = (Object[])var1_1.idata.literalIds[var9_7];
                                                var22_107 = ScriptRuntime.newObjectLiteral(var23_125 /* !! */ , var21_73, var0, var1_1.scope);
                                            } else {
                                                var23_125 /* !! */  = null;
                                                if (var20_29 == -31) {
                                                    var23_125 /* !! */  = (int[])var1_1.idata.literalIds[var9_7];
                                                }
                                                var22_107 = ScriptRuntime.newArrayLiteral(var21_73, (int[])var23_125 /* !! */ , var0, var1_1.scope);
                                            }
                                            var13_10[var19_27] = var22_107;
                                            continue block149;
                                        }
                                        case -53: {
                                            var21_74 = var13_10[var19_27];
                                            if (var21_74 == var3_3) {
                                                var21_74 = ScriptRuntime.wrapNumber(var14_12[var19_27]);
                                            }
                                            --var19_27;
                                            var1_1.scope = ScriptRuntime.enterDotQuery(var21_74, var1_1.scope);
                                            continue block149;
                                        }
                                        case -54: {
                                            var21_75 = Interpreter.stack_boolean(var1_1, var19_27);
                                            var22_108 = ScriptRuntime.updateDotQuery(var21_75, var1_1.scope);
                                            if (var22_108 != null) {
                                                var13_10[var19_27] = var22_108;
                                                var1_1.scope = ScriptRuntime.leaveDotQuery(var1_1.scope);
                                                var1_1.pc += 2;
                                                continue block149;
                                            }
                                            --var19_27;
                                            break;
                                        }
                                        case 70: {
                                            var21_76 = var13_10[var19_27];
                                            if (var21_76 == var3_3) {
                                                var21_76 = ScriptRuntime.wrapNumber(var14_12[var19_27]);
                                            }
                                            var13_10[var19_27] = ScriptRuntime.setDefaultNamespace(var21_76, var0);
                                            continue block149;
                                        }
                                        case 71: {
                                            var21_77 = var13_10[var19_27];
                                            if (var21_77 == var3_3) continue block149;
                                            var13_10[var19_27] = ScriptRuntime.escapeAttributeValue(var21_77, var0);
                                            continue block149;
                                        }
                                        case 72: {
                                            var21_78 = var13_10[var19_27];
                                            if (var21_78 == var3_3) continue block149;
                                            var13_10[var19_27] = ScriptRuntime.escapeTextValue(var21_78, var0);
                                            continue block149;
                                        }
                                        case -26: {
                                            var1_1.pcSourceLineStart = var1_1.pc;
                                            if (var1_1.debuggerFrame != null) {
                                                var21_79 = Interpreter.getIndex(var17_20 /* !! */ , var1_1.pc);
                                                var1_1.debuggerFrame.onLineChange(var0, var21_79);
                                            }
                                            var1_1.pc += 2;
                                            continue block149;
                                        }
                                        case -32: {
                                            var9_7 = 0;
                                            continue block149;
                                        }
                                        case -33: {
                                            var9_7 = 1;
                                            continue block149;
                                        }
                                        case -34: {
                                            var9_7 = 2;
                                            continue block149;
                                        }
                                        case -35: {
                                            var9_7 = 3;
                                            continue block149;
                                        }
                                        case -36: {
                                            var9_7 = 4;
                                            continue block149;
                                        }
                                        case -37: {
                                            var9_7 = 5;
                                            continue block149;
                                        }
                                        case -38: {
                                            var9_7 = 255 & var17_20 /* !! */ [var1_1.pc];
                                            ++var1_1.pc;
                                            continue block149;
                                        }
                                        case -39: {
                                            var9_7 = Interpreter.getIndex(var17_20 /* !! */ , var1_1.pc);
                                            var1_1.pc += 2;
                                            continue block149;
                                        }
                                        case -40: {
                                            var9_7 = Interpreter.getInt(var17_20 /* !! */ , var1_1.pc);
                                            var1_1.pc += 4;
                                            continue block149;
                                        }
                                        case -41: {
                                            var8_6 = var18_22[0];
                                            continue block149;
                                        }
                                        case -42: {
                                            var8_6 = var18_22[1];
                                            continue block149;
                                        }
                                        case -43: {
                                            var8_6 = var18_22[2];
                                            continue block149;
                                        }
                                        case -44: {
                                            var8_6 = var18_22[3];
                                            continue block149;
                                        }
                                        case -45: {
                                            var8_6 = var18_22[255 & var17_20 /* !! */ [var1_1.pc]];
                                            ++var1_1.pc;
                                            continue block149;
                                        }
                                        case -46: {
                                            var8_6 = var18_22[Interpreter.getIndex(var17_20 /* !! */ , var1_1.pc)];
                                            var1_1.pc += 2;
                                            continue block149;
                                        }
                                        case -47: {
                                            var8_6 = var18_22[Interpreter.getInt(var17_20 /* !! */ , var1_1.pc)];
                                            var1_1.pc += 4;
                                            continue block149;
                                        }
                                        default: {
                                            Interpreter.dumpICode(var1_1.idata);
                                            throw new RuntimeException("Unknown icode : " + var20_29 + " @ pc : " + (var1_1.pc - 1));
                                        }
                                    }
                                    if (var5_5) {
                                        Interpreter.addInstructionCount(var0, var1_1, 2);
                                    }
                                    var1_1.pc = (var21_80 = Interpreter.getShort(var17_20 /* !! */ , var1_1.pc)) != 0 ? (var1_1.pc += var21_80 - 1) : var1_1.idata.longJumps.getExistingInt(var1_1.pc);
                                    if (!var5_5) continue;
                                    var1_1.pcPrevBranch = var1_1.pc;
                                }
                                Interpreter.exitFrame(var0, var1_1, null);
                                var10_8 = var1_1.result;
                                var11_9 = var1_1.resultDbl;
                                if (var1_1.parentFrame != null) {
                                    var1_1 = var1_1.parentFrame;
                                    if (var1_1.frozen) {
                                        var1_1 = var1_1.cloneFrozen();
                                    }
                                    Interpreter.setCallResult(var1_1, var10_8, var11_9);
                                    var10_8 = null;
                                    continue;
                                }
                                break block268;
                                break;
                            }
                        }
                        catch (Throwable var13_11) {
                            if (var2_2 != null) {
                                var13_11.printStackTrace(System.err);
                                throw new IllegalStateException();
                            }
                            var2_2 = var13_11;
                        }
                    }
                    if (var2_2 == null) {
                        Kit.codeBug();
                    }
                    var17_20 /* !! */  = null;
                    if (var2_2 instanceof JavaScriptException) {
                        var16_19 = 2;
                    } else if (var2_2 instanceof EcmaError) {
                        var16_19 = 2;
                    } else if (var2_2 instanceof EvaluatorException) {
                        var16_19 = 2;
                    } else if (var2_2 instanceof RuntimeException) {
                        var16_19 = 1;
                    } else if (var2_2 instanceof Error) {
                        var16_19 = 0;
                    } else {
                        var16_19 = 1;
                        var17_20 /* !! */  = (byte[])((ContinuationJump)var2_2);
                    }
                    if (var5_5) {
                        try {
                            Interpreter.addInstructionCount(var0, var1_1, 100);
                        }
                        catch (RuntimeException var18_23) {
                            var2_2 = var18_23;
                            var16_19 = 1;
                        }
                        catch (Error var18_24) {
                            var2_2 = var18_24;
                            var17_20 /* !! */  = null;
                            var16_19 = 0;
                        }
                    }
                    if (var1_1.debuggerFrame != null && var2_2 instanceof RuntimeException) {
                        var18_25 = (RuntimeException)var2_2;
                        try {
                            var1_1.debuggerFrame.onExceptionThrown(var0, var18_25);
                        }
                        catch (Throwable var19_28) {
                            var2_2 = var19_28;
                            var17_20 /* !! */  = null;
                            var16_19 = 0;
                        }
                    }
                    do {
                        if (var16_19 != 0 && (var9_7 = Interpreter.getExceptionHandler(var1_1, var18_26 = var16_19 != 2)) >= 0) continue block145;
                        Interpreter.exitFrame(var0, var1_1, var2_2);
                        var1_1 = var1_1.parentFrame;
                        if (var1_1 == null) break block269;
                    } while (var17_20 /* !! */  == null || var17_20 /* !! */ .branchFrame != var1_1);
                    var9_7 = -1;
                    continue;
                }
                if (var17_20 /* !! */  == null) break block268;
                if (var17_20 /* !! */ .branchFrame != null) {
                    Kit.codeBug();
                }
                if (var17_20 /* !! */ .capturedFrame == null) break;
                var9_7 = -1;
            }
            var10_8 = var17_20 /* !! */ .result;
            var11_9 = var17_20 /* !! */ .resultDbl;
            var2_2 = null;
        }
        if (var0.previousInterpreterInvocations != null && var0.previousInterpreterInvocations.size() != 0) {
            var0.lastInterpreterFrame = var0.previousInterpreterInvocations.pop();
        } else {
            var0.lastInterpreterFrame = null;
            var0.previousInterpreterInvocations = null;
        }
        if (var2_2 != null) {
            if (var2_2 instanceof RuntimeException) {
                throw (RuntimeException)var2_2;
            }
            throw (Error)var2_2;
        }
        return var10_8 != var3_3 ? var10_8 : ScriptRuntime.wrapNumber(var11_9);
    }

    private static void initFrame(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray, double[] dArray, int n, int n2, InterpretedFunction interpretedFunction, CallFrame callFrame, CallFrame callFrame2) {
        int n3;
        double[] dArray2;
        Object[] objectArray2;
        boolean bl;
        int n4;
        int n5;
        Scriptable scriptable3;
        InterpreterData interpreterData = interpretedFunction.idata;
        boolean bl2 = interpreterData.itsNeedsActivation;
        DebugFrame debugFrame = null;
        if (context.debugger != null && (debugFrame = context.debugger.getFrame(context, interpreterData)) != null) {
            bl2 = true;
        }
        if (bl2) {
            if (dArray != null) {
                objectArray = Interpreter.getArgsArray(objectArray, dArray, n, n2);
            }
            n = 0;
            dArray = null;
        }
        if (interpreterData.itsFunctionType != 0) {
            scriptable3 = !interpreterData.useDynamicScope ? interpretedFunction.getParentScope() : scriptable;
            if (bl2) {
                scriptable3 = ScriptRuntime.createFunctionActivation(interpretedFunction, scriptable3, objectArray);
            }
        } else {
            scriptable3 = scriptable;
            ScriptRuntime.initScript(interpretedFunction, scriptable2, context, scriptable3, interpretedFunction.idata.evalScriptFlag);
        }
        if (interpreterData.itsNestedFunctions != null) {
            if (interpreterData.itsFunctionType != 0 && !interpreterData.itsNeedsActivation) {
                Kit.codeBug();
            }
            for (int i = 0; i < interpreterData.itsNestedFunctions.length; ++i) {
                InterpreterData interpreterData2 = interpreterData.itsNestedFunctions[i];
                if (interpreterData2.itsFunctionType != 1) continue;
                Interpreter.initFunction(context, scriptable3, interpretedFunction, i);
            }
        }
        Scriptable[] scriptableArray = null;
        if (interpreterData.itsRegExpLiterals != null) {
            scriptableArray = interpreterData.itsFunctionType != 0 ? interpretedFunction.functionRegExps : interpretedFunction.createRegExpWraps(context, scriptable3);
        }
        if ((n5 = interpreterData.itsMaxFrameArray) != (n4 = interpreterData.itsMaxVars + interpreterData.itsMaxLocals - 1) + interpreterData.itsMaxStack + 1) {
            Kit.codeBug();
        }
        if (callFrame2.stack != null && n5 <= callFrame2.stack.length) {
            bl = true;
            objectArray2 = callFrame2.stack;
            dArray2 = callFrame2.sDbl;
        } else {
            bl = false;
            objectArray2 = new Object[n5];
            dArray2 = new double[n5];
        }
        int n6 = interpreterData.argCount;
        if (n6 > n2) {
            n6 = n2;
        }
        callFrame2.parentFrame = callFrame;
        int n7 = callFrame2.frameIndex = callFrame == null ? 0 : callFrame.frameIndex + 1;
        if (callFrame2.frameIndex > context.getMaximumInterpreterStackDepth()) {
            throw Context.reportRuntimeError("Exceeded maximum stack depth");
        }
        callFrame2.frozen = false;
        callFrame2.fnOrScript = interpretedFunction;
        callFrame2.idata = interpreterData;
        callFrame2.stack = objectArray2;
        callFrame2.sDbl = dArray2;
        callFrame2.varSource = callFrame2;
        callFrame2.localShift = interpreterData.itsMaxVars;
        callFrame2.emptyStackTop = n4;
        callFrame2.debuggerFrame = debugFrame;
        callFrame2.useActivation = bl2;
        callFrame2.thisObj = scriptable2;
        callFrame2.scriptRegExps = scriptableArray;
        callFrame2.result = Undefined.instance;
        callFrame2.pc = 0;
        callFrame2.pcPrevBranch = 0;
        callFrame2.pcSourceLineStart = interpreterData.firstLinePC;
        callFrame2.scope = scriptable3;
        callFrame2.savedStackTop = n4;
        callFrame2.savedCallOp = 0;
        System.arraycopy(objectArray, n, objectArray2, 0, n6);
        if (dArray != null) {
            System.arraycopy(dArray, n, dArray2, 0, n6);
        }
        for (n3 = n6; n3 != interpreterData.itsMaxVars; ++n3) {
            objectArray2[n3] = Undefined.instance;
        }
        if (bl) {
            for (n3 = n4 + 1; n3 != objectArray2.length; ++n3) {
                objectArray2[n3] = null;
            }
        }
        Interpreter.enterFrame(context, callFrame2, objectArray, false);
    }

    private static boolean isFrameEnterExitRequired(CallFrame callFrame) {
        return callFrame.debuggerFrame != null || callFrame.idata.itsNeedsActivation;
    }

    private static void enterFrame(Context context, CallFrame callFrame, Object[] objectArray, boolean bl) {
        boolean bl2;
        boolean bl3 = callFrame.idata.itsNeedsActivation;
        boolean bl4 = bl2 = callFrame.debuggerFrame != null;
        if (bl3 || bl2) {
            Scriptable scriptable = callFrame.scope;
            if (scriptable == null) {
                Kit.codeBug();
            } else if (bl) {
                while (!(scriptable instanceof NativeCall)) {
                    if ((scriptable = scriptable.getParentScope()) != null && (callFrame.parentFrame == null || callFrame.parentFrame.scope != scriptable)) continue;
                    Kit.codeBug();
                    break;
                }
            }
            if (bl2) {
                callFrame.debuggerFrame.onEnter(context, scriptable, callFrame.thisObj, objectArray);
            }
            if (bl3) {
                ScriptRuntime.enterActivationFunction(context, scriptable);
            }
        }
    }

    private static void exitFrame(Context context, CallFrame callFrame, Object object) {
        if (callFrame.idata.itsNeedsActivation) {
            ScriptRuntime.exitActivationFunction(context);
        }
        if (callFrame.debuggerFrame != null) {
            try {
                if (object instanceof Throwable) {
                    callFrame.debuggerFrame.onExit(context, true, object);
                } else {
                    ContinuationJump continuationJump = (ContinuationJump)object;
                    Object object2 = continuationJump == null ? callFrame.result : continuationJump.result;
                    if (object2 == UniqueTag.DOUBLE_MARK) {
                        double d = continuationJump == null ? callFrame.resultDbl : continuationJump.resultDbl;
                        object2 = ScriptRuntime.wrapNumber(d);
                    }
                    callFrame.debuggerFrame.onExit(context, false, object2);
                }
            }
            catch (Throwable throwable) {
                System.err.println("RHINO USAGE WARNING: onExit terminated with exception");
                throwable.printStackTrace(System.err);
            }
        }
    }

    private static void setCallResult(CallFrame callFrame, Object object, double d) {
        if (callFrame.savedCallOp == 37) {
            callFrame.stack[callFrame.savedStackTop] = object;
            callFrame.sDbl[callFrame.savedStackTop] = d;
        } else if (callFrame.savedCallOp == 30) {
            if (object instanceof Scriptable) {
                callFrame.stack[callFrame.savedStackTop] = object;
            }
        } else {
            Kit.codeBug();
        }
        callFrame.savedCallOp = 0;
    }

    private static void captureContinuation(Context context, CallFrame callFrame, int n) {
        Continuation continuation = new Continuation();
        ScriptRuntime.setObjectProtoAndParent(continuation, ScriptRuntime.getTopCallScope(context));
        CallFrame callFrame2 = callFrame.parentFrame;
        while (callFrame2 != null && !callFrame2.frozen) {
            callFrame2.frozen = true;
            for (int i = callFrame2.savedStackTop + 1; i != callFrame2.stack.length; ++i) {
                callFrame2.stack[i] = null;
            }
            if (callFrame2.savedCallOp == 37) {
                callFrame2.stack[callFrame2.savedStackTop] = null;
            } else if (callFrame2.savedCallOp != 30) {
                Kit.codeBug();
            }
            callFrame2 = callFrame2.parentFrame;
        }
        continuation.initImplementation(callFrame.parentFrame);
        callFrame.stack[n] = continuation;
    }

    private static int stack_int32(CallFrame callFrame, int n) {
        Object object = callFrame.stack[n];
        double d = object == UniqueTag.DOUBLE_MARK ? callFrame.sDbl[n] : ScriptRuntime.toNumber(object);
        return ScriptRuntime.toInt32(d);
    }

    private static double stack_double(CallFrame callFrame, int n) {
        Object object = callFrame.stack[n];
        if (object != UniqueTag.DOUBLE_MARK) {
            return ScriptRuntime.toNumber(object);
        }
        return callFrame.sDbl[n];
    }

    private static boolean stack_boolean(CallFrame callFrame, int n) {
        Object object = callFrame.stack[n];
        if (object == Boolean.TRUE) {
            return true;
        }
        if (object == Boolean.FALSE) {
            return false;
        }
        if (object == UniqueTag.DOUBLE_MARK) {
            double d = callFrame.sDbl[n];
            return d == d && d != 0.0;
        }
        if (object == null || object == Undefined.instance) {
            return false;
        }
        if (object instanceof Number) {
            double d = ((Number)object).doubleValue();
            return d == d && d != 0.0;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return ScriptRuntime.toBoolean(object);
    }

    private static void do_add(Object[] objectArray, double[] dArray, int n, Context context) {
        boolean bl;
        double d;
        Object object = objectArray[n + 1];
        Object object2 = objectArray[n];
        if (object == UniqueTag.DOUBLE_MARK) {
            d = dArray[n + 1];
            if (object2 == UniqueTag.DOUBLE_MARK) {
                int n2 = n;
                dArray[n2] = dArray[n2] + d;
                return;
            }
            bl = true;
        } else if (object2 == UniqueTag.DOUBLE_MARK) {
            d = dArray[n];
            object2 = object;
            bl = false;
        } else {
            if (object2 instanceof Scriptable || object instanceof Scriptable) {
                objectArray[n] = ScriptRuntime.add(object2, object, context);
            } else if (object2 instanceof String) {
                String string2 = (String)object2;
                String string3 = ScriptRuntime.toString(object);
                objectArray[n] = string2.concat(string3);
            } else if (object instanceof String) {
                String string4 = ScriptRuntime.toString(object2);
                String string5 = (String)object;
                objectArray[n] = string4.concat(string5);
            } else {
                double d2 = object2 instanceof Number ? ((Number)object2).doubleValue() : ScriptRuntime.toNumber(object2);
                double d3 = object instanceof Number ? ((Number)object).doubleValue() : ScriptRuntime.toNumber(object);
                objectArray[n] = UniqueTag.DOUBLE_MARK;
                dArray[n] = d2 + d3;
            }
            return;
        }
        if (object2 instanceof Scriptable) {
            object = ScriptRuntime.wrapNumber(d);
            if (!bl) {
                Object object3 = object2;
                object2 = object;
                object = object3;
            }
            objectArray[n] = ScriptRuntime.add(object2, object, context);
        } else if (object2 instanceof String) {
            String string6 = (String)object2;
            String string7 = ScriptRuntime.toString(d);
            objectArray[n] = bl ? string6.concat(string7) : string7.concat(string6);
        } else {
            double d4 = object2 instanceof Number ? ((Number)object2).doubleValue() : ScriptRuntime.toNumber(object2);
            objectArray[n] = UniqueTag.DOUBLE_MARK;
            dArray[n] = d4 + d;
        }
    }

    private static Object[] getArgsArray(Object[] objectArray, double[] dArray, int n, int n2) {
        if (n2 == 0) {
            return ScriptRuntime.emptyArgs;
        }
        Object[] objectArray2 = new Object[n2];
        int n3 = 0;
        while (n3 != n2) {
            Object object = objectArray[n];
            if (object == UniqueTag.DOUBLE_MARK) {
                object = ScriptRuntime.wrapNumber(dArray[n]);
            }
            objectArray2[n3] = object;
            ++n3;
            ++n;
        }
        return objectArray2;
    }

    private static void addInstructionCount(Context context, CallFrame callFrame, int n) {
        context.instructionCount += callFrame.pc - callFrame.pcPrevBranch + n;
        if (context.instructionCount > context.instructionThreshold) {
            context.observeInstructionCount(context.instructionCount);
            context.instructionCount = 0;
        }
    }

    private static final class ContinuationJump
    implements Serializable {
        static final long serialVersionUID = 7687739156004308247L;
        CallFrame capturedFrame;
        CallFrame branchFrame;
        Object result;
        double resultDbl;

        ContinuationJump(Continuation continuation, CallFrame callFrame) {
            this.capturedFrame = (CallFrame)continuation.getImplementation();
            if (this.capturedFrame == null || callFrame == null) {
                this.branchFrame = null;
            } else {
                CallFrame callFrame2 = this.capturedFrame;
                CallFrame callFrame3 = callFrame;
                int n = callFrame2.frameIndex - callFrame3.frameIndex;
                if (n != 0) {
                    if (n < 0) {
                        callFrame2 = callFrame;
                        callFrame3 = this.capturedFrame;
                        n = -n;
                    }
                    do {
                        callFrame2 = callFrame2.parentFrame;
                    } while (--n != 0);
                    if (callFrame2.frameIndex != callFrame3.frameIndex) {
                        Kit.codeBug();
                    }
                }
                while (callFrame2 != callFrame3 && callFrame2 != null) {
                    callFrame2 = callFrame2.parentFrame;
                    callFrame3 = callFrame3.parentFrame;
                }
                this.branchFrame = callFrame2;
                if (this.branchFrame != null && !this.branchFrame.frozen) {
                    Kit.codeBug();
                }
            }
        }
    }

    private static class CallFrame
    implements Cloneable,
    Serializable {
        static final long serialVersionUID = -2843792508994958978L;
        CallFrame parentFrame;
        int frameIndex;
        boolean frozen;
        InterpretedFunction fnOrScript;
        InterpreterData idata;
        Object[] stack;
        double[] sDbl;
        CallFrame varSource;
        int localShift;
        int emptyStackTop;
        DebugFrame debuggerFrame;
        boolean useActivation;
        Scriptable thisObj;
        Scriptable[] scriptRegExps;
        Object result;
        double resultDbl;
        int pc;
        int pcPrevBranch;
        int pcSourceLineStart;
        Scriptable scope;
        int savedStackTop;
        int savedCallOp;

        private CallFrame() {
        }

        CallFrame cloneFrozen() {
            CallFrame callFrame;
            if (!this.frozen) {
                Kit.codeBug();
            }
            try {
                callFrame = (CallFrame)this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException();
            }
            callFrame.stack = (Object[])this.stack.clone();
            callFrame.sDbl = (double[])this.sDbl.clone();
            callFrame.frozen = false;
            return callFrame;
        }
    }
}

