/*
 * Decompiled with CFR 0.152.
 */
package cn.bugstack.chatglm.model;

import cn.bugstack.chatglm.model.Model;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ImageCompletionRequest {
    private Model model = Model.COGVIEW_3;
    private String prompt;

    public String getModel() {
        return this.model.getCode();
    }

    public Model getModelEnum() {
        return this.model;
    }

    public String toString() {
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        paramsMap.put("model", this.model.getCode());
        paramsMap.put("prompt", this.prompt);
        try {
            return new ObjectMapper().writeValueAsString(paramsMap);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static ImageCompletionRequestBuilder builder() {
        return new ImageCompletionRequestBuilder();
    }

    public String getPrompt() {
        return this.prompt;
    }

    public void setModel(Model model) {
        this.model = model;
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImageCompletionRequest)) {
            return false;
        }
        ImageCompletionRequest other = (ImageCompletionRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        String this$prompt = this.getPrompt();
        String other$prompt = other.getPrompt();
        return !(this$prompt == null ? other$prompt != null : !this$prompt.equals(other$prompt));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ImageCompletionRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        String $prompt = this.getPrompt();
        result = result * 59 + ($prompt == null ? 43 : $prompt.hashCode());
        return result;
    }

    public ImageCompletionRequest() {
    }

    public ImageCompletionRequest(Model model, String prompt) {
        this.model = model;
        this.prompt = prompt;
    }

    public static class ImageCompletionRequestBuilder {
        private Model model;
        private String prompt;

        ImageCompletionRequestBuilder() {
        }

        public ImageCompletionRequestBuilder model(Model model) {
            this.model = model;
            return this;
        }

        public ImageCompletionRequestBuilder prompt(String prompt) {
            this.prompt = prompt;
            return this;
        }

        public ImageCompletionRequest build() {
            return new ImageCompletionRequest(this.model, this.prompt);
        }

        public String toString() {
            return "ImageCompletionRequest.ImageCompletionRequestBuilder(model=" + (Object)((Object)this.model) + ", prompt=" + this.prompt + ")";
        }
    }
}

