/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator.client.request;

import com.graphql_java_generator.annotation.GraphQLScalar;
import com.graphql_java_generator.client.GraphqlClientUtils;
import com.graphql_java_generator.client.request.InputParameter;
import com.graphql_java_generator.client.request.ObjectResponse;
import com.graphql_java_generator.client.response.GraphQLRequestPreparationException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class Builder {
    private static final String STRING_TOKENIZER_DELIMITER = " {},:()";
    GraphqlClientUtils graphqlClientUtils = new GraphqlClientUtils();
    final ObjectResponse objectResponse;

    public Builder(Class<?> owningClass, String fieldName) throws GraphQLRequestPreparationException {
        this.objectResponse = new ObjectResponse(owningClass, fieldName, null);
    }

    public Builder(Class<?> owningClass, String fieldName, String fieldAlias) throws GraphQLRequestPreparationException {
        this.objectResponse = new ObjectResponse(owningClass, fieldName, fieldAlias);
    }

    public Builder withField(String fieldName) throws GraphQLRequestPreparationException {
        return this.withField(fieldName, null);
    }

    public Builder withField(String fieldName, String alias) throws GraphQLRequestPreparationException {
        this.graphqlClientUtils.checkFieldOfGraphQLType(fieldName, true, this.objectResponse.field.clazz);
        for (ObjectResponse.Field field : this.objectResponse.scalarFields) {
            if (!field.name.equals(fieldName)) continue;
            throw new GraphQLRequestPreparationException("The field <" + fieldName + "> is already in the field list for the objet <" + this.objectResponse.field.name + ">");
        }
        this.objectResponse.scalarFields.add(new ObjectResponse.Field(fieldName, alias, this.objectResponse.field.clazz, this.graphqlClientUtils.checkFieldOfGraphQLType(fieldName, true, this.objectResponse.field.clazz)));
        return this;
    }

    public Builder withInputParameter(InputParameter inputParameter) {
        this.objectResponse.addInputParameter(inputParameter);
        return this;
    }

    public Builder withInputParameters(List<InputParameter> inputParameters) {
        this.objectResponse.addInputParameters(inputParameters);
        return this;
    }

    public Builder withSubObject(ObjectResponse subobjetResponseDef) throws GraphQLRequestPreparationException {
        if (subobjetResponseDef.field.owningClass != this.objectResponse.getFieldClass()) {
            throw new GraphQLRequestPreparationException("Class mismatch when trying to add the Field '" + subobjetResponseDef.getFieldName() + "' owned by the class '" + subobjetResponseDef.getOwningClass().getName() + "' to the field '" + this.objectResponse.getFieldName() + "' of class '" + this.objectResponse.getFieldClass().getName() + "' (the two classes should be identical)");
        }
        for (ObjectResponse subObject : this.objectResponse.subObjects) {
            if (!subObject.field.name.equals(subobjetResponseDef.getFieldName())) continue;
            throw new GraphQLRequestPreparationException("The field <" + subObject.field.name + "> is already in the field list for the objet <" + this.objectResponse.field.name + ">");
        }
        this.objectResponse.subObjects.add(subobjetResponseDef);
        return this;
    }

    public ObjectResponse build() throws GraphQLRequestPreparationException {
        if (this.objectResponse.scalarFields.size() == 0 && this.objectResponse.subObjects.size() == 0) {
            this.addKnownScalarFields();
        }
        return this.objectResponse;
    }

    public Builder withQueryResponseDef(String queryResponseDef) throws GraphQLRequestPreparationException {
        if (queryResponseDef == null || queryResponseDef.trim().equals("")) {
            this.addKnownScalarFields();
        } else {
            StringTokenizer st = new StringTokenizer(queryResponseDef, STRING_TOKENIZER_DELIMITER, true);
            String token = " ";
            while (token.equals(" ")) {
                token = st.nextToken();
            }
            if (!token.equals("{")) {
                throw new GraphQLRequestPreparationException("The queryResponseDef should start with '{'");
            }
            QueryField queryField = new QueryField(this.objectResponse.field.name);
            try {
                queryField.readTokenizerForResponseDefinition(st);
            }
            catch (GraphQLRequestPreparationException e) {
                throw new GraphQLRequestPreparationException(e.getMessage() + " while reading the queryReponseDef: " + queryResponseDef, e);
            }
            block9: while (st.hasMoreTokens()) {
                switch (token = st.nextToken()) {
                    case " ": {
                        continue block9;
                    }
                }
                throw new GraphQLRequestPreparationException("Unexpected token <" + token + "> at the end of the queryReponseDef: " + queryResponseDef);
            }
            this.withQueryField(queryField);
        }
        return this;
    }

    private void addKnownScalarFields() throws GraphQLRequestPreparationException {
        if (this.objectResponse.getFieldClass().isInterface()) {
            for (Method method : this.objectResponse.getFieldClass().getDeclaredMethods()) {
                GraphQLScalar annotation;
                if (!method.getName().startsWith("get") || (annotation = method.getAnnotation(GraphQLScalar.class)) == null) continue;
                this.withField(Builder.getCamelCase(method.getName().substring(3)));
            }
        } else {
            for (Field attribute : this.objectResponse.getFieldClass().getDeclaredFields()) {
                GraphQLScalar annotation = attribute.getAnnotation(GraphQLScalar.class);
                if (annotation == null) continue;
                this.withField(Builder.getCamelCase(attribute.getName()));
            }
        }
    }

    public static String getCamelCase(String name) {
        return name.substring(0, 1).toLowerCase() + name.substring(1);
    }

    private Builder withQueryField(QueryField queryField) throws GraphQLRequestPreparationException {
        if (!queryField.name.equals(this.objectResponse.getFieldName())) {
            throw new GraphQLRequestPreparationException("[INTERNAL ERROR] the field name of the queryField is <" + queryField.name + "> whereas the field name of the objetResponseDef is <" + this.objectResponse.getFieldName() + ">");
        }
        for (QueryField field : queryField.fields) {
            if (field.fields.size() == 0) {
                this.withField(field.name, field.alias);
                continue;
            }
            Builder subobjectResponseDef = new Builder(this.objectResponse.field.clazz, field.name, field.alias).withQueryField(field).withInputParameters(field.inputParameters);
            this.withSubObject(subobjectResponseDef.build());
        }
        return this;
    }

    class QueryField {
        String name;
        String alias;
        List<InputParameter> inputParameters = new ArrayList<InputParameter>();
        List<QueryField> fields = new ArrayList<QueryField>();

        QueryField(String name) {
            this.name = name;
        }

        public void readTokenizerForResponseDefinition(StringTokenizer st) throws GraphQLRequestPreparationException {
            QueryField lastReadField = null;
            block14: while (st.hasMoreTokens()) {
                String token;
                switch (token = st.nextToken()) {
                    case " ": {
                        continue block14;
                    }
                    case ":": {
                        if (lastReadField == null) {
                            throw new GraphQLRequestPreparationException("The given query has a ':' character, not preceded by a proper alias name (before <" + st.nextToken() + ">)");
                        }
                        lastReadField.alias = lastReadField.name;
                        lastReadField.name = " ";
                        while (lastReadField.name.equals(" ")) {
                            lastReadField.name = st.nextToken();
                        }
                        continue block14;
                    }
                    case "(": {
                        if (lastReadField == null) {
                            throw new GraphQLRequestPreparationException("The given query has a parentesis '(' not preceded by a field name (error while reading field <" + this.name + ">");
                        }
                        lastReadField.readTokenizerForInputParameters(st);
                        continue block14;
                    }
                    case "{": {
                        if (lastReadField == null) {
                            throw new GraphQLRequestPreparationException("The given query has two '{', one after another (error while reading field <" + this.name + ">)");
                        }
                        if (lastReadField.fields.size() > 0) {
                            throw new GraphQLRequestPreparationException("The given query contains a '{' not preceded by a fieldname, after field <" + lastReadField.name + "> while reading <" + this.name + ">");
                        }
                        lastReadField.readTokenizerForResponseDefinition(st);
                        lastReadField = null;
                        continue block14;
                    }
                    case "}": {
                        return;
                    }
                }
                lastReadField = new QueryField(token);
                this.fields.add(lastReadField);
            }
            throw new GraphQLRequestPreparationException("The field <" + this.name + "> has a non finished list of fields (it lacks the finishing '}') while reading <" + this.name + ">");
        }

        void readTokenizerForInputParameters(StringTokenizer st) throws GraphQLRequestPreparationException {
            InputParameterStep step = InputParameterStep.NAME;
            String parameterName = null;
            block17: while (st.hasMoreTokens()) {
                String token;
                switch (token = st.nextToken()) {
                    case "{": {
                        throw new GraphQLRequestPreparationException("Encountered a '{' while reading parameters for the field '" + this.name + "' : if you're using DirectQueries with field's parameter, please note that input parameters are not managed in Direct Queries. Please use Prepared Queries. If you're not using field's parameter, please correct the query syntax");
                    }
                    case ":": 
                    case " ": {
                        continue block17;
                    }
                    case ",": {
                        if (step == InputParameterStep.NAME) continue block17;
                        throw new GraphQLRequestPreparationException("Misplacer comma for the field '" + this.name + "' is not finished (no closing parenthesis)");
                    }
                    case ")": {
                        if (parameterName == null) {
                            throw new GraphQLRequestPreparationException("Misplaced closing parenthesis for the field '" + this.name + "' (no parameter has been read)");
                        }
                        if (step != InputParameterStep.NAME) {
                            throw new GraphQLRequestPreparationException("Misplaced closing parenthesis for the field '" + this.name + "' is not finished (no closing parenthesis)");
                        }
                        return;
                    }
                }
                switch (step) {
                    case NAME: {
                        parameterName = token;
                        step = InputParameterStep.VALUE;
                        break;
                    }
                    case VALUE: {
                        if (token.startsWith("?")) {
                            this.inputParameters.add(InputParameter.newBindParameter(parameterName, token.substring(1), false));
                        } else if (token.startsWith("&")) {
                            this.inputParameters.add(InputParameter.newBindParameter(parameterName, token.substring(1), true));
                        } else if (token.startsWith("\"") && token.endsWith("\"")) {
                            String value = token.substring(1, token.length() - 1);
                            this.inputParameters.add(InputParameter.newHardCodedParameter(parameterName, value));
                        } else {
                            if (token.startsWith("\"") || token.endsWith("\"")) {
                                throw new GraphQLRequestPreparationException("Bad parameter value: parameter values should start and finish by \", or not having any \" at the beginning and end.. But it's not the case for the value <" + token + "> of parameter <" + parameterName + ">. Maybe you wanted to add a bind parameter instead (bind parameter must start with a ? or a &");
                            }
                            this.inputParameters.add(InputParameter.newHardCodedParameter(parameterName, token));
                        }
                        step = InputParameterStep.NAME;
                    }
                }
            }
            throw new GraphQLRequestPreparationException("The list of parameters for the field '" + this.name + "' is not finished (no closing parenthesis)");
        }
    }

    private static enum InputParameterStep {
        NAME,
        VALUE;

    }
}

