/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.javacompilerscriptengine;

import de.sormuras.javacompilerscriptengine.JavaCompilerScriptEngineFactory;
import de.sormuras.javacompilerscriptengine.JavaCompilerUtils;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.stream.Collectors;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.script.SimpleBindings;

class JavaCompilerScriptEngine
extends AbstractScriptEngine
implements Compilable {
    private final JavaCompilerScriptEngineFactory factory;

    JavaCompilerScriptEngine(JavaCompilerScriptEngineFactory javaCompilerScriptEngineFactory) {
        this.factory = javaCompilerScriptEngineFactory;
        this.context.setBindings(new SimpleBindings(), 200);
        this.context.setBindings(new SimpleBindings(), 100);
    }

    @Override
    public Object eval(String string, ScriptContext scriptContext) throws ScriptException {
        return this.compile(string).eval(scriptContext);
    }

    @Override
    public Object eval(Reader reader, ScriptContext scriptContext) throws ScriptException {
        String string = new BufferedReader(reader).lines().collect(Collectors.joining());
        return this.eval(string, scriptContext);
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    @Override
    public JavaCompilerScriptEngineFactory getFactory() {
        return this.factory;
    }

    @Override
    public CompiledScript compile(String string) throws ScriptException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\n");
        stringBuilder.append("import javax.script.*;");
        stringBuilder.append("\n");
        stringBuilder.append("public class CompiledJavaScript extends CompiledScript {\n");
        stringBuilder.append("\n");
        stringBuilder.append("    private final ScriptEngine engine;\n");
        stringBuilder.append("\n");
        stringBuilder.append("    public CompiledJavaScript(ScriptEngine engine) {\n");
        stringBuilder.append("        this.engine = engine;\n");
        stringBuilder.append("    }\n");
        stringBuilder.append("\n");
        stringBuilder.append("    public Object eval(ScriptContext context) throws ScriptException {\n");
        for (String string2 : string.split("\\R")) {
            stringBuilder.append("        ");
            stringBuilder.append(string2);
        }
        stringBuilder.append("    }\n");
        stringBuilder.append("\n");
        stringBuilder.append("    public ScriptEngine getEngine() {\n");
        stringBuilder.append("        return engine;\n");
        stringBuilder.append("    }\n");
        stringBuilder.append("\n");
        stringBuilder.append("}\n");
        try {
            Class<?> clazz = JavaCompilerUtils.compile("CompiledJavaScript", stringBuilder.toString());
            Object t = clazz.getConstructor(ScriptEngine.class).newInstance(this);
            return (CompiledScript)t;
        }
        catch (Exception exception) {
            throw new ScriptException("Compilation failed for: " + stringBuilder + "\n" + exception.getMessage());
        }
    }

    @Override
    public CompiledScript compile(Reader reader) throws ScriptException {
        String string = new BufferedReader(reader).lines().collect(Collectors.joining());
        return this.compile(string);
    }
}

