/*
 * Decompiled with CFR 0.152.
 */
package dev.argon.esexpr;

import dev.argon.esexpr.DecodeException;
import dev.argon.esexpr.ESExpr;
import dev.argon.esexpr.ESExprCodec;
import dev.argon.esexpr.ESExprCodecTags;
import dev.argon.esexpr.ESExprTag;
import dev.argon.esexpr.ESExprTagSet;
import dev.argon.esexpr.codecs.StringCodec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public record StringTable(List<String> values) {
    private static final ESExprCodec<StringTable> CODEC = new ESExprCodec<StringTable>(){

        @Override
        public ESExprTagSet tags() {
            return ESExprTagSet.of(new ESExprTag.Constructor("string-table"));
        }

        @Override
        public boolean isEncodedEqual(StringTable x, StringTable y) {
            return x.equals(y);
        }

        @Override
        public ESExpr encode(StringTable value) {
            return new ESExpr.Constructor("string-table", value.values.stream().map(StringCodec.INSTANCE::encode).toList(), new HashMap<String, ESExpr>());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public StringTable decode(ESExpr expr, ESExprCodec.FailurePath path) throws DecodeException {
            Map<String, ESExpr> args;
            block5: {
                if (!(expr instanceof ESExpr.Constructor)) throw new DecodeException("Expected a string-table constructor", path);
                ESExpr.Constructor constructor = (ESExpr.Constructor)expr;
                Map<String, ESExpr> map = constructor.constructor();
                String name = map;
                args = map = constructor.args();
                try {
                    Map<String, ESExpr> kwargs = map = constructor.kwargs();
                    if (!name.equals("string-table")) throw new DecodeException("Expected a string-table constructor", path);
                    if (kwargs.isEmpty()) break block5;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                throw new DecodeException("Unexpected keyword arguments for string table", path.withConstructor("string-table"));
            }
            ArrayList<String> values = new ArrayList<String>(args.size());
            int i = 0;
            Iterator iterator = args.iterator();
            while (iterator.hasNext()) {
                ESExpr arg = (ESExpr)iterator.next();
                values.add(StringCodec.INSTANCE.decode(arg, path.append("string-table", i)));
                ++i;
            }
            return new StringTable(values);
        }
    };

    @ESExprCodecTags(constructors={"string-table"})
    public static ESExprCodec<StringTable> codec() {
        return CODEC;
    }
}

