/*
 * Decompiled with CFR 0.152.
 */
package dev.argon.esexpr.codecs;

import dev.argon.esexpr.DecodeException;
import dev.argon.esexpr.ESExpr;
import dev.argon.esexpr.ESExprCodec;
import dev.argon.esexpr.ESExprCodecTags;
import dev.argon.esexpr.ESExprOverrideCodec;
import dev.argon.esexpr.ESExprTag;
import dev.argon.esexpr.ESExprTagSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@ESExprOverrideCodec(value=List.class)
@ESExprCodecTags(constructors={"list"})
public class ListCodec<T>
extends ESExprCodec<List<T>> {
    private final ESExprCodec<T> itemCodec;

    public ListCodec(ESExprCodec<T> itemCodec) {
        this.itemCodec = itemCodec;
    }

    @Override
    public ESExprTagSet tags() {
        return ESExprTagSet.of(new ESExprTag.Constructor("list"));
    }

    @Override
    public boolean isEncodedEqual(List<T> x, List<T> y) {
        if (x.size() != y.size()) {
            return false;
        }
        for (int i = 0; i < x.size(); ++i) {
            if (this.itemCodec.isEncodedEqual(x.get(i), y.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public ESExpr encode(List<T> value) {
        return new ESExpr.Constructor("list", value.stream().map(this.itemCodec::encode).toList(), new HashMap<String, ESExpr>());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<T> decode(ESExpr expr, ESExprCodec.FailurePath path) throws DecodeException {
        Map<String, ESExpr> args;
        block5: {
            if (!(expr instanceof ESExpr.Constructor)) throw new DecodeException("Expected a list constructor", path);
            ESExpr.Constructor constructor = (ESExpr.Constructor)expr;
            Map<String, ESExpr> map = constructor.constructor();
            String name = map;
            args = map = constructor.args();
            try {
                Map<String, ESExpr> kwargs = map = constructor.kwargs();
                if (!name.equals("list")) throw new DecodeException("Expected a list constructor", path);
                if (kwargs.isEmpty()) break block5;
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            throw new DecodeException("Unexpected keyword arguments for list.", path.withConstructor("list"));
        }
        ArrayList<T> res = new ArrayList<T>(args.size());
        int i = 0;
        Iterator iterator = args.iterator();
        while (iterator.hasNext()) {
            ESExpr item = (ESExpr)iterator.next();
            res.add(this.itemCodec.decode(item, path.append("list", i)));
            ++i;
        }
        return res;
    }
}

