/*
 * Decompiled with CFR 0.152.
 */
package dev.cdevents.events;

import com.fasterxml.jackson.annotation.JsonProperty;
import dev.cdevents.constants.CDEventConstants;
import dev.cdevents.models.CDEvent;
import dev.cdevents.models.TaskRunFinishedSubject;
import java.net.URI;

public class TaskRunFinishedCDEvent
extends CDEvent {
    private static final String CDEVENT_VERSION = "0.1.0";
    @JsonProperty(required=true)
    private TaskRunFinishedSubject subject;

    public TaskRunFinishedCDEvent() {
        this.initCDEvent(this.currentCDEventType());
        this.setSubject(new TaskRunFinishedSubject(CDEventConstants.SubjectType.TASKRUN));
    }

    public TaskRunFinishedSubject getSubject() {
        return this.subject;
    }

    public void setSubject(TaskRunFinishedSubject subject) {
        this.subject = subject;
    }

    @Override
    public String currentCDEventType() {
        return CDEventConstants.CDEventTypes.TaskRunFinishedEvent.getEventType().concat(CDEVENT_VERSION);
    }

    @Override
    public String schemaURL() {
        return String.format("https://cdevents.dev/%s/schema/task-run-finished-event", "0.1.2");
    }

    @Override
    public String eventSchema() {
        return "{\n  \"$schema\": \"https://json-schema.org/draft/2020-12/schema\",\n  \"$id\": \"https://cdevents.dev/0.1.2/schema/task-run-finished-event\",\n  \"properties\": {\n    \"context\": {\n      \"properties\": {\n        \"version\": {\n          \"type\": \"string\",\n          \"minLength\": 1\n        },\n        \"id\": {\n          \"type\": \"string\",\n          \"minLength\": 1\n        },\n        \"source\": {\n          \"type\": \"string\",\n          \"minLength\": 1\n        },\n        \"type\": {\n          \"type\": \"string\",\n          \"enum\": [\n            \"dev.cdevents.taskrun.finished.0.1.0\"\n          ],\n          \"default\": \"dev.cdevents.taskrun.finished.0.1.0\"\n        },\n        \"timestamp\": {\n          \"type\": \"string\",\n          \"format\": \"date-time\"\n        }\n      },\n      \"additionalProperties\": false,\n      \"type\": \"object\",\n      \"required\": [\n        \"version\",\n        \"id\",\n        \"source\",\n        \"type\",\n        \"timestamp\"\n      ]\n    },\n    \"subject\": {\n      \"properties\": {\n        \"id\": {\n          \"type\": \"string\",\n          \"minLength\": 1\n        },\n        \"source\": {\n          \"type\": \"string\"\n        },\n        \"type\": {\n          \"type\": \"string\",\n          \"minLength\": 1\n        },\n        \"content\": {\n          \"properties\": {\n            \"taskName\": {\n              \"type\": \"string\"\n            },\n            \"url\": {\n              \"type\": \"string\"\n            },\n            \"pipelineRun\": {\n              \"properties\": {\n                \"id\": {\n                  \"type\": \"string\",\n                  \"minLength\": 1\n                },\n                \"source\": {\n                  \"type\": \"string\"\n                }\n              },\n              \"additionalProperties\": false,\n              \"type\": \"object\",\n              \"required\": [\n                \"id\"\n              ]\n            },\n            \"outcome\": {\n              \"type\": \"string\"\n            },\n            \"errors\": {\n              \"type\": \"string\"\n            }\n          },\n          \"additionalProperties\": false,\n          \"type\": \"object\"\n        }\n      },\n      \"additionalProperties\": false,\n      \"type\": \"object\",\n      \"required\": [\n        \"id\",\n        \"type\",\n        \"content\"\n      ]\n    },\n    \"customData\": {\n      \"oneOf\": [\n        {\n          \"type\": \"object\"\n        },\n        {\n          \"type\": \"string\",\n          \"contentEncoding\": \"base64\"\n        }\n      ]\n    },\n    \"customDataContentType\": {\n      \"type\": \"string\"\n    }\n  },\n  \"additionalProperties\": false,\n  \"type\": \"object\",\n  \"required\": [\n    \"context\",\n    \"subject\"\n  ]\n}";
    }

    public void setSubjectId(String subjectId) {
        this.getSubject().setId(subjectId);
    }

    public void setSubjectSource(URI subjectSource) {
        this.getSubject().setSource(subjectSource);
    }

    public void setSubjectTaskName(String taskName) {
        this.getSubject().getContent().setTaskName(taskName);
    }

    public void setSubjectUrl(URI subjectUrl) {
        this.getSubject().getContent().setUrl(subjectUrl);
    }

    public void setSubjectOutcome(CDEventConstants.Outcome subjectOutcome) {
        this.getSubject().getContent().setOutcome(subjectOutcome);
    }

    public void setSubjectErrors(String subjectErrors) {
        this.getSubject().getContent().setErrors(subjectErrors);
    }

    public void setSubjectPipelineRunId(String pipelineRunId) {
        this.getSubject().getContent().getPipelineRun().setId(pipelineRunId);
    }

    public void setSubjectPipelineRunSource(URI pipelineRunSource) {
        this.getSubject().getContent().getPipelineRun().setSource(pipelineRunSource);
    }
}

