/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.core;

import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.google.firebase.firestore.core.FieldFilter;
import com.google.firebase.firestore.core.Filter;
import com.google.firebase.firestore.model.Document;
import com.google.firebase.firestore.model.FieldPath;
import com.google.firebase.firestore.util.Function;
import com.google.firestore.v1.StructuredQuery;
import java.util.ArrayList;
import java.util.List;

public class CompositeFilter
extends Filter {
    private final List<Filter> filters;
    private final StructuredQuery.CompositeFilter.Operator operator;
    private List<FieldFilter> memoizedFlattenedFilters;

    public CompositeFilter(List<Filter> filters, StructuredQuery.CompositeFilter.Operator operator) {
        this.filters = filters;
        this.operator = operator;
    }

    @Override
    public List<Filter> getFilters() {
        return this.filters;
    }

    public StructuredQuery.CompositeFilter.Operator getOperator() {
        return this.operator;
    }

    @Override
    public List<FieldFilter> getFlattenedFilters() {
        if (this.memoizedFlattenedFilters != null) {
            return this.memoizedFlattenedFilters;
        }
        this.memoizedFlattenedFilters = new ArrayList<FieldFilter>();
        for (Filter subfilter : this.filters) {
            this.memoizedFlattenedFilters.addAll(subfilter.getFlattenedFilters());
        }
        return this.memoizedFlattenedFilters;
    }

    @Override
    public FieldPath getFirstInequalityField() {
        FieldFilter found = this.findFirstMatchingFilter(f -> f.isInequality());
        if (found != null) {
            return found.getField();
        }
        return null;
    }

    public boolean isConjunction() {
        return this.operator == StructuredQuery.CompositeFilter.Operator.AND;
    }

    public boolean isDisjunction() {
        return this.operator == StructuredQuery.CompositeFilter.Operator.OPERATOR_UNSPECIFIED;
    }

    public boolean isFlatConjunction() {
        return this.isFlat() && this.isConjunction();
    }

    public boolean isFlat() {
        for (Filter filter : this.filters) {
            if (!(filter instanceof CompositeFilter)) continue;
            return false;
        }
        return true;
    }

    public CompositeFilter withAddedFilters(List<Filter> otherFilters) {
        ArrayList<Filter> mergedFilters = new ArrayList<Filter>(this.filters);
        mergedFilters.addAll(otherFilters);
        return new CompositeFilter(mergedFilters, this.operator);
    }

    @Nullable
    private FieldFilter findFirstMatchingFilter(Function<FieldFilter, Boolean> condition) {
        for (Filter filter : this.filters) {
            FieldFilter found;
            if (filter instanceof FieldFilter && condition.apply((FieldFilter)filter).booleanValue()) {
                return (FieldFilter)filter;
            }
            if (!(filter instanceof CompositeFilter) || (found = ((CompositeFilter)filter).findFirstMatchingFilter(condition)) == null) continue;
            return found;
        }
        return null;
    }

    @Override
    public boolean matches(Document doc) {
        if (this.isConjunction()) {
            for (Filter filter : this.filters) {
                if (filter.matches(doc)) continue;
                return false;
            }
            return true;
        }
        for (Filter filter : this.filters) {
            if (!filter.matches(doc)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getCanonicalId() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.isConjunction() ? "and(" : "or(");
        builder.append(TextUtils.join((CharSequence)",", this.filters));
        builder.append(")");
        return builder.toString();
    }

    public String toString() {
        return this.getCanonicalId();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof CompositeFilter)) {
            return false;
        }
        CompositeFilter other = (CompositeFilter)o;
        return this.operator == other.operator && this.filters.equals(other.filters);
    }

    public int hashCode() {
        int result = 37;
        result = 31 * result + this.operator.hashCode();
        result = 31 * result + this.filters.hashCode();
        return result;
    }
}

