/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.local;

import com.google.firebase.database.collection.ImmutableSortedMap;
import com.google.firebase.database.collection.ImmutableSortedSet;
import com.google.firebase.firestore.core.Query;
import com.google.firebase.firestore.core.Target;
import com.google.firebase.firestore.local.IndexManager;
import com.google.firebase.firestore.local.LocalDocumentsView;
import com.google.firebase.firestore.model.Document;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.FieldIndex;
import com.google.firebase.firestore.model.SnapshotVersion;
import com.google.firebase.firestore.util.Assert;
import com.google.firebase.firestore.util.Logger;
import com.google.firebase.firestore.util.Util;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class QueryEngine {
    private static final String LOG_TAG = "QueryEngine";
    private LocalDocumentsView localDocumentsView;
    private IndexManager indexManager;
    private boolean initialized;

    public void initialize(LocalDocumentsView localDocumentsView, IndexManager indexManager) {
        this.localDocumentsView = localDocumentsView;
        this.indexManager = indexManager;
        this.initialized = true;
    }

    public ImmutableSortedMap<DocumentKey, Document> getDocumentsMatchingQuery(Query query, SnapshotVersion lastLimboFreeSnapshotVersion, ImmutableSortedSet<DocumentKey> remoteKeys) {
        Assert.hardAssert(this.initialized, "initialize() not called", new Object[0]);
        ImmutableSortedMap<DocumentKey, Document> result = this.performQueryUsingIndex(query);
        if (result != null) {
            return result;
        }
        result = this.performQueryUsingRemoteKeys(query, remoteKeys, lastLimboFreeSnapshotVersion);
        if (result != null) {
            return result;
        }
        return this.executeFullCollectionScan(query);
    }

    @Nullable
    private ImmutableSortedMap<DocumentKey, Document> performQueryUsingIndex(Query query) {
        List<DocumentKey> keys;
        if (query.matchesAllDocuments()) {
            return null;
        }
        Target target = query.toTarget();
        IndexManager.IndexType indexType = this.indexManager.getIndexType(target);
        if (indexType.equals((Object)IndexManager.IndexType.NONE)) {
            return null;
        }
        if (indexType.equals((Object)IndexManager.IndexType.PARTIAL)) {
            query = query.limitToFirst(-1L);
            target = query.toTarget();
        }
        Assert.hardAssert((keys = this.indexManager.getDocumentsMatchingTarget(target)) != null, "index manager must return results for partial and full indexes.", new Object[0]);
        ImmutableSortedMap<DocumentKey, Document> indexedDocuments = this.localDocumentsView.getDocuments(keys);
        FieldIndex.IndexOffset offset = this.indexManager.getMinOffset(target);
        ImmutableSortedSet<Document> previousResults = this.applyQuery(query, indexedDocuments);
        if ((query.hasLimitToFirst() || query.hasLimitToLast()) && this.needsRefill(query.getLimitType(), keys.size(), previousResults, offset.getReadTime())) {
            return null;
        }
        return this.appendRemainingResults(Util.values(indexedDocuments), query, offset);
    }

    @Nullable
    private ImmutableSortedMap<DocumentKey, Document> performQueryUsingRemoteKeys(Query query, ImmutableSortedSet<DocumentKey> remoteKeys, SnapshotVersion lastLimboFreeSnapshotVersion) {
        if (query.matchesAllDocuments()) {
            return null;
        }
        if (lastLimboFreeSnapshotVersion.equals(SnapshotVersion.NONE)) {
            return null;
        }
        ImmutableSortedMap<DocumentKey, Document> documents = this.localDocumentsView.getDocuments(remoteKeys);
        ImmutableSortedSet<Document> previousResults = this.applyQuery(query, documents);
        if ((query.hasLimitToFirst() || query.hasLimitToLast()) && this.needsRefill(query.getLimitType(), remoteKeys.size(), previousResults, lastLimboFreeSnapshotVersion)) {
            return null;
        }
        if (Logger.isDebugEnabled()) {
            Logger.debug(LOG_TAG, "Re-using previous result from %s to execute query: %s", lastLimboFreeSnapshotVersion.toString(), query.toString());
        }
        return this.appendRemainingResults(previousResults, query, FieldIndex.IndexOffset.createSuccessor(lastLimboFreeSnapshotVersion, -1));
    }

    private ImmutableSortedSet<Document> applyQuery(Query query, ImmutableSortedMap<DocumentKey, Document> documents) {
        ImmutableSortedSet<Document> queryResults = new ImmutableSortedSet<Document>(Collections.emptyList(), query.comparator());
        for (Map.Entry<DocumentKey, Document> entry : documents) {
            Document document = entry.getValue();
            if (!query.matches(document)) continue;
            queryResults = queryResults.insert(document);
        }
        return queryResults;
    }

    private boolean needsRefill(Query.LimitType limitType, int expectedDocumentCount, ImmutableSortedSet<Document> sortedPreviousResults, SnapshotVersion limboFreeSnapshotVersion) {
        Document documentAtLimitEdge;
        if (expectedDocumentCount != sortedPreviousResults.size()) {
            return true;
        }
        Document document = documentAtLimitEdge = limitType == Query.LimitType.LIMIT_TO_FIRST ? sortedPreviousResults.getMaxEntry() : sortedPreviousResults.getMinEntry();
        if (documentAtLimitEdge == null) {
            return false;
        }
        return documentAtLimitEdge.hasPendingWrites() || documentAtLimitEdge.getVersion().compareTo(limboFreeSnapshotVersion) > 0;
    }

    private ImmutableSortedMap<DocumentKey, Document> executeFullCollectionScan(Query query) {
        if (Logger.isDebugEnabled()) {
            Logger.debug(LOG_TAG, "Using full collection scan to execute query: %s", query.toString());
        }
        return this.localDocumentsView.getDocumentsMatchingQuery(query, FieldIndex.IndexOffset.NONE);
    }

    private ImmutableSortedMap<DocumentKey, Document> appendRemainingResults(Iterable<Document> indexedResults, Query query, FieldIndex.IndexOffset offset) {
        ImmutableSortedMap<DocumentKey, Document> remainingResults = this.localDocumentsView.getDocumentsMatchingQuery(query, offset);
        for (Document entry : indexedResults) {
            remainingResults = remainingResults.insert(entry.getKey(), entry);
        }
        return remainingResults;
    }
}

