/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.os.Looper;
import androidx.annotation.NonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.internal.ListenerHolder;
import com.google.android.gms.common.internal.Preconditions;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Executor;

@KeepForSdk
public class ListenerHolders {
    private final Set zaa;

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @NonNull
    public static <L> ListenerHolder.ListenerKey<L> createListenerKey(@NonNull L listener2, @NonNull String listenerType) {
        L l;
        void var1_1;
        Preconditions.checkNotNull(listener2, "Listener must not be null");
        Preconditions.checkNotNull(var1_1, "Listener type must not be null");
        Preconditions.checkNotEmpty((String)var1_1, "Listener type must not be empty");
        ListenerHolder.ListenerKey<L> listenerKey = new ListenerHolder.ListenerKey<L>(l, (String)var1_1);
        return listenerKey;
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @NonNull
    public static <L> ListenerHolder<L> createListenerHolder(@NonNull L listener2, @NonNull Looper looper, @NonNull String listenerType) {
        L l;
        void var2_2;
        void var1_1;
        Preconditions.checkNotNull(listener2, "Listener must not be null");
        Preconditions.checkNotNull(var1_1, "Looper must not be null");
        Preconditions.checkNotNull(var2_2, "Listener type must not be null");
        ListenerHolder<L> listenerHolder = new ListenerHolder<L>((Looper)var1_1, l, (String)var2_2);
        return listenerHolder;
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @NonNull
    public static <L> ListenerHolder<L> createListenerHolder(@NonNull L listener2, @NonNull Executor executor, @NonNull String listenerType) {
        L l;
        void var2_2;
        void var1_1;
        Preconditions.checkNotNull(listener2, "Listener must not be null");
        Preconditions.checkNotNull(var1_1, "Executor must not be null");
        Preconditions.checkNotNull(var2_2, "Listener type must not be null");
        ListenerHolder<L> listenerHolder = new ListenerHolder<L>((Executor)var1_1, l, (String)var2_2);
        return listenerHolder;
    }

    public ListenerHolders() {
        WeakHashMap weakHashMap = new WeakHashMap();
        this.zaa = Collections.newSetFromMap(weakHashMap);
    }

    @NonNull
    public final ListenerHolder zaa(@NonNull Object listenerHolder, @NonNull Looper looper, @NonNull String string2) {
        listenerHolder = ListenerHolders.createListenerHolder(listenerHolder, looper, "NO_TYPE");
        this.zaa.add(listenerHolder);
        return listenerHolder;
    }

    public final void zab() {
        Iterator iterator = this.zaa.iterator();
        while (iterator.hasNext()) {
            ((ListenerHolder)iterator.next()).clear();
        }
        this.zaa.clear();
    }
}

