/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.remoteconfig.internal;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.util.Log;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.xmlpull.v1.XmlPullParserException;

public class DefaultsXmlParser {
    private static final String XML_TAG_ENTRY = "entry";
    private static final String XML_TAG_KEY = "key";
    private static final String XML_TAG_VALUE = "value";

    public static Map<String, String> getDefaultsFromXml(Context context, int resourceId) {
        HashMap<String, String> defaultsMap = new HashMap<String, String>();
        try {
            Resources resources = context.getResources();
            if (resources == null) {
                Log.e("FirebaseRemoteConfig", "Could not find the resources of the current context while trying to set defaults from an XML.");
                return defaultsMap;
            }
            XmlResourceParser xmlParser = resources.getXml(resourceId);
            String curTag = null;
            String key = null;
            String value = null;
            int eventType = xmlParser.getEventType();
            while (eventType != 1) {
                if (eventType == 2) {
                    curTag = xmlParser.getName();
                } else if (eventType == 3) {
                    if (xmlParser.getName().equals(XML_TAG_ENTRY)) {
                        if (key != null && value != null) {
                            defaultsMap.put(key, value);
                        } else {
                            Log.w("FirebaseRemoteConfig", "An entry in the defaults XML has an invalid key and/or value tag.");
                        }
                        key = null;
                        value = null;
                    }
                    curTag = null;
                } else if (eventType == 4 && curTag != null) {
                    switch (curTag) {
                        case "key": {
                            key = xmlParser.getText();
                            break;
                        }
                        case "value": {
                            value = xmlParser.getText();
                            break;
                        }
                        default: {
                            Log.w("FirebaseRemoteConfig", "Encountered an unexpected tag while parsing the defaults XML.");
                        }
                    }
                }
                eventType = xmlParser.next();
            }
        }
        catch (IOException | XmlPullParserException e) {
            Log.e("FirebaseRemoteConfig", "Encountered an error while parsing the defaults XML file.", e);
        }
        return defaultsMap;
    }
}

