/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import androidx.annotation.NonNull;
import com.google.firebase.firestore.LocalCacheSettings;

public final class PersistentCacheSettings
implements LocalCacheSettings {
    private final long sizeBytes;

    @NonNull
    public static Builder newBuilder() {
        return new Builder();
    }

    private PersistentCacheSettings(long sizeBytes) {
        this.sizeBytes = sizeBytes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PersistentCacheSettings that = (PersistentCacheSettings)o;
        return this.sizeBytes == that.sizeBytes;
    }

    public int hashCode() {
        return (int)(this.sizeBytes ^ this.sizeBytes >>> 32);
    }

    public String toString() {
        return "PersistentCacheSettings{sizeBytes=" + this.sizeBytes + '}';
    }

    public long getSizeBytes() {
        return this.sizeBytes;
    }

    public static class Builder {
        private long sizeBytes = 0x6400000L;

        private Builder() {
        }

        @NonNull
        public Builder setSizeBytes(long sizeBytes) {
            this.sizeBytes = sizeBytes;
            return this;
        }

        @NonNull
        public PersistentCacheSettings build() {
            return new PersistentCacheSettings(this.sizeBytes);
        }
    }
}

