/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.core;

import android.content.Context;
import androidx.annotation.Nullable;
import com.google.firebase.firestore.FirebaseFirestoreSettings;
import com.google.firebase.firestore.auth.User;
import com.google.firebase.firestore.core.DatabaseInfo;
import com.google.firebase.firestore.core.EventManager;
import com.google.firebase.firestore.core.SyncEngine;
import com.google.firebase.firestore.local.IndexBackfiller;
import com.google.firebase.firestore.local.LocalStore;
import com.google.firebase.firestore.local.Persistence;
import com.google.firebase.firestore.local.Scheduler;
import com.google.firebase.firestore.remote.ConnectivityMonitor;
import com.google.firebase.firestore.remote.Datastore;
import com.google.firebase.firestore.remote.RemoteStore;
import com.google.firebase.firestore.util.Assert;
import com.google.firebase.firestore.util.AsyncQueue;

public abstract class ComponentProvider {
    private Persistence persistence;
    private LocalStore localStore;
    private SyncEngine syncEngine;
    private RemoteStore remoteStore;
    private EventManager eventManager;
    private ConnectivityMonitor connectivityMonitor;
    @Nullable
    private IndexBackfiller indexBackfiller;
    @Nullable
    private Scheduler garbageCollectionScheduler;

    public Persistence getPersistence() {
        return Assert.hardAssertNonNull(this.persistence, "persistence not initialized yet", new Object[0]);
    }

    @Nullable
    public Scheduler getGarbageCollectionScheduler() {
        return this.garbageCollectionScheduler;
    }

    @Nullable
    public IndexBackfiller getIndexBackfiller() {
        return this.indexBackfiller;
    }

    public LocalStore getLocalStore() {
        return Assert.hardAssertNonNull(this.localStore, "localStore not initialized yet", new Object[0]);
    }

    public SyncEngine getSyncEngine() {
        return Assert.hardAssertNonNull(this.syncEngine, "syncEngine not initialized yet", new Object[0]);
    }

    public RemoteStore getRemoteStore() {
        return Assert.hardAssertNonNull(this.remoteStore, "remoteStore not initialized yet", new Object[0]);
    }

    public EventManager getEventManager() {
        return Assert.hardAssertNonNull(this.eventManager, "eventManager not initialized yet", new Object[0]);
    }

    protected ConnectivityMonitor getConnectivityMonitor() {
        return Assert.hardAssertNonNull(this.connectivityMonitor, "connectivityMonitor not initialized yet", new Object[0]);
    }

    public void initialize(Configuration configuration) {
        this.persistence = this.createPersistence(configuration);
        this.persistence.start();
        this.localStore = this.createLocalStore(configuration);
        this.connectivityMonitor = this.createConnectivityMonitor(configuration);
        this.remoteStore = this.createRemoteStore(configuration);
        this.syncEngine = this.createSyncEngine(configuration);
        this.eventManager = this.createEventManager(configuration);
        this.localStore.start();
        this.remoteStore.start();
        this.garbageCollectionScheduler = this.createGarbageCollectionScheduler(configuration);
        this.indexBackfiller = this.createIndexBackfiller(configuration);
    }

    protected abstract Scheduler createGarbageCollectionScheduler(Configuration var1);

    protected abstract IndexBackfiller createIndexBackfiller(Configuration var1);

    protected abstract EventManager createEventManager(Configuration var1);

    protected abstract LocalStore createLocalStore(Configuration var1);

    protected abstract ConnectivityMonitor createConnectivityMonitor(Configuration var1);

    protected abstract Persistence createPersistence(Configuration var1);

    protected abstract RemoteStore createRemoteStore(Configuration var1);

    protected abstract SyncEngine createSyncEngine(Configuration var1);

    public static class Configuration {
        private final Context context;
        private final AsyncQueue asyncQueue;
        private final DatabaseInfo databaseInfo;
        private final Datastore datastore;
        private final User initialUser;
        private final int maxConcurrentLimboResolutions;
        private final FirebaseFirestoreSettings settings;

        public Configuration(Context context, AsyncQueue asyncQueue, DatabaseInfo databaseInfo, Datastore datastore, User initialUser, int maxConcurrentLimboResolutions, FirebaseFirestoreSettings settings) {
            this.context = context;
            this.asyncQueue = asyncQueue;
            this.databaseInfo = databaseInfo;
            this.datastore = datastore;
            this.initialUser = initialUser;
            this.maxConcurrentLimboResolutions = maxConcurrentLimboResolutions;
            this.settings = settings;
        }

        FirebaseFirestoreSettings getSettings() {
            return this.settings;
        }

        AsyncQueue getAsyncQueue() {
            return this.asyncQueue;
        }

        DatabaseInfo getDatabaseInfo() {
            return this.databaseInfo;
        }

        Datastore getDatastore() {
            return this.datastore;
        }

        User getInitialUser() {
            return this.initialUser;
        }

        int getMaxConcurrentLimboResolutions() {
            return this.maxConcurrentLimboResolutions;
        }

        Context getContext() {
            return this.context;
        }
    }
}

